#!/bin/bash

if [ "${1}" = "bayes" ]
then
    remotehost="bayes.colorado.edu";
elif [ "${1}" = "gryphon" ]
then
    remotehost="gryphon.biochem.brandeis.edu";
elif [ "${1}" = "hippocerf" ]
then
    remotehost="hippocerf.biochem.brandeis.edu";
elif [ "${1}" = "wren" ]
then
    remotehost="xray.bmb.colostate.edu";
elif [ "${1}" = "monkshood" ]
then
    remotehost="monkshood.colorado.edu";
elif [ "${1}" = "molevo" ]
then
    remotehost="www.molevo.org";
elif [ "${1}" = "kriti" ]
then
    remotehost="wuttke@kriti.colorado.edu";
elif [ "${1}" = "orochi" ]
then
    remotehost="dtheobald@orochi.scit.us";
else
    remotehost="www.molevo.org";
fi

FILES="*.[ch] Makefile* make.inc archive* AUTHORS COPYING INSTALL.txt LICENSE README make_dist.sh theseus.1 theseus_man.pdf theseus_align examples/ lib/ libDLTutils/ libdistfit/ libdltmath/ libdssplite/ libmsa/";

DATE=$(date +%s);
TARFILE="theseus${DATE}.tgz";

# /usr/bin/tar --exclude '*.gz' --exclude '*.bz2' --exclude '*.pdb' \
#              --exclude '*.o' --exclude '*.bak' --exclude '*.BAK' \
#              --exclude 'backups*' --exclude '*.txt' --exclude '*.tgz' \
#              --exclude '*.bin' --exclude '*.aln' --exclude 'theseus' \
#              --exclude 'distfit' \
#              -cvzf ${TARFILE} ${FILES};

/usr/bin/tar --exclude '*.[oa]' --exclude '_*' -cvzf  ${TARFILE} ${FILES};

scp ${TARFILE} ${remotehost}:${TARFILE}

#sftp ${remotehost} << EOF
#cd theseus
#put ${TARFILE}
#exit
#EOF

mv ${TARFILE} backups

echo "";
exit 0;

