/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2007 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef MSA_SEEN
#define MSA_SEEN

#include "DLTutils.h"
#define MAXLINE           50
#define SEQ_NAME_LENGTH 8192

typedef struct
{
    char            filename[FILENAME_MAX]; /* MSA file name */
    int             distance;
    int             allocnum;    /* number of sequences allocated in the MSA */
    int             alloclen;    /* allocated length of the alignment */
    int             seqnum;      /* number of actual sequences in the MSA */
    int             seqlen;      /* actual length of the alignment */
    int            *checksum;    /* GCG/MSF-style sequence checksums */
    int             msachecksum; /* MSA checksum */
    int            *flag;        /* external boolean flag */
    int            *flag2;       /* private boolean flag for MSA functions */
    char          **seq;         /* pointer to an array of sequences */
    char          **name;        /* pointer to an array of the sequence names */
    double        **dist;        /* pointer to array of distances */
} MSA;


typedef struct
{
    int             arraynum; /* number of MSAs allocated in the MSAA */
    int            *flag;     /* external boolean flag */
    MSA           **array;    /* pointer to an array of the sequence names */
} MSAA;


/* ////////////////////////////////////////////////////////////////////// */
MSA
*getmsa(char *msafile_name);

int
isnexdist(char *msafile_name);

int
ismsf(char *msafile_name);

MSA
*MSAalloc(MSA *msa, int seqnum, int alignment_len, int name_size);

MSA
*DISTalloc(MSA *msa);

void
DISTfree(MSA *msa);

MSAA
*MSAalloc_array(MSAA *msas, int arraynum);

void
MSAfree(MSA *msa);

void
MSAfree_array(MSAA *msas);

/* ////////////////////////////////////////////////////////////////////// */
void
MSAprint(MSA *);

void
MSAmultiprint(MSAA *msas);

MSA
*MSAcpy(MSA *msa1, MSA *msa2);

MSA
*MSAduplicate(MSA *msa);

MSA
*MSAmult(MSA *msa, int multiply);

MSA
*MSAduplicate_empty(MSA *msa);

int
MSAseqeq(MSA *msa1, MSA *msa2, int *seq1, int *begin1, int *end1, int *seq2, int *begin2, int *end2);

void
MSAtemplate_adjust(MSAA *msas,
                   int  msa1,  /* first msa in msas */
                   int  msa2,  /* second msa in msas */
                   MSAA *newmsas,
                   int  newmsa1, /* first msa in newmsas */
                   int  newmsa2, /* second msa in newmsas */
                   int  seq1,
                   int  begin1,
                   int  end1, /* end is inclusive */
                   int  seq2,
                   int  begin2,
                   int  end2); /* end is inclusive */

MSA
*MSAdeldups(MSA *msa);

MSA
*MSAdelgap(MSA *msa);

MSA
*MSAmingap(MSA *msa);

MSA
*MSAmerge(MSAA *msas);

MSA
*MSAcombine(MSAA *msas);

/* ////////////////////////////////////////////////////////////////////// */
int
GCGchecksum(MSA *msa, int seq);

int
GCGmultichecksum(MSA *msa);

MSA
*reada2m(char *msafile_name, MSA *msa);

MSA
*reada2m2(char *msafile_name, MSA *msa);

MSA
*readaln(char *msafile_name, MSA *msa);

MSA
*readnex(char *msafile_name, MSA *msa);

MSA
*readnexd(char *msafile_name, MSA *msa);

MSA
*nexus_dist(MSA *msa, char *filestr, int filesize, int format);

int
getvali(char *string, char *key, char delimiter, char **endptr);

char *
getvals(char *string, char *key, char delimiter, char **endptr);

double
getvald(char *string, char *key, char delimiter, char **endptr);

char
getvalc(char *string, char *key, char delimiter, char **endptr);

MSA
*readphylip(char *msafile_name, MSA *msa);

MSA
*readphylipd(char *msafile_name, MSA *msa);

int
phyip_dist_format(MSA *msa, char *filestr, int filesize);

MSA
*phylip_dist(MSA *msa, char *filestr, int filesize, int format);

MSA
*readmsf(char *msafile_name, MSA *msa);

/* ////////////////////////////////////////////////////////////////////// */
void
writea2m_seq(MSA *msa, int seqID, char *outfile_root);

void
writealn_seq(MSA *msa, int seqID, char *outfile_root);

void
writenex_seq(MSA *msa, int seqID, char *outfile_root);

void
writenexd(MSA *msa, char *outfile_root);

void
writea2m(MSA *msa, int begin, int window, char *outfile_root);

void
writealn(MSA *msa, int begin, int window, char *outfile_root);

void
writenex(MSA *msa, int begin, int window, char *outfile_root);

void
writepsib(MSA *msa, int begin, int window, char *outfile_root);

#endif
