# Adapted from CMake 2.8 QT4_CREATE_TRANSLATION
# TODO: Find a better name for this
MACRO(CREATE_QT4_PRO_FILE _pro_path _qm_res)
  QT4_EXTRACT_OPTIONS(_lupdate_files _lupdate_options ${ARGN})
  SET(_my_sources)
  SET(_my_dirs)
  SET(_my_tsfiles)
  SET(_ts_pro)
  GET_FILENAME_COMPONENT(_pro_basepath ${_pro_path} PATH)
  FOREACH (_file ${_lupdate_files})
    GET_FILENAME_COMPONENT(_ext ${_file} EXT)
    GET_FILENAME_COMPONENT(_abs_FILE ${_file} ABSOLUTE)
    IF(_ext MATCHES "ts")
      LIST(APPEND _my_tsfiles ${_abs_FILE})
    ELSE(_ext MATCHES "ts")
      IF(NOT _ext)
        LIST(APPEND _my_dirs ${_abs_FILE})
      ELSE(NOT _ext)
        LIST(APPEND _my_sources ${_abs_FILE})
      ENDIF(NOT _ext)
    ENDIF(_ext MATCHES "ts")
  ENDFOREACH(_file)

  # Construct the .pro file
  # It includes SOURCES and TRANSLATIONS settings, but nothing else.
  SET(_pro_content "# WARNING: This file was generated automatically by CMake.\n\nerror(\"This file is not intended for building ${CMAKE_PROJECT_NAME}. Please use CMake instead. See the README for further instructions.\")")
  IF(_my_sources)
    SET(_pro_content "${_pro_content}\n\nSOURCES =")
    FOREACH(_pro_src ${_my_sources})
      FILE(RELATIVE_PATH _pro_src ${_pro_basepath} ${_pro_src})
      SET(_pro_content "${_pro_content} \\\n\"${_pro_src}\"")
    ENDFOREACH(_pro_src ${_my_sources})
  ENDIF(_my_sources)
  IF(_my_tsfiles)
    SET(_pro_content "${_pro_content}\n\nTRANSLATIONS =")
    FOREACH(_pro_ts ${_my_tsfiles})
      FILE(RELATIVE_PATH _pro_ts ${_pro_basepath} ${_pro_ts})
      SET(_pro_content "${_pro_content} \\\n\"${_pro_ts}\"")
    ENDFOREACH(_pro_ts ${_my_tsfiles})
  ENDIF(_my_tsfiles)
  FILE(WRITE ${_pro_path} "${_pro_content}\n")

  # Ensure the .qm files are generated in the build tree
  FOREACH(_ts_file ${_my_tsfiles})
    GET_FILENAME_COMPONENT(_ts_path ${_ts_file} PATH)
    FILE(RELATIVE_PATH _ts_path ${CMAKE_CURRENT_SOURCE_DIR} ${_ts_path})
    SET(_ts_path "${CMAKE_CURRENT_BINARY_DIR}/${_ts_path}")
    SET_SOURCE_FILES_PROPERTIES(${_ts_file} PROPERTIES OUTPUT_LOCATION ${_ts_path})
  ENDFOREACH(_ts_file ${_my_tsfiles})

  # Add the translations 
  QT4_ADD_TRANSLATION(_qm_files ${_my_tsfiles})
  
  # Construct an appropriate resource file
  SET(_qm_qrc "<!DOCTYPE RCC>\n<RCC version=\"1.0\">\n<qresource>\n")
  FOREACH(_qm_file ${_qm_files})
    FILE(RELATIVE_PATH _qm_file ${CMAKE_CURRENT_BINARY_DIR} ${_qm_file})
    SET(_qm_qrc "${_qm_qrc}<file>${_qm_file}</file>\n")
  ENDFOREACH(_qm_file ${_qm_files})
  SET(_qm_qrc "${_qm_qrc}</qresource>\n</RCC>\n")
  SET(_qm_qrc_path ${CMAKE_CURRENT_BINARY_DIR}/${CMAKE_PROJECT_NAME}_trans.qrc)
  FILE(WRITE ${_qm_qrc_path} ${_qm_qrc})

  QT4_ADD_RESOURCES(${_qm_res} ${_qm_qrc_path})
ENDMACRO(CREATE_QT4_PRO_FILE)

