% minijour.cls
\LoadClass[a4paper,twoside]{report}
\RequirePackage[dvips]{graphics}
\RequirePackage{german,ifthen,calc}

% interne Platzhalter
\newcommand{\@jahrgang}{\the\year}
\newcommand{\@ausgabe}{}
\newcommand{\ausgabename}{Ausgabe~\@ausgabe}
\newcommand{\@autor}{}
\newcommand{\@impressum}{}
\newcommand{\@maintitle}{Programmieren wie einst}
\newcommand{\@subtitle}{Mitteilungen zu Fragen der EDV}

% Benutzerkommandos
\newcommand{\maintitle}[1]
  {\renewcommand{\@maintitle}{#1}}
\newcommand{\subtitle}[1]
  {\renewcommand{\@subtitle}{#1}}
\renewcommand{\author}[1]
  {\renewcommand{\@autor}{Von #1}}
\newcommand{\ausgabe}[1]
  {\renewcommand{\@ausgabe}{#1}}
\newcommand{\impressum}[1]
  {\renewcommand{\@impressum}{#1}}
\newcommand{\jahrgang}[1]
  {\renewcommand{\@jahrgang}{#1}}

%Titelseite
\renewcommand{\maketitle}
 { \thispagestyle{empty}
   \begin{minipage}{\textwidth}
     \parbox[c][5cm][s]{\textwidth}
       {\vspace{0pt plus.5fil}
        \rightline{%
          \ausgabename \hspace{2em} 
            Jahrgang~\@jahrgang}
        \vfil
        \centerline{%
          \Huge\bfseries\@maintitle}
        \vspace{0pt plus.5fil}
        \centerline{\bfseries\@subtitle}
        \vfil
        \rule{\textwidth}{3mm} 
       } 

     \hbox to \textwidth
       {\parbox[c][12cm][t]{7cm}
         {\vspace{1em}
          {\LARGE Inhalt}\\\@starttoc{loe}
         }
        \parbox[c][12cm][c]{2em}
         {\hfil\rule{0.2mm}{11cm}\hfil}
        \parbox[c][12cm][c]{\textwidth-7cm-2em}
         {\resizebox*{\textwidth-7cm-2em}{!}
           {\includegraphics{rgray.eps}}
         }
       }

     \vspace{1em}\rule{\textwidth}{3mm}\vspace{1em}

     \ifthenelse{\equal{\@impressum}{}}
      {}{\small\textbf{Impressum}\\\@impressum}

   \end{minipage}
   \newpage\thispagestyle{empty} \tableofcontents
   \par\bigskip
 }

\newcommand{\article}
 {\@ifstar{\@@articles}{\@@article}}
\newcommand{\@article}
 {\@startsection{chapter}{1}{0pt}
  {-3.5ex plus -1ex minus -.2ex}
  {2.3ex plus .2ex}{\normalfont\Large\bfseries}}
\newcommand{\@@articles}[1]{\@article*{#1}
  \centerline{\@autor} }
\newcommand{\@@article}[4]
 {\twocolumn[\@article{#1}
  \centerline{\@autor}\vspace*{0.5em}
  \addcontentsline{loe}{section}
    {$\bullet$ #2}
  \addtocontents{loe}
    {\protect\mjbcom{}\@autor\protect\mjecom}
  \addtocontents{loe}
    {\protect\mjbcom{}#3\protect\mjecom}
  \ifx#4\empty\else\begin{quote} #4 \end{quote}\fi
  ]
  \markright{#2}
  }

\newcommand{\mjbcom}{\noindent\bgroup\footnotesize}
\newcommand{\mjecom}{\egroup\par\vspace{1ex}}