/*

    File: chgtype.c

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 51
    Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include "types.h"
#include "common.h"
#include "lang.h"
#include "intrf.h"
#include "intrfn.h"
#include "fnctdsk.h"
#include "chgtype.h"
#include "log.h"

struct part_name_struct
{
  unsigned int index;
  const char *name;
};

int change_part_type(const disk_t *disk_car,partition_t *partition, char **current_cmd)
{
  char response[100];
  int size=0;
  int i;
  unsigned int last[3], done = 0, next = 0;
  struct part_name_struct part_name[0x100];
  struct MenuItem menuType[]=
  {
    { 'P', "Previous",""},
    { 'N', "Next","" },
    { 'Q', "Proceed","Go set the partition type"},
    { 0, NULL, NULL }
  };
  /* Create an index of all partition type except Intel extended */
  partition_t *new_partition=partition_new();
  dup_partition_t(new_partition,partition);
  for(i=0;i<=0xFF;i++)
  {
    if(disk_car->arch->set_part_type(new_partition,i)==0)
    {
      part_name[size].name=disk_car->arch->get_partition_name(new_partition);
      if(part_name[size].name!=NULL)
	part_name[size++].index=i;
    }
  }
  free(new_partition);

  /* Display the list of partition type in 3 columns */
  aff_buffer(BUFFER_RESET,"Q");
  aff_buffer(BUFFER_ADD,"List of partition type\n");
  for (i = 2; i >= 0; i--)
    last[2 - i] = done += (size + i - done) / (i + 1);
  i = done = 0;
  do {
    aff_buffer(BUFFER_ADD, "%02x %-20s%c",  part_name[next].index, part_name[next].name,(i==2 ? '\n' : ' '));
    next = last[i++] + done;
    if (i > 2 || next >= last[i]) {
      i = 0;
      next = ++done;
    }
  } while (done < last[0]);

  /* Ask for the new partition type*/
  aff_copy(stdscr);
  wmove(stdscr,4,0);
  aff_part(stdscr,AFF_PART_ORDER,disk_car,partition);
  if(*current_cmd==NULL)
    screen_buffer_display(stdscr,"",menuType);
  wmove(stdscr,23,0);
  wdoprintf(stdscr,"New partition type [current %02x] ? ",disk_car->arch->get_part_type(partition));
  if(*current_cmd!=NULL)
  {
    while(*current_cmd[0]==',')
      (*current_cmd)++;
    {
      int tmp_val= strtol(*current_cmd, NULL, 16);
      while(*current_cmd[0]!=',' && *current_cmd[0]!='\0')
	(*current_cmd)++;
      disk_car->arch->set_part_type(partition,tmp_val);
    }
  }
  else
  {
    if (get_string(response, sizeof(response), NULL) > 0) {
      int tmp_val = strtol(response, NULL, 16);
      disk_car->arch->set_part_type(partition,tmp_val);
    }
  }
  log_partition(disk_car,partition);
  return 0;
}
