#!/bin/sh
if [ -z "$CC" ];
then
  CC="gcc"
  export CC
fi
TESTDISK_CC=$CC
export TESTDISK_CC
LD=ld
export LD
AR=ar
export AR
LYNX=links
PWDSRC=`pwd|sed 's#^\w:/#/#'`
# Comment the version definition to not compile the library
VER_E2FSPROGS=1.36
#VER_E2FSPROGS=
VER_PROGSREISERFS=0.3.1-rc8
VER_NTFSPROGS=1.9.4
LIBEXT=e2fsprogs-$VER_E2FSPROGS/lib/ext2fs/libext2fs.a
LIBNTFS=ntfsprogs-$VER_NTFSPROGS/libntfs/.libs/libntfs.a
LIBREISER=progsreiserfs-$VER_PROGSREISERFS/libreiserfs/.libs/libreiserfs.a
CONFIGUREOPT=
echo "This script will try to compile e2fsprogs progsreiserfs ntfsprogs libraries"
if [ "$VER_E2FSPROGS" != "" ];
then
CONFIGUREOPT="$CONFIGUREOPT --with-ext2fs-lib=${PWDSRC}/e2fsprogs-${VER_E2FSPROGS}/lib --with-ext2fs-includes=${PWDSRC}/e2fsprogs-${VER_E2FSPROGS}/lib"

if [ ! -e e2fsprogs-$VER_E2FSPROGS.tar.gz ];
then
	$LYNX http://prdownloads.sourceforge.net/e2fsprogs/e2fsprogs-$VER_E2FSPROGS.tar.gz
fi

if [ -e e2fsprogs-$VER_E2FSPROGS.tar.gz ];
then
  if [ ! -e e2fsprogs-$VER_E2FSPROGS/configure ];
  then
	tar xzf e2fsprogs-$VER_E2FSPROGS.tar.gz
  fi
fi

if [ -d e2fsprogs-$VER_E2FSPROGS ];
then
  if [ ! -e e2fsprogs-$VER_E2FSPROGS/Makefile ];
  then
	cd e2fsprogs-$VER_E2FSPROGS
	CFLAGS="$CFLAGS -DOMIT_COM_ERR" ./configure --with-cc="$TESTDISK_CC"
	cd ..
  fi
  if [ ! -e $LIBEXT ];
  then
	cd e2fsprogs-$VER_E2FSPROGS
	make libs
	cd ..
  fi
fi
fi

if [ "$VER_PROGSREISERFS" != "" ];
then
CONFIGUREOPT="$CONFIGUREOPT --with-reiserfs-lib=${PWDSRC}/progsreiserfs-${VER_PROGSREISERFS}/libreiserfs/.libs/ --with-reiserfs-includes=${PWDSRC}/progsreiserfs-${VER_PROGSREISERFS}/include/ --with-dal-lib=${PWDSRC}/progsreiserfs-${VER_PROGSREISERFS}/libdal/.libs/"
if [ ! -e progsreiserfs-$VER_PROGSREISERFS.tar.gz ];
then
	$LYNX http://reiserfs.osdn.org.ua/snapshots/progsreiserfs-$VER_PROGSREISERFS.tar.gz
fi

if [ -e progsreiserfs-$VER_PROGSREISERFS.tar.gz ];
then
  if [ ! -e progsreiserfs-$VER_PROGSREISERFS/configure ];
  then
	tar xzf progsreiserfs-$VER_PROGSREISERFS.tar.gz
  fi
fi

if [ -d progsreiserfs-$VER_PROGSREISERFS ];
then
  if [ ! -e progsreiserfs-$VER_PROGSREISERFS/Makefile ];
  then
	cd progsreiserfs-$VER_PROGSREISERFS
	./configure --disable-nls --disable-Werror CC="$TESTDISK_CC"
	cd ..
  fi
  if [ ! -e $LIBREISER ];
  then
	cd progsreiserfs-$VER_PROGSREISERFS
	make
	cd ..
  fi
fi
fi

if [ "$VER_NTFSPROGS" != "" ];
then
CONFIGUREOPT="$CONFIGUREOPT --with-ntfs-lib=${PWDSRC}/ntfsprogs-${VER_NTFSPROGS}/libntfs/.libs/ --with-ntfs-includes=${PWDSRC}/ntfsprogs-${VER_NTFSPROGS}/include/"
if [ ! -e ntfsprogs-$VER_NTFSPROGS.tar.gz ];
then
	$LYNX http://prdownloads.sourceforge.net/linux-ntfs/ntfsprogs-$VER_NTFSPROGS.tar.gz
fi

if [ -e ntfsprogs-$VER_NTFSPROGS.tar.gz ];
then
  if [ ! -e ntfsprogs-$VER_NTFSPROGS/configure ];
  then
	tar xzf ntfsprogs-$VER_NTFSPROGS.tar.gz
  fi
fi

if [ -d ntfsprogs-$VER_NTFSPROGS ];
then
  if [ ! -e ntfsprogs-$VER_NTFSPROGS/Makefile ];
  then
	cd ntfsprogs-$VER_NTFSPROGS
# --disable-default-device-io-ops is need for NT 4
	./configure --disable-default-device-io-ops CC="$TESTDISK_CC"
	cd ..
  fi
  if [ ! -e $LIBNTFS ];
  then
	cd ntfsprogs-$VER_NTFSPROGS
	make libs
	cd ..
  fi
fi
fi
echo "Try to compile TestDisk"
./configure $CONFIGUREOPT
make smallstatic
