/*

    File: fnctdsk.h

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#define s_cyl(p) (((p)->cyl & (unsigned)0xff) | (((p)->sector << 2) & (unsigned)0x300))
#define s_head(p) ((p)->head)
#define s_sect(p) ((p)->sector & (unsigned)0x3f)
#define e_cyl(p) (((p)->end_cyl & (unsigned)0xff) | (((p)->end_sector << 2) & (unsigned)0x300))
#define e_head(p) ((p)->end_head)
#define e_sect(p) ((p)->end_sector & (unsigned)0x3f)
unsigned int get_start_sect(const struct partition_dos *p);
unsigned int get_nr_sects(const struct partition_dos *p);

dword C_H_S2LBA(const t_param_disk *disk_car,const unsigned int C, const unsigned int H, const unsigned int S);
dword CHS2LBA(const t_param_disk *disk_car,const t_CHS*CHS);

void partition2entry(const t_param_disk *disk_car,const dword pos,const t_diskext *partition, struct partition_dos *p);
int entry2partition(t_param_disk *disk_car, const dword pos, t_diskext *partition, const struct partition_dos *p, const status_type_t status,const unsigned int order,const int debug);
const char* errmsg_entry2partition(const errcode_type_t errcode);
int read_MBR(t_param_disk *disk_car,void *buffer);
int write_MBR(t_param_disk *disk_car,void *buffer);
int write_clean_table(t_param_disk *disk_car);
int write_MBR_code(t_param_disk *disk_car);
int write_MBR_code_aux(unsigned char *buffer);
void dup_t_CHS(t_CHS * CHS_dest, const t_CHS * CHS_source);
t_list_part *element_new(t_diskext *part);
t_list_disk *insert_new_disk(t_list_disk *list_disk, t_param_disk *disk_car);
t_list_part *insert_new_partition(t_list_part *list_part, t_diskext *part);
t_list_part *insert_new_partition_aux(t_list_part *list_part, t_list_part *new_element);
t_list_part *remove_partition(t_list_part *list_part, t_list_part *element2removed);
t_list_part *sort_list_part(t_list_part *list_part);
void delete_list_part(t_list_part *list_part);
void  partition_reset(t_diskext *partition);
t_diskext *partition_new(void);
int compar_diskext(const t_diskext *a, const t_diskext *b);
unsigned int LBA2sector(const t_param_disk *disk_car, const dword sect);
unsigned int LBA2head(const t_param_disk *disk_car, const dword sect);
unsigned int LBA2cylinder(const t_param_disk *disk_car, const dword sect);
void LBA2CHS(const t_param_disk *disk_car,const dword lba, t_CHS*CHS);
int check_list_part(t_list_part *list_part);
int is_extended(const unsigned int part_type);
int can_be_ext(const t_param_disk *disk_car, t_diskext *partition);
int test_structure(t_list_part *list_part);
void get_geometry_from_list_part(const t_param_disk *disk_car, const t_list_part *list_part, const int debug);

