/*

    File: fat.h

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifndef FAT_H
#define FAT_H
#define FAT1X_PART_NAME 0x2B
#define FAT32_PART_NAME 0x47
#define FAT_NAME1       0x36
#define FAT_NAME2       0x52    /* FAT32 only */
#define NTFS_NAME       0x03
#define OS2_NAME        0x03

#define NBR_SECT        8

/*
 * FAT partition boot sector information, taken from the Linux
 * kernel sources.
 */

struct fat_boot_sector {
	__u8	ignored[3];	/* 0x00 Boot strap short or near jump */
	__s8	system_id[8];	/* 0x03 Name - can be used to special case
				   partition manager volumes */
	__u8	sector_size[2];	/* 0x0B bytes per logical sector */
	__u8	cluster_size;	/* 0x0D sectors/cluster */
	__u16	reserved;	/* 0x0E reserved sectors */
	__u8	fats;		/* 0x10 number of FATs */
	__u8	dir_entries[2];	/* 0x11 root directory entries */
	__u8	sectors[2];	/* 0x13 number of sectors */
	__u8	media;		/* 0x15 media code (unused) */
	__u16	fat_length;	/* 0x16 sectors/FAT */
	__u16	secs_track;	/* 0x18 sectors per track */
	__u16	heads;		/* 0x1A number of heads */
	__u32	hidden;		/* 0x1C hidden sectors (unused) */
	__u32	total_sect;	/* 0x20 number of sectors (if sectors == 0) */

	/* The following fields are only used by FAT32 */
	__u32	fat32_length;	/* 0x24=36 sectors/FAT */
	__u16	flags;		/* 0x28 bit 8: fat mirroring, low 4: active fat */
	__u8	version[2];	/* 0x2A major, minor filesystem version */
	__u32	root_cluster;	/* 0x2C first cluster in root directory */
	__u16	info_sector;	/* 0x30 filesystem info sector */
	__u16	backup_boot;	/* 0x32 backup boot sector */
	__u8	BPB_Reserved[12];	/* 0x34 Unused */
	__u8	BS_DrvNum;		/* 0x40 */
	__u8	BS_Reserved1;		/* 0x41 */
	__u8	BS_BootSig;		/* 0x42 */
	__u8	BS_VolID[4];		/* 0x43 */
	__u8	BS_VolLab[11];		/* 0x47 */
	__u8	BS_FilSysType[8];	/* 0x52=82*/

	/* */
	__u8	nothing[420];	/* 0x5A */
	__u16	marker;
} __attribute__ ((__packed__));

struct msdos_dir_entry {
	__s8	name[8],ext[3];	/* name and extension */
	__u8	attr;		/* attribute bits */
	__u8    lcase;		/* Case for base and extension */
	__u8	ctime_ms;	/* Creation time, milliseconds */
	__u16	ctime;		/* Creation time */
	__u16	cdate;		/* Creation date */
	__u16	adate;		/* Last access date */
	__u16   starthi;	/* High 16 bits of cluster in FAT32 */
	__u16	time,date,start;/* time, date and first cluster */
	__u32	size;		/* file size (in bytes) */
};

/* Up to 13 characters of the name */
struct msdos_dir_slot {
	__u8    id;		/* 00 sequence number for slot */
	__u8    name0_4[10];	/* 01 first 5 characters in name */
	__u8    attr;		/* 0B attribute byte */
	__u8    reserved;	/* 0C always 0 */
	__u8    alias_checksum;	/* 0D checksum for 8.3 alias */
	__u8    name5_10[12];	/* 0E 6 more characters in name */
	__u16   start;		/* starting cluster number, 0 in long slots */
	__u8    name11_12[4];	/* last 2 characters in name */
};


int check_FAT(t_param_disk *disk_car,t_diskext *partition, const int debug);
int test_FAT(t_param_disk *disk_car,const struct fat_boot_sector *fat_header, t_diskext *partition,const int debug, const int dump_ind);
int comp_FAT(t_param_disk *disk_car,const t_diskext *partition, const dword taille, const dword sect_res);
unsigned int get_frag(const unsigned char *buffer, const int fat_type);
int dump_fat_rapport(const struct fat_boot_sector*fh1, const upart_type_t upart_type);
int dump_2fat_rapport(const struct fat_boot_sector*fh1, const struct fat_boot_sector*fh2, const upart_type_t upart_type);
int sort_fat(int pos_fat_test, int debug);
int search_fat_aux(t_param_disk *disk_car,const t_diskext *partition,const dword max_offset,const int p_fat12,const int p_fat16,const int p_fat32,int *f_fat12,int*f_fat16,int*f_fat32,const int debug,const int dump_ind,const int interface);

dword get_subdirectory(t_param_disk *disk_car,const dword hd_offset, const dword i);
dword get_next_cluster(t_param_disk *disk_car,const t_diskext *partition, const upart_type_t upart_type,const int offset, dword cluster);
dword get_prev_cluster(t_param_disk *disk_car,const t_diskext *partition, const upart_type_t upart_type,const int offset, const dword cluster, const dword no_of_cluster);
int recover_FAT12(t_param_disk *disk_car,const struct fat_boot_sector*fat_header, t_diskext *partition, const int debug, const int dump_ind);
int recover_FAT16(t_param_disk *disk_car,const struct fat_boot_sector*fat_header, t_diskext *partition, const int debug, const int dump_ind);
int recover_FAT32(t_param_disk *disk_car,const struct fat_boot_sector*fat_header, t_diskext *partition, const int debug, const int dump_ind, const int backup);
int recover_HPFS(t_param_disk *disk_car, const struct fat_boot_sector*fat_header, t_diskext *partition, const int debug, const int dump_ind);
int recover_OS2MB(t_param_disk *disk_car, const struct fat_boot_sector*fat_header, t_diskext *partition, const int debug, const int dump_ind);
int is_fat(const int part_type);
int is_fat12(const int part_type);
int is_fat16(const int part_type);
int is_fat32(const int part_type);
int dir_partition_fat(WINDOW *window,t_param_disk *disk_car, t_diskext *partition, const int debug);
unsigned int get_dir_entries(const struct fat_boot_sector *fat_header);
int dump_fat_info(const struct fat_boot_sector*fh1, const upart_type_t upart_type);
int dump_2fat_info(const struct fat_boot_sector*fh1, const struct fat_boot_sector*fh2, const upart_type_t upart_type);
int dump_fat_info_rapport(const struct fat_boot_sector*fh1, const upart_type_t upart_type);
int fat32_set_part_name(t_param_disk *disk_car, t_diskext *partition, const struct fat_boot_sector*fat_header);
unsigned int sector_size(const struct fat_boot_sector *fat_header);
unsigned int sectors(const struct fat_boot_sector *fat_header);
dword fat32_get_prev_cluster(t_param_disk *disk_car,const t_diskext *partition, const unsigned int fat_offset, const dword cluster, const dword no_of_cluster);
int fat32_free_info(t_param_disk *disk_car,const t_diskext *partition, const unsigned int fat_offset, const dword no_of_cluster,dword *next_free,dword*free_count);
dword get_free_count(const unsigned char *boot_fat32);
dword get_next_free(const unsigned char *boot_fat32);
int clean_FAT(t_param_disk *disk_car, t_diskext *partition, const int debug);

#define DELETED_FLAG 0xe5 /* marks file as deleted when in name[0] */
#define IS_FREE(n) (!*(n) || *(const unsigned char *) (n) == DELETED_FLAG)
#define ATTR_RO      1  /* read-only */
#define ATTR_HIDDEN  2  /* hidden */
#define ATTR_SYS     4  /* system */
#define ATTR_VOLUME  8  /* volume label */
#define ATTR_DIR     16 /* directory */
#define ATTR_ARCH    32 /* archived */

#define ATTR_NONE    0 /* no attribute bits */
#define ATTR_UNUSED  (ATTR_VOLUME | ATTR_ARCH | ATTR_SYS | ATTR_HIDDEN)
	/* attribute bits that are copied "as is" */
#define ATTR_EXT     (ATTR_RO | ATTR_HIDDEN | ATTR_SYS | ATTR_VOLUME)
#define ATTR_EXT_MASK     (ATTR_RO | ATTR_HIDDEN | ATTR_SYS | ATTR_VOLUME | ATTR_DIR | ATTR_ARCH)
	/* bits that are used by the Windows 95/Windows NT extended FAT */
#endif
