/*
    		 Crown Copyright (c) 1997
    
    This TenDRA(r) Computer Program is subject to Copyright
    owned by the United Kingdom Secretary of State for Defence
    acting through the Defence Evaluation and Research Agency
    (DERA).  It is made available to Recipients with a
    royalty-free licence for its use, reproduction, transfer
    to other parties and amendment for any purpose not excluding
    product development provided that any such use et cetera
    shall be deemed to be acceptance of the following conditions:-
    
        (1) Its Recipients shall ensure that this Notice is
        reproduced upon any copies or amended versions of it;
    
        (2) Any amended version of it shall be clearly marked to
        show both the nature of and the organisation responsible
        for the relevant amendment or amendments;
    
        (3) Its onward transfer from a recipient to another
        party shall be deemed to be that party's acceptance of
        these conditions;
    
        (4) DERA gives no warranty or assurance as to its
        quality or suitability for any purpose and DERA accepts
        no liability whatsoever in relation to any use to which
        it may be put.
*/


/* AUTOMATICALLY GENERATED BY make_tdf VERSION 2.0 FROM TDF 4.1 */

#include "config.h"
#include "types.h"
#include "de_types.h"
#include "enc_types.h"
#include "check.h"
#include "decode.h"
#include "de_capsule.h"
#include "de_unit.h"
#include "encode.h"
#include "node.h"
#include "read.h"
#include "shape.h"
#include "table.h"
#include "tdf.h"
#include "utility.h"


/* INITIALISE CONSTRUCTS */

void init_constructs
    PROTO_Z ()
{
    sortname s ;

    s = SORT_access ;
    sort_letters [s] = 'u' ;
    sort_encoding [s] = 4 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_access ;
    sort_read [s] = read_access ;
    new_sort ( s, 14 ) ;
    new_cons ( "access_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "access_cond", s, 2, "x@[u]@[u]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "add_accesses", s, 3, "uu" ) ;
    new_cons ( "constant", s, 4, ( char * ) null ) ;
    new_cons ( "long_jump_access", s, 5, ( char * ) null ) ;
    new_cons ( "no_other_read", s, 6, ( char * ) null ) ;
    new_cons ( "no_other_write", s, 7, ( char * ) null ) ;
    new_cons ( "out_par", s, 8, ( char * ) null ) ;
    new_cons ( "preserve", s, 9, ( char * ) null ) ;
    new_cons ( "register", s, 10, ( char * ) null ) ;
    new_cons ( "standard_access", s, 11, ( char * ) null ) ;
    new_cons ( "used_as_volatile", s, 12, ( char * ) null ) ;
    new_cons ( "visible", s, 13, ( char * ) null ) ;

    s = SORT_al_tag ;
    sort_letters [s] = 'A' ;
    sort_encoding [s] = 1 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_al_tag ;
    sort_read [s] = read_al_tag ;
    new_sort ( s, 3 ) ;
    new_cons ( "al_tag_apply_token", s, 2, "!" ) ;
    sort_tokens [s] = 2 ;
    new_cons ( "make_al_tag", s, 1, "i" ) ;

    s = SORT_alignment ;
    sort_letters [s] = 'a' ;
    sort_encoding [s] = 4 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_alignment ;
    sort_read [s] = read_alignment ;
    new_sort ( s, 13 ) ;
    new_cons ( "alignment_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "alignment_cond", s, 2, "x@[a]@[a]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "alignment", s, 3, "S" ) ;
    new_cons ( "alloca_alignment", s, 4, ( char * ) null ) ;
    new_cons ( "callees_alignment", s, 5, "b" ) ;
    new_cons ( "callers_alignment", s, 6, "b" ) ;
    new_cons ( "code_alignment", s, 7, ( char * ) null ) ;
    new_cons ( "locals_alignment", s, 8, ( char * ) null ) ;
    new_cons ( "obtain_al_tag", s, 9, "A" ) ;
    new_cons ( "parameter_alignment", s, 10, "S" ) ;
    new_cons ( "unite_alignments", s, 11, "aa" ) ;
    new_cons ( "var_param_alignment", s, 12, ( char * ) null ) ;

    s = SORT_bitfield_variety ;
    sort_letters [s] = 'B' ;
    sort_encoding [s] = 2 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_bitfield_variety ;
    sort_read [s] = read_bitfield_variety ;
    new_sort ( s, 4 ) ;
    new_cons ( "bfvar_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "bfvar_cond", s, 2, "x@[B]@[B]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "bfvar_bits", s, 3, "bn" ) ;

    s = SORT_bool ;
    sort_letters [s] = 'b' ;
    sort_encoding [s] = 3 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_bool ;
    sort_read [s] = read_bool ;
    new_sort ( s, 5 ) ;
    new_cons ( "bool_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "bool_cond", s, 2, "x@[b]@[b]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "false", s, 3, ( char * ) null ) ;
    new_cons ( "true", s, 4, ( char * ) null ) ;

    s = SORT_callees ;
    sort_letters [s] = 'q' ;
    sort_encoding [s] = 2 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_callees ;
    sort_read [s] = read_callees ;
    new_sort ( s, 4 ) ;
    new_cons ( "make_callee_list", s, 1, "*[x]" ) ;
    new_cons ( "make_dynamic_callees", s, 2, "xx" ) ;
    new_cons ( "same_callees", s, 3, ( char * ) null ) ;

    s = SORT_error_code ;
    sort_letters [s] = 'c' ;
    sort_encoding [s] = 2 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_error_code ;
    sort_read [s] = read_error_code ;
    new_sort ( s, 4 ) ;
    new_cons ( "nil_access", s, 1, ( char * ) null ) ;
    new_cons ( "overflow", s, 2, ( char * ) null ) ;
    new_cons ( "stack_overflow", s, 3, ( char * ) null ) ;

    s = SORT_error_treatment ;
    sort_letters [s] = 'e' ;
    sort_encoding [s] = 3 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_error_treatment ;
    sort_read [s] = read_error_treatment ;
    new_sort ( s, 8 ) ;
    new_cons ( "errt_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "errt_cond", s, 2, "x@[e]@[e]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "continue", s, 3, ( char * ) null ) ;
    new_cons ( "error_jump", s, 4, "l" ) ;
    new_cons ( "trap", s, 5, "*[c]" ) ;
    new_cons ( "wrap", s, 6, ( char * ) null ) ;
    new_cons ( "impossible", s, 7, ( char * ) null ) ;

    s = SORT_exp ;
    sort_letters [s] = 'x' ;
    sort_encoding [s] = 7 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_exp ;
    sort_read [s] = read_exp ;
    new_sort ( s, 117 ) ;
    new_cons ( "exp_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "exp_cond", s, 2, "x@[x]@[x]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "abs", s, 3, "ex" ) ;
    new_cons ( "add_to_ptr", s, 4, "xx" ) ;
    new_cons ( "and", s, 5, "xx" ) ;
    new_cons ( "apply_proc", s, 6, "Sx*[x]?[x]" ) ;
    new_cons ( "apply_general_proc", s, 7, "S?[P]x*[?[t&]x]q{x}" ) ;
    new_cons ( "assign", s, 8, "xx" ) ;
    new_cons ( "assign_with_mode", s, 9, "mxx" ) ;
    new_cons ( "bitfield_assign", s, 10, "xxx" ) ;
    new_cons ( "bitfield_assign_with_mode", s, 11, "mxxx" ) ;
    new_cons ( "bitfield_contents", s, 12, "Bxx" ) ;
    new_cons ( "bitfield_contents_with_mode", s, 13, "mBxx" ) ;
    new_cons ( "case", s, 14, "bx*[lss]" ) ;
    new_cons ( "change_bitfield_to_int", s, 15, "vx" ) ;
    new_cons ( "change_floating_variety", s, 16, "efx" ) ;
    new_cons ( "change_variety", s, 17, "evx" ) ;
    new_cons ( "change_int_to_bitfield", s, 18, "Bx" ) ;
    new_cons ( "complex_conjugate", s, 19, "x" ) ;
    new_cons ( "component", s, 20, "Sxx" ) ;
    new_cons ( "concat_nof", s, 21, "xx" ) ;
    new_cons ( "conditional", s, 22, "l&{xx}" ) ;
    new_cons ( "contents", s, 23, "Sx" ) ;
    new_cons ( "contents_with_mode", s, 24, "mSx" ) ;
    new_cons ( "current_env", s, 25, ( char * ) null ) ;
    new_cons ( "div0", s, 26, "eexx" ) ;
    new_cons ( "div1", s, 27, "eexx" ) ;
    new_cons ( "div2", s, 28, "eexx" ) ;
    new_cons ( "env_offset", s, 29, "aat" ) ;
    new_cons ( "env_size", s, 30, "t" ) ;
    new_cons ( "fail_installer", s, 31, "X" ) ;
    new_cons ( "float_int", s, 32, "efx" ) ;
    new_cons ( "floating_abs", s, 33, "ex" ) ;
    new_cons ( "floating_div", s, 34, "exx" ) ;
    new_cons ( "floating_minus", s, 35, "exx" ) ;
    new_cons ( "floating_maximum", s, 36, "exx" ) ;
    new_cons ( "floating_minimum", s, 37, "exx" ) ;
    new_cons ( "floating_mult", s, 38, "e*[x]" ) ;
    new_cons ( "floating_negate", s, 39, "ex" ) ;
    new_cons ( "floating_plus", s, 40, "e*[x]" ) ;
    new_cons ( "floating_power", s, 41, "exx" ) ;
    new_cons ( "floating_test", s, 42, "?[n]eNlxx" ) ;
    new_cons ( "goto", s, 43, "l" ) ;
    new_cons ( "goto_local_lv", s, 44, "x" ) ;
    new_cons ( "identify", s, 45, "?[u]t^x{x}" ) ;
    new_cons ( "ignorable", s, 46, "x" ) ;
    new_cons ( "imaginary_part", s, 47, "x" ) ;
    new_cons ( "initial_value", s, 48, "{x}" ) ;
    new_cons ( "integer_test", s, 49, "?[n]Nlxx" ) ;
    new_cons ( "labelled", s, 50, "*[l&]{x*[x]}" ) ;
    new_cons ( "last_local", s, 51, "x" ) ;
    new_cons ( "local_alloc", s, 52, "x" ) ;
    new_cons ( "local_alloc_check", s, 53, "x" ) ;
    new_cons ( "local_free", s, 54, "xx" ) ;
    new_cons ( "local_free_all", s, 55, ( char * ) null ) ;
    new_cons ( "long_jump", s, 56, "xx" ) ;
    new_cons ( "make_complex", s, 57, "fxx" ) ;
    new_cons ( "make_compound", s, 58, "x*[x]" ) ;
    new_cons ( "make_floating", s, 59, "frbXns" ) ;
    new_cons ( "make_general_proc", s, 60, "S?[P]*[S?[u]t&]*[S?[u]t&]{x}" ) ;
    new_cons ( "make_int", s, 61, "vs" ) ;
    new_cons ( "make_local_lv", s, 62, "l" ) ;
    new_cons ( "make_nof", s, 63, "*[x]" ) ;
    new_cons ( "make_nof_int", s, 64, "vX" ) ;
    new_cons ( "make_null_local_lv", s, 65, ( char * ) null ) ;
    new_cons ( "make_null_proc", s, 66, ( char * ) null ) ;
    new_cons ( "make_null_ptr", s, 67, "a" ) ;
    new_cons ( "make_proc", s, 68, "S*[S?[u]t&]?[t&?[u]]{x}" ) ;
    new_cons ( "make_stack_limit", s, 116, "xxx" ) ;
    new_cons ( "make_top", s, 69, ( char * ) null ) ;
    new_cons ( "make_value", s, 70, "S" ) ;
    new_cons ( "maximum", s, 71, "xx" ) ;
    new_cons ( "minimum", s, 72, "xx" ) ;
    new_cons ( "minus", s, 73, "exx" ) ;
    new_cons ( "move_some", s, 74, "mxxx" ) ;
    new_cons ( "mult", s, 75, "exx" ) ;
    new_cons ( "n_copies", s, 76, "nx" ) ;
    new_cons ( "negate", s, 77, "ex" ) ;
    new_cons ( "not", s, 78, "x" ) ;
    new_cons ( "obtain_tag", s, 79, "t" ) ;
    new_cons ( "offset_add", s, 80, "xx" ) ;
    new_cons ( "offset_div", s, 81, "vxx" ) ;
    new_cons ( "offset_div_by_int", s, 82, "xx" ) ;
    new_cons ( "offset_max", s, 83, "xx" ) ;
    new_cons ( "offset_mult", s, 84, "xx" ) ;
    new_cons ( "offset_negate", s, 85, "x" ) ;
    new_cons ( "offset_pad", s, 86, "ax" ) ;
    new_cons ( "offset_subtract", s, 87, "xx" ) ;
    new_cons ( "offset_test", s, 88, "?[n]Nlxx" ) ;
    new_cons ( "offset_zero", s, 89, "a" ) ;
    new_cons ( "or", s, 90, "xx" ) ;
    new_cons ( "plus", s, 91, "exx" ) ;
    new_cons ( "pointer_test", s, 92, "?[n]Nlxx" ) ;
    new_cons ( "power", s, 93, "exx" ) ;
    new_cons ( "proc_test", s, 94, "?[n]Nlxx" ) ;
    new_cons ( "profile", s, 95, "n" ) ;
    new_cons ( "real_part", s, 96, "x" ) ;
    new_cons ( "rem0", s, 97, "eexx" ) ;
    new_cons ( "rem1", s, 98, "eexx" ) ;
    new_cons ( "rem2", s, 99, "eexx" ) ;
    new_cons ( "repeat", s, 100, "l&{xx}" ) ;
    new_cons ( "return", s, 101, "x" ) ;
    new_cons ( "return_to_label", s, 102, "x" ) ;
    new_cons ( "round_with_mode", s, 103, "ervx" ) ;
    new_cons ( "rotate_left", s, 104, "xx" ) ;
    new_cons ( "rotate_right", s, 105, "xx" ) ;
    new_cons ( "sequence", s, 106, "*[x]x" ) ;
    new_cons ( "set_stack_limit", s, 107, "x" ) ;
    new_cons ( "shape_offset", s, 108, "S" ) ;
    new_cons ( "shift_left", s, 109, "exx" ) ;
    new_cons ( "shift_right", s, 110, "xx" ) ;
    new_cons ( "subtract_ptrs", s, 111, "xx" ) ;
    new_cons ( "tail_call", s, 112, "?[P]xq" ) ;
    new_cons ( "untidy_return", s, 113, "x" ) ;
    new_cons ( "variable", s, 114, "?[u]t&x{x}" ) ;
    new_cons ( "xor", s, 115, "xx" ) ;

    s = SORT_floating_variety ;
    sort_letters [s] = 'f' ;
    sort_encoding [s] = 3 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_floating_variety ;
    sort_read [s] = read_floating_variety ;
    new_sort ( s, 7 ) ;
    new_cons ( "flvar_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "flvar_cond", s, 2, "x@[f]@[f]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "flvar_parms", s, 3, "nnnn" ) ;
    new_cons ( "complex_parms", s, 4, "nnnn" ) ;
    new_cons ( "float_of_complex", s, 5, "S" ) ;
    new_cons ( "complex_of_float", s, 6, "S" ) ;

    s = SORT_label ;
    sort_letters [s] = 'l' ;
    sort_encoding [s] = 1 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_label ;
    sort_read [s] = read_label ;
    new_sort ( s, 3 ) ;
    new_cons ( "label_apply_token", s, 2, "!" ) ;
    sort_tokens [s] = 2 ;
    new_cons ( "make_label", s, 1, "i" ) ;

    s = SORT_nat ;
    sort_letters [s] = 'n' ;
    sort_encoding [s] = 3 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_nat ;
    sort_read [s] = read_nat ;
    new_sort ( s, 6 ) ;
    new_cons ( "nat_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "nat_cond", s, 2, "x@[n]@[n]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "computed_nat", s, 3, "x" ) ;
    new_cons ( "error_val", s, 4, "c" ) ;
    new_cons ( "make_nat", s, 5, "i" ) ;

    s = SORT_ntest ;
    sort_letters [s] = 'N' ;
    sort_encoding [s] = 4 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_ntest ;
    sort_read [s] = read_ntest ;
    new_sort ( s, 17 ) ;
    new_cons ( "ntest_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "ntest_cond", s, 2, "x@[N]@[N]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "equal", s, 3, ( char * ) null ) ;
    new_cons ( "greater_than", s, 4, ( char * ) null ) ;
    new_cons ( "greater_than_or_equal", s, 5, ( char * ) null ) ;
    new_cons ( "less_than", s, 6, ( char * ) null ) ;
    new_cons ( "less_than_or_equal", s, 7, ( char * ) null ) ;
    new_cons ( "not_equal", s, 8, ( char * ) null ) ;
    new_cons ( "not_greater_than", s, 9, ( char * ) null ) ;
    new_cons ( "not_greater_than_or_equal", s, 10, ( char * ) null ) ;
    new_cons ( "not_less_than", s, 11, ( char * ) null ) ;
    new_cons ( "not_less_than_or_equal", s, 12, ( char * ) null ) ;
    new_cons ( "less_than_or_greater_than", s, 13, ( char * ) null ) ;
    new_cons ( "not_less_than_and_not_greater_than", s, 14, ( char * ) null ) ;
    new_cons ( "comparable", s, 15, ( char * ) null ) ;
    new_cons ( "not_comparable", s, 16, ( char * ) null ) ;

    s = SORT_procprops ;
    sort_letters [s] = 'P' ;
    sort_encoding [s] = 4 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_procprops ;
    sort_read [s] = read_procprops ;
    new_sort ( s, 10 ) ;
    new_cons ( "procprops_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "procprops_cond", s, 2, "x@[P]@[P]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "add_procprops", s, 3, "PP" ) ;
    new_cons ( "check_stack", s, 4, ( char * ) null ) ;
    new_cons ( "inline", s, 5, ( char * ) null ) ;
    new_cons ( "no_long_jump_dest", s, 6, ( char * ) null ) ;
    new_cons ( "untidy", s, 7, ( char * ) null ) ;
    new_cons ( "var_callees", s, 8, ( char * ) null ) ;
    new_cons ( "var_callers", s, 9, ( char * ) null ) ;

    s = SORT_rounding_mode ;
    sort_letters [s] = 'r' ;
    sort_encoding [s] = 3 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_rounding_mode ;
    sort_read [s] = read_rounding_mode ;
    new_sort ( s, 8 ) ;
    new_cons ( "rounding_mode_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "rounding_mode_cond", s, 2, "x@[r]@[r]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "round_as_state", s, 3, ( char * ) null ) ;
    new_cons ( "to_nearest", s, 4, ( char * ) null ) ;
    new_cons ( "toward_larger", s, 5, ( char * ) null ) ;
    new_cons ( "toward_smaller", s, 6, ( char * ) null ) ;
    new_cons ( "toward_zero", s, 7, ( char * ) null ) ;

    s = SORT_shape ;
    sort_letters [s] = 'S' ;
    sort_encoding [s] = 4 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_shape ;
    sort_read [s] = read_shape ;
    new_sort ( s, 13 ) ;
    new_cons ( "shape_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "shape_cond", s, 2, "x@[S]@[S]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "bitfield", s, 3, "B" ) ;
    new_cons ( "bottom", s, 4, ( char * ) null ) ;
    new_cons ( "compound", s, 5, "x" ) ;
    new_cons ( "floating", s, 6, "f" ) ;
    new_cons ( "integer", s, 7, "v" ) ;
    new_cons ( "nof", s, 8, "nS" ) ;
    new_cons ( "offset", s, 9, "aa" ) ;
    new_cons ( "pointer", s, 10, "a" ) ;
    new_cons ( "proc", s, 11, ( char * ) null ) ;
    new_cons ( "top", s, 12, ( char * ) null ) ;

    s = SORT_signed_nat ;
    sort_letters [s] = 's' ;
    sort_encoding [s] = 3 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_signed_nat ;
    sort_read [s] = read_signed_nat ;
    new_sort ( s, 6 ) ;
    new_cons ( "signed_nat_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "signed_nat_cond", s, 2, "x@[s]@[s]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "computed_signed_nat", s, 3, "x" ) ;
    new_cons ( "make_signed_nat", s, 4, "ji" ) ;
    new_cons ( "snat_from_nat", s, 5, "bn" ) ;

    s = SORT_sortname ;
    new_sort ( s, 24 ) ;
    new_cons ( "access", s, 1, ( char * ) null ) ;
    new_cons ( "al_tag", s, 2, ( char * ) null ) ;
    new_cons ( "alignment", s, 3, ( char * ) null ) ;
    new_cons ( "bitfield_variety", s, 4, ( char * ) null ) ;
    new_cons ( "bool", s, 5, ( char * ) null ) ;
    new_cons ( "error_treatment", s, 6, ( char * ) null ) ;
    new_cons ( "exp", s, 7, ( char * ) null ) ;
    new_cons ( "floating_variety", s, 8, ( char * ) null ) ;
    new_cons ( "foreign_sort", s, 9, "X" ) ;
    new_cons ( "label", s, 10, ( char * ) null ) ;
    new_cons ( "nat", s, 11, ( char * ) null ) ;
    new_cons ( "ntest", s, 12, ( char * ) null ) ;
    new_cons ( "procprops", s, 13, ( char * ) null ) ;
    new_cons ( "rounding_mode", s, 14, ( char * ) null ) ;
    new_cons ( "shape", s, 15, ( char * ) null ) ;
    new_cons ( "signed_nat", s, 16, ( char * ) null ) ;
    new_cons ( "string", s, 17, ( char * ) null ) ;
    new_cons ( "tag", s, 18, ( char * ) null ) ;
    new_cons ( "transfer_mode", s, 19, ( char * ) null ) ;
    new_cons ( "token", s, 20, "~*[~]" ) ;
    new_cons ( "variety", s, 21, ( char * ) null ) ;
    new_cons ( "callees", s, 22, ( char * ) null ) ;
    new_cons ( "error_code", s, 23, ( char * ) null ) ;

    s = SORT_string ;
    sort_letters [s] = 'X' ;
    sort_encoding [s] = 3 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_string ;
    sort_read [s] = read_string ;
    new_sort ( s, 5 ) ;
    new_cons ( "string_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "string_cond", s, 2, "x@[X]@[X]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "concat_string", s, 3, "XX" ) ;
    new_cons ( "make_string", s, 4, "$" ) ;

    s = SORT_tag ;
    sort_letters [s] = 't' ;
    sort_encoding [s] = 1 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_tag ;
    sort_read [s] = read_tag ;
    new_sort ( s, 3 ) ;
    new_cons ( "tag_apply_token", s, 2, "!" ) ;
    sort_tokens [s] = 2 ;
    new_cons ( "make_tag", s, 1, "i" ) ;

    s = SORT_transfer_mode ;
    sort_letters [s] = 'm' ;
    sort_encoding [s] = 3 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_transfer_mode ;
    sort_read [s] = read_transfer_mode ;
    new_sort ( s, 9 ) ;
    new_cons ( "transfer_mode_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "transfer_mode_cond", s, 2, "x@[m]@[m]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "add_modes", s, 3, "mm" ) ;
    new_cons ( "overlap", s, 4, ( char * ) null ) ;
    new_cons ( "standard_transfer_mode", s, 5, ( char * ) null ) ;
    new_cons ( "trap_on_nil", s, 6, ( char * ) null ) ;
    new_cons ( "volatile", s, 7, ( char * ) null ) ;
    new_cons ( "complete", s, 8, ( char * ) null ) ;

    s = SORT_variety ;
    sort_letters [s] = 'v' ;
    sort_encoding [s] = 2 ;
    sort_extension [s] = 1 ;
    sort_decode [s] = de_variety ;
    sort_read [s] = read_variety ;
    new_sort ( s, 5 ) ;
    new_cons ( "var_apply_token", s, 1, "!" ) ;
    sort_tokens [s] = 1 ;
    new_cons ( "var_cond", s, 2, "x@[v]@[v]" ) ;
    sort_conds [s] = 2 ;
    new_cons ( "var_limits", s, 3, "ss" ) ;
    new_cons ( "var_width", s, 4, "bn" ) ;
    return ;
}


/* FIND A SORT NAME */

sortname find_sort
    PROTO_N ( ( c ) )
    PROTO_T ( char c )
{
    sortname s ;
    switch ( c ) {
	case 'u' : s = SORT_access ; break ;
	case 'A' : s = SORT_al_tag ; break ;
	case 'a' : s = SORT_alignment ; break ;
	case 'B' : s = SORT_bitfield_variety ; break ;
	case 'b' : s = SORT_bool ; break ;
	case 'q' : s = SORT_callees ; break ;
	case 'c' : s = SORT_error_code ; break ;
	case 'e' : s = SORT_error_treatment ; break ;
	case 'x' : s = SORT_exp ; break ;
	case 'f' : s = SORT_floating_variety ; break ;
	case 'l' : s = SORT_label ; break ;
	case 'n' : s = SORT_nat ; break ;
	case 'N' : s = SORT_ntest ; break ;
	case 'P' : s = SORT_procprops ; break ;
	case 'r' : s = SORT_rounding_mode ; break ;
	case 'S' : s = SORT_shape ; break ;
	case 's' : s = SORT_signed_nat ; break ;
	case 'X' : s = SORT_string ; break ;
	case 't' : s = SORT_tag ; break ;
	case 'm' : s = SORT_transfer_mode ; break ;
	case 'v' : s = SORT_variety ; break ;
	default : {
	    input_error ( "Illegal decode letter, %c", c ) ;
	    s = SORT_unknown ;
	    break ;
	}
    }
    return ( s ) ;
}


/* DECODE A ACCESS */

node *de_access
    PROTO_Z ()
{
    long n = fetch_extn ( 4 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_access, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 13 || cons->name == null ) {
	input_error ( "Illegal access value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_access ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "access_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_access
    check_access ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A AL_TAG */

node *de_al_tag
    PROTO_Z ()
{
    long n = fetch_extn ( 1 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_al_tag, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 2 || cons->name == null ) {
	input_error ( "Illegal al_tag value, %ld", n ) ;
    }
    switch ( n ) {
	case 2 : {
	    IGNORE de_token ( p, SORT_al_tag ) ;
	    break ;
	}
	case 1 : {
	    p->son = de_var_sort ( al_tag_var ) ;
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_al_tag
    check_al_tag ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A AL_TAGDEF */

long de_al_tagdef_bits
    PROTO_Z ()
{
    long n = fetch_extn ( 1 ) ;
    if ( n < 1 || n > 1 ) {
	input_error ( "Illegal al_tagdef value, %ld", n ) ;
    }
    return ( n ) ;
}


/* DECODE A ALIGNMENT */

node *de_alignment
    PROTO_Z ()
{
    long n = fetch_extn ( 4 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_alignment, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 12 || cons->name == null ) {
	input_error ( "Illegal alignment value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_alignment ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "alignment_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_alignment
    check_alignment ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A BITFIELD_VARIETY */

node *de_bitfield_variety
    PROTO_Z ()
{
    long n = fetch_extn ( 2 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_bitfield_variety, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 3 || cons->name == null ) {
	input_error ( "Illegal bitfield_variety value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_bitfield_variety ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "bfvar_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_bitfield_variety
    check_bitfield_variety ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A BOOL */

node *de_bool
    PROTO_Z ()
{
    long n = fetch_extn ( 3 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_bool, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 4 || cons->name == null ) {
	input_error ( "Illegal bool value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_bool ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "bool_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_bool
    check_bool ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A CALLEES */

node *de_callees
    PROTO_Z ()
{
    long n = fetch_extn ( 2 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_callees, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 3 || cons->name == null ) {
	input_error ( "Illegal callees value, %ld", n ) ;
    }
    args = get_char_info ( cons ) ;
    if ( args ) p->son = de_node ( args ) ;
#ifdef check_callees
    check_callees ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A ERROR_CODE */

node *de_error_code
    PROTO_Z ()
{
    long n = fetch_extn ( 2 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_error_code, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 3 || cons->name == null ) {
	input_error ( "Illegal error_code value, %ld", n ) ;
    }
    args = get_char_info ( cons ) ;
    if ( args ) p->son = de_node ( args ) ;
#ifdef check_error_code
    check_error_code ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A ERROR_TREATMENT */

node *de_error_treatment
    PROTO_Z ()
{
    long n = fetch_extn ( 3 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_error_treatment, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 7 || cons->name == null ) {
	input_error ( "Illegal error_treatment value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_error_treatment ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "errt_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_error_treatment
    check_error_treatment ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A EXP */

node *de_exp
    PROTO_Z ()
{
    long n = fetch_extn ( 7 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_exp, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 116 || cons->name == null ) {
	input_error ( "Illegal exp value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_exp ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "exp_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_exp
    check_exp ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A EXTERNAL */

long de_external_bits
    PROTO_Z ()
{
    long n = fetch_extn ( 2 ) ;
    if ( n < 1 || n > 3 ) {
	input_error ( "Illegal external value, %ld", n ) ;
    }
    return ( n ) ;
}


/* DECODE A FLOATING_VARIETY */

node *de_floating_variety
    PROTO_Z ()
{
    long n = fetch_extn ( 3 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_floating_variety, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 6 || cons->name == null ) {
	input_error ( "Illegal floating_variety value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_floating_variety ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "flvar_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_floating_variety
    check_floating_variety ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A LABEL */

node *de_label
    PROTO_Z ()
{
    long n = fetch_extn ( 1 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_label, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 2 || cons->name == null ) {
	input_error ( "Illegal label value, %ld", n ) ;
    }
    switch ( n ) {
	case 2 : {
	    IGNORE de_token ( p, SORT_label ) ;
	    break ;
	}
	case 1 : {
	    long m = tdf_int () ;
	    p->son = new_node () ;
	    p->son->cons = find_label ( m ) ;
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_label
    check_label ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A NAT */

node *de_nat
    PROTO_Z ()
{
    long n = fetch_extn ( 3 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_nat, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 5 || cons->name == null ) {
	input_error ( "Illegal nat value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_nat ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "nat_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_nat
    check_nat ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A NTEST */

node *de_ntest
    PROTO_Z ()
{
    long n = fetch_extn ( 4 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_ntest, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 16 || cons->name == null ) {
	input_error ( "Illegal ntest value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_ntest ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "ntest_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_ntest
    check_ntest ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A PROCPROPS */

node *de_procprops
    PROTO_Z ()
{
    long n = fetch_extn ( 4 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_procprops, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 9 || cons->name == null ) {
	input_error ( "Illegal procprops value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_procprops ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "procprops_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_procprops
    check_procprops ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A ROUNDING_MODE */

node *de_rounding_mode
    PROTO_Z ()
{
    long n = fetch_extn ( 3 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_rounding_mode, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 7 || cons->name == null ) {
	input_error ( "Illegal rounding_mode value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_rounding_mode ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "rounding_mode_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_rounding_mode
    check_rounding_mode ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A SHAPE */

node *de_shape
    PROTO_Z ()
{
    long n = fetch_extn ( 4 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_shape, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 12 || cons->name == null ) {
	input_error ( "Illegal shape value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_shape ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "shape_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_shape
    check_shape ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A SIGNED_NAT */

node *de_signed_nat
    PROTO_Z ()
{
    long n = fetch_extn ( 3 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_signed_nat, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 5 || cons->name == null ) {
	input_error ( "Illegal signed_nat value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_signed_nat ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "signed_nat_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_signed_nat
    check_signed_nat ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A SORTNAME */

long de_sortname_bits
    PROTO_Z ()
{
    long n = fetch_extn ( 5 ) ;
    if ( n < 1 || n > 21 ) {
	input_error ( "Illegal sortname value, %ld", n ) ;
    }
    return ( n ) ;
}


/* DECODE A STRING */

node *de_string
    PROTO_Z ()
{
    long n = fetch_extn ( 3 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_string, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 4 || cons->name == null ) {
	input_error ( "Illegal string value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_string ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "string_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_string
    check_string ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A TAG */

node *de_tag
    PROTO_Z ()
{
    long n = fetch_extn ( 1 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_tag, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 2 || cons->name == null ) {
	input_error ( "Illegal tag value, %ld", n ) ;
    }
    switch ( n ) {
	case 2 : {
	    IGNORE de_token ( p, SORT_tag ) ;
	    break ;
	}
	case 1 : {
	    p->son = de_var_sort ( tag_var ) ;
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_tag
    check_tag ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A TAGDEC */

long de_tagdec_bits
    PROTO_Z ()
{
    long n = fetch_extn ( 2 ) ;
    if ( n < 1 || n > 3 ) {
	input_error ( "Illegal tagdec value, %ld", n ) ;
    }
    return ( n ) ;
}


/* DECODE A TAGDEF */

long de_tagdef_bits
    PROTO_Z ()
{
    long n = fetch_extn ( 2 ) ;
    if ( n < 1 || n > 3 ) {
	input_error ( "Illegal tagdef value, %ld", n ) ;
    }
    return ( n ) ;
}


/* DECODE A TOKDEC */

long de_tokdec_bits
    PROTO_Z ()
{
    long n = fetch_extn ( 1 ) ;
    if ( n < 1 || n > 1 ) {
	input_error ( "Illegal tokdec value, %ld", n ) ;
    }
    return ( n ) ;
}


/* DECODE A TOKDEF */

long de_tokdef_bits
    PROTO_Z ()
{
    long n = fetch_extn ( 1 ) ;
    if ( n < 1 || n > 1 ) {
	input_error ( "Illegal tokdef value, %ld", n ) ;
    }
    return ( n ) ;
}


/* DECODE A TOKEN */

long de_token_bits
    PROTO_Z ()
{
    long n = fetch_extn ( 2 ) ;
    if ( n < 1 || n > 3 ) {
	input_error ( "Illegal token value, %ld", n ) ;
    }
    return ( n ) ;
}


/* DECODE A TOKEN_DEFN */

long de_token_defn_bits
    PROTO_Z ()
{
    long n = fetch_extn ( 1 ) ;
    if ( n < 1 || n > 1 ) {
	input_error ( "Illegal token_defn value, %ld", n ) ;
    }
    return ( n ) ;
}


/* DECODE A TRANSFER_MODE */

node *de_transfer_mode
    PROTO_Z ()
{
    long n = fetch_extn ( 3 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_transfer_mode, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 8 || cons->name == null ) {
	input_error ( "Illegal transfer_mode value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_transfer_mode ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "transfer_mode_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_transfer_mode
    check_transfer_mode ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A VARIETY */

node *de_variety
    PROTO_Z ()
{
    long n = fetch_extn ( 2 ) ;
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_variety, n ) ;
    p->cons = cons ;
    if ( n < 1 || n > 4 || cons->name == null ) {
	input_error ( "Illegal variety value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    IGNORE de_token ( p, SORT_variety ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = de_node ( args ) ;
	    if ( do_check ) {
		checking = "var_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = de_node ( args ) ;
	    break ;
	}
    }
#ifdef check_variety
    check_variety ( p ) ;
#endif
    return ( p ) ;
}


/* DECODE A VERSION */

long de_version_bits
    PROTO_Z ()
{
    long n = fetch_extn ( 1 ) ;
    if ( n < 1 || n > 2 ) {
	input_error ( "Illegal version value, %ld", n ) ;
    }
    return ( n ) ;
}


/* ENCODE A AL_TAG */

void enc_al_tag_bits
    PROTO_N ( ( p, n ) )
    PROTO_T ( bitstream *p X int n )
{
    enc_bits_extn ( p, 1, ( long ) n ) ;
    return ;
}


/* ENCODE A AL_TAGDEF */

void enc_al_tagdef_bits
    PROTO_N ( ( p, n ) )
    PROTO_T ( bitstream *p X int n )
{
    enc_bits_extn ( p, 1, ( long ) n ) ;
    return ;
}


/* ENCODE A EXTERNAL */

void enc_external_bits
    PROTO_N ( ( p, n ) )
    PROTO_T ( bitstream *p X int n )
{
    enc_bits_extn ( p, 2, ( long ) n ) ;
    return ;
}


/* ENCODE A LABEL */

void enc_label_bits
    PROTO_N ( ( p, n ) )
    PROTO_T ( bitstream *p X int n )
{
    enc_bits_extn ( p, 1, ( long ) n ) ;
    return ;
}


/* ENCODE A SORTNAME */

void enc_sortname_bits
    PROTO_N ( ( p, n ) )
    PROTO_T ( bitstream *p X int n )
{
    enc_bits_extn ( p, 5, ( long ) n ) ;
    return ;
}


/* ENCODE A TAG */

void enc_tag_bits
    PROTO_N ( ( p, n ) )
    PROTO_T ( bitstream *p X int n )
{
    enc_bits_extn ( p, 1, ( long ) n ) ;
    return ;
}


/* ENCODE A TAGDEC */

void enc_tagdec_bits
    PROTO_N ( ( p, n ) )
    PROTO_T ( bitstream *p X int n )
{
    enc_bits_extn ( p, 2, ( long ) n ) ;
    return ;
}


/* ENCODE A TAGDEF */

void enc_tagdef_bits
    PROTO_N ( ( p, n ) )
    PROTO_T ( bitstream *p X int n )
{
    enc_bits_extn ( p, 2, ( long ) n ) ;
    return ;
}


/* ENCODE A TOKDEC */

void enc_tokdec_bits
    PROTO_N ( ( p, n ) )
    PROTO_T ( bitstream *p X int n )
{
    enc_bits_extn ( p, 1, ( long ) n ) ;
    return ;
}


/* ENCODE A TOKDEF */

void enc_tokdef_bits
    PROTO_N ( ( p, n ) )
    PROTO_T ( bitstream *p X int n )
{
    enc_bits_extn ( p, 1, ( long ) n ) ;
    return ;
}


/* ENCODE A TOKEN */

void enc_token_bits
    PROTO_N ( ( p, n ) )
    PROTO_T ( bitstream *p X int n )
{
    enc_bits_extn ( p, 2, ( long ) n ) ;
    return ;
}


/* ENCODE A TOKEN_DEFN */

void enc_token_defn_bits
    PROTO_N ( ( p, n ) )
    PROTO_T ( bitstream *p X int n )
{
    enc_bits_extn ( p, 1, ( long ) n ) ;
    return ;
}


/* ENCODE A VERSION */

void enc_version_bits
    PROTO_N ( ( p, n ) )
    PROTO_T ( bitstream *p X int n )
{
    enc_bits_extn ( p, 1, ( long ) n ) ;
    return ;
}


/* READ A ACCESS */

node *read_access
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_access, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 13 || cons->name == null ) {
	input_error ( "Illegal access value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_access ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "access_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_access
    check_access ( p ) ;
#endif
    return ( p ) ;
}


/* READ A AL_TAG */

node *read_al_tag
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_al_tag, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 2 || cons->name == null ) {
	input_error ( "Illegal al_tag value, %ld", n ) ;
    }
    switch ( n ) {
	case 2 : {
	    read_token ( p, SORT_al_tag ) ;
	    break ;
	}
	case 1 : {
	    p->son = read_var_sort ( SORT_al_tag ) ;
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_al_tag
    check_al_tag ( p ) ;
#endif
    return ( p ) ;
}


/* READ A ALIGNMENT */

node *read_alignment
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_alignment, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 12 || cons->name == null ) {
	input_error ( "Illegal alignment value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_alignment ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "alignment_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_alignment
    check_alignment ( p ) ;
#endif
    return ( p ) ;
}


/* READ A BITFIELD_VARIETY */

node *read_bitfield_variety
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_bitfield_variety, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 3 || cons->name == null ) {
	input_error ( "Illegal bitfield_variety value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_bitfield_variety ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "bfvar_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_bitfield_variety
    check_bitfield_variety ( p ) ;
#endif
    return ( p ) ;
}


/* READ A BOOL */

node *read_bool
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_bool, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 4 || cons->name == null ) {
	input_error ( "Illegal bool value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_bool ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "bool_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_bool
    check_bool ( p ) ;
#endif
    return ( p ) ;
}


/* READ A CALLEES */

node *read_callees
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_callees, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 3 || cons->name == null ) {
	input_error ( "Illegal callees value, %ld", n ) ;
    }
    args = get_char_info ( cons ) ;
    if ( args ) p->son = read_node ( args ) ;
#ifdef check_callees
    check_callees ( p ) ;
#endif
    return ( p ) ;
}


/* READ A ERROR_CODE */

node *read_error_code
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_error_code, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 3 || cons->name == null ) {
	input_error ( "Illegal error_code value, %ld", n ) ;
    }
    args = get_char_info ( cons ) ;
    if ( args ) p->son = read_node ( args ) ;
#ifdef check_error_code
    check_error_code ( p ) ;
#endif
    return ( p ) ;
}


/* READ A ERROR_TREATMENT */

node *read_error_treatment
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_error_treatment, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 7 || cons->name == null ) {
	input_error ( "Illegal error_treatment value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_error_treatment ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "errt_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_error_treatment
    check_error_treatment ( p ) ;
#endif
    return ( p ) ;
}


/* READ A EXP */

node *read_exp
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_exp, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 116 || cons->name == null ) {
	input_error ( "Illegal exp value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_exp ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "exp_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	case 106 : {
	    read_sequence ( p, get_char_info ( cons ) ) ;
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_exp
    check_exp ( p ) ;
#endif
    return ( p ) ;
}


/* READ A FLOATING_VARIETY */

node *read_floating_variety
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_floating_variety, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 6 || cons->name == null ) {
	input_error ( "Illegal floating_variety value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_floating_variety ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "flvar_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_floating_variety
    check_floating_variety ( p ) ;
#endif
    return ( p ) ;
}


/* READ A LABEL */

node *read_label
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_label, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 2 || cons->name == null ) {
	input_error ( "Illegal label value, %ld", n ) ;
    }
    switch ( n ) {
	case 2 : {
	    read_token ( p, SORT_label ) ;
	    break ;
	}
	case 1 : {
	    p->son = read_var_sort ( SORT_label ) ;
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_label
    check_label ( p ) ;
#endif
    return ( p ) ;
}


/* READ A NAT */

node *read_nat
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_nat, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 5 || cons->name == null ) {
	input_error ( "Illegal nat value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_nat ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "nat_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_nat
    check_nat ( p ) ;
#endif
    return ( p ) ;
}


/* READ A NTEST */

node *read_ntest
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_ntest, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 16 || cons->name == null ) {
	input_error ( "Illegal ntest value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_ntest ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "ntest_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_ntest
    check_ntest ( p ) ;
#endif
    return ( p ) ;
}


/* READ A PROCPROPS */

node *read_procprops
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_procprops, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 9 || cons->name == null ) {
	input_error ( "Illegal procprops value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_procprops ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "procprops_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_procprops
    check_procprops ( p ) ;
#endif
    return ( p ) ;
}


/* READ A ROUNDING_MODE */

node *read_rounding_mode
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_rounding_mode, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 7 || cons->name == null ) {
	input_error ( "Illegal rounding_mode value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_rounding_mode ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "rounding_mode_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_rounding_mode
    check_rounding_mode ( p ) ;
#endif
    return ( p ) ;
}


/* READ A SHAPE */

node *read_shape
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_shape, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 12 || cons->name == null ) {
	input_error ( "Illegal shape value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_shape ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "shape_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_shape
    check_shape ( p ) ;
#endif
    return ( p ) ;
}


/* READ A SIGNED_NAT */

node *read_signed_nat
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_signed_nat, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 5 || cons->name == null ) {
	input_error ( "Illegal signed_nat value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_signed_nat ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "signed_nat_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	case 4 : {
	    read_make_signed_nat ( p, get_char_info ( cons ) ) ;
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_signed_nat
    check_signed_nat ( p ) ;
#endif
    return ( p ) ;
}


/* READ A STRING */

node *read_string
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_string, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 4 || cons->name == null ) {
	input_error ( "Illegal string value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_string ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "string_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_string
    check_string ( p ) ;
#endif
    return ( p ) ;
}


/* READ A TAG */

node *read_tag
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_tag, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 2 || cons->name == null ) {
	input_error ( "Illegal tag value, %ld", n ) ;
    }
    switch ( n ) {
	case 2 : {
	    read_token ( p, SORT_tag ) ;
	    break ;
	}
	case 1 : {
	    p->son = read_var_sort ( SORT_tag ) ;
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_tag
    check_tag ( p ) ;
#endif
    return ( p ) ;
}


/* READ A TRANSFER_MODE */

node *read_transfer_mode
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_transfer_mode, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 8 || cons->name == null ) {
	input_error ( "Illegal transfer_mode value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_transfer_mode ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "transfer_mode_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_transfer_mode
    check_transfer_mode ( p ) ;
#endif
    return ( p ) ;
}


/* READ A VARIETY */

node *read_variety
    PROTO_N ( ( n ) )
    PROTO_T ( long n )
{
    char *args ;
    node *p = new_node () ;
    construct *cons = cons_no ( SORT_variety, n ) ;
    p->cons = cons ;
    if ( n < 0 || n > 4 || cons->name == null ) {
	input_error ( "Illegal variety value, %ld", n ) ;
    }
    switch ( n ) {
	case 1 : {
	    read_token ( p, SORT_variety ) ;
	    break ;
	}
	case 2 : {
	    args = get_char_info ( cons ) ;
	    p->son = read_node ( args ) ;
	    if ( do_check ) {
		checking = "var_cond" ;
		IGNORE check1 ( ENC_integer, p->son ) ;
	    }
	    break ;
	}
	default : {
	    args = get_char_info ( cons ) ;
	    if ( args ) p->son = read_node ( args ) ;
	    break ;
	}
    }
#ifdef check_variety
    check_variety ( p ) ;
#endif
    return ( p ) ;
}
