<?xml version="1.0"?>
<!-- WARNING: Tellico uses tc as the internal namespace declaration, and it must be identical here!! -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:tc="http://periapsis.org/tellico/"
                xmlns:exsl="http://exslt.org/common"
                xmlns:dyn="http://exslt.org/dynamic"
                extension-element-prefixes="exsl dyn"
                exclude-result-prefixes="tc"
                version="1.0">

<!--
   ===================================================================
   Tellico XSLT file - Collection Summary Report

   Copyright (C) 2005 Robby Stephenson - robby@periapsis.org

   This XSLT stylesheet is designed to be used with the 'Tellico'
   application, which can be found at http://www.periapsis.org/tellico/

   ===================================================================
-->

<!-- import common templates -->
<!-- location depends on being installed correctly -->
<xsl:import href="../tellico-common.xsl"/>

<xsl:output method="html" version="xhtml" encoding="utf-8"/>

<xsl:variable name="limit" select="5"/>

<xsl:key name="fieldsByName" match="tc:field" use="@name"/>

<xsl:template match="/">
 <xsl:apply-templates select="tc:tellico"/>
</xsl:template>

<xsl:template match="tc:tellico">
 <html>
  <head>
   <style type="text/css">
   body {
        font-family: sans-serif;
        background-color: #fff;
        color: #000;
   }
   h1.colltitle {
        margin: 0px;
        padding-bottom: 5px;
        font-size: 2em;
        text-align: center;
   }
   div.field {
        margin-left: auto;
        margin-right: auto;
        margin-bottom: 20px;
        width: 750px;
        background-color: #ddd;
        border: solid 1px #999;
   }
   h2 {
        font-size: 125%;
        border-bottom: solid 1px #999;
        text-align: center;
        margin-top: 5px;
        margin-bottom: 0px;
   }
   h3 {
        font-size: 90%;
        color: #666;
        text-align: right;
        padding-right: 4px;
        margin-top: -1em;
        margin-bottom: 0px;
   }
   table {
        margin-left: auto;
        margin-right: auto;
        font-weight: bold;
        font-size: 120%;
        padding-top: 10px;
        padding-bottom: 10px;
   }
   div.row {
        height: 1em;
        margin: 4px 0px 4px 0px;
        border: solid 1px transparent;
   }
   div.group {
        font-weight: bold;
        text-align: left;
        padding: 2px 10px 0px 4px;
        float: left;
   }
   span.bar {
        width: 590px;
        margin: 2px;
        margin-left: 150px;
        position: absolute;
        float: left;
        border-left: solid 5px #ddd; /* padding of a sort */
   }
   span.bar span {
        border-top: outset 1px #669;
        border-right: outset 2px #003;
        border-bottom: outset 2px #003;
        border-left: outset 2px #669;
        height: 1em;
        float: left;
        background-color: #336;
   }
   strong {
        padding-left: 4px;
        color: #666;
        font-style: italic;
   }
   h4 {
        text-align: center;
   }
   </style>
   <title>Tellico</title>
  </head>
  <body>
   <xsl:apply-templates select="tc:collection"/>
  </body>
 </html>
</xsl:template>

<xsl:template match="tc:collection">
 <h1 class="colltitle">
  <xsl:value-of select="@title"/>
  <i18n>: Group Summary</i18n>
 </h1>

 <xsl:variable name="coll" select="."/>

 <table>
  <tbody>
   <tr>
    <td><i18n>Total number of fields:</i18n></td>
    <td style="padding-right: 50px; color: #006;">
     <xsl:value-of select="count(tc:fields/tc:field)"/>
    </td>
    <td><i18n>Total number of entries:</i18n></td>
    <td style="color:#006;">
     <xsl:value-of select="count(tc:entry)"/>
    </td>
   </tr>
  </tbody>
 </table>
 <!-- grouping flag is second bit from right -->
 <xsl:for-each select="tc:fields/tc:field[boolean(floor(@flags div 2) mod 2)]">
  <xsl:call-template name="output-group">
   <xsl:with-param name="coll" select="$coll"/>
   <xsl:with-param name="fieldname" select="@name"/>
  </xsl:call-template>  
 </xsl:for-each>

 <!--
 <h4 xml:space="preserve"><i18n>Generated by</i18n>&#160; <a href="http://www.periapsis.org/tellico/">Tellico</a>.</h4>
-->
</xsl:template>

<xsl:template name="output-group">
 <xsl:param name="coll"/>
 <xsl:param name="fieldname"/>

 <xsl:variable name="str">
  <xsl:choose>
   <xsl:when test="boolean(floor(key('fieldsByName', $fieldname)/@flags mod 2))">
    <xsl:choose>
     <xsl:when test="key('fieldsByName', $fieldname)/@type=8">
      <xsl:value-of select="concat('$coll/tc:entry/tc:',$fieldname,'s/tc:',$fieldname,'/tc:column[1]')"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="concat('$coll/tc:entry/tc:',$fieldname,'s/tc:',$fieldname)"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="concat('$coll/tc:entry/tc:',$fieldname)"/>
   </xsl:otherwise> 
  </xsl:choose>
 </xsl:variable>
 <xsl:variable name="values" select="dyn:evaluate($str)"/>

 <xsl:variable name="listing">
  <xsl:for-each select="$values[not(. = preceding::*)]">
   <!-- speed sorting by ignoring groups with a count of 1 -->
   <xsl:variable name="c" select="count($values[. = current()])"/>
   <xsl:if test="$c &gt; 1">
    <group>
     <xsl:attribute name="name">
      <xsl:call-template name="text-value"/>
     </xsl:attribute>
     <xsl:attribute name="count">
      <xsl:value-of select="$c"/>
     </xsl:attribute>
    </group>
   </xsl:if>
  </xsl:for-each>
 </xsl:variable>

 <xsl:variable name="groups" select="exsl:node-set($listing)/group"/>
 <xsl:variable name="total" select="count($groups)"/>
 
 <xsl:variable name="max">
  <xsl:call-template name="max-count">
   <xsl:with-param name="nodes" select="$groups"/>
  </xsl:call-template>   
 </xsl:variable>

 <xsl:if test="$total &gt; 2">
   
  <div class="field">
   <h2>
    <xsl:value-of select="key('fieldsByName', $fieldname)/@title"/>
   </h2>
   
   <xsl:for-each select="$groups">
    <xsl:sort select="@count" data-type="number" order="descending" />
    <xsl:sort select="@name"/>
    <xsl:if test="position() &lt;= $limit">
     <div class="row">
      <div class="group">
       <xsl:value-of select="@name"/>
      </div>
      <span class="bar">
       <span>
        <xsl:attribute name="style">
         <xsl:text>padding-left:</xsl:text>
         <!-- the 540 is rather arbitrarily dependent on font-size, seem to work -->
         <xsl:value-of select="540 * @count div $max"/>
         <xsl:text>px;</xsl:text>
        </xsl:attribute>
        <xsl:text>&#160;</xsl:text>
       </span>
       <strong>(<xsl:value-of select="@count"/>)</strong>
      </span>
     </div>
    </xsl:if>
   </xsl:for-each>

   <h3>
    <i18n>Distinct values: </i18n><xsl:value-of select="$total"/>
   </h3>
  </div>

 </xsl:if>
</xsl:template>

<xsl:template name="max-count">
 <xsl:param name="nodes" select="/.."/>
 <xsl:param name="max"/>
 
 <xsl:variable name="count" select="count($nodes)"/>
 <xsl:variable name="aNode" select="$nodes[ceiling($count div 2)]"/>
 
 <xsl:choose>
  <xsl:when test="$count = 0">
   <xsl:value-of select="number($max)"/>
  </xsl:when>

  <xsl:otherwise>
   <xsl:call-template name="max-count">
    
    <xsl:with-param name="nodes" select="$nodes[not(@count &lt;= number($aNode/@count))]"/>
    <xsl:with-param name="max">
     <xsl:choose>
      <xsl:when test="not($max) or $aNode/@count &gt; $max">
       <xsl:value-of select="$aNode/@count"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$max"/>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:with-param>
   </xsl:call-template>
  </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<xsl:template name="text-value">
 <xsl:choose>
  <xsl:when test="text()">
   <xsl:value-of select="text()"/>
  </xsl:when>
  <xsl:otherwise>
   <xsl:value-of select="..//tc:column[1]"/>
  </xsl:otherwise>
 </xsl:choose>
</xsl:template>

</xsl:stylesheet>
<!-- Local Variables: -->
<!-- sgml-indent-step: 1 -->
<!-- sgml-indent-data: 1 -->
<!-- End: -->
