/*
 * QtTelepathy, the Tapioca Qt4 Telepathy Client Library
 * Copyright (C) 2006 by INdT
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "QtTelepathy/PropertiesTypes"

using namespace org::freedesktop::Telepathy;

const QDBusArgument &operator>>(const QDBusArgument &argument, org::freedesktop::Telepathy::Property &prop)
{
    argument.beginStructure();
    argument >> prop.id >> prop.value;
    argument.endStructure();
    return argument;
}

QDBusArgument &operator<<(QDBusArgument &argument, const org::freedesktop::Telepathy::Property &prop)
{
    argument.beginStructure();
    argument << prop.id << prop.value;
    argument.endStructure();
    return argument;
}

const QDBusArgument &operator>>(const QDBusArgument &argument, org::freedesktop::Telepathy::PropertyDefinition &propdef)
{
    argument.beginStructure();
    argument >> propdef.id >> propdef.name >> propdef.type >> propdef.flags;
    argument.endStructure();
    return argument;
}

QDBusArgument &operator<<(QDBusArgument &argument, const org::freedesktop::Telepathy::PropertyDefinition &propdef)
{
    argument.beginStructure();
    argument << propdef.id << propdef.name << propdef.type << propdef.flags;
    argument.endStructure();
    return argument;
}

const QDBusArgument &operator>>(const QDBusArgument &argument, org::freedesktop::Telepathy::PropertyFlagChange &propchange)
{
    argument.beginStructure();
    argument >> propchange.id >> propchange.newFlags;
    argument.endStructure();
    return argument;
}

QDBusArgument &operator<<(QDBusArgument &argument, const org::freedesktop::Telepathy::PropertyFlagChange &propchange)
{
    argument.beginStructure();
    argument << propchange.id << propchange.newFlags;
    argument.endStructure();
    return argument;
}
