/*
 * QtTelepathy, the Tapioca Qt4 Telepathy Client Library
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <tobias.hunger@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "QtTelepathy/ConnectionCapabilitiesInterfaceTypes"

const QDBusArgument &operator>>(const QDBusArgument &argument, org::freedesktop::Telepathy::LocalCapabilityInfo &capinfo)
{
    argument.beginStructure();
    argument >> capinfo.channelType >> capinfo.typeSpecificFlags;
    argument.endStructure();
    return argument;
}

QDBusArgument &operator<<(QDBusArgument &argument, const org::freedesktop::Telepathy::LocalCapabilityInfo &capinfo)
{
    argument.beginStructure();
    argument << capinfo.channelType << capinfo.typeSpecificFlags;
    argument.endStructure();
    return argument;
}

const QDBusArgument &operator>>(const QDBusArgument &argument, org::freedesktop::Telepathy::CapabilityInfo &capinfo)
{
    argument.beginStructure();
    argument >> capinfo.contactHandle >> capinfo.channelType >> capinfo.genericFlags >> capinfo.typeSpecificFlags;
    argument.endStructure();
    return argument;
}

QDBusArgument &operator<<(QDBusArgument &argument, const org::freedesktop::Telepathy::CapabilityInfo &capinfo)
{
    argument.beginStructure();
    argument << capinfo.contactHandle << capinfo.channelType << capinfo.genericFlags << capinfo.typeSpecificFlags;
    argument.endStructure();
    return argument;
}

const QDBusArgument &operator>>(const QDBusArgument &argument, org::freedesktop::Telepathy::CapabilitiesChangedInfo &capchange)
{
    argument.beginStructure();
    argument >> capchange.contactHandle >> capchange.channelType >> capchange.oldGenericFlags >> capchange.newGenericFlags >> capchange.oldTypeSpecificFlags >> capchange.newTypeSpecificFlags;
    argument.endStructure();
    return argument;
}

QDBusArgument &operator<<(QDBusArgument &argument, const org::freedesktop::Telepathy::CapabilitiesChangedInfo &capchange)
{
    argument.beginStructure();
    argument << capchange.contactHandle << capchange.channelType << capchange.oldGenericFlags << capchange.newGenericFlags << capchange.oldTypeSpecificFlags << capchange.newTypeSpecificFlags;
    argument.endStructure();
    return argument;
}
