/*
 *  Copyright (C) 2006, Raphaël Slinckx <raphael@slinckx.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id$
 */

#ifndef TP_BLUE_SMS_CONTROLLER_H
#define TP_BLUE_SMS_CONTROLLER_H

#include <glib-object.h>

G_BEGIN_DECLS

#define TP_BLUE_TYPE_SMS_CONTROLLER				(tp_blue_sms_controller_get_type ())
#define TP_BLUE_SMS_CONTROLLER(o)				(G_TYPE_CHECK_INSTANCE_CAST ((o), TP_BLUE_TYPE_SMS_CONTROLLER, TpBlueSmsController))
#define TP_BLUE_SMS_CONTROLLER_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST((k), TP_BLUE_TYPE_SMS_CONTROLLER, TpBlueSmsControllerClass))
#define TP_BLUE_IS_SMS_CONTROLLER(o)			(G_TYPE_CHECK_INSTANCE_TYPE ((o), TP_BLUE_TYPE_SMS_CONTROLLER))
#define TP_BLUE_IS_SMS_CONTROLLER_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), TP_BLUE_TYPE_SMS_CONTROLLER))
#define TP_BLUE_SMS_CONTROLLER_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), TP_BLUE_TYPE_SMS_CONTROLLER, TpBlueSmsControllerClass))

typedef struct _TpBlueSmsControllerClass		TpBlueSmsControllerClass;
typedef struct _TpBlueSmsController				TpBlueSmsController;
typedef struct _TpBlueSmsControllerPrivate	TpBlueSmsControllerPrivate;

struct _TpBlueSmsController
{
	GObject parent;

	/*< private >*/
	TpBlueSmsControllerPrivate *priv;
};

struct _TpBlueSmsControllerClass
{
	GObjectClass parent_class;
	void (* sms_received) (gchar *sms);
	void (* disconnected) (void);
};

GType tp_blue_sms_controller_get_type (void) G_GNUC_CONST;
TpBlueSmsController	*tp_blue_sms_controller_new (gchar *address, guint channel);
gboolean tp_blue_sms_controller_send_sms (TpBlueSmsController *self, gchar *number, gchar *message);
void tp_blue_sms_controller_disconnect_bt (TpBlueSmsController *self);
gboolean tp_blue_sms_controller_connect_bt (TpBlueSmsController *self);
G_END_DECLS

#endif
