//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azblob

import (
	"context"
	"encoding/base64"
	"net/http"
	"strconv"
	"strings"
	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

type blobClient struct {
	con            *connection
	pathRenameMode *PathRenameMode
}

// AbortCopyFromURL - The Abort Copy From URL operation aborts a pending Copy From URL operation, and leaves a destination blob with zero length and full
// metadata.
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) AbortCopyFromURL(ctx context.Context, copyID string, blobAbortCopyFromURLOptions *BlobAbortCopyFromURLOptions, leaseAccessConditions *LeaseAccessConditions) (BlobAbortCopyFromURLResponse, error) {
	req, err := client.abortCopyFromURLCreateRequest(ctx, copyID, blobAbortCopyFromURLOptions, leaseAccessConditions)
	if err != nil {
		return BlobAbortCopyFromURLResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobAbortCopyFromURLResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return BlobAbortCopyFromURLResponse{}, runtime.NewResponseError(resp)
	}
	return client.abortCopyFromURLHandleResponse(resp)
}

// abortCopyFromURLCreateRequest creates the AbortCopyFromURL request.
func (client *blobClient) abortCopyFromURLCreateRequest(ctx context.Context, copyID string, blobAbortCopyFromURLOptions *BlobAbortCopyFromURLOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "copy")
	reqQP.Set("copyid", copyID)
	if blobAbortCopyFromURLOptions != nil && blobAbortCopyFromURLOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobAbortCopyFromURLOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-copy-action", "abort")
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobAbortCopyFromURLOptions != nil && blobAbortCopyFromURLOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobAbortCopyFromURLOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// abortCopyFromURLHandleResponse handles the AbortCopyFromURL response.
func (client *blobClient) abortCopyFromURLHandleResponse(resp *http.Response) (BlobAbortCopyFromURLResponse, error) {
	result := BlobAbortCopyFromURLResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobAbortCopyFromURLResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// AcquireLease - [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete operations
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) AcquireLease(ctx context.Context, blobAcquireLeaseOptions *BlobAcquireLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (BlobAcquireLeaseResponse, error) {
	req, err := client.acquireLeaseCreateRequest(ctx, blobAcquireLeaseOptions, modifiedAccessConditions)
	if err != nil {
		return BlobAcquireLeaseResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobAcquireLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return BlobAcquireLeaseResponse{}, runtime.NewResponseError(resp)
	}
	return client.acquireLeaseHandleResponse(resp)
}

// acquireLeaseCreateRequest creates the AcquireLease request.
func (client *blobClient) acquireLeaseCreateRequest(ctx context.Context, blobAcquireLeaseOptions *BlobAcquireLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	if blobAcquireLeaseOptions != nil && blobAcquireLeaseOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobAcquireLeaseOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-lease-action", "acquire")
	if blobAcquireLeaseOptions != nil && blobAcquireLeaseOptions.Duration != nil {
		req.Raw().Header.Set("x-ms-lease-duration", strconv.FormatInt(int64(*blobAcquireLeaseOptions.Duration), 10))
	}
	if blobAcquireLeaseOptions != nil && blobAcquireLeaseOptions.ProposedLeaseID != nil {
		req.Raw().Header.Set("x-ms-proposed-lease-id", *blobAcquireLeaseOptions.ProposedLeaseID)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobAcquireLeaseOptions != nil && blobAcquireLeaseOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobAcquireLeaseOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// acquireLeaseHandleResponse handles the AcquireLease response.
func (client *blobClient) acquireLeaseHandleResponse(resp *http.Response) (BlobAcquireLeaseResponse, error) {
	result := BlobAcquireLeaseResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobAcquireLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobAcquireLeaseResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// BreakLease - [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete operations
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) BreakLease(ctx context.Context, blobBreakLeaseOptions *BlobBreakLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (BlobBreakLeaseResponse, error) {
	req, err := client.breakLeaseCreateRequest(ctx, blobBreakLeaseOptions, modifiedAccessConditions)
	if err != nil {
		return BlobBreakLeaseResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobBreakLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return BlobBreakLeaseResponse{}, runtime.NewResponseError(resp)
	}
	return client.breakLeaseHandleResponse(resp)
}

// breakLeaseCreateRequest creates the BreakLease request.
func (client *blobClient) breakLeaseCreateRequest(ctx context.Context, blobBreakLeaseOptions *BlobBreakLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	if blobBreakLeaseOptions != nil && blobBreakLeaseOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobBreakLeaseOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-lease-action", "break")
	if blobBreakLeaseOptions != nil && blobBreakLeaseOptions.BreakPeriod != nil {
		req.Raw().Header.Set("x-ms-lease-break-period", strconv.FormatInt(int64(*blobBreakLeaseOptions.BreakPeriod), 10))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobBreakLeaseOptions != nil && blobBreakLeaseOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobBreakLeaseOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// breakLeaseHandleResponse handles the BreakLease response.
func (client *blobClient) breakLeaseHandleResponse(resp *http.Response) (BlobBreakLeaseResponse, error) {
	result := BlobBreakLeaseResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobBreakLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-time"); val != "" {
		leaseTime32, err := strconv.ParseInt(val, 10, 32)
		leaseTime := int32(leaseTime32)
		if err != nil {
			return BlobBreakLeaseResponse{}, err
		}
		result.LeaseTime = &leaseTime
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobBreakLeaseResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// ChangeLease - [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete operations
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) ChangeLease(ctx context.Context, leaseID string, proposedLeaseID string, blobChangeLeaseOptions *BlobChangeLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (BlobChangeLeaseResponse, error) {
	req, err := client.changeLeaseCreateRequest(ctx, leaseID, proposedLeaseID, blobChangeLeaseOptions, modifiedAccessConditions)
	if err != nil {
		return BlobChangeLeaseResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobChangeLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BlobChangeLeaseResponse{}, runtime.NewResponseError(resp)
	}
	return client.changeLeaseHandleResponse(resp)
}

// changeLeaseCreateRequest creates the ChangeLease request.
func (client *blobClient) changeLeaseCreateRequest(ctx context.Context, leaseID string, proposedLeaseID string, blobChangeLeaseOptions *BlobChangeLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	if blobChangeLeaseOptions != nil && blobChangeLeaseOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobChangeLeaseOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-lease-action", "change")
	req.Raw().Header.Set("x-ms-lease-id", leaseID)
	req.Raw().Header.Set("x-ms-proposed-lease-id", proposedLeaseID)
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobChangeLeaseOptions != nil && blobChangeLeaseOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobChangeLeaseOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// changeLeaseHandleResponse handles the ChangeLease response.
func (client *blobClient) changeLeaseHandleResponse(resp *http.Response) (BlobChangeLeaseResponse, error) {
	result := BlobChangeLeaseResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobChangeLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobChangeLeaseResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// CopyFromURL - The Copy From URL operation copies a blob or an internet resource to a new blob. It will not return a response until the copy is complete.
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) CopyFromURL(ctx context.Context, copySource string, blobCopyFromURLOptions *BlobCopyFromURLOptions, sourceModifiedAccessConditions *SourceModifiedAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, leaseAccessConditions *LeaseAccessConditions) (BlobCopyFromURLResponse, error) {
	req, err := client.copyFromURLCreateRequest(ctx, copySource, blobCopyFromURLOptions, sourceModifiedAccessConditions, modifiedAccessConditions, leaseAccessConditions)
	if err != nil {
		return BlobCopyFromURLResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobCopyFromURLResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return BlobCopyFromURLResponse{}, runtime.NewResponseError(resp)
	}
	return client.copyFromURLHandleResponse(resp)
}

// copyFromURLCreateRequest creates the CopyFromURL request.
func (client *blobClient) copyFromURLCreateRequest(ctx context.Context, copySource string, blobCopyFromURLOptions *BlobCopyFromURLOptions, sourceModifiedAccessConditions *SourceModifiedAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if blobCopyFromURLOptions != nil && blobCopyFromURLOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobCopyFromURLOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-requires-sync", "true")
	if blobCopyFromURLOptions != nil && blobCopyFromURLOptions.Metadata != nil {
		for k, v := range blobCopyFromURLOptions.Metadata {
			req.Raw().Header.Set("x-ms-meta-"+k, v)
		}
	}
	if blobCopyFromURLOptions != nil && blobCopyFromURLOptions.Tier != nil {
		req.Raw().Header.Set("x-ms-access-tier", string(*blobCopyFromURLOptions.Tier))
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfModifiedSince != nil {
		req.Raw().Header.Set("x-ms-source-if-modified-since", sourceModifiedAccessConditions.SourceIfModifiedSince.Format(time.RFC1123))
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfUnmodifiedSince != nil {
		req.Raw().Header.Set("x-ms-source-if-unmodified-since", sourceModifiedAccessConditions.SourceIfUnmodifiedSince.Format(time.RFC1123))
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfMatch != nil {
		req.Raw().Header.Set("x-ms-source-if-match", *sourceModifiedAccessConditions.SourceIfMatch)
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfNoneMatch != nil {
		req.Raw().Header.Set("x-ms-source-if-none-match", *sourceModifiedAccessConditions.SourceIfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("x-ms-copy-source", copySource)
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobCopyFromURLOptions != nil && blobCopyFromURLOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobCopyFromURLOptions.RequestID)
	}
	if blobCopyFromURLOptions != nil && blobCopyFromURLOptions.SourceContentMD5 != nil {
		req.Raw().Header.Set("x-ms-source-content-md5", base64.StdEncoding.EncodeToString(blobCopyFromURLOptions.SourceContentMD5))
	}
	if blobCopyFromURLOptions != nil && blobCopyFromURLOptions.BlobTagsString != nil {
		req.Raw().Header.Set("x-ms-tags", *blobCopyFromURLOptions.BlobTagsString)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// copyFromURLHandleResponse handles the CopyFromURL response.
func (client *blobClient) copyFromURLHandleResponse(resp *http.Response) (BlobCopyFromURLResponse, error) {
	result := BlobCopyFromURLResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobCopyFromURLResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("x-ms-version-id"); val != "" {
		result.VersionID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobCopyFromURLResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-copy-id"); val != "" {
		result.CopyID = &val
	}
	if val := resp.Header.Get("x-ms-copy-status"); val != "" {
		result.CopyStatus = &val
	}
	if val := resp.Header.Get("Content-MD5"); val != "" {
		contentMD5, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return BlobCopyFromURLResponse{}, err
		}
		result.ContentMD5 = contentMD5
	}
	if val := resp.Header.Get("x-ms-content-crc64"); val != "" {
		xMSContentCRC64, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return BlobCopyFromURLResponse{}, err
		}
		result.XMSContentCRC64 = xMSContentCRC64
	}
	return result, nil
}

// CreateSnapshot - The Create Snapshot operation creates a read-only snapshot of a blob
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) CreateSnapshot(ctx context.Context, blobCreateSnapshotOptions *BlobCreateSnapshotOptions, cpkInfo *CpkInfo, cpkScopeInfo *CpkScopeInfo, modifiedAccessConditions *ModifiedAccessConditions, leaseAccessConditions *LeaseAccessConditions) (BlobCreateSnapshotResponse, error) {
	req, err := client.createSnapshotCreateRequest(ctx, blobCreateSnapshotOptions, cpkInfo, cpkScopeInfo, modifiedAccessConditions, leaseAccessConditions)
	if err != nil {
		return BlobCreateSnapshotResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobCreateSnapshotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return BlobCreateSnapshotResponse{}, runtime.NewResponseError(resp)
	}
	return client.createSnapshotHandleResponse(resp)
}

// createSnapshotCreateRequest creates the CreateSnapshot request.
func (client *blobClient) createSnapshotCreateRequest(ctx context.Context, blobCreateSnapshotOptions *BlobCreateSnapshotOptions, cpkInfo *CpkInfo, cpkScopeInfo *CpkScopeInfo, modifiedAccessConditions *ModifiedAccessConditions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "snapshot")
	if blobCreateSnapshotOptions != nil && blobCreateSnapshotOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobCreateSnapshotOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if blobCreateSnapshotOptions != nil && blobCreateSnapshotOptions.Metadata != nil {
		for k, v := range blobCreateSnapshotOptions.Metadata {
			req.Raw().Header.Set("x-ms-meta-"+k, v)
		}
	}
	if cpkInfo != nil && cpkInfo.EncryptionKey != nil {
		req.Raw().Header.Set("x-ms-encryption-key", *cpkInfo.EncryptionKey)
	}
	if cpkInfo != nil && cpkInfo.EncryptionKeySHA256 != nil {
		req.Raw().Header.Set("x-ms-encryption-key-sha256", *cpkInfo.EncryptionKeySHA256)
	}
	if cpkInfo != nil && cpkInfo.EncryptionAlgorithm != nil {
		req.Raw().Header.Set("x-ms-encryption-algorithm", "AES256")
	}
	if cpkScopeInfo != nil && cpkScopeInfo.EncryptionScope != nil {
		req.Raw().Header.Set("x-ms-encryption-scope", *cpkScopeInfo.EncryptionScope)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobCreateSnapshotOptions != nil && blobCreateSnapshotOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobCreateSnapshotOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// createSnapshotHandleResponse handles the CreateSnapshot response.
func (client *blobClient) createSnapshotHandleResponse(resp *http.Response) (BlobCreateSnapshotResponse, error) {
	result := BlobCreateSnapshotResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-snapshot"); val != "" {
		result.Snapshot = &val
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobCreateSnapshotResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("x-ms-version-id"); val != "" {
		result.VersionID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobCreateSnapshotResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-request-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return BlobCreateSnapshotResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	return result, nil
}

// Delete - If the storage account's soft delete feature is disabled then, when a blob is deleted, it is permanently removed from the storage account. If
// the storage account's soft delete feature is enabled,
// then, when a blob is deleted, it is marked for deletion and becomes inaccessible immediately. However, the blob service retains the blob or snapshot
// for the number of days specified by the
// DeleteRetentionPolicy section of Storage service properties [Set-Blob-Service-Properties.md]. After the specified number of days has passed, the blob's
// data is permanently removed from the storage
// account. Note that you continue to be charged for the soft-deleted blob's storage until it is permanently removed. Use the List Blobs API and specify
// the "include=deleted" query parameter to discover
// which blobs and snapshots have been soft deleted. You can then use the Undelete Blob API to restore a soft-deleted blob. All other operations on a soft-deleted
// blob or snapshot causes the service to
// return an HTTP status code of 404 (ResourceNotFound).
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) Delete(ctx context.Context, blobDeleteOptions *BlobDeleteOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (BlobDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, blobDeleteOptions, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return BlobDeleteResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return BlobDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteHandleResponse(resp)
}

// deleteCreateRequest creates the Delete request.
func (client *blobClient) deleteCreateRequest(ctx context.Context, blobDeleteOptions *BlobDeleteOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodDelete, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if blobDeleteOptions != nil && blobDeleteOptions.Snapshot != nil {
		reqQP.Set("snapshot", *blobDeleteOptions.Snapshot)
	}
	if blobDeleteOptions != nil && blobDeleteOptions.VersionID != nil {
		reqQP.Set("versionid", *blobDeleteOptions.VersionID)
	}
	if blobDeleteOptions != nil && blobDeleteOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobDeleteOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if blobDeleteOptions != nil && blobDeleteOptions.DeleteSnapshots != nil {
		req.Raw().Header.Set("x-ms-delete-snapshots", string(*blobDeleteOptions.DeleteSnapshots))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobDeleteOptions != nil && blobDeleteOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobDeleteOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// deleteHandleResponse handles the Delete response.
func (client *blobClient) deleteHandleResponse(resp *http.Response) (BlobDeleteResponse, error) {
	result := BlobDeleteResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobDeleteResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// Download - The Download operation reads or downloads a blob from the system, including its metadata and properties. You can also call Download to read
// a snapshot.
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) Download(ctx context.Context, blobDownloadOptions *BlobDownloadOptions, leaseAccessConditions *LeaseAccessConditions, cpkInfo *CpkInfo, modifiedAccessConditions *ModifiedAccessConditions) (BlobDownloadResponse, error) {
	req, err := client.downloadCreateRequest(ctx, blobDownloadOptions, leaseAccessConditions, cpkInfo, modifiedAccessConditions)
	if err != nil {
		return BlobDownloadResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobDownloadResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusPartialContent) {
		return BlobDownloadResponse{}, runtime.NewResponseError(resp)
	}
	return client.downloadHandleResponse(resp)
}

// downloadCreateRequest creates the Download request.
func (client *blobClient) downloadCreateRequest(ctx context.Context, blobDownloadOptions *BlobDownloadOptions, leaseAccessConditions *LeaseAccessConditions, cpkInfo *CpkInfo, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if blobDownloadOptions != nil && blobDownloadOptions.Snapshot != nil {
		reqQP.Set("snapshot", *blobDownloadOptions.Snapshot)
	}
	if blobDownloadOptions != nil && blobDownloadOptions.VersionID != nil {
		reqQP.Set("versionid", *blobDownloadOptions.VersionID)
	}
	if blobDownloadOptions != nil && blobDownloadOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobDownloadOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	if blobDownloadOptions != nil && blobDownloadOptions.Range != nil {
		req.Raw().Header.Set("x-ms-range", *blobDownloadOptions.Range)
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if blobDownloadOptions != nil && blobDownloadOptions.RangeGetContentMD5 != nil {
		req.Raw().Header.Set("x-ms-range-get-content-md5", strconv.FormatBool(*blobDownloadOptions.RangeGetContentMD5))
	}
	if blobDownloadOptions != nil && blobDownloadOptions.RangeGetContentCRC64 != nil {
		req.Raw().Header.Set("x-ms-range-get-content-crc64", strconv.FormatBool(*blobDownloadOptions.RangeGetContentCRC64))
	}
	if cpkInfo != nil && cpkInfo.EncryptionKey != nil {
		req.Raw().Header.Set("x-ms-encryption-key", *cpkInfo.EncryptionKey)
	}
	if cpkInfo != nil && cpkInfo.EncryptionKeySHA256 != nil {
		req.Raw().Header.Set("x-ms-encryption-key-sha256", *cpkInfo.EncryptionKeySHA256)
	}
	if cpkInfo != nil && cpkInfo.EncryptionAlgorithm != nil {
		req.Raw().Header.Set("x-ms-encryption-algorithm", "AES256")
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobDownloadOptions != nil && blobDownloadOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobDownloadOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// downloadHandleResponse handles the Download response.
func (client *blobClient) downloadHandleResponse(resp *http.Response) (BlobDownloadResponse, error) {
	result := BlobDownloadResponse{RawResponse: resp}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobDownloadResponse{}, err
		}
		result.LastModified = &lastModified
	}
	for hh := range resp.Header {
		if len(hh) > len("x-ms-meta-") && strings.EqualFold(hh[:len("x-ms-meta-")], "x-ms-meta-") {
			if result.Metadata == nil {
				result.Metadata = map[string]string{}
			}
			result.Metadata[hh[len("x-ms-meta-"):]] = resp.Header.Get(hh)
		}
	}
	if val := resp.Header.Get("x-ms-or-policy-id"); val != "" {
		result.ObjectReplicationPolicyID = &val
	}
	for hh := range resp.Header {
		if len(hh) > len("x-ms-or-") && strings.EqualFold(hh[:len("x-ms-or-")], "x-ms-or-") {
			if result.Metadata == nil {
				result.Metadata = map[string]string{}
			}
			result.Metadata[hh[len("x-ms-or-"):]] = resp.Header.Get(hh)
		}
	}
	if val := resp.Header.Get("Content-Length"); val != "" {
		contentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return BlobDownloadResponse{}, err
		}
		result.ContentLength = &contentLength
	}
	if val := resp.Header.Get("Content-Type"); val != "" {
		result.ContentType = &val
	}
	if val := resp.Header.Get("Content-Range"); val != "" {
		result.ContentRange = &val
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Content-MD5"); val != "" {
		contentMD5, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return BlobDownloadResponse{}, err
		}
		result.ContentMD5 = contentMD5
	}
	if val := resp.Header.Get("Content-Encoding"); val != "" {
		result.ContentEncoding = &val
	}
	if val := resp.Header.Get("Cache-Control"); val != "" {
		result.CacheControl = &val
	}
	if val := resp.Header.Get("Content-Disposition"); val != "" {
		result.ContentDisposition = &val
	}
	if val := resp.Header.Get("Content-Language"); val != "" {
		result.ContentLanguage = &val
	}
	if val := resp.Header.Get("x-ms-blob-sequence-number"); val != "" {
		blobSequenceNumber, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return BlobDownloadResponse{}, err
		}
		result.BlobSequenceNumber = &blobSequenceNumber
	}
	if val := resp.Header.Get("x-ms-blob-type"); val != "" {
		result.BlobType = (*BlobType)(&val)
	}
	if val := resp.Header.Get("x-ms-copy-completion-time"); val != "" {
		copyCompletionTime, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobDownloadResponse{}, err
		}
		result.CopyCompletionTime = &copyCompletionTime
	}
	if val := resp.Header.Get("x-ms-copy-status-description"); val != "" {
		result.CopyStatusDescription = &val
	}
	if val := resp.Header.Get("x-ms-copy-id"); val != "" {
		result.CopyID = &val
	}
	if val := resp.Header.Get("x-ms-copy-progress"); val != "" {
		result.CopyProgress = &val
	}
	if val := resp.Header.Get("x-ms-copy-source"); val != "" {
		result.CopySource = &val
	}
	if val := resp.Header.Get("x-ms-copy-status"); val != "" {
		result.CopyStatus = (*CopyStatusType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-duration"); val != "" {
		result.LeaseDuration = (*LeaseDurationType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-state"); val != "" {
		result.LeaseState = (*LeaseStateType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-status"); val != "" {
		result.LeaseStatus = (*LeaseStatusType)(&val)
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("x-ms-version-id"); val != "" {
		result.VersionID = &val
	}
	if val := resp.Header.Get("x-ms-is-current-version"); val != "" {
		isCurrentVersion, err := strconv.ParseBool(val)
		if err != nil {
			return BlobDownloadResponse{}, err
		}
		result.IsCurrentVersion = &isCurrentVersion
	}
	if val := resp.Header.Get("Accept-Ranges"); val != "" {
		result.AcceptRanges = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobDownloadResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-blob-committed-block-count"); val != "" {
		blobCommittedBlockCount32, err := strconv.ParseInt(val, 10, 32)
		blobCommittedBlockCount := int32(blobCommittedBlockCount32)
		if err != nil {
			return BlobDownloadResponse{}, err
		}
		result.BlobCommittedBlockCount = &blobCommittedBlockCount
	}
	if val := resp.Header.Get("x-ms-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return BlobDownloadResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("x-ms-encryption-key-sha256"); val != "" {
		result.EncryptionKeySHA256 = &val
	}
	if val := resp.Header.Get("x-ms-encryption-scope"); val != "" {
		result.EncryptionScope = &val
	}
	if val := resp.Header.Get("x-ms-blob-content-md5"); val != "" {
		blobContentMD5, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return BlobDownloadResponse{}, err
		}
		result.BlobContentMD5 = blobContentMD5
	}
	if val := resp.Header.Get("x-ms-tag-count"); val != "" {
		tagCount, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return BlobDownloadResponse{}, err
		}
		result.TagCount = &tagCount
	}
	if val := resp.Header.Get("x-ms-blob-sealed"); val != "" {
		isSealed, err := strconv.ParseBool(val)
		if err != nil {
			return BlobDownloadResponse{}, err
		}
		result.IsSealed = &isSealed
	}
	if val := resp.Header.Get("x-ms-content-crc64"); val != "" {
		contentCRC64, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return BlobDownloadResponse{}, err
		}
		result.ContentCRC64 = contentCRC64
	}
	return result, nil
}

// GetAccessControl - Get the owner, group, permissions, or access control list for a blob.
// If the operation fails it returns the *DataLakeStorageError error type.
func (client *blobClient) GetAccessControl(ctx context.Context, blobGetAccessControlOptions *BlobGetAccessControlOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (BlobGetAccessControlResponse, error) {
	req, err := client.getAccessControlCreateRequest(ctx, blobGetAccessControlOptions, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return BlobGetAccessControlResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobGetAccessControlResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BlobGetAccessControlResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAccessControlHandleResponse(resp)
}

// getAccessControlCreateRequest creates the GetAccessControl request.
func (client *blobClient) getAccessControlCreateRequest(ctx context.Context, blobGetAccessControlOptions *BlobGetAccessControlOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodHead, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("action", "getAccessControl")
	if blobGetAccessControlOptions != nil && blobGetAccessControlOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobGetAccessControlOptions.Timeout), 10))
	}
	if blobGetAccessControlOptions != nil && blobGetAccessControlOptions.Upn != nil {
		reqQP.Set("upn", strconv.FormatBool(*blobGetAccessControlOptions.Upn))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if blobGetAccessControlOptions != nil && blobGetAccessControlOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobGetAccessControlOptions.RequestID)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// getAccessControlHandleResponse handles the GetAccessControl response.
func (client *blobClient) getAccessControlHandleResponse(resp *http.Response) (BlobGetAccessControlResponse, error) {
	result := BlobGetAccessControlResponse{RawResponse: resp}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobGetAccessControlResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobGetAccessControlResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-owner"); val != "" {
		result.XMSOwner = &val
	}
	if val := resp.Header.Get("x-ms-group"); val != "" {
		result.XMSGroup = &val
	}
	if val := resp.Header.Get("x-ms-permissions"); val != "" {
		result.XMSPermissions = &val
	}
	if val := resp.Header.Get("x-ms-acl"); val != "" {
		result.XMSACL = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// GetAccountInfo - Returns the sku name and account kind
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) GetAccountInfo(ctx context.Context, options *BlobGetAccountInfoOptions) (BlobGetAccountInfoResponse, error) {
	req, err := client.getAccountInfoCreateRequest(ctx, options)
	if err != nil {
		return BlobGetAccountInfoResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobGetAccountInfoResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BlobGetAccountInfoResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAccountInfoHandleResponse(resp)
}

// getAccountInfoCreateRequest creates the GetAccountInfo request.
func (client *blobClient) getAccountInfoCreateRequest(ctx context.Context, options *BlobGetAccountInfoOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "account")
	reqQP.Set("comp", "properties")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// getAccountInfoHandleResponse handles the GetAccountInfo response.
func (client *blobClient) getAccountInfoHandleResponse(resp *http.Response) (BlobGetAccountInfoResponse, error) {
	result := BlobGetAccountInfoResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobGetAccountInfoResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-sku-name"); val != "" {
		result.SKUName = (*SKUName)(&val)
	}
	if val := resp.Header.Get("x-ms-account-kind"); val != "" {
		result.AccountKind = (*AccountKind)(&val)
	}
	return result, nil
}

// GetProperties - The Get Properties operation returns all user-defined metadata, standard HTTP properties, and system properties for the blob. It does
// not return the content of the blob.
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) GetProperties(ctx context.Context, blobGetPropertiesOptions *BlobGetPropertiesOptions, leaseAccessConditions *LeaseAccessConditions, cpkInfo *CpkInfo, modifiedAccessConditions *ModifiedAccessConditions) (BlobGetPropertiesResponse, error) {
	req, err := client.getPropertiesCreateRequest(ctx, blobGetPropertiesOptions, leaseAccessConditions, cpkInfo, modifiedAccessConditions)
	if err != nil {
		return BlobGetPropertiesResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobGetPropertiesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BlobGetPropertiesResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPropertiesHandleResponse(resp)
}

// getPropertiesCreateRequest creates the GetProperties request.
func (client *blobClient) getPropertiesCreateRequest(ctx context.Context, blobGetPropertiesOptions *BlobGetPropertiesOptions, leaseAccessConditions *LeaseAccessConditions, cpkInfo *CpkInfo, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodHead, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if blobGetPropertiesOptions != nil && blobGetPropertiesOptions.Snapshot != nil {
		reqQP.Set("snapshot", *blobGetPropertiesOptions.Snapshot)
	}
	if blobGetPropertiesOptions != nil && blobGetPropertiesOptions.VersionID != nil {
		reqQP.Set("versionid", *blobGetPropertiesOptions.VersionID)
	}
	if blobGetPropertiesOptions != nil && blobGetPropertiesOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobGetPropertiesOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if cpkInfo != nil && cpkInfo.EncryptionKey != nil {
		req.Raw().Header.Set("x-ms-encryption-key", *cpkInfo.EncryptionKey)
	}
	if cpkInfo != nil && cpkInfo.EncryptionKeySHA256 != nil {
		req.Raw().Header.Set("x-ms-encryption-key-sha256", *cpkInfo.EncryptionKeySHA256)
	}
	if cpkInfo != nil && cpkInfo.EncryptionAlgorithm != nil {
		req.Raw().Header.Set("x-ms-encryption-algorithm", "AES256")
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobGetPropertiesOptions != nil && blobGetPropertiesOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobGetPropertiesOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// getPropertiesHandleResponse handles the GetProperties response.
func (client *blobClient) getPropertiesHandleResponse(resp *http.Response) (BlobGetPropertiesResponse, error) {
	result := BlobGetPropertiesResponse{RawResponse: resp}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-creation-time"); val != "" {
		creationTime, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.CreationTime = &creationTime
	}
	for hh := range resp.Header {
		if len(hh) > len("x-ms-meta-") && strings.EqualFold(hh[:len("x-ms-meta-")], "x-ms-meta-") {
			if result.Metadata == nil {
				result.Metadata = map[string]string{}
			}
			result.Metadata[hh[len("x-ms-meta-"):]] = resp.Header.Get(hh)
		}
	}
	if val := resp.Header.Get("x-ms-or-policy-id"); val != "" {
		result.ObjectReplicationPolicyID = &val
	}
	for hh := range resp.Header {
		if len(hh) > len("x-ms-or-") && strings.EqualFold(hh[:len("x-ms-or-")], "x-ms-or-") {
			if result.Metadata == nil {
				result.Metadata = map[string]string{}
			}
			result.Metadata[hh[len("x-ms-or-"):]] = resp.Header.Get(hh)
		}
	}
	if val := resp.Header.Get("x-ms-blob-type"); val != "" {
		result.BlobType = (*BlobType)(&val)
	}
	if val := resp.Header.Get("x-ms-copy-completion-time"); val != "" {
		copyCompletionTime, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.CopyCompletionTime = &copyCompletionTime
	}
	if val := resp.Header.Get("x-ms-copy-status-description"); val != "" {
		result.CopyStatusDescription = &val
	}
	if val := resp.Header.Get("x-ms-copy-id"); val != "" {
		result.CopyID = &val
	}
	if val := resp.Header.Get("x-ms-copy-progress"); val != "" {
		result.CopyProgress = &val
	}
	if val := resp.Header.Get("x-ms-copy-source"); val != "" {
		result.CopySource = &val
	}
	if val := resp.Header.Get("x-ms-copy-status"); val != "" {
		result.CopyStatus = (*CopyStatusType)(&val)
	}
	if val := resp.Header.Get("x-ms-incremental-copy"); val != "" {
		isIncrementalCopy, err := strconv.ParseBool(val)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.IsIncrementalCopy = &isIncrementalCopy
	}
	if val := resp.Header.Get("x-ms-copy-destination-snapshot"); val != "" {
		result.DestinationSnapshot = &val
	}
	if val := resp.Header.Get("x-ms-lease-duration"); val != "" {
		result.LeaseDuration = (*LeaseDurationType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-state"); val != "" {
		result.LeaseState = (*LeaseStateType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-status"); val != "" {
		result.LeaseStatus = (*LeaseStatusType)(&val)
	}
	if val := resp.Header.Get("Content-Length"); val != "" {
		contentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.ContentLength = &contentLength
	}
	if val := resp.Header.Get("Content-Type"); val != "" {
		result.ContentType = &val
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Content-MD5"); val != "" {
		contentMD5, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.ContentMD5 = contentMD5
	}
	if val := resp.Header.Get("Content-Encoding"); val != "" {
		result.ContentEncoding = &val
	}
	if val := resp.Header.Get("Content-Disposition"); val != "" {
		result.ContentDisposition = &val
	}
	if val := resp.Header.Get("Content-Language"); val != "" {
		result.ContentLanguage = &val
	}
	if val := resp.Header.Get("Cache-Control"); val != "" {
		result.CacheControl = &val
	}
	if val := resp.Header.Get("x-ms-blob-sequence-number"); val != "" {
		blobSequenceNumber, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.BlobSequenceNumber = &blobSequenceNumber
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("Accept-Ranges"); val != "" {
		result.AcceptRanges = &val
	}
	if val := resp.Header.Get("x-ms-blob-committed-block-count"); val != "" {
		blobCommittedBlockCount32, err := strconv.ParseInt(val, 10, 32)
		blobCommittedBlockCount := int32(blobCommittedBlockCount32)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.BlobCommittedBlockCount = &blobCommittedBlockCount
	}
	if val := resp.Header.Get("x-ms-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("x-ms-encryption-key-sha256"); val != "" {
		result.EncryptionKeySHA256 = &val
	}
	if val := resp.Header.Get("x-ms-encryption-scope"); val != "" {
		result.EncryptionScope = &val
	}
	if val := resp.Header.Get("x-ms-access-tier"); val != "" {
		result.AccessTier = &val
	}
	if val := resp.Header.Get("x-ms-access-tier-inferred"); val != "" {
		accessTierInferred, err := strconv.ParseBool(val)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.AccessTierInferred = &accessTierInferred
	}
	if val := resp.Header.Get("x-ms-archive-status"); val != "" {
		result.ArchiveStatus = &val
	}
	if val := resp.Header.Get("x-ms-access-tier-change-time"); val != "" {
		accessTierChangeTime, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.AccessTierChangeTime = &accessTierChangeTime
	}
	if val := resp.Header.Get("x-ms-version-id"); val != "" {
		result.VersionID = &val
	}
	if val := resp.Header.Get("x-ms-is-current-version"); val != "" {
		isCurrentVersion, err := strconv.ParseBool(val)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.IsCurrentVersion = &isCurrentVersion
	}
	if val := resp.Header.Get("x-ms-tag-count"); val != "" {
		tagCount, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.TagCount = &tagCount
	}
	if val := resp.Header.Get("x-ms-expiry-time"); val != "" {
		expiresOn, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.ExpiresOn = &expiresOn
	}
	if val := resp.Header.Get("x-ms-blob-sealed"); val != "" {
		isSealed, err := strconv.ParseBool(val)
		if err != nil {
			return BlobGetPropertiesResponse{}, err
		}
		result.IsSealed = &isSealed
	}
	if val := resp.Header.Get("x-ms-rehydrate-priority"); val != "" {
		result.RehydratePriority = &val
	}
	return result, nil
}

// GetTags - The Get Tags operation enables users to get the tags associated with a blob.
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) GetTags(ctx context.Context, blobGetTagsOptions *BlobGetTagsOptions, modifiedAccessConditions *ModifiedAccessConditions) (BlobGetTagsResponse, error) {
	req, err := client.getTagsCreateRequest(ctx, blobGetTagsOptions, modifiedAccessConditions)
	if err != nil {
		return BlobGetTagsResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobGetTagsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BlobGetTagsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getTagsHandleResponse(resp)
}

// getTagsCreateRequest creates the GetTags request.
func (client *blobClient) getTagsCreateRequest(ctx context.Context, blobGetTagsOptions *BlobGetTagsOptions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "tags")
	if blobGetTagsOptions != nil && blobGetTagsOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobGetTagsOptions.Timeout), 10))
	}
	if blobGetTagsOptions != nil && blobGetTagsOptions.Snapshot != nil {
		reqQP.Set("snapshot", *blobGetTagsOptions.Snapshot)
	}
	if blobGetTagsOptions != nil && blobGetTagsOptions.VersionID != nil {
		reqQP.Set("versionid", *blobGetTagsOptions.VersionID)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobGetTagsOptions != nil && blobGetTagsOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobGetTagsOptions.RequestID)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// getTagsHandleResponse handles the GetTags response.
func (client *blobClient) getTagsHandleResponse(resp *http.Response) (BlobGetTagsResponse, error) {
	result := BlobGetTagsResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobGetTagsResponse{}, err
		}
		result.Date = &date
	}
	if err := runtime.UnmarshalAsXML(resp, &result.BlobTags); err != nil {
		return BlobGetTagsResponse{}, err
	}
	return result, nil
}

// Query - The Query operation enables users to select/project on blob data by providing simple query expressions.
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) Query(ctx context.Context, blobQueryOptions *BlobQueryOptions, leaseAccessConditions *LeaseAccessConditions, cpkInfo *CpkInfo, modifiedAccessConditions *ModifiedAccessConditions) (BlobQueryResponse, error) {
	req, err := client.queryCreateRequest(ctx, blobQueryOptions, leaseAccessConditions, cpkInfo, modifiedAccessConditions)
	if err != nil {
		return BlobQueryResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobQueryResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusPartialContent) {
		return BlobQueryResponse{}, runtime.NewResponseError(resp)
	}
	return client.queryHandleResponse(resp)
}

// queryCreateRequest creates the Query request.
func (client *blobClient) queryCreateRequest(ctx context.Context, blobQueryOptions *BlobQueryOptions, leaseAccessConditions *LeaseAccessConditions, cpkInfo *CpkInfo, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPost, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "query")
	if blobQueryOptions != nil && blobQueryOptions.Snapshot != nil {
		reqQP.Set("snapshot", *blobQueryOptions.Snapshot)
	}
	if blobQueryOptions != nil && blobQueryOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobQueryOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if cpkInfo != nil && cpkInfo.EncryptionKey != nil {
		req.Raw().Header.Set("x-ms-encryption-key", *cpkInfo.EncryptionKey)
	}
	if cpkInfo != nil && cpkInfo.EncryptionKeySHA256 != nil {
		req.Raw().Header.Set("x-ms-encryption-key-sha256", *cpkInfo.EncryptionKeySHA256)
	}
	if cpkInfo != nil && cpkInfo.EncryptionAlgorithm != nil {
		req.Raw().Header.Set("x-ms-encryption-algorithm", "AES256")
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobQueryOptions != nil && blobQueryOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobQueryOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	if blobQueryOptions != nil && blobQueryOptions.QueryRequest != nil {
		return req, runtime.MarshalAsXML(req, *blobQueryOptions.QueryRequest)
	}
	return req, nil
}

// queryHandleResponse handles the Query response.
func (client *blobClient) queryHandleResponse(resp *http.Response) (BlobQueryResponse, error) {
	result := BlobQueryResponse{RawResponse: resp}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobQueryResponse{}, err
		}
		result.LastModified = &lastModified
	}
	for hh := range resp.Header {
		if len(hh) > len("x-ms-meta-") && strings.EqualFold(hh[:len("x-ms-meta-")], "x-ms-meta-") {
			if result.Metadata == nil {
				result.Metadata = map[string]string{}
			}
			result.Metadata[hh[len("x-ms-meta-"):]] = resp.Header.Get(hh)
		}
	}
	if val := resp.Header.Get("Content-Length"); val != "" {
		contentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return BlobQueryResponse{}, err
		}
		result.ContentLength = &contentLength
	}
	if val := resp.Header.Get("Content-Type"); val != "" {
		result.ContentType = &val
	}
	if val := resp.Header.Get("Content-Range"); val != "" {
		result.ContentRange = &val
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Content-MD5"); val != "" {
		contentMD5, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return BlobQueryResponse{}, err
		}
		result.ContentMD5 = contentMD5
	}
	if val := resp.Header.Get("Content-Encoding"); val != "" {
		result.ContentEncoding = &val
	}
	if val := resp.Header.Get("Cache-Control"); val != "" {
		result.CacheControl = &val
	}
	if val := resp.Header.Get("Content-Disposition"); val != "" {
		result.ContentDisposition = &val
	}
	if val := resp.Header.Get("Content-Language"); val != "" {
		result.ContentLanguage = &val
	}
	if val := resp.Header.Get("x-ms-blob-sequence-number"); val != "" {
		blobSequenceNumber, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return BlobQueryResponse{}, err
		}
		result.BlobSequenceNumber = &blobSequenceNumber
	}
	if val := resp.Header.Get("x-ms-blob-type"); val != "" {
		result.BlobType = (*BlobType)(&val)
	}
	if val := resp.Header.Get("x-ms-copy-completion-time"); val != "" {
		copyCompletionTime, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobQueryResponse{}, err
		}
		result.CopyCompletionTime = &copyCompletionTime
	}
	if val := resp.Header.Get("x-ms-copy-status-description"); val != "" {
		result.CopyStatusDescription = &val
	}
	if val := resp.Header.Get("x-ms-copy-id"); val != "" {
		result.CopyID = &val
	}
	if val := resp.Header.Get("x-ms-copy-progress"); val != "" {
		result.CopyProgress = &val
	}
	if val := resp.Header.Get("x-ms-copy-source"); val != "" {
		result.CopySource = &val
	}
	if val := resp.Header.Get("x-ms-copy-status"); val != "" {
		result.CopyStatus = (*CopyStatusType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-duration"); val != "" {
		result.LeaseDuration = (*LeaseDurationType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-state"); val != "" {
		result.LeaseState = (*LeaseStateType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-status"); val != "" {
		result.LeaseStatus = (*LeaseStatusType)(&val)
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Accept-Ranges"); val != "" {
		result.AcceptRanges = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobQueryResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-blob-committed-block-count"); val != "" {
		blobCommittedBlockCount32, err := strconv.ParseInt(val, 10, 32)
		blobCommittedBlockCount := int32(blobCommittedBlockCount32)
		if err != nil {
			return BlobQueryResponse{}, err
		}
		result.BlobCommittedBlockCount = &blobCommittedBlockCount
	}
	if val := resp.Header.Get("x-ms-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return BlobQueryResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("x-ms-encryption-key-sha256"); val != "" {
		result.EncryptionKeySHA256 = &val
	}
	if val := resp.Header.Get("x-ms-encryption-scope"); val != "" {
		result.EncryptionScope = &val
	}
	if val := resp.Header.Get("x-ms-blob-content-md5"); val != "" {
		blobContentMD5, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return BlobQueryResponse{}, err
		}
		result.BlobContentMD5 = blobContentMD5
	}
	if val := resp.Header.Get("x-ms-content-crc64"); val != "" {
		contentCRC64, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return BlobQueryResponse{}, err
		}
		result.ContentCRC64 = contentCRC64
	}
	return result, nil
}

// ReleaseLease - [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete operations
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) ReleaseLease(ctx context.Context, leaseID string, blobReleaseLeaseOptions *BlobReleaseLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (BlobReleaseLeaseResponse, error) {
	req, err := client.releaseLeaseCreateRequest(ctx, leaseID, blobReleaseLeaseOptions, modifiedAccessConditions)
	if err != nil {
		return BlobReleaseLeaseResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobReleaseLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BlobReleaseLeaseResponse{}, runtime.NewResponseError(resp)
	}
	return client.releaseLeaseHandleResponse(resp)
}

// releaseLeaseCreateRequest creates the ReleaseLease request.
func (client *blobClient) releaseLeaseCreateRequest(ctx context.Context, leaseID string, blobReleaseLeaseOptions *BlobReleaseLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	if blobReleaseLeaseOptions != nil && blobReleaseLeaseOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobReleaseLeaseOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-lease-action", "release")
	req.Raw().Header.Set("x-ms-lease-id", leaseID)
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobReleaseLeaseOptions != nil && blobReleaseLeaseOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobReleaseLeaseOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// releaseLeaseHandleResponse handles the ReleaseLease response.
func (client *blobClient) releaseLeaseHandleResponse(resp *http.Response) (BlobReleaseLeaseResponse, error) {
	result := BlobReleaseLeaseResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobReleaseLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobReleaseLeaseResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// Rename - Rename a blob/file. By default, the destination is overwritten and if the destination already exists and has a lease the lease is broken. This
// operation supports conditional HTTP requests. For more
// information, see Specifying Conditional Headers for Blob Service Operations [https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations].
// To
// fail if the destination already exists, use a conditional request with If-None-Match: "*".
// If the operation fails it returns the *DataLakeStorageError error type.
func (client *blobClient) Rename(ctx context.Context, renameSource string, blobRenameOptions *BlobRenameOptions, directoryHTTPHeaders *DirectoryHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, sourceModifiedAccessConditions *SourceModifiedAccessConditions) (BlobRenameResponse, error) {
	req, err := client.renameCreateRequest(ctx, renameSource, blobRenameOptions, directoryHTTPHeaders, leaseAccessConditions, modifiedAccessConditions, sourceModifiedAccessConditions)
	if err != nil {
		return BlobRenameResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobRenameResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return BlobRenameResponse{}, runtime.NewResponseError(resp)
	}
	return client.renameHandleResponse(resp)
}

// renameCreateRequest creates the Rename request.
func (client *blobClient) renameCreateRequest(ctx context.Context, renameSource string, blobRenameOptions *BlobRenameOptions, directoryHTTPHeaders *DirectoryHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, sourceModifiedAccessConditions *SourceModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if blobRenameOptions != nil && blobRenameOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobRenameOptions.Timeout), 10))
	}
	if client.pathRenameMode != nil {
		reqQP.Set("mode", string(*client.pathRenameMode))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-rename-source", renameSource)
	if blobRenameOptions != nil && blobRenameOptions.DirectoryProperties != nil {
		req.Raw().Header.Set("x-ms-properties", *blobRenameOptions.DirectoryProperties)
	}
	if blobRenameOptions != nil && blobRenameOptions.PosixPermissions != nil {
		req.Raw().Header.Set("x-ms-permissions", *blobRenameOptions.PosixPermissions)
	}
	if blobRenameOptions != nil && blobRenameOptions.PosixUmask != nil {
		req.Raw().Header.Set("x-ms-umask", *blobRenameOptions.PosixUmask)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.CacheControl != nil {
		req.Raw().Header.Set("x-ms-cache-control", *directoryHTTPHeaders.CacheControl)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.ContentType != nil {
		req.Raw().Header.Set("x-ms-content-type", *directoryHTTPHeaders.ContentType)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.ContentEncoding != nil {
		req.Raw().Header.Set("x-ms-content-encoding", *directoryHTTPHeaders.ContentEncoding)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.ContentLanguage != nil {
		req.Raw().Header.Set("x-ms-content-language", *directoryHTTPHeaders.ContentLanguage)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.ContentDisposition != nil {
		req.Raw().Header.Set("x-ms-content-disposition", *directoryHTTPHeaders.ContentDisposition)
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if blobRenameOptions != nil && blobRenameOptions.SourceLeaseID != nil {
		req.Raw().Header.Set("x-ms-source-lease-id", *blobRenameOptions.SourceLeaseID)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfModifiedSince != nil {
		req.Raw().Header.Set("x-ms-source-if-modified-since", sourceModifiedAccessConditions.SourceIfModifiedSince.Format(time.RFC1123))
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfUnmodifiedSince != nil {
		req.Raw().Header.Set("x-ms-source-if-unmodified-since", sourceModifiedAccessConditions.SourceIfUnmodifiedSince.Format(time.RFC1123))
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfMatch != nil {
		req.Raw().Header.Set("x-ms-source-if-match", *sourceModifiedAccessConditions.SourceIfMatch)
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfNoneMatch != nil {
		req.Raw().Header.Set("x-ms-source-if-none-match", *sourceModifiedAccessConditions.SourceIfNoneMatch)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobRenameOptions != nil && blobRenameOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobRenameOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// renameHandleResponse handles the Rename response.
func (client *blobClient) renameHandleResponse(resp *http.Response) (BlobRenameResponse, error) {
	result := BlobRenameResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobRenameResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Content-Length"); val != "" {
		contentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return BlobRenameResponse{}, err
		}
		result.ContentLength = &contentLength
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobRenameResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// RenewLease - [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete operations
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) RenewLease(ctx context.Context, leaseID string, blobRenewLeaseOptions *BlobRenewLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (BlobRenewLeaseResponse, error) {
	req, err := client.renewLeaseCreateRequest(ctx, leaseID, blobRenewLeaseOptions, modifiedAccessConditions)
	if err != nil {
		return BlobRenewLeaseResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobRenewLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BlobRenewLeaseResponse{}, runtime.NewResponseError(resp)
	}
	return client.renewLeaseHandleResponse(resp)
}

// renewLeaseCreateRequest creates the RenewLease request.
func (client *blobClient) renewLeaseCreateRequest(ctx context.Context, leaseID string, blobRenewLeaseOptions *BlobRenewLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	if blobRenewLeaseOptions != nil && blobRenewLeaseOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobRenewLeaseOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-lease-action", "renew")
	req.Raw().Header.Set("x-ms-lease-id", leaseID)
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobRenewLeaseOptions != nil && blobRenewLeaseOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobRenewLeaseOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// renewLeaseHandleResponse handles the RenewLease response.
func (client *blobClient) renewLeaseHandleResponse(resp *http.Response) (BlobRenewLeaseResponse, error) {
	result := BlobRenewLeaseResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobRenewLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobRenewLeaseResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// SetAccessControl - Set the owner, group, permissions, or access control list for a blob.
// If the operation fails it returns the *DataLakeStorageError error type.
func (client *blobClient) SetAccessControl(ctx context.Context, blobSetAccessControlOptions *BlobSetAccessControlOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (BlobSetAccessControlResponse, error) {
	req, err := client.setAccessControlCreateRequest(ctx, blobSetAccessControlOptions, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return BlobSetAccessControlResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobSetAccessControlResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BlobSetAccessControlResponse{}, runtime.NewResponseError(resp)
	}
	return client.setAccessControlHandleResponse(resp)
}

// setAccessControlCreateRequest creates the SetAccessControl request.
func (client *blobClient) setAccessControlCreateRequest(ctx context.Context, blobSetAccessControlOptions *BlobSetAccessControlOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPatch, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("action", "setAccessControl")
	if blobSetAccessControlOptions != nil && blobSetAccessControlOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobSetAccessControlOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if blobSetAccessControlOptions != nil && blobSetAccessControlOptions.Owner != nil {
		req.Raw().Header.Set("x-ms-owner", *blobSetAccessControlOptions.Owner)
	}
	if blobSetAccessControlOptions != nil && blobSetAccessControlOptions.Group != nil {
		req.Raw().Header.Set("x-ms-group", *blobSetAccessControlOptions.Group)
	}
	if blobSetAccessControlOptions != nil && blobSetAccessControlOptions.PosixPermissions != nil {
		req.Raw().Header.Set("x-ms-permissions", *blobSetAccessControlOptions.PosixPermissions)
	}
	if blobSetAccessControlOptions != nil && blobSetAccessControlOptions.PosixACL != nil {
		req.Raw().Header.Set("x-ms-acl", *blobSetAccessControlOptions.PosixACL)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if blobSetAccessControlOptions != nil && blobSetAccessControlOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobSetAccessControlOptions.RequestID)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// setAccessControlHandleResponse handles the SetAccessControl response.
func (client *blobClient) setAccessControlHandleResponse(resp *http.Response) (BlobSetAccessControlResponse, error) {
	result := BlobSetAccessControlResponse{RawResponse: resp}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobSetAccessControlResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobSetAccessControlResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// SetExpiry - Sets the time a blob will expire and be deleted.
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) SetExpiry(ctx context.Context, expiryOptions BlobExpiryOptions, options *BlobSetExpiryOptions) (BlobSetExpiryResponse, error) {
	req, err := client.setExpiryCreateRequest(ctx, expiryOptions, options)
	if err != nil {
		return BlobSetExpiryResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobSetExpiryResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BlobSetExpiryResponse{}, runtime.NewResponseError(resp)
	}
	return client.setExpiryHandleResponse(resp)
}

// setExpiryCreateRequest creates the SetExpiry request.
func (client *blobClient) setExpiryCreateRequest(ctx context.Context, expiryOptions BlobExpiryOptions, options *BlobSetExpiryOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "expiry")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("x-ms-expiry-option", string(expiryOptions))
	if options != nil && options.ExpiresOn != nil {
		req.Raw().Header.Set("x-ms-expiry-time", *options.ExpiresOn)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// setExpiryHandleResponse handles the SetExpiry response.
func (client *blobClient) setExpiryHandleResponse(resp *http.Response) (BlobSetExpiryResponse, error) {
	result := BlobSetExpiryResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobSetExpiryResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobSetExpiryResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// SetHTTPHeaders - The Set HTTP Headers operation sets system properties on the blob
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) SetHTTPHeaders(ctx context.Context, blobSetHTTPHeadersOptions *BlobSetHTTPHeadersOptions, blobHTTPHeaders *BlobHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (BlobSetHTTPHeadersResponse, error) {
	req, err := client.setHTTPHeadersCreateRequest(ctx, blobSetHTTPHeadersOptions, blobHTTPHeaders, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return BlobSetHTTPHeadersResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobSetHTTPHeadersResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BlobSetHTTPHeadersResponse{}, runtime.NewResponseError(resp)
	}
	return client.setHTTPHeadersHandleResponse(resp)
}

// setHTTPHeadersCreateRequest creates the SetHTTPHeaders request.
func (client *blobClient) setHTTPHeadersCreateRequest(ctx context.Context, blobSetHTTPHeadersOptions *BlobSetHTTPHeadersOptions, blobHTTPHeaders *BlobHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "properties")
	if blobSetHTTPHeadersOptions != nil && blobSetHTTPHeadersOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobSetHTTPHeadersOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if blobHTTPHeaders != nil && blobHTTPHeaders.BlobCacheControl != nil {
		req.Raw().Header.Set("x-ms-blob-cache-control", *blobHTTPHeaders.BlobCacheControl)
	}
	if blobHTTPHeaders != nil && blobHTTPHeaders.BlobContentType != nil {
		req.Raw().Header.Set("x-ms-blob-content-type", *blobHTTPHeaders.BlobContentType)
	}
	if blobHTTPHeaders != nil && blobHTTPHeaders.BlobContentMD5 != nil {
		req.Raw().Header.Set("x-ms-blob-content-md5", base64.StdEncoding.EncodeToString(blobHTTPHeaders.BlobContentMD5))
	}
	if blobHTTPHeaders != nil && blobHTTPHeaders.BlobContentEncoding != nil {
		req.Raw().Header.Set("x-ms-blob-content-encoding", *blobHTTPHeaders.BlobContentEncoding)
	}
	if blobHTTPHeaders != nil && blobHTTPHeaders.BlobContentLanguage != nil {
		req.Raw().Header.Set("x-ms-blob-content-language", *blobHTTPHeaders.BlobContentLanguage)
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	if blobHTTPHeaders != nil && blobHTTPHeaders.BlobContentDisposition != nil {
		req.Raw().Header.Set("x-ms-blob-content-disposition", *blobHTTPHeaders.BlobContentDisposition)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobSetHTTPHeadersOptions != nil && blobSetHTTPHeadersOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobSetHTTPHeadersOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// setHTTPHeadersHandleResponse handles the SetHTTPHeaders response.
func (client *blobClient) setHTTPHeadersHandleResponse(resp *http.Response) (BlobSetHTTPHeadersResponse, error) {
	result := BlobSetHTTPHeadersResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobSetHTTPHeadersResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-blob-sequence-number"); val != "" {
		blobSequenceNumber, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return BlobSetHTTPHeadersResponse{}, err
		}
		result.BlobSequenceNumber = &blobSequenceNumber
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobSetHTTPHeadersResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// SetMetadata - The Set Blob Metadata operation sets user-defined metadata for the specified blob as one or more name-value pairs
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) SetMetadata(ctx context.Context, blobSetMetadataOptions *BlobSetMetadataOptions, leaseAccessConditions *LeaseAccessConditions, cpkInfo *CpkInfo, cpkScopeInfo *CpkScopeInfo, modifiedAccessConditions *ModifiedAccessConditions) (BlobSetMetadataResponse, error) {
	req, err := client.setMetadataCreateRequest(ctx, blobSetMetadataOptions, leaseAccessConditions, cpkInfo, cpkScopeInfo, modifiedAccessConditions)
	if err != nil {
		return BlobSetMetadataResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobSetMetadataResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BlobSetMetadataResponse{}, runtime.NewResponseError(resp)
	}
	return client.setMetadataHandleResponse(resp)
}

// setMetadataCreateRequest creates the SetMetadata request.
func (client *blobClient) setMetadataCreateRequest(ctx context.Context, blobSetMetadataOptions *BlobSetMetadataOptions, leaseAccessConditions *LeaseAccessConditions, cpkInfo *CpkInfo, cpkScopeInfo *CpkScopeInfo, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "metadata")
	if blobSetMetadataOptions != nil && blobSetMetadataOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobSetMetadataOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if blobSetMetadataOptions != nil && blobSetMetadataOptions.Metadata != nil {
		for k, v := range blobSetMetadataOptions.Metadata {
			req.Raw().Header.Set("x-ms-meta-"+k, v)
		}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if cpkInfo != nil && cpkInfo.EncryptionKey != nil {
		req.Raw().Header.Set("x-ms-encryption-key", *cpkInfo.EncryptionKey)
	}
	if cpkInfo != nil && cpkInfo.EncryptionKeySHA256 != nil {
		req.Raw().Header.Set("x-ms-encryption-key-sha256", *cpkInfo.EncryptionKeySHA256)
	}
	if cpkInfo != nil && cpkInfo.EncryptionAlgorithm != nil {
		req.Raw().Header.Set("x-ms-encryption-algorithm", "AES256")
	}
	if cpkScopeInfo != nil && cpkScopeInfo.EncryptionScope != nil {
		req.Raw().Header.Set("x-ms-encryption-scope", *cpkScopeInfo.EncryptionScope)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobSetMetadataOptions != nil && blobSetMetadataOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobSetMetadataOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// setMetadataHandleResponse handles the SetMetadata response.
func (client *blobClient) setMetadataHandleResponse(resp *http.Response) (BlobSetMetadataResponse, error) {
	result := BlobSetMetadataResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobSetMetadataResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("x-ms-version-id"); val != "" {
		result.VersionID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobSetMetadataResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-request-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return BlobSetMetadataResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("x-ms-encryption-key-sha256"); val != "" {
		result.EncryptionKeySHA256 = &val
	}
	if val := resp.Header.Get("x-ms-encryption-scope"); val != "" {
		result.EncryptionScope = &val
	}
	return result, nil
}

// SetTags - The Set Tags operation enables users to set tags on a blob.
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) SetTags(ctx context.Context, blobSetTagsOptions *BlobSetTagsOptions, modifiedAccessConditions *ModifiedAccessConditions) (BlobSetTagsResponse, error) {
	req, err := client.setTagsCreateRequest(ctx, blobSetTagsOptions, modifiedAccessConditions)
	if err != nil {
		return BlobSetTagsResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobSetTagsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return BlobSetTagsResponse{}, runtime.NewResponseError(resp)
	}
	return client.setTagsHandleResponse(resp)
}

// setTagsCreateRequest creates the SetTags request.
func (client *blobClient) setTagsCreateRequest(ctx context.Context, blobSetTagsOptions *BlobSetTagsOptions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "tags")
	if blobSetTagsOptions != nil && blobSetTagsOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobSetTagsOptions.Timeout), 10))
	}
	if blobSetTagsOptions != nil && blobSetTagsOptions.VersionID != nil {
		reqQP.Set("versionid", *blobSetTagsOptions.VersionID)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobSetTagsOptions != nil && blobSetTagsOptions.TransactionalContentMD5 != nil {
		req.Raw().Header.Set("Content-MD5", base64.StdEncoding.EncodeToString(blobSetTagsOptions.TransactionalContentMD5))
	}
	if blobSetTagsOptions != nil && blobSetTagsOptions.TransactionalContentCRC64 != nil {
		req.Raw().Header.Set("x-ms-content-crc64", base64.StdEncoding.EncodeToString(blobSetTagsOptions.TransactionalContentCRC64))
	}
	if blobSetTagsOptions != nil && blobSetTagsOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobSetTagsOptions.RequestID)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	if blobSetTagsOptions != nil && blobSetTagsOptions.Tags != nil {
		return req, runtime.MarshalAsXML(req, *blobSetTagsOptions.Tags)
	}
	return req, nil
}

// setTagsHandleResponse handles the SetTags response.
func (client *blobClient) setTagsHandleResponse(resp *http.Response) (BlobSetTagsResponse, error) {
	result := BlobSetTagsResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobSetTagsResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// SetTier - The Set Tier operation sets the tier on a blob. The operation is allowed on a page blob in a premium storage account and on a block blob in
// a blob storage account (locally redundant storage only). A
// premium page blob's tier determines the allowed size, IOPS, and bandwidth of the blob. A block blob's tier determines Hot/Cool/Archive storage type.
// This operation does not update the blob's ETag.
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) SetTier(ctx context.Context, tier AccessTier, blobSetTierOptions *BlobSetTierOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (BlobSetTierResponse, error) {
	req, err := client.setTierCreateRequest(ctx, tier, blobSetTierOptions, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return BlobSetTierResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobSetTierResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return BlobSetTierResponse{}, runtime.NewResponseError(resp)
	}
	return client.setTierHandleResponse(resp)
}

// setTierCreateRequest creates the SetTier request.
func (client *blobClient) setTierCreateRequest(ctx context.Context, tier AccessTier, blobSetTierOptions *BlobSetTierOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "tier")
	if blobSetTierOptions != nil && blobSetTierOptions.Snapshot != nil {
		reqQP.Set("snapshot", *blobSetTierOptions.Snapshot)
	}
	if blobSetTierOptions != nil && blobSetTierOptions.VersionID != nil {
		reqQP.Set("versionid", *blobSetTierOptions.VersionID)
	}
	if blobSetTierOptions != nil && blobSetTierOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobSetTierOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-access-tier", string(tier))
	if blobSetTierOptions != nil && blobSetTierOptions.RehydratePriority != nil {
		req.Raw().Header.Set("x-ms-rehydrate-priority", string(*blobSetTierOptions.RehydratePriority))
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobSetTierOptions != nil && blobSetTierOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobSetTierOptions.RequestID)
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// setTierHandleResponse handles the SetTier response.
func (client *blobClient) setTierHandleResponse(resp *http.Response) (BlobSetTierResponse, error) {
	result := BlobSetTierResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// StartCopyFromURL - The Start Copy From URL operation copies a blob or an internet resource to a new blob.
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) StartCopyFromURL(ctx context.Context, copySource string, blobStartCopyFromURLOptions *BlobStartCopyFromURLOptions, sourceModifiedAccessConditions *SourceModifiedAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, leaseAccessConditions *LeaseAccessConditions) (BlobStartCopyFromURLResponse, error) {
	req, err := client.startCopyFromURLCreateRequest(ctx, copySource, blobStartCopyFromURLOptions, sourceModifiedAccessConditions, modifiedAccessConditions, leaseAccessConditions)
	if err != nil {
		return BlobStartCopyFromURLResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobStartCopyFromURLResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return BlobStartCopyFromURLResponse{}, runtime.NewResponseError(resp)
	}
	return client.startCopyFromURLHandleResponse(resp)
}

// startCopyFromURLCreateRequest creates the StartCopyFromURL request.
func (client *blobClient) startCopyFromURLCreateRequest(ctx context.Context, copySource string, blobStartCopyFromURLOptions *BlobStartCopyFromURLOptions, sourceModifiedAccessConditions *SourceModifiedAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if blobStartCopyFromURLOptions != nil && blobStartCopyFromURLOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*blobStartCopyFromURLOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if blobStartCopyFromURLOptions != nil && blobStartCopyFromURLOptions.Metadata != nil {
		for k, v := range blobStartCopyFromURLOptions.Metadata {
			req.Raw().Header.Set("x-ms-meta-"+k, v)
		}
	}
	if blobStartCopyFromURLOptions != nil && blobStartCopyFromURLOptions.Tier != nil {
		req.Raw().Header.Set("x-ms-access-tier", string(*blobStartCopyFromURLOptions.Tier))
	}
	if blobStartCopyFromURLOptions != nil && blobStartCopyFromURLOptions.RehydratePriority != nil {
		req.Raw().Header.Set("x-ms-rehydrate-priority", string(*blobStartCopyFromURLOptions.RehydratePriority))
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfModifiedSince != nil {
		req.Raw().Header.Set("x-ms-source-if-modified-since", sourceModifiedAccessConditions.SourceIfModifiedSince.Format(time.RFC1123))
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfUnmodifiedSince != nil {
		req.Raw().Header.Set("x-ms-source-if-unmodified-since", sourceModifiedAccessConditions.SourceIfUnmodifiedSince.Format(time.RFC1123))
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfMatch != nil {
		req.Raw().Header.Set("x-ms-source-if-match", *sourceModifiedAccessConditions.SourceIfMatch)
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfNoneMatch != nil {
		req.Raw().Header.Set("x-ms-source-if-none-match", *sourceModifiedAccessConditions.SourceIfNoneMatch)
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfTags != nil {
		req.Raw().Header.Set("x-ms-source-if-tags", *sourceModifiedAccessConditions.SourceIfTags)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfTags != nil {
		req.Raw().Header.Set("x-ms-if-tags", *modifiedAccessConditions.IfTags)
	}
	req.Raw().Header.Set("x-ms-copy-source", copySource)
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if blobStartCopyFromURLOptions != nil && blobStartCopyFromURLOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *blobStartCopyFromURLOptions.RequestID)
	}
	if blobStartCopyFromURLOptions != nil && blobStartCopyFromURLOptions.BlobTagsString != nil {
		req.Raw().Header.Set("x-ms-tags", *blobStartCopyFromURLOptions.BlobTagsString)
	}
	if blobStartCopyFromURLOptions != nil && blobStartCopyFromURLOptions.SealBlob != nil {
		req.Raw().Header.Set("x-ms-seal-blob", strconv.FormatBool(*blobStartCopyFromURLOptions.SealBlob))
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// startCopyFromURLHandleResponse handles the StartCopyFromURL response.
func (client *blobClient) startCopyFromURLHandleResponse(resp *http.Response) (BlobStartCopyFromURLResponse, error) {
	result := BlobStartCopyFromURLResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobStartCopyFromURLResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("x-ms-version-id"); val != "" {
		result.VersionID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobStartCopyFromURLResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-copy-id"); val != "" {
		result.CopyID = &val
	}
	if val := resp.Header.Get("x-ms-copy-status"); val != "" {
		result.CopyStatus = (*CopyStatusType)(&val)
	}
	return result, nil
}

// Undelete - Undelete a blob that was previously soft deleted
// If the operation fails it returns the *StorageError error type.
func (client *blobClient) Undelete(ctx context.Context, options *BlobUndeleteOptions) (BlobUndeleteResponse, error) {
	req, err := client.undeleteCreateRequest(ctx, options)
	if err != nil {
		return BlobUndeleteResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return BlobUndeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BlobUndeleteResponse{}, runtime.NewResponseError(resp)
	}
	return client.undeleteHandleResponse(resp)
}

// undeleteCreateRequest creates the Undelete request.
func (client *blobClient) undeleteCreateRequest(ctx context.Context, options *BlobUndeleteOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "undelete")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// undeleteHandleResponse handles the Undelete response.
func (client *blobClient) undeleteHandleResponse(resp *http.Response) (BlobUndeleteResponse, error) {
	result := BlobUndeleteResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return BlobUndeleteResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}
