/***************************************************************************
                          tea_funx.c  -  description
                             -------------------
    begin                : Mon Dec 12 2003
    copyright            : (C) 2003, 2004, 2005 by Peter 'Roxton' Semiletov
    email                : roxton@ua.fm
 ***************************************************************************/

/*
Copyright (C) 2002 Paolo Maggi
Copyright (C) 2000 Olivier Sessink
Copyright (C) 2000  Kh. Naba Kumar Singh
*/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <errno.h>
#include <sys/stat.h>
#include <time.h>
#include <stdio.h>

#include "tea_defs.h"
#include "tea_config.h"
#include "rox_strings.h"
#include "interface.h"
#include "tea_text_document.h"
#include "tea_funx.h"
#include "tea_proj.h"
#include "tea_gtk_utils.h"
#include "callbacks.h"


/* from:
 * time.c
 * This file is part of gedit
 *
 * Copyright (C) 2002 Paolo Maggi

  changed by roxton
*/

gchar* get_time (const gchar* format)
{
   if (! format)
      return NULL;

  	gchar *out = NULL;
	gchar *out_utf8 = NULL;
  	time_t clock;
  	struct tm *now;
  	size_t out_length = 0;
	gchar *locale_format;

	if (strlen (format) == 0)
		return g_strdup (" ");

	locale_format = g_locale_from_utf8 (format, -1, NULL, NULL, NULL);

	if (! locale_format)
		return g_strdup (" ");

  	clock = time (NULL);
  	now = localtime (&clock);

	do
	{
		out_length += 255;
		out = g_realloc (out, out_length);
	}
  	while (strftime (out, out_length, locale_format, now) == 0);

	g_free (locale_format);

	if (g_utf8_validate (out, -1, NULL))
		out_utf8 = out;
	else
	{
		out_utf8 = g_locale_to_utf8 (out, -1, NULL, NULL, NULL);
		g_free (out);

		if (! out_utf8)
			out_utf8 = g_strdup (" ");
	}

  	return out_utf8;
}


//from Anjuta ::
//    utilities.c
//  Copyright (C) 2000  Kh. Naba Kumar Singh
#define FILE_BUFFER_SIZE 65535
gboolean
copy_file (gchar * src, gchar * dest)
{
	FILE *input_fp, *output_fp;
	gchar buffer[FILE_BUFFER_SIZE];
	gint bytes_read, bytes_written;
	gboolean error;

	error = TRUE;

	input_fp = fopen (src, "rb");
	if (input_fp == NULL)
	{
		return FALSE;
	}

	output_fp = fopen (dest, "wb");
	if (output_fp == NULL)
	{
		fclose (input_fp);
		return TRUE;
	}

	for (;;)
	{
		bytes_read = fread (buffer, 1, FILE_BUFFER_SIZE, input_fp);
		if (bytes_read != FILE_BUFFER_SIZE && ferror (input_fp))
		{
			error = FALSE;
			break;
		}

		if (bytes_read)
		{
			bytes_written = fwrite (buffer, 1, bytes_read, output_fp);
			if (bytes_read != bytes_written)
			{
				error = FALSE;
				break;
			}
		}

		if (bytes_read != FILE_BUFFER_SIZE && feof (input_fp))
		{
			break;
		}
	}

	fclose (input_fp);
	fclose (output_fp);

	return error;
}
//


//from Bluefish:: bf_lib.c and gtk_easy
/**
 * ending_slash:
 * @dirname: a #const gchar * with a diretory name
 *
 * makes sure the last character of the newly allocated
 * string it returns is a '/'
 *
 * Return value: a newly allocated gchar * dirname that does end on a '/'
 **/
gchar *ending_slash(const gchar *dirname) {
	if (!dirname) {
		return g_strdup("");
	}

	if (dirname[strlen(dirname)-1] == G_DIR_SEPARATOR) {
		return g_strdup(dirname);
	} else {
		return g_strconcat(dirname, G_DIR_SEPARATOR_S, NULL);
	}
}


/**
 * most_efficient_filename:
 * @filename: a gchar * with a possibly inefficient filename like /hello/../tmp/../myfile
 *
 * tries to eliminate any dir/../ combinations in filename
 * this function could do evern better, it should also remove /./ entries
 *
 * Return value: the same gchar * as passed to the function
 **/
gchar *most_efficient_filename(gchar *filename) {
	gint i,j, len;

	len = strlen(filename);
	for (i=0; i < len-4; i++) {
		if (strncmp(&filename[i], "/../", 4) == 0) {
			for (j=1; j < i; j++) {
				if ((filename[i - j] == G_DIR_SEPARATOR) || (i==j)) {
					memmove(&filename[i-j], &filename[i+3], len-i);
					j=i;
					i--;
				}
			}
		}
	}
	return filename;
}

/**
 * create_relative_link_to:
 * @current_filepath: a #gchar * with the current filename
 * @link_to_filepath: a #gchar * with a file to link to
 *
 * creates a newly allocated relative link from current_filepath
 * to link_to_filepath
 *
 * if current_filepath == NULL it returns the most efficient filepath
 * for link_to_filepath
 *
 * if link_to_filepath == NULL it will return NULL
 *
 * Return value: a newly allocated gchar * with the relative link
 **/
gchar *create_relative_link_to(gchar * current_filepath, gchar * link_to_filepath)
{
	gchar *returnstring = NULL;
	gchar *eff_current_filepath, *eff_link_to_filepath;
	gint common_lenght, maxcommonlen;
	gint current_filename_length, link_to_filename_length, current_dirname_length, link_to_dirname_length;
	gint count, deeper_dirs;

	if (!current_filepath){
		returnstring = most_efficient_filename(g_strdup(link_to_filepath));
		return returnstring;
	}
	if (!link_to_filepath) {
		return NULL;
	}
	eff_current_filepath = most_efficient_filename(g_strdup(current_filepath));
	eff_link_to_filepath = most_efficient_filename(g_strdup(link_to_filepath));
	/* get the size of the directory of the current_filename */
	current_filename_length = strlen(strrchr(eff_current_filepath, G_DIR_SEPARATOR))-1;
	link_to_filename_length = strlen(strrchr(eff_link_to_filepath, G_DIR_SEPARATOR))-1;
	current_dirname_length = strlen(eff_current_filepath) - current_filename_length;
	link_to_dirname_length = strlen(eff_link_to_filepath) - link_to_filename_length;

	if (current_dirname_length < link_to_dirname_length) {
		maxcommonlen = current_dirname_length;
	} else {
		maxcommonlen = link_to_dirname_length;
	}

	/* first lets get the common basedir for both dir+file  by comparing the
	   common path in the directories */
	common_lenght = 0;
	while ((strncmp(eff_current_filepath, eff_link_to_filepath, common_lenght + 1)) == 0) {
		common_lenght++;
		if (common_lenght >= maxcommonlen) {
			common_lenght = maxcommonlen;
			break;
		}
	}
	/* this is the common length, but we need the common directories */
	if (eff_current_filepath[common_lenght] != G_DIR_SEPARATOR) {
		gchar *ltmp = &eff_current_filepath[common_lenght];
		while ((*ltmp != G_DIR_SEPARATOR) && (common_lenght > 0)) {
			common_lenght--;
			ltmp--;
		}
	}

	/* now we need to count how much deeper (in directories) the current_filename
	   is compared to the link_to_file, that is the amount of ../ we need to add */
	deeper_dirs = 0;
	for (count = common_lenght+1; count <= current_dirname_length; count++) {
		if (eff_current_filepath[count] == G_DIR_SEPARATOR) {
			deeper_dirs++;
		}
	}

	/* now we know everything we need to know we can create the relative link */
	returnstring = g_malloc0((strlen(link_to_filepath) - common_lenght + 3 * deeper_dirs + 1) * sizeof(gchar *));
	count = deeper_dirs;
	while (count) {
		strcat(returnstring, "../");
		count--;
	}
	strcat(returnstring, &eff_link_to_filepath[common_lenght+1]);
	g_free(eff_current_filepath);
	g_free(eff_link_to_filepath);
	return returnstring;
}

/**
 * create_full_path:
 * @filename: a gchar * with the (relative or not) filename
 * @basedir: a gchar * with a basedir or NULL for current dir
 *
 * if filename is already absolute, it returns it
 * else it will use basedir if available, else the current dir
 * to add to the filename to form the full path
 *
 * it does use most_efficient_filename() to remote unwanted dir/../ entries
 *
 * Return value: a newly allocated gchar * with the full path
 **/


gchar *create_full_path(gchar * filename, gchar *basedir) {
	gchar *absolute_filename;
	gchar *tmpcdir;


	if (g_path_is_absolute(filename)) {
		absolute_filename = g_strdup(filename);
	} else {
		if (basedir) {
			tmpcdir = ending_slash(basedir);
		} else {
			gchar *curdir = g_get_current_dir();
			tmpcdir = ending_slash(curdir);
			g_free(curdir);
		}
		absolute_filename = g_strconcat(tmpcdir, filename, NULL);
		g_free(tmpcdir);
	}
	absolute_filename = most_efficient_filename(absolute_filename);
	return absolute_filename;
}
//



static gint noname_name_counter = -1;

gchar* get_noname_name (void) 
{
  ++noname_name_counter;
  if (noname_name_counter >= G_MAXINT)
     noname_name_counter = 0;
  return g_strdup_printf ("noname_%d", noname_name_counter);
}


int get_value (int total, int perc)
{
  return (int) (total / 100) * perc;
}


int get_percent (int total, int value)
{
  return (int) (value / total) * 100;
}


void handle_file (gchar *filename, gint mode, gboolean kwas)
{
  if (! filename)
     return;
 
  gchar *cmd = NULL;
  
  gint i = get_n_page_by_filename (filename);

  if (i != -1)
     {
      gtk_notebook_set_current_page (notebook1, i);
      return;
     } 

  if (! g_file_test (filename, G_FILE_TEST_EXISTS))
     return;
 
  if (is_image (filename))
     {
      if (mode != 0)
         {
          cmd = g_strdup_printf (confile.ext_pic_editor, filename);
          system (cmd);
          g_free (cmd);
          return;
         }

      if (confile.use_ext_image_viewer)
         {
          cmd = g_strdup_printf (confile.ext_pic_editor, filename);
          system (cmd);
          g_free(cmd);
          return;        
         }
      else  
          create_wnd_imgviewer (filename);

      return;
     }

  if (! kwas)
     {
      if (! get_page_text() )
        cur_settings.selected_enc = ch_str (cur_settings.selected_enc, confile.default_charset);
      else
          cur_settings.selected_enc = ch_str (cur_settings.selected_enc, cur_text_doc->encoding);
     }

  open_file_std (filename);
}


void handle_file_enc (gchar *filename, gchar *enc)
{
  if (! filename)
     return;
 
  gchar *cmd = NULL;
  
  gint i = get_n_page_by_filename (filename);

  if (i != -1)
     {
      gtk_notebook_set_current_page (notebook1, i);
      return;
     } 

  if (! g_file_test (filename, G_FILE_TEST_EXISTS))
     return;
  
  cur_settings.selected_enc = ch_str (cur_settings.selected_enc, enc);

  open_file_std (filename);
}
      

gboolean is_image (const gchar *filename)
{
  return is_ext (filename, ".png", ".gif", ".jpg", ".jpeg", ".wbmp", ".bmp", ".mng", NULL);
}


gboolean is_tex (const gchar *filename)
{
  return is_ext (filename, ".tex", NULL);
}


gboolean is_po (const gchar *f)
{
  return is_ext (f, ".pot", ".po", NULL); 
}


void create_empty_file (gchar *filename, gchar *first_line)
{
  FILE *out = fopen (filename, "w");
  
  if (! out) 
     return FALSE;                     

  if (first_line)
     fprintf (out, "%s", first_line);

  fclose (out);                        
}


gint get_file_size (const gchar *filename)
{
  struct stat s;
  stat (filename, &s);
  return s.st_size;
}


gboolean check_ext (gchar *filename, gchar *ext)
{
  if (! filename || ! ext)
     return FALSE;

  gboolean r = FALSE;
  gchar *f = g_utf8_strdown (filename, -1);
  r = g_str_has_suffix (f, ext);
  g_free (f);
  return r; 
}


gboolean is_markup (const gchar *f)
{
  return is_ext (f, ".html", ".htm", ".shtml", ".xml", ".sgm", ".xhtml", ".docbook", NULL);
}


gboolean is_c (const gchar *f)
{
  return is_ext (f, ".c", ".h", ".cpp", ".cxx", ".cc", ".cp", ".c++", NULL);
}


gboolean is_pascal (const gchar *f)
{
  return is_ext (f, ".pas", ".pp", ".dpr", NULL);
}


gchar* get_hl_name (gchar *file_name)
{
  gchar *b;

  if (is_markup (file_name))
     return g_strdup (HL_MARKUP); 
       
  if (is_c (file_name))
     return g_strdup (HL_C); 
 
  if (is_pascal (file_name))
     return g_strdup (HL_PASCAL); 

  if (check_ext (file_name, ".py")) 
     return g_strdup (HL_PYTHON); 
 
  if (check_ext (file_name, ".php")) 
     return g_strdup (HL_PHP); 

  if (check_ext (file_name, ".sh")) 
     return g_strdup (HL_BASH); 

  if (is_po (file_name))
     return g_strdup (HL_PO); 

  if (is_tex (file_name))
     return g_strdup (HL_TEX); 

  if (confile.do_det_scripts_by_content)
     {
      b = str_file_read (file_name);
      if (b)
         { 
          if (strstr (b, "#!/bin/bash") || strstr (b, "#!/bin/sh"))
             {
              g_free (b);
              return g_strdup (HL_BASH); 
             }
          g_free (b);
         }
     } 

  return g_strdup (HL_NONE);
}


gchar* get_l_filename (const gchar *filename)
{
  if (! filename)
     return NULL;

  gsize bytes_read;
  gsize bytes_written;
  return g_filename_from_utf8 (filename, -1, &bytes_read, &bytes_written, NULL);  
}


gchar* get_8_filename (const gchar *filename)
{
  if (! filename)
     return NULL;

  gsize bytes_read;
  gsize bytes_written;
  
  return g_filename_to_utf8 (filename, -1, &bytes_read, &bytes_written, NULL);  
}

/*
void make_stats2 (t_note_page *doc)
{
  gboolean selected = TRUE;
  gchar *text;
  gint words = 0;
  gint chars = 0;
  gint white_chars = 0;
  gint lines = 0;
  gint bytes = 0;
  GtkTextIter start;
  GtkTextIter end;
  gunichar ch;

  if (doc_is_sel (doc->text_buffer))
     gtk_text_buffer_get_selection_bounds (doc->text_buffer, &start, &end);
  else
      {
       gtk_text_buffer_get_start_iter (doc->text_buffer, &start); 
       gtk_text_buffer_get_end_iter (doc->text_buffer, &end); 
       selected = FALSE;
      }  

  lines = gtk_text_buffer_get_line_count (doc->text_buffer);
  text =  gtk_text_buffer_get_text (doc->text_buffer, &start, &end, FALSE);
  bytes = strlen (text);

  do 
    {
     ch = gtk_text_iter_get_char (&start);
     if (g_unichar_isspace (ch))
        white_chars++;
     if (gtk_text_iter_starts_word (&start))
        words++; 

     chars++;
    }
  while ( (gtk_text_iter_forward_char (&start)) && ( ! gtk_text_iter_equal (&start, &end)) ); 

  gchar *s_bytes = g_strdup_printf(_("bytes: %d\n"), bytes);
  gchar *s_lines = g_strdup_printf(_("lines: %d\n"), lines);
  gchar *s_words = g_strdup_printf(_("words: %d\n"), words);
  gchar *s_chars = g_strdup_printf(_("chars: %d\n"), chars);
  gchar *s_charsnsp = g_strdup_printf(_("chars non-space: %d\n"), chars - white_chars);

  gchar *result;

  if (! selected)
     result = g_strconcat (_("stats for "),
                           doc->file_name_utf8,
                           ":\n",
                           s_charsnsp,
                           s_chars,
                           s_words,
                           s_lines,
                           s_bytes,
                           NULL);
   else
       result = g_strconcat (_("stats for the selection"),
                             ":\n",
                             s_charsnsp,
                             s_chars,
                             s_words,
                             s_bytes,
                             NULL);

  log_to_memo (result, NULL, LM_NORMAL);

  g_free (s_bytes);
  g_free (s_charsnsp);
  g_free (s_chars);
  g_free (s_words);
  g_free (s_lines);
  g_free (result);
  g_free (text);
}
*/


//from Gedit - plugin
/*
 * docinfo.c
 * This file is part of gedit
 *
 * Copyright (C) 2002 Paolo Maggi

modified by roxton
*/

void make_stats (t_note_page *doc)
{
  if (! doc)
     return;

  if (! doc->text_buffer)
     return;

  gboolean selected = TRUE;

  gchar *text;
  PangoLogAttr *attrs;
  gint words = 0;
  gint chars = 0;
  gint white_chars = 0;
  gint lines = 0;
  gint bytes = 0;
  gint i;
  gchar *tmp_str;

  selected = doc_is_sel (doc->text_buffer);

  if (! selected)
      text = doc_get_buf (doc->text_buffer);
  else
      text = doc_get_sel (doc);

  if (! text)
     return; 

  if (! g_utf8_validate (text, -1, NULL))
     return;

  lines = gtk_text_buffer_get_line_count (doc->text_buffer);

  chars = g_utf8_strlen (text, -1);
  attrs = g_new0 (PangoLogAttr, chars + 1);

  pango_get_log_attrs (text,
                       -1,
                       0,
                       pango_language_from_string ("C"),
                       attrs,
                       chars + 1);

  i = 0;

  while (i < chars)
        {
         if (attrs [i].is_white)
            ++white_chars;

         if (attrs [i].is_word_start)
            ++words;

         ++i;
        }

  if (chars == 0)
     lines = 0;

  bytes = strlen (text);

  gchar *s_bytes = g_strdup_printf(_("bytes: %d\n"), bytes);
  gchar *s_lines = g_strdup_printf(_("lines: %d\n"), lines);
  gchar *s_words = g_strdup_printf(_("words: %d\n"), words);
  gchar *s_chars = g_strdup_printf(_("chars: %d\n"), chars);
  gchar *s_charsnsp = g_strdup_printf(_("chars non-space: %d\n"), chars - white_chars);

  gchar *result;

  if (! selected)
     result = g_strconcat (_("stats for "),
                           doc->file_name_utf8,
                           ":\n",
                           s_charsnsp,
                           s_chars,
                           s_words,
                           s_lines,
                           s_bytes,
                           NULL);
   else
       result = g_strconcat (_("stats for selected:\n"),
                             s_charsnsp,
                             s_chars,
                             s_words,
                             s_bytes,
                             NULL);

  log_to_memo (result, NULL, LM_NORMAL);

  g_free (s_bytes);
  g_free (s_charsnsp);
  g_free (s_chars);
  g_free (s_words);
  g_free (s_lines);
  g_free (result);
  g_free (attrs);
  g_free (text);
}


gchar* get_lang_name (void)
{
  gchar *l = g_getenv ("LANG");
  if (! l)
     return g_strdup ("UTF-8"); 

  if (strcmp (l, "UTF-8") == 0)
     return g_strdup ("UTF-8"); 

  return g_strndup (g_getenv ("LANG"), 2);
}  


gchar* find_good_browser (void)
{
   gchar *t = g_find_program_in_path ("konqueror");
   if (! t)
      t = g_find_program_in_path ("opera");
      if (! t)
         t = g_find_program_in_path ("firefox");
         if (! t)
            t = g_find_program_in_path ("mozilla");
            if (! t)
                t = g_find_program_in_path ("galeon");

   return t;
}


gchar* compose_browser_cmd (gchar *filename)
{
  if (! filename)
     return NULL;

  gchar *t;
  gchar *b; 

  if (confile.use_def_doc_browser)
     {
      if (confile.cmd_def_doc_browser)
         t = rep_all_s (confile.cmd_def_doc_browser, filename); 
      return t;
     }
  
  b = find_good_browser ();
  
  if (! b)
     return NULL;

  t = g_strconcat (b, " ", filename, " &", NULL);

  g_free (b);
  return t;
}


gchar* get_tea_doc_compose_name (gchar *f)
{
  return g_strconcat (TEA_DOC_DIR, f, NULL);
} 


gchar* find_doc_index_name (void)
{
  gchar *l = get_lang_name ();

  gchar *f = g_strconcat (TEA_DOC_DIR, l, "/index.html", NULL);

  if (! g_file_test (f, G_FILE_TEST_EXISTS))
     {
      g_free (f);
      f = g_strconcat (TEA_DOC_DIR, "en/index.html", NULL);
      g_free (l);
      return f;
     }

  g_free (l);
  return f;
}


void run_doc_in_browser (void)
{
  gchar *f = find_doc_index_name ();
  gchar *t = compose_browser_cmd (f);
  if (t)
     system (t); 

  g_free (f);
  g_free (t);
}


gchar* get_clipboard_text (void)
{
  GtkClipboard *c = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
  if (! c)
     return NULL; 

  if (! gtk_clipboard_wait_is_text_available (c))
     return NULL;

  return gtk_clipboard_wait_for_text (c); 
}  


void insert_image (gchar *a_filename)
{
  if (! get_page_text()) return;
 
  if (! cur_text_doc->b_saved)
     return;

  if (! a_filename)
     return;

  if (! g_file_test (a_filename, G_FILE_TEST_EXISTS))
     return;

  gint *width;
  gint *height;
  gdk_pixbuf_get_file_info (a_filename, &width, &height);

  gchar *dir = g_path_get_dirname (cur_text_doc->file_name_local);
  gchar *filename = create_relative_link_to (dir, a_filename);
 
  if (! filename) 
     {
      g_free (dir); 
      return;
     }

  gint mm = get_markup_mode ();       
  gchar *t;

  gchar *x = g_strrstr (filename, G_DIR_SEPARATOR_S);
  if (x)
     t = g_utf8_next_char (x);
  else
      t = filename; 

  gchar *temp = g_malloc (7777);

  if (mm == MM_HTML) 
      g_snprintf (temp,
                  7777,
                  "<img src=\"%s\" border=\"0\" alt=\"\" width=\"%d\" height=\"%d\">",
                  t, width, height);
  else
  if (mm == MM_XHTML) 
     g_snprintf (temp,
                 7777,
                 "<img src=\"%s\" border=\"0\" alt=\"\" width=\"%d\" height=\"%d\" />",
                 t, width, height);
  else
      if (mm == MM_DOCBOOK) 
          g_snprintf (temp,
                      7777,
                      "<mediaobject><imageobject>\n<imagedata fileref=\"%s\"/>\n</imageobject></mediaobject>",
                      t);
  else
  if (mm == MM_WIKI) 
     g_snprintf (temp,
                 7777,
                 "[[Image:%s|thumb|alternative text]]",
                 t);
  else
  if (mm == MM_TEX) 
     g_snprintf (temp,
                 7777,
                 "\\includegraphics{%s}",
                 t);
    
  doc_insert_at_cursor (cur_text_doc, temp);

  g_free (temp);
  g_free (filename);
  g_free (dir);
}


void insert_link (gchar *a_filename)
{
  if (! a_filename)
     return;

  if (! g_file_test (a_filename, G_FILE_TEST_EXISTS))
     return;
  
  gchar *dir = g_path_get_dirname (cur_text_doc->file_name_local);
  gchar *filename = create_relative_link_to (dir, a_filename);
 
  if (! filename) 
     {
      g_free (dir); 
      return;
     }
       
  gchar *t;
  gchar *x = g_strrstr (filename, G_DIR_SEPARATOR_S);
  if (x)
     t = g_utf8_next_char (x);
  else
      t = filename; 

  gchar *z =  g_strdup_printf ("<a href=\"%s\"></a>", t); 

  doc_insert_at_cursor (cur_text_doc, z);
  doc_move_cursor_backw_middle_tags (cur_text_doc);

  g_free (filename);
  g_free (dir);
  g_free (z);
}


static build_menu_from_ht_cb (gpointer key,
                              gpointer value,
                              gpointer user_data)
{
  t_ppair *t = user_data;
  new_menu_item (key, t->a, t->b);
}


void build_menu_from_ht (GHashTable *hash_table, gpointer menu, gpointer callback)
{
   if (! ht_entities)
       return; 
 
   t_ppair t;
   t.a = menu;
   t.b = callback; 

   g_hash_table_foreach (hash_table,
                         build_menu_from_ht_cb,
                         &t);
}


void build_menu_from_glist (GList *list, gpointer menu, gpointer callback)
{
   if (! list)
       return; 
 
   GList *p = g_list_first (list);
   while (p)
        {
         if (strlen (p->data) >= 1)
            mni_temp = new_menu_item (p->data, menu, callback);
         p = g_list_next (p);
        }
}


void handle_file_ide (gchar *filename, gint line)
{
  if (! filename || ! cur_tea_project)
     return;
 
  gchar *cmd = g_strconcat (cur_tea_project->dir_source, filename, NULL);
 
  gint i = get_n_page_by_filename (cmd);

  if (i != -1)
     {
      gtk_notebook_set_current_page (notebook1, i);
      if (get_page_text ())
          doc_select_line (cur_text_doc, line); 
      return;
     } 

  if (! g_file_test (cmd, G_FILE_TEST_EXISTS))
     return;
  else
      {
       if (! get_page_text() )
          cur_settings.selected_enc = ch_str (cur_settings.selected_enc, "UTF-8");
       else
           cur_settings.selected_enc = ch_str (cur_settings.selected_enc, cur_text_doc->encoding);

       cur_text_doc = open_file_std (cmd);
       doc_select_line (cur_text_doc, line);
      }
}


gboolean parse_error_line (const gchar *line, gchar **filename, gint *lineno)
{
   if (! line)
       return FALSE;

   if (! strstr (line, ":"))
       return FALSE;

   gchar **a = g_strsplit (line, ":", -1);
   
   if (a[0])
      if (a[1])
         if (a[2])
            if (strstr (a[2], "error") || strstr (a[2], "warning")) 
            {
             *filename = g_strstrip (g_strdup (a[0]));
             *lineno = strtol (a[1], NULL, 10);
             g_strfreev (a);   
             return TRUE; 
            }

   g_strfreev (a);   
   return FALSE;
}


void clipboard_put_text (const gchar *s)
{
  GtkClipboard *c = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
  if (c && s)
     gtk_clipboard_set_text (c, s, -1);
}


GList* read_dir_to_glist (gchar *path)
{
  if (! path)
     return NULL;

  GDir *dir = g_dir_open (path, 0, NULL);
  if (! dir) 
     return NULL;

  GList *l = NULL;
  gchar *f = NULL;
  
  while (f = g_dir_read_name (dir))
        l = g_list_prepend (l, g_strconcat (path, G_DIR_SEPARATOR_S, f, NULL));

  g_dir_close (dir);
  return g_list_reverse (l);
}


GList* read_dir_files (gchar *path)
{
  if (! path)
      return NULL;

  GList *l = NULL;

  GDir *d = g_dir_open (path, 0, NULL);  
  gchar *t;

  while (t = g_dir_read_name (d))
        {
         if (! g_file_test (t, G_FILE_TEST_IS_DIR))
             l = g_list_prepend (l, g_strdup (t));
        }

  g_dir_close (d);  
  return g_list_reverse (l);
}

/*
static gint get_markup_mode (void)
returns an ID of markup mode
*/
gint get_markup_mode (void)
{
  if (g_utf8_collate (confile.default_markup_mode, "HTML") == 0)
     return MM_HTML;
  if (g_utf8_collate (confile.default_markup_mode, "XHTML") == 0)
     return MM_XHTML;
  if (g_utf8_collate (confile.default_markup_mode, "Wikipedia") == 0)
     return MM_WIKI;
  if (g_utf8_collate (confile.default_markup_mode, "LaTeX") == 0)
     return MM_TEX;
  if (g_utf8_collate (confile.default_markup_mode, "Docbook") == 0)
     return MM_DOCBOOK;

  return MM_HTML;
} 


gchar* get_amarok_now_playing (void)
{
  gchar *standard_output = NULL;
  gchar *standard_error = NULL;
  gint exit_status;
  GError *error;

  if (g_spawn_command_line_sync ("dcop amarok player nowPlaying", &standard_output,
                                 &standard_error,
                                 &exit_status,
                                 &error))
     g_free (standard_error);

  gchar *x = locale_to_utf8 (standard_output);
  g_free (standard_output);
  return x;
}


gboolean is_ext (gchar *filename, gchar *ext1, ...)
{
  if (! filename)
     return FALSE;

  va_list args;
  gchar *t;
  gboolean r = FALSE;
  
  va_start (args, ext1);
  t = ext1;
  
  while (t)
        {
         r = check_ext (filename, t);
         if (r)
            break;   

         t = va_arg (args, gchar*);
        }

  va_end (args);

  return r;
}


gchar* run_process_and_wait (gchar *command) 
{
  if (! command)
     return NULL;

  gchar *standard_output = NULL;
  gchar *standard_error = NULL;
  gint exit_status;
  gchar *x = NULL;

  if (command) 
  if (g_spawn_command_line_sync (command, &standard_output,
                                 &standard_error,
                                 &exit_status,
                                 NULL))
     {
      g_free (standard_error);
      x = locale_to_utf8 (standard_output);
      g_free (standard_output);
     }

  return x;
}


void delete_dir (gchar *path)
{
  gchar *cm = g_strconcat ("rm -r -f ", path, NULL);
  system (cm);
  g_free (cm);
}


gchar* correct_relative_filename (const gchar *path, const gchar *filename)
{
  gchar *x = filename_from_xuri (filename); 
  gchar *r;

  if (g_utf8_get_char (x) == '/')
     r = g_strdup (x);
  else
      r = g_strconcat (path, G_DIR_SEPARATOR_S, filename, NULL);

  g_free (x);
  return r;  
} 


gchar* filename_from_xuri (const gchar *uri)
{
  gchar *p = strstr (uri, "file:/");
  if (! p)
     return g_strdup (uri);

  p+=5;
  return g_strdup (p);
}