/***************************************************************************
                          tea_options.c  -  description
                             -------------------
    begin                : aug. 2004
    copyright            : (C) 2004, 2005 by Peter 'Roxton' Semiletov
    email                : peter.semiletov@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <glib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <sys/stat.h>
#include <gdk/gdkkeysyms.h>
#include <glib/gi18n.h>
#include <stddef.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

#ifdef CHAI_MODE

#include <gtksourceview/gtksourcetag.h>
#include <gtksourceview/gtksourcelanguagesmanager.h>
#include <gtksourceview/gtksourcetagtable.h>
#include <gtksourceview/gtksourcetag.h>
#include <gtksourceview/gtksourceview.h>

#endif


#include "tea_defs.h"
#include "tea_options.h"
#include "tea_gtk_utils.h"
#include "tea_config.h"
#include "tea_text_document.h"




#ifdef CHAI_MODE


static GtkSourceTagStyle *cur_tag_style;
static GtkSourceTag *cur_tag;
GtkSourceLanguage *cur_language;
static GSList *avail_langs;


static void update_cboxes_with_style (GtkSourceTagStyle *style)
{
  if (! style)
     return;

  gtk_toggle_button_set_active (cb_hl_italic, style->italic);
  gtk_toggle_button_set_active (cb_hl_bold, style->bold);
  gtk_toggle_button_set_active (cb_hl_underline, style->underline);
  gtk_toggle_button_set_active (cb_hl_strikethrough, style->strikethrough);
}


static void cb_tv_available_hlangs_change (GtkComboBox *combobox,
                                           gpointer user_data)
{
  if (! tv_hlang_elements)
     return;

  gint index = gtk_combo_box_get_active (combobox);
  if (index == -1)
     return;
    
  GSList *list = g_slist_nth (avail_langs, index);
  if (! list)
    return;  

  cur_language = list->data;

 // dbm (gtk_source_language_get_name (cur_language));
 
  gchar *name;

  if (gsl_tags_list)
     {
      g_slist_foreach (gsl_tags_list, (GFunc)g_object_unref, NULL);
      g_slist_free (gsl_tags_list);
     }
  
  gsl_tags_list = gtk_source_language_get_tags (GTK_SOURCE_LANGUAGE (cur_language));

  cur_tag = gsl_tags_list->data;
  GSList *gsl = gsl_tags_list;

  glist_strings_free (gl_tags_list);
  gl_tags_list = NULL;

  while (gsl)
        {
         g_object_get (gsl->data, "name", &name, NULL);
         gl_tags_list = g_list_append (gl_tags_list, name);
         gsl = g_slist_next (gsl);
        } 

  gtk_list_store_clear (gtk_combo_box_get_model (tv_hlang_elements));
  fill_combo_with_glist (tv_hlang_elements, gl_tags_list);

  gtk_combo_box_set_active (tv_hlang_elements, 0);
}


static void cb_tv_hlang_elements_change (GtkComboBox *combobox,
                                         gpointer user_data)
{
  if (! gsl_tags_list)
     return;

  gint index = gtk_combo_box_get_active (combobox);
  if (index == -1)
     return;

  GSList *list = g_slist_nth (gsl_tags_list, index);
  if (! list)
     return;

  if (cur_tag_style)
     gtk_source_tag_style_free (cur_tag_style);

  cur_tag = list->data;

  cur_tag_style = gtk_source_tag_get_style (cur_tag);

  gtk_color_button_set_color (bt_tag_foreground, &cur_tag_style->foreground);

  update_cboxes_with_style (cur_tag_style);
}


static void cb_select_tag_color (GtkColorButton *widget, gpointer user_data) 
{
  GdkColor color;
  gtk_color_button_get_color (widget, &color);  
  cur_tag_style->foreground = color;

  gchar *id;   
  g_object_get (cur_tag, "id", &id, NULL);

  gtk_source_language_set_tag_style (cur_language, id, cur_tag_style);
  g_free (id);

  save_tag (cur_language, cur_tag);
}


static void cb_hl_italic_toggle (GtkToggleButton *togglebutton, gpointer user_data)
{
  cur_tag_style->italic = gtk_toggle_button_get_active (togglebutton);
  
  gchar *id;   
  g_object_get (cur_tag, "id", &id, NULL);

  gtk_source_language_set_tag_style (cur_language, id, cur_tag_style);
  g_free (id);

  save_tag (cur_language, cur_tag);
}


static void cb_hl_bold_toggle (GtkToggleButton *togglebutton, gpointer user_data)
{
  cur_tag_style->bold = gtk_toggle_button_get_active (togglebutton);
  
  gchar *id;   
  g_object_get (cur_tag, "id", &id, NULL);

  gtk_source_language_set_tag_style (cur_language, id, cur_tag_style);
  g_free (id);

  save_tag (cur_language, cur_tag);
}


static void cb_hl_underline_toggle (GtkToggleButton *togglebutton, gpointer user_data)
{
  cur_tag_style->underline = gtk_toggle_button_get_active (togglebutton);

  gchar *id;   
  g_object_get (cur_tag, "id", &id, NULL);

  gtk_source_language_set_tag_style (cur_language, id, cur_tag_style);
  g_free (id);

  save_tag (cur_language, cur_tag);
}


static void cb_hl_strikethrough_toggle (GtkToggleButton *togglebutton, gpointer user_data)
{
  cur_tag_style->strikethrough = gtk_toggle_button_get_active (togglebutton);
  gtk_source_tag_set_style (cur_tag, cur_tag_style);

  gchar *id;   
  g_object_get (cur_tag, "id", &id, NULL);

  gtk_source_language_set_tag_style (cur_language, id, cur_tag_style);
  g_free (id);

  save_tag (cur_language, cur_tag);
}



static GtkWidget* wnd_options_hl_chai (void)
{
  avail_langs = gtk_source_languages_manager_get_available_languages (source_languages_manager);
  
  cur_tag = NULL;
  gsl_tags_list = NULL;
  gl_tags_list = NULL;
  cur_tag_style = NULL;
  cur_language = NULL;

  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);

  GtkWidget *hb = gtk_hbox_new (FALSE, UI_PACKFACTOR);
  
  gtk_widget_show (hb);
  gtk_box_pack_start (page, hb, FALSE, FALSE, UI_PACKFACTOR);


  tv_available_hlangs = tea_combo_combo (page, gl_supported_hlangs, _("Available highlighting modes"), 0); 
  
  g_signal_connect ((gpointer) tv_available_hlangs, "changed",
                    G_CALLBACK (cb_tv_available_hlangs_change),
                    NULL);


  tv_hlang_elements = tea_combo_combo (page, NULL, _("Elements"), 0); 
  g_signal_connect ((gpointer) tv_hlang_elements, "changed",
                    G_CALLBACK (cb_tv_hlang_elements_change),
                    NULL);
  

  bt_tag_foreground = tea_color_selector_simple (page, _("Element foreground"));  
  g_signal_connect (bt_tag_foreground, "color-set", G_CALLBACK (cb_select_tag_color), NULL);

  cb_hl_italic = tea_checkbox (page, _("Italic"), FALSE); 
  cb_hl_bold = tea_checkbox (page, _("Bold"), FALSE); 
  cb_hl_underline = tea_checkbox (page, _("Underline"), FALSE); 
  cb_hl_strikethrough = tea_checkbox (page, _("Strikethrough"), FALSE); 

  g_signal_connect ((gpointer) &cb_hl_italic->toggle_button, "clicked",
                    G_CALLBACK (cb_hl_italic_toggle),
                    NULL);
 
  g_signal_connect ((gpointer) &cb_hl_bold->toggle_button, "clicked", //"toggled"
                    G_CALLBACK (cb_hl_bold_toggle),
                    NULL);

  g_signal_connect ((gpointer) &cb_hl_underline->toggle_button, "clicked",
                    G_CALLBACK (cb_hl_underline_toggle),
                    NULL);

  g_signal_connect ((gpointer) &cb_hl_strikethrough->toggle_button, "clicked",
                    G_CALLBACK (cb_hl_strikethrough_toggle),
                    NULL);

  cb_tv_available_hlangs_change (tv_available_hlangs, NULL);

  return page;
}


#endif




static void cb_put_launcher (GtkButton *button,
                             gpointer user_data)
{
  free_desktop_create_shortcut ();
}


static void cb_del_launcher (GtkButton *button,
                             gpointer user_data)
{
  free_desktop_delete_shortcut ();
}


static void cb_on_choose_enc (GtkButton *button,
                              gpointer user_data)
{
  gchar *s = tv_get_selected_single (tv_available_charsets);
  if (! s)
     return;

  gl_enc_choosed = g_list_prepend (gl_enc_choosed, g_strdup (s));
  tv_fill_with_glist (tv_choosed_charsets, gl_enc_choosed);

  glist_save_to_file (gl_enc_choosed, confile.tea_choosed_charsets); 
  get_iconv_sup ();
}


static void cb_on_del_enc (GtkButton *button,
                           gpointer user_data)
{
  gchar *s = tv_get_selected_single (tv_choosed_charsets);
  if (! s)
     return;

  GList *l = str_remove_from_list (gl_enc_choosed, s);

  glist_strings_free (gl_enc_choosed);
  gl_enc_choosed = l;

  glist_save_to_file (gl_enc_choosed, confile.tea_choosed_charsets); 
  get_iconv_sup ();
  tv_fill_with_glist (tv_choosed_charsets, gl_enc_choosed);
}


static void on_kwas_notebook_switch_page (GtkNotebook *notebook,
                                          GtkNotebookPage *page,
                                          guint page_num,
                                          gpointer user_data)
{
  confile.last_prefs_tab = page_num;      
}


static void cb_on_bt_apply (GtkObject *object, GtkWidget *w) 
{
   GList *l = NULL;

   l = add_to_glist_combined_str (l, "fmt_color_function", gtk_entry_get_text (GTK_ENTRY (ent_fmt_color_function)));
   l = add_to_glist_combined_str (l, "default_markup_mode", gtk_entry_get_text (GTK_ENTRY (ent_def_markup_mode)));

   l = add_to_glist_combined_str (l, "def_save_dir", gtk_entry_get_text (GTK_ENTRY (ent_def_save_dir)));
   l = add_to_glist_combined_str (l, "def_open_dir", gtk_entry_get_text (GTK_ENTRY (ent_def_open_dir)));

   l = add_to_glist_combined_str (l, "cm_pdflatex", gtk_entry_get_text (GTK_ENTRY (ent_cm_pdflatex)));
   l = add_to_glist_combined_str (l, "cm_dvi_to_ps", gtk_entry_get_text (GTK_ENTRY (ent_cm_dvi_to_ps)));
   l = add_to_glist_combined_str (l, "cm_dvi_view", gtk_entry_get_text (GTK_ENTRY (ent_cm_dvi_view)));
   l = add_to_glist_combined_str (l, "cm_pdf_view", gtk_entry_get_text (GTK_ENTRY (ent_cm_pdf_view)));
   l = add_to_glist_combined_str (l, "cm_ps_view", gtk_entry_get_text (GTK_ENTRY (ent_cm_ps_view)));
   l = add_to_glist_combined_str (l, "cm_run_latex", gtk_entry_get_text (GTK_ENTRY (ent_cm_run_latex)));
   l = add_to_glist_combined_str (l, "cm_dvi_to_pdf", gtk_entry_get_text (GTK_ENTRY (ent_cm_dvi_to_pdf)));

   l = add_to_glist_combined_str (l, "mplayer", gtk_entry_get_text (GTK_ENTRY (ent_cm_mplayer)));

   l = add_to_glist_combined_str (l, "def_doc_browser", gtk_entry_get_text (GTK_ENTRY (ent_cm_manual_browser)));

   l = add_to_glist_combined_str (l, "date_time", gtk_entry_get_text (GTK_ENTRY (ent_date_time)));
   l = add_to_glist_combined_str (l, "now_playing", gtk_entry_get_text (GTK_ENTRY (ent_now_playing)));

   l = add_to_glist_combined_str (l, "tag_color_lm_error_fg", gtk_entry_get_text (GTK_ENTRY (ent_tag_color_lm_error_fg)));
   l = add_to_glist_combined_str (l, "tag_color_lm_error_bg", gtk_entry_get_text (GTK_ENTRY (ent_tag_color_lm_error_bg)));

   l = add_to_glist_combined_str (l, "tag_current_line_fg", gtk_entry_get_text (GTK_ENTRY (ent_tag_current_line_fg)));
   l = add_to_glist_combined_str (l, "tag_current_line_bg", gtk_entry_get_text (GTK_ENTRY (ent_tag_current_line_bg)));

   l = add_to_glist_combined_int (l, "margin_visible", gtk_toggle_button_get_active (&cb_margin_visible->toggle_button));
   l = add_to_glist_combined_int (l, "margin_width", gtk_spin_button_get_value_as_int (sb_margin_width)); 

   l = add_to_glist_combined_str (l, "color_cursor", gtk_entry_get_text (GTK_ENTRY (ent_color_cursor)));

   l = add_to_glist_combined_str (l, "tag_color_paint_fg", gtk_entry_get_text (GTK_ENTRY (ent_tag_color_paint_fg)));
   l = add_to_glist_combined_str (l, "tag_color_paint_bg", gtk_entry_get_text (GTK_ENTRY (ent_tag_color_paint_bg)));


   l = add_to_glist_combined_str (l, "tag_comment", gtk_entry_get_text (GTK_ENTRY (ent_tag_comment)));
   l = add_to_glist_combined_str (l, "tag_identifier", gtk_entry_get_text (GTK_ENTRY (ent_tag_identifier)));
   l = add_to_glist_combined_str (l, "tag_digit", gtk_entry_get_text (GTK_ENTRY (ent_tag_digit)));
   l = add_to_glist_combined_str (l, "tag_string", gtk_entry_get_text (GTK_ENTRY (ent_tag_string)));
   l = add_to_glist_combined_str (l, "tag_html_tag", gtk_entry_get_text (GTK_ENTRY (ent_tag_html_tag)));

   l = add_to_glist_combined_str (l, "tag_preprocessor", gtk_entry_get_text (GTK_ENTRY (ent_tag_preprocessor)));
   l = add_to_glist_combined_str (l, "tag_type", gtk_entry_get_text (GTK_ENTRY (ent_tag_type)));
   l = add_to_glist_combined_str (l, "tag_spellcheck", gtk_entry_get_text (GTK_ENTRY (ent_tag_spellcheck)));

   l = add_to_glist_combined_str (l, "text_foreground", gtk_entry_get_text (GTK_ENTRY (ent_text_foreground)));
   l = add_to_glist_combined_str (l, "text_background", gtk_entry_get_text (GTK_ENTRY (ent_text_background)));
 
   l = add_to_glist_combined_str (l, "text_sel_foreground", gtk_entry_get_text (GTK_ENTRY (ent_text_sel_foreground)));
   l = add_to_glist_combined_str (l, "text_sel_background", gtk_entry_get_text (GTK_ENTRY (ent_text_sel_background)));

   l = add_to_glist_combined_str (l, "def_filesave_charset", gtk_entry_get_text (GTK_ENTRY (ent_def_filesave_charset)));
   l = add_to_glist_combined_str (l, "default_charset", gtk_entry_get_text (GTK_ENTRY (ent_default_charset)));
   l = add_to_glist_combined_str (l, "rtf_enc", gtk_entry_get_text (GTK_ENTRY (ent_rtf_enc)));

   l = add_to_glist_combined_str (l, "tag_comment_font", gtk_font_button_get_font_name (fb_tag_comment_font));
   l = add_to_glist_combined_str (l, "tag_identifier_font", gtk_font_button_get_font_name (fb_tag_identifier_font));
   l = add_to_glist_combined_str (l, "tag_digit_font", gtk_font_button_get_font_name (fb_tag_digit_font));
   l = add_to_glist_combined_str (l, "tag_string_font", gtk_font_button_get_font_name (fb_tag_string_font));
   l = add_to_glist_combined_str (l, "tag_html_tag_font", gtk_font_button_get_font_name (fb_tag_html_tag_font));
   l = add_to_glist_combined_str (l, "tag_preprocessor_font", gtk_font_button_get_font_name (fb_tag_preprocessor_font));
   l = add_to_glist_combined_str (l, "tag_type_font", gtk_font_button_get_font_name (fb_tag_type_font));
   l = add_to_glist_combined_str (l, "editor_font", gtk_font_button_get_font_name (fb_editor_font));

   l = add_to_glist_combined_str (l, "ext_pic_editor", gtk_entry_get_text (GTK_ENTRY (ent_ext_pic_editor)));
   l = add_to_glist_combined_str (l, "ext_pic_viewer", gtk_entry_get_text (GTK_ENTRY (ent_ext_pic_viewer)));
   
   l = add_to_glist_combined_str (l, "def_file_ext", gtk_entry_get_text (GTK_ENTRY (ent_def_file_ext)));


   l = add_to_glist_combined_int (l, "common_closing_button_visible", gtk_toggle_button_get_active (&cb_common_closing_button_visible->toggle_button));
   l = add_to_glist_combined_int (l, "do_crash_file", gtk_toggle_button_get_active (&cb_do_crash_file->toggle_button));
   l = add_to_glist_combined_int (l, "do_save_all_on_termination", gtk_toggle_button_get_active (&cb_do_save_all_on_termination->toggle_button));
   l = add_to_glist_combined_int (l, "det_charset_by_meta", gtk_toggle_button_get_active (&cb_det_charset_by_meta->toggle_button));
   l = add_to_glist_combined_int (l, "do_last_session", gtk_toggle_button_get_active (&cb_autorestore_last_session->toggle_button));
   l = add_to_glist_combined_int (l, "hl_current_line", gtk_toggle_button_get_active (&cb_hl_current_line->toggle_button));
   l = add_to_glist_combined_int (l, "do_autosave", gtk_toggle_button_get_active (&cb_do_autosave->toggle_button));
   l = add_to_glist_combined_int (l, "autoclose_tags", gtk_toggle_button_get_active (&cb_autoclose_tags->toggle_button));
   l = add_to_glist_combined_int (l, "fullscreen", gtk_toggle_button_get_active (&cb_fullscreen->toggle_button));
   l = add_to_glist_combined_int (l, "notebook_tab_position", gtk_combo_box_get_active (tv_notetab_positions));
   l = add_to_glist_combined_int (l, "prompt_on_not_saved", gtk_toggle_button_get_active (&cb_prompt_on_not_saved->toggle_button));
   l = add_to_glist_combined_int (l, "prompt_on_file_exists", gtk_toggle_button_get_active (&cb_prompt_on_file_exists->toggle_button));

   l = add_to_glist_combined_int (l, "do_det_scripts_by_content", gtk_toggle_button_get_active (&cb_do_det_scripts_by_content->toggle_button));
   l = add_to_glist_combined_int (l, "do_show_main_toolbar", gtk_toggle_button_get_active (&cb_do_show_main_toolbar->toggle_button));
   l = add_to_glist_combined_int (l, "implane_ins_image", gtk_toggle_button_get_active (&cb_implane_ins_image->toggle_button));
   l = add_to_glist_combined_int (l, "use_cursor_blink", gtk_toggle_button_get_active (&cb_use_cursor_blink->toggle_button));

   l = add_to_glist_combined_int (l, "use_snippets", gtk_toggle_button_get_active (&cb_use_snippets->toggle_button));
   l = add_to_glist_combined_int (l, "use_ext_image_viewer", gtk_toggle_button_get_active (&cb_use_ext_image_viewer->toggle_button));



   l = add_to_glist_combined_int (l, "add_def_file_ext", gtk_toggle_button_get_active (&cb_add_def_file_ext->toggle_button));
   

   l = add_to_glist_combined_int (l, "do_hl_on_fileopen", gtk_toggle_button_get_active (&cb_do_hl_on_fileopen->toggle_button));
   l = add_to_glist_combined_int (l, "do_backup", gtk_toggle_button_get_active (&cb_do_backup->toggle_button));

   l = add_to_glist_combined_int (l, "start_with_blank_file", gtk_toggle_button_get_active (&cb_start_with_blank_file->toggle_button));
//   l = add_to_glist_combined_int (l, "start_with_recent_file", gtk_toggle_button_get_active (&cb_start_with_recent_file->toggle_button));

   l = add_to_glist_combined_int (l, "use_def_doc_browser", gtk_toggle_button_get_active (&cb_use_def_doc_browser->toggle_button));

   l = add_to_glist_combined_int (l, "show_line_nums", gtk_toggle_button_get_active (&cb_show_line_nums->toggle_button));
   l = add_to_glist_combined_int (l, "word_wrap", gtk_toggle_button_get_active (&cb_word_wrap->toggle_button));
   l = add_to_glist_combined_int (l, "use_def_save_dir", gtk_toggle_button_get_active (&cb_use_def_save_dir->toggle_button));
   l = add_to_glist_combined_int (l, "use_def_open_dir", gtk_toggle_button_get_active (&cb_use_def_open_dir->toggle_button));
   l = add_to_glist_combined_int (l, "use_auto_indent", gtk_toggle_button_get_active (&cb_use_auto_indent->toggle_button));

   l = add_to_glist_combined_int (l, "ins_spaces_on_tab_press", gtk_toggle_button_get_active (&cb_ins_spaces_on_tab_press->toggle_button));
   l = add_to_glist_combined_int (l, "scan_for_links_on_doc_open", gtk_toggle_button_get_active (&cb_scan_for_links_on_doc_open->toggle_button));
   l = add_to_glist_combined_int (l, "main_wnd_show_full_path", gtk_toggle_button_get_active (&cb_main_wnd_show_full_path->toggle_button));

   l = add_to_glist_combined_int (l, "enc_det_cp1251", gtk_toggle_button_get_active (&cb_enc_det_cp1251->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_koi8r", gtk_toggle_button_get_active (&cb_enc_det_koi8r->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_koi8u", gtk_toggle_button_get_active (&cb_enc_det_koi8u->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_866", gtk_toggle_button_get_active (&cb_enc_det_866->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_czech", gtk_toggle_button_get_active (&cb_enc_czech->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_finnish", gtk_toggle_button_get_active (&cb_enc_det_finnish->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_german", gtk_toggle_button_get_active (&cb_enc_det_german->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_serbian", gtk_toggle_button_get_active (&cb_enc_det_serbian->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_latvian", gtk_toggle_button_get_active (&cb_enc_det_latvian->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_polish", gtk_toggle_button_get_active (&cb_enc_det_polish->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_portuguese", gtk_toggle_button_get_active (&cb_enc_det_portuguese->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_slovak", gtk_toggle_button_get_active (&cb_enc_det_slovak->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_slovenian", gtk_toggle_button_get_active (&cb_enc_det_slovenian->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_spanish", gtk_toggle_button_get_active (&cb_enc_det_spanish->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_turkish", gtk_toggle_button_get_active (&cb_enc_det_turkish->toggle_button));
   l = add_to_glist_combined_int (l, "show_hidden_files", gtk_toggle_button_get_active (&cb_show_hidden_files->toggle_button));
   l = add_to_glist_combined_int (l, "do_autorep", gtk_toggle_button_get_active (&cb_do_autorep->toggle_button));



   l = add_to_glist_combined_int (l, "autosave_interval", gtk_spin_button_get_value_as_int (sb_autosave_interval));  
   l = add_to_glist_combined_int (l, "logmemo_lines_max", gtk_spin_button_get_value_as_int (sb_logmemo_lines_max));  
   //l = add_to_glist_combined_int (l, "famous_history_max", gtk_spin_button_get_value_as_int (sb_famous_history_max));  
   l = add_to_glist_combined_int (l, "max_recent_items", gtk_spin_button_get_value_as_int (sb_max_recent_items));  

   l = add_to_glist_combined_int (l, "thumb_width", gtk_spin_button_get_value_as_int (sb_thumb_width));  
   l = add_to_glist_combined_int (l, "thumb_height", gtk_spin_button_get_value_as_int (sb_thumb_height));  

   l = add_to_glist_combined_int (l, "saveopen_w", gtk_spin_button_get_value_as_int (sb_saveopen_w));  
   l = add_to_glist_combined_int (l, "saveopen_h", gtk_spin_button_get_value_as_int (sb_saveopen_h));  
   l = add_to_glist_combined_int (l, "tab_size", gtk_spin_button_get_value_as_int (sb_tab_size));  
 
   glist_save_to_file (l, confile.tea_rc);
   glist_strings_free (l);
   confile_reload ();
   write_gtkrc (); 
   gtk_rc_parse (confile.file_gtkrc);
   gtk_rc_reset_styles (gtk_settings_get_for_screen (gdk_screen_get_default ()));
   ui_update ();
   doc_update_all ();
   update_enc_menu();
}


static GtkWidget* wnd_options_encoding (void)
{
  GtkWidget *enc_tabs = gtk_notebook_new ();    
  gtk_widget_show (enc_tabs);
  
  GtkWidget *wnd = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (wnd);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (wnd), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
 
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  gtk_scrolled_window_add_with_viewport (wnd, page);

  GtkWidget *fr1 = gtk_frame_new (_("Defaults"));   
  gtk_widget_show (fr1);
  gtk_box_pack_start (page, fr1, FALSE, FALSE, UI_PACKFACTOR);

  GtkWidget *box = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (box);
  gtk_container_add (fr1, box); 

  ent_default_charset = tea_combo (box, confile.iconv_encs, _("Default charset for File open"), confile.default_charset);
  ent_def_filesave_charset = tea_combo (box, confile.gl_save_charsets, _("Default charset for File save as"), confile.def_filesave_charset);
  ent_rtf_enc = tea_text_entry (box, _("Default charset for RTF"), confile.rtf_enc);  
 

  fr1 = gtk_frame_new (_("Misc"));   
  gtk_widget_show (fr1);
  gtk_box_pack_start (box, fr1, FALSE, FALSE, UI_PACKFACTOR);
 
  box = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (box);
  gtk_container_add (fr1, box); 

  cb_det_charset_by_meta = tea_checkbox (box, _("Detect a charset by the [X]HTML meta header"), confile.det_charset_by_meta); 
 
  GtkWidget *fr2 = gtk_frame_new (_("Autodetect"));   
  gtk_widget_show (fr2);
 
  gtk_box_pack_start (page, fr2, FALSE, FALSE, UI_PACKFACTOR);
  
  box = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (box);
  gtk_container_add (fr2, box); 

  cb_enc_det_cp1251 = tea_checkbox (box, _("CP 1251"), confile.enc_det_cp1251); 
  cb_enc_det_koi8r = tea_checkbox (box, _("KOI8-R"), confile.enc_det_koi8r);
  cb_enc_det_koi8u = tea_checkbox (box, _("KOI8-U"), confile.enc_det_koi8u);
  cb_enc_det_866 = tea_checkbox (box, _("DOS 866"), confile.enc_det_866);
  cb_enc_czech = tea_checkbox (box, _("Czech"), confile.enc_det_czech);
  cb_enc_det_finnish = tea_checkbox (box, _("Finnish"), confile.enc_det_finnish);
  cb_enc_det_german = tea_checkbox (box, _("German"), confile.enc_det_german);
  cb_enc_det_serbian = tea_checkbox (box, _("Serbian"), confile.enc_det_serbian);
  cb_enc_det_latvian = tea_checkbox (box, _("Latvian"), confile.enc_det_latvian);
  cb_enc_det_polish = tea_checkbox (box, _("Polish"), confile.enc_det_polish);
  cb_enc_det_portuguese = tea_checkbox (box, _("Portuguese"), confile.enc_det_portuguese);
  cb_enc_det_slovak = tea_checkbox (box, _("Slovak"), confile.enc_det_slovak);
  cb_enc_det_slovenian = tea_checkbox (box, _("Slovenian"), confile.enc_det_slovenian);
  cb_enc_det_spanish = tea_checkbox (box, _("Spanish"), confile.enc_det_spanish);  
  cb_enc_det_turkish = tea_checkbox (box, _("Turkish"), confile.enc_det_turkish);  

  //current music: Radiohead - Banana Co.
  gtk_notebook_append_page (enc_tabs, wnd, gtk_label_new (_("Management")));

  GtkWidget *hb = gtk_hbox_new (FALSE, UI_PACKFACTOR);
  
  gtk_widget_show (hb);

  tv_available_charsets = tv_create_framed (hb, _("Available"), GTK_SELECTION_SINGLE);
  tv_fill_with_glist (tv_available_charsets, gl_enc_available);

  GtkVBox *buttons = daisho_add_del (cb_on_choose_enc, cb_on_del_enc);
  gtk_box_pack_start (hb, buttons, FALSE, FALSE, UI_PACKFACTOR);
  
  tv_choosed_charsets = tv_create_framed (hb, _("Selected"), GTK_SELECTION_SINGLE);
  tv_fill_with_glist (tv_choosed_charsets, gl_enc_choosed);
 
  gtk_notebook_append_page (enc_tabs, hb, gtk_label_new (_("Configure charsets")));
  
  return enc_tabs;
}


static GtkWidget* wnd_options_commands (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);

  GtkWidget *fr_misc = gtk_frame_new (_("Misc"));
  gtk_widget_show (fr_misc);
  gtk_container_add (page, fr_misc);

  GtkWidget *b = gtk_vbox_new (FALSE, UI_PACKFACTOR); 
  gtk_widget_show (b);
  gtk_container_add (fr_misc, b);

  ent_ext_pic_editor = tea_text_entry (b, _("External image editor"), confile.ext_pic_editor);
  ent_ext_pic_viewer = tea_text_entry (b, _("External image viewer"), confile.ext_pic_viewer);
  ent_cm_mplayer =  tea_text_entry (b, _("Run Mplayer with subtitles"), confile.cm_mplayer);

  ent_cm_manual_browser = tea_text_entry (b, _("Browser for the manual"), confile.cmd_def_doc_browser);
  cb_use_def_doc_browser = tea_checkbox (b, _("Use this browser"), confile.use_def_doc_browser); 

  GtkWidget *fr_latex = gtk_frame_new (_("LaTeX"));
  gtk_widget_show (fr_latex);
  gtk_container_add (page, fr_latex);

  b = gtk_vbox_new (FALSE, UI_PACKFACTOR); 
  gtk_widget_show (b);
  gtk_container_add (fr_latex, b);
  
  ent_cm_run_latex = tea_text_entry (b, _("Process with LaTeX"), confile.cm_run_latex); 
  ent_cm_pdflatex = tea_text_entry (b, _("Process with pdflatex"), confile.cm_pdflatex); 
  ent_cm_dvi_to_pdf = tea_text_entry (b, _("dvi to PDF"), confile.cm_dvi_to_pdf); 
  ent_cm_dvi_to_ps = tea_text_entry (b, _("dvi to PS"), confile.cm_dvi_to_ps); 
  ent_cm_dvi_view = tea_text_entry (b, _("View dvi"), confile.cm_dvi_view); 
  ent_cm_pdf_view = tea_text_entry (b, _("View PDF"), confile.cm_pdf_view); 
  ent_cm_ps_view = tea_text_entry (b, _("View PS"), confile.cm_ps_view); 
  
  return page;
}

/*
static GtkWidget* wnd_options_limits (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, 1);
  gtk_widget_show (page);

  sb_famous_history_max = tea_spinbutton (page, _("Text entry history limit"), confile.famous_history_max);
  sb_max_recent_items = tea_spinbutton (page, _("Max. recent files"), confile.max_recent_items); 
 sb_logmemo_lines_max = tea_spinbutton (page, _("Logmemo lines limit"), confile.logmemo_lines_max);
 
  return page;
}
*/

static GtkWidget* wnd_options_functions (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, 1);
  gtk_widget_show (page);
  ent_now_playing = tea_text_entry (page, _("Now Playing string format"), confile.now_playing);
  ent_date_time = tea_text_entry (page, _("Date and time format"), confile.date_time);
  ent_fmt_color_function = tea_text_entry (page, _("The format of the Color function"), confile.fmt_color_function);

  return page;
}


static GtkWidget* wnd_options_interface (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  
  sb_saveopen_w = tea_spinbutton (page, _("Save/Open dialogs width per cents"), confile.saveopen_w);
  sb_saveopen_h = tea_spinbutton (page, _("Save/Open dialogs height per cents"), confile.saveopen_h);
  sb_thumb_width = tea_spinbutton (page, _("Image thumbnail width"), confile.thumb_width);
  sb_thumb_height = tea_spinbutton (page, _("Image thumbnail height"), confile.thumb_height);
  cb_main_wnd_show_full_path = tea_checkbox (page, _("Show the full path in the window caption"), confile.main_wnd_show_full_path); 
  cb_do_show_main_toolbar = tea_checkbox (page, _("Show the main toolbar"), confile.do_show_main_toolbar); 
  cb_common_closing_button_visible = tea_checkbox (page, _("Show the common close button"), confile.common_closing_button_visible); 
  cb_fullscreen = tea_checkbox (page, _("Start in the full-screen mode"), confile.fullscreen); 

  tv_notetab_positions = tea_combo_combo (page, gl_notetab_positions, _("Tabs position"), confile.notebook_tab_position); 

  sb_max_recent_items = tea_spinbutton (page, _("Max. recent files"), confile.max_recent_items); 
  sb_logmemo_lines_max = tea_spinbutton (page, _("Logmemo lines limit"), confile.logmemo_lines_max);
 

  return page;
}


static GtkWidget* wnd_options_switches (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);

  cb_do_crash_file = tea_checkbox (page, _("Save the crashfile on terminate"), confile.do_crash_file); 
  cb_do_save_all_on_termination = tea_checkbox (page, _("Save all on the abnormal termination (SIGTERM, etc)"), confile.do_save_all_on_termination); 
  
  cb_autorestore_last_session = tea_checkbox (page, _("Restore the last session on start"), confile.do_last_session); 
  cb_start_with_blank_file = tea_checkbox (page, _("Start TEA with a blank file"), confile.start_with_blank_file); 

  cb_do_det_scripts_by_content = tea_checkbox (page, _("Determine a scripts highlighting by the content"), confile.do_det_scripts_by_content); 

#ifndef CHAI_MODE

gtk_widget_hide (cb_do_det_scripts_by_content);
  
#endif

  cb_show_hidden_files = tea_checkbox (page, _("Show hidden files in Kwas"), confile.show_hidden_files); 
  cb_use_snippets = tea_checkbox (page, _("Use snippets"), confile.use_snippets); 
  cb_use_ext_image_viewer = tea_checkbox (page, _("Use external image viewer"), confile.use_ext_image_viewer);
  cb_do_hl_on_fileopen = tea_checkbox (page, _("Highlight on file open"), confile.do_hl_on_fileopen);
  cb_do_backup = tea_checkbox (page, _("Do backup"), confile.do_backup);
  cb_show_line_nums = tea_checkbox (page, _("Show line numbers"), confile.show_line_nums);
  cb_word_wrap = tea_checkbox (page, _("Word wrap"), confile.word_wrap);
  cb_scan_for_links_on_doc_open = tea_checkbox (page, _("Scan for links on file open"), confile.scan_for_links_on_doc_open);
  cb_implane_ins_image = tea_checkbox (page, _("Imageplane insert tags by default"), confile.implane_ins_image);

  return page;
}


static GtkWidget* wnd_options_confirmations (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  
  cb_prompt_on_not_saved = tea_checkbox (page, _("Warn before closing a modified file"), confile.prompt_on_not_saved); 
  cb_prompt_on_file_exists = tea_checkbox (page, _("Overwrite the existing file"), confile.prompt_on_file_exists); 
 
  return page;
}


static void cb_backup_config (GtkButton *button,
                              gpointer user_data)
{
  gchar *f = g_strconcat (confile.tea_rc, ".bak", NULL);
  copy_file (confile.tea_rc, f);
  g_free (f);
}


static void cb_change_all_fonts (GtkButton *button,
                                gpointer user_data)
{
  GtkFontSelectionDialog *w = gtk_font_selection_dialog_new (_("Please select the font"));
  gchar *font_name;

  if (gtk_dialog_run (GTK_DIALOG (w)) == GTK_RESPONSE_OK)
    {
     font_name = gtk_font_selection_dialog_get_font_name (w);
     if (font_name)
       {
        gtk_font_button_set_font_name (fb_tag_comment_font, font_name);
        gtk_font_button_set_font_name (fb_tag_identifier_font, font_name);
        gtk_font_button_set_font_name (fb_tag_digit_font, font_name);
        gtk_font_button_set_font_name (fb_tag_string_font, font_name);
        gtk_font_button_set_font_name (fb_tag_html_tag_font, font_name);
        gtk_font_button_set_font_name (fb_tag_preprocessor_font, font_name);
        gtk_font_button_set_font_name (fb_tag_type_font, font_name);
        gtk_font_button_set_font_name (fb_editor_font, font_name);
        g_free (font_name);
       }
     }

  gtk_widget_destroy (w);
}

static void cb_restore_config (GtkButton *button,
                               gpointer user_data)
{
  gchar *f = g_strconcat (confile.tea_rc, ".bak", NULL);
  copy_file (f, confile.tea_rc);
  g_free (f);
  confile_reload ();
  doc_update_all();
  update_enc_menu();
  dlg_info (wnd_options, _("Configuration restored, please close and reopen the Preferences window."), NULL);  
}


static void cb_config_reset (GtkButton *button,
                             gpointer user_data)
{
   if (unlink (confile.tea_rc) == 0 )
      {
       confile_reload ();
       doc_update_all();
       update_enc_menu();
       dlg_info (wnd_options, _("Configuration is reseted to default, please close and reopen the Preferences window."), NULL);  
      }  
}


static GtkWidget* wnd_options_maintenance (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  
  GtkWidget *b = tea_button_at_box (page, _("Backup the current config" ), cb_backup_config, NULL);
  b = tea_button_at_box (page, _("Config restore" ), cb_restore_config, NULL);
  b = tea_button_at_box (page, _("Reset config to default" ), cb_config_reset, NULL);
  b = tea_button_at_box (page, _("Put the launcher to the desktop" ), cb_put_launcher, NULL);
  b = tea_button_at_box (page, _("Remove the launcher from the desktop" ), cb_del_launcher, NULL);
  
  return page;
}


static GtkWidget* wnd_options_colors (void)
{
  GtkWidget *notebook = gtk_notebook_new ();         
  gtk_widget_show (notebook);

  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);

  gtk_notebook_append_page (notebook, page, gtk_label_new (_("Editor")));

  ent_text_foreground = tea_color_selector (page, _("Text foreground"), confile.text_foreground);
  ent_text_background = tea_color_selector (page, _("Text background"), confile.text_background);
  ent_text_sel_foreground = tea_color_selector (page, _("Selected foreground"), confile.text_sel_foreground);
  ent_text_sel_background = tea_color_selector (page, _("Selected background"), confile.text_sel_background);
  ent_color_cursor = tea_color_selector (page, _("Cursor color"), confile.color_cursor);

  ent_tag_color_paint_fg = tea_color_selector (page, _("Marking function foreground"), confile.tag_color_paint_fg);
  ent_tag_color_paint_bg = tea_color_selector (page, _("Marking function background"), confile.tag_color_paint_bg);

  ent_tag_current_line_fg = tea_color_selector (page, _("Current line foreground"), confile.tag_current_line_fg);
  ent_tag_current_line_bg = tea_color_selector (page, _("Current line background"), confile.tag_current_line_bg);

  ent_tag_spellcheck = tea_color_selector (page, _("Spellchecker marks"), confile.tag_spellcheck);
  
  page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  gtk_notebook_append_page (notebook, page, gtk_label_new (_("Highlighting")));
 
  ent_tag_comment = tea_color_selector (page, _("Comments"), confile.tag_comment);
  ent_tag_identifier = tea_color_selector (page, _("Identifiers"), confile.tag_identifier);
  ent_tag_digit = tea_color_selector (page, _("Digits"), confile.tag_digit); 
  ent_tag_string = tea_color_selector (page, _("Strings"), confile.tag_string);
  ent_tag_html_tag = tea_color_selector (page, _("HTML tags"), confile.tag_html_tag);
  ent_tag_preprocessor = tea_color_selector (page, _("Preprocessor"), confile.tag_preprocessor);
  ent_tag_type = tea_color_selector (page, _("Types"), confile.tag_type);

  #ifdef CHAI_MODE

  gtk_widget_hide (page);
  
  #endif

  page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  gtk_notebook_append_page (notebook, page, gtk_label_new (_("IDE")));
 
  ent_tag_color_lm_error_fg = tea_color_selector (page, _("Errors foreground (logmemo)"), confile.tag_color_lm_error_fg);
  ent_tag_color_lm_error_bg = tea_color_selector (page, _("Errors background (logmemo)"), confile.tag_color_lm_error_bg);

  return notebook ;
}


static GtkWidget* wnd_options_fonts (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);

#ifndef CHAI_MODE

  fb_editor_font = tea_font_button (page, _("Editor font"), confile.editor_font); 

#endif

  fb_tag_comment_font = tea_font_button (page, _("Comments font"), confile.tag_comment_font); 
  fb_tag_identifier_font = tea_font_button (page, _("Identifiers font"), confile.tag_identifier_font); 
  fb_tag_digit_font = tea_font_button (page, _("Digits font"), confile.tag_digit_font); 
  fb_tag_string_font = tea_font_button (page, _("Strings font"), confile.tag_string_font); 
  fb_tag_html_tag_font = tea_font_button (page, _("HTML tags font"), confile.tag_html_tag_font); 
  fb_tag_preprocessor_font = tea_font_button (page, _("Preprocessor font"), confile.tag_preprocessor_font); 
  fb_tag_type_font = tea_font_button (page, _("Types font"), confile.tag_type_font); 

  GtkButton *bt_change_all_fonts = tea_button_at_box (page, _("Change all fonts"), cb_change_all_fonts, NULL);
 
  return page;
}


static GtkWidget* wnd_options_editor (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
 
#ifdef CHAI_MODE

  fb_editor_font = tea_font_button (page, _("Font"), confile.editor_font); 

#endif

  ent_def_markup_mode = tea_combo (page, gl_markup_modes, _("Default markup mode"), confile.default_markup_mode);

  sb_tab_size = tea_spinbutton (page, _("Tab size in spaces"), confile.tab_size);
  cb_ins_spaces_on_tab_press = tea_checkbox (page, _("Insert spaces on TAB key"), confile.ins_spaces_on_tab_press);
  cb_use_auto_indent = tea_checkbox (page, _("Automatic indent"), confile.use_auto_indent);
  cb_do_autorep = tea_checkbox (page, _("Autoreplace"), confile.do_autorep);
  cb_autoclose_tags = tea_checkbox (page, _("Autoclose tags"), confile.autoclose_tags);  
  cb_use_cursor_blink = tea_checkbox (page, _("Cursor blink"), confile.use_cursor_blink);  
  sb_autosave_interval = tea_spinbutton (page, _("Autosaving interval, minutes"), confile.autosave_interval);
  cb_do_autosave = tea_checkbox (page, _("Enable the autosaving"), confile.do_autosave);
  cb_hl_current_line = tea_checkbox (page, _("Highlight the current line"), confile.hl_current_line);

  cb_margin_visible = tea_checkbox (page, _("Show the margin"), confile.margin_visible);  
  sb_margin_width = tea_spinbutton (page, _("Position of the margin (GtkSourceView-only)"), confile.margin_width);

#ifndef CHAI_MODE

  gtk_widget_hide (cb_margin_visible);
  
#endif


  return page;
}


static GtkWidget* wnd_options_paths (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  ent_def_save_dir = tea_dir_selector (page, _("Default file saving directory"), confile.def_save_dir);
  cb_use_def_save_dir = tea_checkbox (page, _("Use default saving directory"), confile.use_def_save_dir);
  ent_def_open_dir = tea_dir_selector (page, _("Default file opening directory"), confile.def_open_dir);
  cb_use_def_open_dir = tea_checkbox (page, _("Use default file opening directory"), confile.use_def_open_dir);
  
  cb_add_def_file_ext = tea_checkbox (page, _("Add this extension to the file which is *Saving as*"), confile.add_def_file_ext);
  ent_def_file_ext = tea_text_entry (page, _("(<i>for example, txt, html, etc</i>)"), confile.def_file_ext);


  return page;
}


GtkWidget* wnd_options_create (void)
{
  wnd_options = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_window_set_title (GTK_WINDOW (wnd_options), _("Options, I presume..."));

  GtkWidget *vbox1 = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (wnd_options), vbox1);

  GtkWidget *notebook = gtk_notebook_new ();         
  gtk_notebook_set_tab_pos (notebook, GTK_POS_LEFT);

  gtk_widget_show (notebook);

  gtk_container_add (GTK_CONTAINER (vbox1), notebook);

  gtk_notebook_append_page (notebook, wnd_options_switches (), gtk_label_new (_("Switches")));
  gtk_notebook_append_page (notebook, wnd_options_encoding (), gtk_label_new (_("Encoding")));
  gtk_notebook_append_page (notebook, wnd_options_functions (), gtk_label_new (_("Functions")));
  gtk_notebook_append_page (notebook, wnd_options_interface (), gtk_label_new (_("Interface")));
//  gtk_notebook_append_page (notebook, wnd_options_limits (), gtk_label_new (_("Limits")));

  page_fonts = wnd_options_fonts ();

#ifndef CHAI_MODE

  gtk_notebook_append_page (notebook, page_fonts, gtk_label_new (_("Fonts")));

#endif
  
  gtk_notebook_append_page (notebook, wnd_options_editor (), gtk_label_new (_("Editor")));

#ifdef CHAI_MODE

//n.p. THe Pixies - Manta Ray

 gtk_notebook_append_page (notebook, wnd_options_hl_chai (), gtk_label_new (_("Highlighting")));
  
#endif

  gtk_notebook_append_page (notebook, wnd_options_colors (), gtk_label_new (_("Colors")));


  gtk_notebook_append_page (notebook, wnd_options_commands (), gtk_label_new (_("Commands")));
  gtk_notebook_append_page (notebook, wnd_options_paths (), gtk_label_new (_("Paths")));
  gtk_notebook_append_page (notebook, wnd_options_confirmations (), gtk_label_new (_("Confirmations")));
  gtk_notebook_append_page (notebook, wnd_options_maintenance (), gtk_label_new (_("Maintenance")));

  gtk_notebook_set_current_page (notebook, confile.last_prefs_tab);

  g_signal_connect ((gpointer) notebook, "switch_page",
                    G_CALLBACK (on_kwas_notebook_switch_page),
                    NULL);

  GtkWidget *hbox1 = gtk_hbutton_box_new ();     
  gtk_button_box_set_layout (hbox1, GTK_BUTTONBOX_SPREAD);

  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (vbox1), hbox1);

  GtkWidget *bt_close = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
  gtk_widget_show (bt_close);
  gtk_container_add (GTK_CONTAINER (hbox1), bt_close);

  g_signal_connect (bt_close, "clicked", G_CALLBACK (cb_on_bt_close), wnd_options);

  GtkWidget *im_save = gtk_image_new_from_stock (GTK_STOCK_SAVE, GTK_ICON_SIZE_BUTTON);
  GtkWidget *im_apply = gtk_image_new_from_stock (GTK_STOCK_APPLY, GTK_ICON_SIZE_BUTTON);
  GtkWidget *hb_apply = gtk_hbox_new (FALSE, UI_PACKFACTOR);
  GtkWidget *l_apply = gtk_label_new (_("Save and apply"));
  gtk_container_add (GTK_CONTAINER (hb_apply), im_save);
  gtk_container_add (GTK_CONTAINER (hb_apply), im_apply);
  gtk_container_add (GTK_CONTAINER (hb_apply), l_apply);
  gtk_widget_show_all (hb_apply);

  GtkWidget *bt_apply = gtk_button_new ();
  gtk_container_add (GTK_CONTAINER (bt_apply), hb_apply);
  
  gtk_widget_show (bt_apply);
  gtk_container_add (GTK_CONTAINER (hbox1), bt_apply);

  g_signal_connect (bt_apply, "clicked", G_CALLBACK (cb_on_bt_apply), wnd_options);

  gtk_window_set_position (wnd_options, GTK_WIN_POS_CENTER);   
  gtk_window_set_modal (wnd_options, TRUE);

  g_signal_connect (G_OBJECT (wnd_options), "key_press_event", G_CALLBACK (win_key_handler), wnd_options);

  gtk_widget_show (wnd_options);
  return wnd_options;
}
