/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (tcprewrite_opts.h)
 *  
 *  It has been AutoGen-ed  Thursday July 28, 2005 at 09:57:17 PM PDT
 *  From the definitions    tcprewrite_opts.def
 *  and the template file   options
 */
/*
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the tcprewrite program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_TCPREWRITE_OPTS_H_GUARD
#define AUTOOPTS_TCPREWRITE_OPTS_H_GUARD

/*
 * tcprewrite copyright 2004-2005 Aaron Turner - all rights reserved
 *
 * tcprewrite is free software copyrighted by Aaron Turner.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name ``Aaron Turner'' nor the name of any other
 *    contributor may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 * 
 * tcprewrite IS PROVIDED BY Aaron Turner ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Aaron Turner OR ANY OTHER CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "config.h"
#include <autoopts/options.h>

/*
 *  Enumeration of each option:
 */
typedef enum {
        INDEX_OPT_DBUG             =  0,
        INDEX_OPT_DMAC             =  1,
        INDEX_OPT_SMAC             =  2,
        INDEX_OPT_PROTO            =  3,
        INDEX_OPT_DLINK            =  4,
        INDEX_OPT_PORTMAP          =  5,
        INDEX_OPT_SEED             =  6,
        INDEX_OPT_PNAT             =  7,
        INDEX_OPT_ENDPOINTS        =  8,
        INDEX_OPT_FIXCSUM          =  9,
        INDEX_OPT_INFILE           = 10,
        INDEX_OPT_OUTFILE          = 11,
        INDEX_OPT_CACHEFILE        = 12,
        INDEX_OPT_MTU              = 13,
        INDEX_OPT_EFCS             = 14,
        INDEX_OPT_FIXLEN           = 15,
        INDEX_OPT_VLAN             = 16,
        INDEX_OPT_VLAN_TAG         = 17,
        INDEX_OPT_VLAN_CFI         = 18,
        INDEX_OPT_VLAN_PRI         = 19,
        INDEX_OPT_VERBOSE          = 20,
        INDEX_OPT_DECODE           = 21,
        INDEX_OPT_VERSION          = 22,
        INDEX_OPT_LESS_HELP        = 23,
        INDEX_OPT_HELP             = 24,
        INDEX_OPT_MORE_HELP        = 25,
        INDEX_OPT_SAVE_OPTS        = 26,
        INDEX_OPT_LOAD_OPTS        = 27
} teOptIndex;

#define OPTION_CT    28

/*
 *  Interface defines for all options.  Replace "n" with
 *  the UPPER_CASED option name (as in the teOptIndex
 *  enumeration above).  e.g. HAVE_OPT( DBUG )
 */
#define         DESC(n) tcprewriteOptions.pOptDesc[INDEX_OPT_ ## n]
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
#define      OPT_ARG(n) (DESC(n).pzLastArg)
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
#define    COUNT_OPT(n) (DESC(n).optOccCt)
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT;   \
                if ( (DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )

/*
 *  Interface defines for specific options.
 */
#define VALUE_OPT_DBUG           'd'
#define OPT_VALUE_DBUG           (*(unsigned long*)(&DESC(DBUG).pzLastArg))
#define VALUE_OPT_DMAC           'D'
#define VALUE_OPT_SMAC           'S'
#define VALUE_OPT_PROTO          'P'
#define OPT_VALUE_PROTO          (*(unsigned long*)(&DESC(PROTO).pzLastArg))
#define VALUE_OPT_DLINK          'l'
#define VALUE_OPT_PORTMAP        'r'
#define VALUE_OPT_SEED           's'
#define OPT_VALUE_SEED           (*(unsigned long*)(&DESC(SEED).pzLastArg))
#define VALUE_OPT_PNAT           'N'
#define VALUE_OPT_ENDPOINTS      'e'
#define VALUE_OPT_FIXCSUM        'C'
#define VALUE_OPT_INFILE         'i'
#define VALUE_OPT_OUTFILE        'o'
#define VALUE_OPT_CACHEFILE      'c'
#define SET_OPT_CACHEFILE(a)   STMTS( \
        DESC(CACHEFILE).optActualIndex = 12; \
        DESC(CACHEFILE).optActualValue = VALUE_OPT_CACHEFILE; \
        DESC(CACHEFILE).fOptState &= OPTST_PERSISTENT; \
        DESC(CACHEFILE).fOptState |= OPTST_SET; \
        DESC(CACHEFILE).pzLastArg  = (tCC*)(a); \
        (*(DESC(CACHEFILE).pOptProc))( &tcprewriteOptions, \
                tcprewriteOptions.pOptDesc + 12 ) )
#define VALUE_OPT_MTU            'm'
#define OPT_VALUE_MTU            (*(unsigned long*)(&DESC(MTU).pzLastArg))
#define VALUE_OPT_EFCS           'E'
#define VALUE_OPT_FIXLEN         'F'
#define VALUE_OPT_VLAN           'T'
#define VALUE_OPT_VLAN_TAG       't'
#define OPT_VALUE_VLAN_TAG       (*(unsigned long*)(&DESC(VLAN_TAG).pzLastArg))
#define VALUE_OPT_VLAN_CFI       'c'
#define OPT_VALUE_VLAN_CFI       (*(unsigned long*)(&DESC(VLAN_CFI).pzLastArg))
#define VALUE_OPT_VLAN_PRI       'p'
#define OPT_VALUE_VLAN_PRI       (*(unsigned long*)(&DESC(VLAN_PRI).pzLastArg))
#ifdef HAVE_TCPDUMP
#define VALUE_OPT_VERBOSE        'v'
#define SET_OPT_VERBOSE   STMTS( \
        DESC(VERBOSE).optActualIndex = 20; \
        DESC(VERBOSE).optActualValue = VALUE_OPT_VERBOSE; \
        DESC(VERBOSE).fOptState &= OPTST_PERSISTENT; \
        DESC(VERBOSE).fOptState |= OPTST_SET )
#endif /* HAVE_TCPDUMP */
#ifdef HAVE_TCPDUMP
#define VALUE_OPT_DECODE         'A'
#endif /* HAVE_TCPDUMP */
#define VALUE_OPT_VERSION        'V'
#define VALUE_OPT_LESS_HELP      'h'

#define VALUE_OPT_SAVE_OPTS     INDEX_OPT_SAVE_OPTS
#define VALUE_OPT_LOAD_OPTS     INDEX_OPT_LOAD_OPTS
#define VALUE_OPT_HELP          'H'
#define VALUE_OPT_MORE_HELP     '!'
#define SET_OPT_SAVE_OPTS(a)   STMTS( \
        DESC(SAVE_OPTS).fOptState &= OPTST_PERSISTENT; \
        DESC(SAVE_OPTS).fOptState |= OPTST_SET; \
        DESC(SAVE_OPTS).pzLastArg  = (tCC*)(a) )

/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS( tcprewriteOptions.fOptSet &= ~OPTPROC_ERRSTOP )
#define ERRSTOP_OPTERR  STMTS( tcprewriteOptions.fOptSet |= OPTPROC_ERRSTOP )
#define RESTART_OPT(n)  STMTS( \
                tcprewriteOptions.curOptIdx = (n); \
                tcprewriteOptions.pzCurOpt  = NULL )
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*tcprewriteOptions.pUsageProc)( &tcprewriteOptions, c )
/* extracted from /usr/local/share/autogen/opthead.tpl near line 246 */

/* * * * * *
 *
 *  Declare the tcprewrite option descriptor.
 */
#ifdef  __cplusplus
extern "C" {
#endif

extern tOptions   tcprewriteOptions;

#ifndef _
#  if ENABLE_NLS
#    include <stdio.h>
     static inline char* aoGetsText( const char* pz ) {
         if (pz == NULL) return NULL;
         return (char*)gettext( pz );
     }
#    define _(s)  aoGetsText(s)
#  else  /* ENABLE_NLS */
#    define _(s)  s
#  endif /* ENABLE_NLS */
#endif

#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_TCPREWRITE_OPTS_H_GUARD */
