/*
 * host_descriptor_t.h -- struct that represents a side of a
 *                             connection (client or server)
 * Part of the tcpick project
 *
 * Author: Francesco Stablum <duskdruid @ despammed.com>
 *
 * Copyright (C) 2003, 2004  Francesco Stablum
 * Licensed under the GPL
 *
 */


typedef enum { NOTHING = 0,
	       CLIENT,
	       SERVER,
	       BOTH } Part_t;

struct host_descriptor_t { 
	u_int16_t port;
        struct in_addr ip;

	u_int32_t sip;
    /* why have I called them SIP and not SIN?
       well, SIP means Sequence Initial Pointer
       that is exactly the SIN plus one
    */
	FILE * file;     /* NULL means closed */
	char * filename;
	Part_t side;
	int wlen;
	
	struct fragment_t * unack;
	
	struct host_descriptor_t * oth;
};

