/*
 * trfDecls.h --
 *
 *	Declarations of functions in the platform independent public Trf API.
 *
 * Copyright (c) 1999 by Andreas Kupries <andreas_kupries@users.sourceforge.net>
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: trfDecls.h,v 1.2 1999/09/21 18:48:57 aku Exp $
 */

#ifndef _TRFDECLS
#define _TRFDECLS

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/trf.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

/* 0 */
EXTERN int		Trf_IsInitialized _ANSI_ARGS_((Tcl_Interp * interp));
/* 1 */
EXTERN int		Trf_Register _ANSI_ARGS_((Tcl_Interp * interp, 
				CONST Trf_TypeDefinition * type));
/* 2 */
EXTERN Trf_OptionVectors* Trf_ConverterOptions _ANSI_ARGS_((void));
/* 3 */
EXTERN int		Trf_LoadLibrary _ANSI_ARGS_((Tcl_Interp * interp, 
				CONST char * libName, VOID ** handlePtr, 
				char ** symbols, int num));
/* 4 */
EXTERN void		Trf_LoadFailed _ANSI_ARGS_((VOID** handlePtr));
/* 5 */
EXTERN int		Trf_RegisterMessageDigest _ANSI_ARGS_((
				Tcl_Interp* interp, 
				CONST Trf_MessageDigestDescription* md_desc));
/* 6 */
EXTERN void		Trf_XorBuffer _ANSI_ARGS_((VOID* buffer, VOID* mask, 
				int length));
/* 7 */
EXTERN void		Trf_ShiftRegister _ANSI_ARGS_((VOID* buffer, 
				VOID* in, int shift, int buffer_length));
/* 8 */
EXTERN void		Trf_FlipRegisterLong _ANSI_ARGS_((VOID* buffer, 
				int length));
/* 9 */
EXTERN void		Trf_FlipRegisterShort _ANSI_ARGS_((VOID* buffer, 
				int length));

typedef struct TrfStubHooks {
    struct TrfIntStubs *trfIntStubs;
} TrfStubHooks;

typedef struct TrfStubs {
    int magic;
    struct TrfStubHooks *hooks;

    int (*trf_IsInitialized) _ANSI_ARGS_((Tcl_Interp * interp)); /* 0 */
    int (*trf_Register) _ANSI_ARGS_((Tcl_Interp * interp, CONST Trf_TypeDefinition * type)); /* 1 */
    Trf_OptionVectors* (*trf_ConverterOptions) _ANSI_ARGS_((void)); /* 2 */
    int (*trf_LoadLibrary) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * libName, VOID ** handlePtr, char ** symbols, int num)); /* 3 */
    void (*trf_LoadFailed) _ANSI_ARGS_((VOID** handlePtr)); /* 4 */
    int (*trf_RegisterMessageDigest) _ANSI_ARGS_((Tcl_Interp* interp, CONST Trf_MessageDigestDescription* md_desc)); /* 5 */
    void (*trf_XorBuffer) _ANSI_ARGS_((VOID* buffer, VOID* mask, int length)); /* 6 */
    void (*trf_ShiftRegister) _ANSI_ARGS_((VOID* buffer, VOID* in, int shift, int buffer_length)); /* 7 */
    void (*trf_FlipRegisterLong) _ANSI_ARGS_((VOID* buffer, int length)); /* 8 */
    void (*trf_FlipRegisterShort) _ANSI_ARGS_((VOID* buffer, int length)); /* 9 */
} TrfStubs;

#ifdef __cplusplus
extern "C" {
#endif
extern TrfStubs *trfStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_TRF_STUBS) && !defined(USE_TRF_STUB_PROCS)

/*
 * Inline function declarations:
 */

#ifndef Trf_IsInitialized
#define Trf_IsInitialized \
	(trfStubsPtr->trf_IsInitialized) /* 0 */
#endif
#ifndef Trf_Register
#define Trf_Register \
	(trfStubsPtr->trf_Register) /* 1 */
#endif
#ifndef Trf_ConverterOptions
#define Trf_ConverterOptions \
	(trfStubsPtr->trf_ConverterOptions) /* 2 */
#endif
#ifndef Trf_LoadLibrary
#define Trf_LoadLibrary \
	(trfStubsPtr->trf_LoadLibrary) /* 3 */
#endif
#ifndef Trf_LoadFailed
#define Trf_LoadFailed \
	(trfStubsPtr->trf_LoadFailed) /* 4 */
#endif
#ifndef Trf_RegisterMessageDigest
#define Trf_RegisterMessageDigest \
	(trfStubsPtr->trf_RegisterMessageDigest) /* 5 */
#endif
#ifndef Trf_XorBuffer
#define Trf_XorBuffer \
	(trfStubsPtr->trf_XorBuffer) /* 6 */
#endif
#ifndef Trf_ShiftRegister
#define Trf_ShiftRegister \
	(trfStubsPtr->trf_ShiftRegister) /* 7 */
#endif
#ifndef Trf_FlipRegisterLong
#define Trf_FlipRegisterLong \
	(trfStubsPtr->trf_FlipRegisterLong) /* 8 */
#endif
#ifndef Trf_FlipRegisterShort
#define Trf_FlipRegisterShort \
	(trfStubsPtr->trf_FlipRegisterShort) /* 9 */
#endif

#endif /* defined(USE_TRF_STUBS) && !defined(USE_TRF_STUB_PROCS) */

/* !END!: Do not edit above this line. */

#endif /* _TRFDECLS */

