[comment {-*- tcl -*- doctools manpage}]
[manpage_begin transfer::connect n 0.1]
[copyright {2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Data transfer facilities}]
[titledesc {Connection setup}]
[require Tcl               8.4]
[require snit              [opt 1.0]]
[require transfer::connect [opt 0.1]]
[description]
[keywords transfer channel connection passive active]
[para]

This package provides objects holding enough information to enable
them to either connect to a counterpart, or to be connected to by said
counterpart.

I.e. any object created by this packages is always in one of two
complementary modes, called [term active] (the object initiates the
connection) and [term passive] (the object receives the connection).

[para]

Of the two objects in a connecting pair one has to be configured for
[term active] mode, and the other then has to be configured for
[term passive] mode. This establishes which of the two partners
connects to whom (the [term active] to the other), or, who is waiting
on whom (the [term passive] on the other).

Note that this is completely independent of the direction of any data
transmission using the connection after it has been established.

An active node can, after establishing the connection, either transmit
or receive data. Equivalently the passive node can do the same after
the waiting for it partner has ended.

[section API]

[list_begin definitions]

[call [cmd transfer::connect] \
	[arg object] \
	[opt [arg options]...]]

This command creates and configures a new connection [arg object]. The
fully qualified name of the object command is returned as the result
of the command.

[nl]

The recognized options are listed below.

[list_begin opt]

[opt_def -mode [arg mode]]

This option specifies the mode the object is in. It is optional and
defaults to [const active] mode. The two possible modes are:

[list_begin definitions]
[lst_item [const active]]

In this mode the two options [option -host] and [option -port] are
relevant and specify the host and TCP port the object has to connect
to. The host is given by either name or IP address.

[lst_item [const passive]]

In this mode the option [option -host] has no relevance and is ignored
should it be configured.

The only option the object needs is [option -port], and it specifies
the TCP port on which the listening socket is opened to await the
connection from the partner.

[list_end]

[opt_def -host [arg hostname-or-ipaddr]]

This option specifies the host to connect to in [term active] mode,
either by name or ip-address. An object configured for [term passive]
mode ignores this option.

[opt_def -port [arg int]]

For [term active] mode this option specifies the port the object is
expected to connect to. For [term passive] mode however it is the port
where the object creates the listening socket waiting for a
connection. It defaults to [const 0], which allows the OS to choose
the actual port to listen on.

[opt_def -encoding encodingname]
[opt_def -eofchar eofspec]
[opt_def -translation transspec]

These options are the same as are recognized by the builtin command
[cmd fconfigure]. They provide the configuration to be set for the
channel between the two partners after it has been established, but
before the callback is invoked (See method [method connect]).

[list_end]


[call [arg object] [method destroy]]

This method destroys the object. 

This is safe to do for an [term active] object when a connection has
been started, as the completion callback is synchronous.

For a [term passive] object currently waiting for its parter to
establish the connection however this is not safe and will cause
errors later on, when the connection setup completes and tries to
access the now missing data structures of the destroyed object.


[call [arg object] [method connect] [arg command]]

This method starts the connection setup per the configuration of the
object. When the connection is established the callback [arg command]
will be invoked with one additional argument, the channel handle of
the socket over which data can be transfered.

[nl]

The detailed behaviour of the method depends on the configured
mode. For an [term active] object the connection setup is done
synchronously. I.e. the object will wait until the connection is
established. In that mode the method returns the empty string as its
result.

[nl]

A [term passive] object however operates asynchronously. The method
will return immediately after a listener has been set up and the
connection will be established in the background. In that mode the
method returns the port number of the listening socket, for use by the
caller, like transfering this information to the counterpart so that
it may know where to connect to.

[nl]

This is necessary as the object might have been configured for port
[const 0], allowing the OS to choose the actual port it will listen
on.

[nl]

The listening port is closed immediately when the connection was
established by the partner, to keep the time interval small within
which a third party can connect to the port too. Even so it is
recommended to use additional measures in the protocol outside of the
connect and transfer object to ensure that a connection is not used
with an unidentified/unauthorized partner.

[list_end]
[manpage_end]
