[manpage_begin otp n 1.0.0]
[see_also md4]
[see_also md5]
[see_also ripemd160]
[see_also SASL]
[see_also sha1]
[keywords hashing]
[keywords message-digest]
[keywords password]
[keywords {rfc 2289}]
[keywords security]
[moddesc   {RFC 2289 A One-Time Password System}]
[copyright {2006, Pat Thoyts <patthoyts@users.sourceforge.net>}]
[titledesc {One-Time Passwords}]
[category  {Hashes, checksums, and encryption}]
[require Tcl 8.2]
[require otp [opt 1.0.0]]
[description]
[para]

This package is an implementation in Tcl of the One-Time Password
system as described in RFC 2289 (1). This system uses message-digest
algorithms to sequentially hash a passphrase to create single-use
passwords. The resulting data is then provided to the user as either
hexadecimal digits or encoded using a dictionary of 2048 words. This
system is used by OpenBSD for secure login and can be used as a SASL
mechanism for authenticating users.

[para]

In this implementation we provide support for four algorithms that are
included in the tcllib distribution: MD5 (2), MD4 (3), RIPE-MD160 (4)
and SHA-1 (5).

[section {COMMANDS}]

[list_begin definitions]

[call [cmd "::otp::otp-md4"] [opt "[arg -hex]"] [opt "[arg -words]"] \
        [arg "-seed seed"] [arg "-count count"] [arg "data"]]

[call [cmd "::otp::otp-md5"] [opt "[arg -hex]"] [opt "[arg -words]"] \
        [arg "-seed seed"] [arg "-count count"] [arg "data"]]

[call [cmd "::otp::otp-sha1"] [opt "[arg -hex]"] [opt "[arg -words]"] \
        [arg "-seed seed"] [arg "-count count"] [arg "data"]]

[call [cmd "::otp::otp-rmd160"] [opt "[arg -hex]"] [opt "[arg -words]"] \
        [arg "-seed seed"] [arg "-count count"] [arg "data"]]

[list_end]

[section {EXAMPLES}]

[example {
% otp::otp-md5 -count 99 -seed host67821 "My Secret Pass Phrase"
(binary gibberish)
% otp::otp-md5 -words -count 99 -seed host67821 "My Secret Pass Phrase"
SOON ARAB BURG LIMB FILE WAD
% otp::otp-md5 -hex -count 99 -seed host67821 "My Secret Pass Phrase"
e249b58257c80087
}]

[section {REFERENCES}]

[list_begin enumerated]

[enum]
        Haller, N. et al., "A One-Time Password System", RFC 2289, February 1998.
	[uri http://www.rfc-editor.org/rfc/rfc2289.txt]

[enum]
       Rivest, R., "The MD5 Message-Digest Algorithm", RFC 1321, MIT and
       RSA Data Security, Inc, April 1992.
	([uri http://www.rfc-editor.org/rfc/rfc1321.txt])

[enum]
       Rivest, R., "The MD4 Message Digest Algorithm", RFC 1320, MIT,
       April 1992. ([uri http://www.rfc-editor.org/rfc/rfc1320.txt])

[enum]
        H. Dobbertin, A. Bosselaers, B. Preneel,
        "RIPEMD-160, a strengthened version of RIPEMD"
        [uri http://www.esat.kuleuven.ac.be/~cosicart/pdf/AB-9601/AB-9601.pdf]

[enum]
        "Secure Hash Standard", National Institute of Standards
        and Technology, U.S. Department Of Commerce, April 1995.
	([uri http://www.itl.nist.gov/fipspubs/fip180-1.htm])

[list_end]

[vset CATEGORY otp]
[include ../doctools2base/include/feedback.inc]
[manpage_end]
