package edu.uoregon.tau.taujava.preferences;

import edu.uoregon.tau.taujava.TaujavaPlugin;
import org.eclipse.jface.preference.*;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */


public class TauJavaPrefs
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {
	//Used to id the path to the tau selection file
	public static final String EX_PATH = "exclusionPathPreference";
//	Used to indicate if exclusion should be used
	public static final String EX_BOOLEAN = "exclusionPreference";
//	Used to indicate if the default output location should be used
	public static final String DEF_OUT = "defaultOutputRoot";
//	Used to id the path (non-default) where the tau output should be put
	public static final String USR_OUT = "outputRoot";
//	Used to id the path to the tau lib directory
	public static final String TDIR_PATH = "tauDirPathPreference";
//	Used to indicate which windows java .dll file to use
	public static final String TWIN_DLL = "tauWinDLLPreference";
//	Used to indicate if paraprof should be run on profile output
	public static final String PARA_BOOL = "runParaProf";
//	Used to indicate which tau-jdk library to use.
	public static final String TIX_LIB = "tauIxLibPref";
	
	public TauJavaPrefs() {
		super(GRID);
		setPreferenceStore(TaujavaPlugin.getDefault().getPreferenceStore());
		setDescription("Setup Tau instrumentation for Java");
		initializeDefaults();
	}
/**
 * Sets the default values of the preferences.
 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		store.setDefault(EX_BOOLEAN, false);
		store.setDefault(DEF_OUT,false);
	}
	
/**
 * Creates the field editors. Field editors are abstractions of
 * the common GUI blocks needed to manipulate various types
 * of preferences. Each field editor knows how to save and
 * restore itself.
 */

	public void createFieldEditors() {
		
		
		//addField(new FileFieldEditor(TLIB_PATH, "&Jar file containing TAU definitions:", getFieldEditorParent()));
		addField(new DirectoryFieldEditor(TDIR_PATH, 
				"&TAU Library Directory:", getFieldEditorParent()));

		addField(
				new BooleanFieldEditor(
					EX_BOOLEAN,
					"&Enable Selective Instrumentation?",
					getFieldEditorParent()));
		addField(new FileFieldEditor(EX_PATH, 
				"&Selective Instrumentation File:", getFieldEditorParent()));



		addField(new BooleanFieldEditor(DEF_OUT,"&Use Alternative TAU Output Directory?",getFieldEditorParent()));
		addField(new DirectoryFieldEditor(USR_OUT, "&Alternate TAU Output Directory:", getFieldEditorParent()));
		addField(new BooleanFieldEditor(PARA_BOOL,"&Automatically run ParaProf on profile output?",getFieldEditorParent()));
		
		//Only check for .dlls in windows
		if((System.getProperty("os.name","").toLowerCase()).indexOf("windows")!=-1)
		{
			addField(new RadioGroupFieldEditor(TWIN_DLL, 
					"&TAU Analysis Method:",1, 
					new String[][]{
					{"Profile","tau-profile.dll"},{"Callpath","tau-callpath.dll"},{"Trace","tau-trace.dll"}}, 
			getFieldEditorParent()));
		}
		else
		{
			/*addField(new RadioGroupFieldEditor(TIX_LIB, 
					"&TAU Analysis Method:",1,
					new String[][]{},
					getFieldEditorParent()));*/
		}
		
	}
	
	public void init(IWorkbench workbench) {
	}
}