/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.paraprof.LedgerDataElement;
import edu.uoregon.tau.paraprof.LedgerWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class LedgerWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ImageExport {
    private int xPanelSize = 300;
    private int yPanelSize = 400;
    private int barHeight = -1;
    private int rowHeight = -1;
    private ParaProfTrial ppTrial = null;
    private LedgerWindow window = null;
    private JPopupMenu popup = new JPopupMenu();
    private Object clickedOnObject = null;
    private Vector list = new Vector();
    private boolean widthSet = false;
    private int windowType = -1;

    public LedgerWindowPanel(ParaProfTrial paraProfTrial, LedgerWindow ledgerWindow, int n) {
        this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
        this.setBackground(Color.white);
        this.ppTrial = paraProfTrial;
        this.window = ledgerWindow;
        this.windowType = n;
        this.addMouseListener(this);
        this.setupMenus();
        this.repaint();
    }

    public void setupMenus() {
        JMenuItem jMenuItem = null;
        if (this.windowType == 1) {
            jMenuItem = new JMenuItem("Change Group Color");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem("Reset to Generic Color");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem("Show This Group Only");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem("Show All Groups Except This One");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem("Show All Groups");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.export((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.export((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            return 1;
        }
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        int n;
        this.list = this.window.getData();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.barHeight = this.ppTrial.getPreferencesWindow().getFontSize();
        Font font = ParaProf.preferencesWindow.getFont();
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        this.rowHeight = fontMetrics.getHeight();
        if (!this.widthSet) {
            int n6 = 0;
            while (n6 < this.list.size()) {
                LedgerDataElement ledgerDataElement = (LedgerDataElement)this.list.get(n6);
                if (ledgerDataElement.getName() != null && this.xPanelSize < (n = 5 + this.barHeight + fontMetrics.stringWidth(ledgerDataElement.getName()))) {
                    this.xPanelSize = n + 11;
                }
                ++n6;
            }
            this.widthSet = true;
        }
        if (this.resizePanel(fontMetrics, n4) && bl) {
            this.revalidate();
            return;
        }
        int[] nArray = ParaProfUtils.computeClipping(graphics2D.getClipBounds(), this.window.getViewRect(), bl, bl2, this.list.size(), this.rowHeight, n3);
        int n7 = nArray[0];
        n = nArray[1];
        n3 = nArray[2];
        n2 = 5;
        int n8 = n7;
        while (n8 <= n) {
            LedgerDataElement ledgerDataElement = (LedgerDataElement)this.list.get(n8);
            if (ledgerDataElement.getName() != null) {
                graphics2D.setColor(ledgerDataElement.getColor());
                graphics2D.fillRect(n2, (n3 += this.rowHeight) - this.barHeight, this.barHeight, this.barHeight);
                if (ledgerDataElement.isHighlighted(this.ppTrial)) {
                    graphics2D.setColor(ledgerDataElement.getHighlightColor(this.ppTrial.getColorChooser()));
                    graphics2D.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                    graphics2D.drawRect(n2 + 1, n3 - this.barHeight + 1, this.barHeight - 2, this.barHeight - 2);
                } else {
                    graphics2D.setColor(Color.black);
                    graphics2D.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                }
                graphics2D.setColor(Color.black);
                String string = ledgerDataElement.getName();
                graphics2D.drawString(string, n2 += this.barHeight + 10, n3);
                int n9 = 5 + this.barHeight + fontMetrics.stringWidth(string);
                if (n5 < n9) {
                    n5 = n9 + 11;
                }
                if (bl) {
                    ledgerDataElement.setDrawCoords(0, n9, n3 - this.barHeight, n3);
                }
                n2 -= this.barHeight + 10;
            }
            ++n8;
        }
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n) {
        boolean bl = false;
        int n2 = this.window.getData().size() * this.rowHeight;
        if (n2 != this.yPanelSize) {
            this.yPanelSize = n2;
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            bl = false;
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (this.clickedOnObject instanceof LedgerDataElement) {
                    LedgerDataElement ledgerDataElement = (LedgerDataElement)this.clickedOnObject;
                    if (string.equals("Change Group Color")) {
                        Color color = ledgerDataElement.getColor();
                        if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                            ledgerDataElement.setSpecificColor(color);
                            ledgerDataElement.setColorFlag(true);
                            this.ppTrial.updateRegisteredObjects("colorEvent");
                        }
                    } else if (string.equals("Reset to Generic Color")) {
                        ledgerDataElement.setColorFlag(false);
                        this.ppTrial.updateRegisteredObjects("colorEvent");
                    } else if (string.equals("Show This Group Only")) {
                        this.ppTrial.showGroupOnly(ledgerDataElement.getGroup());
                    } else if (string.equals("Show All Groups Except This One")) {
                        this.ppTrial.showAllExcept(ledgerDataElement.getGroup());
                    } else if (string.equals("Show All Groups")) {
                        this.ppTrial.setFunctionMask(null);
                        this.ppTrial.updateRegisteredObjects("dataEvent");
                    }
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            if (this.list == null) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            Enumeration enumeration = this.list.elements();
            while (enumeration.hasMoreElements()) {
                LedgerDataElement ledgerDataElement = (LedgerDataElement)enumeration.nextElement();
                if (n2 > ledgerDataElement.getYEnd()) continue;
                if (n2 >= ledgerDataElement.getYBeg() && n >= ledgerDataElement.getXBeg() && n <= ledgerDataElement.getXEnd()) {
                    if (ParaProfUtils.rightClick(mouseEvent)) {
                        this.clickedOnObject = ledgerDataElement;
                        if (this.windowType == 0 || this.windowType == 3) {
                            ParaProfUtils.createFunctionClickPopUp(this.ppTrial, ledgerDataElement.getFunction(), this.ppTrial.getDataSource().getTotalData(), this).show(this, mouseEvent.getX(), mouseEvent.getY());
                        } else if (this.windowType == 2) {
                            ParaProfUtils.handleUserEventClick(this.ppTrial, ledgerDataElement.getUserEvent(), this, mouseEvent);
                        } else {
                            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                        }
                        return;
                    }
                    if (this.windowType == 2) {
                        this.ppTrial.toggleHighlightedUserEvent(ledgerDataElement.getUserEvent());
                    } else if (this.windowType == 1) {
                        this.ppTrial.toggleHighlightedGroup(ledgerDataElement.getGroup());
                    } else {
                        this.ppTrial.toggleHighlightedFunction(ledgerDataElement.getFunction());
                    }
                    return;
                }
                return;
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        if (bl) {
            return this.getPreferredSize();
        }
        return this.window.getSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize + 10, this.yPanelSize + 10);
    }

    public void help(boolean bl) {
    }

    public Rectangle getViewRect() {
        return null;
    }
}

