/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.renderer.PolarItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtils;

public class PolarPlot
extends Plot
implements ValueAxisPlot,
RendererChangeListener,
Cloneable,
Serializable {
    private static final int MARGIN = 20;
    private static final double ANNOTATION_MARGIN = 7.0;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.gray;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private List angleTicks;
    private ValueAxis radiusAxis;
    private XYDataset dataset;
    private PolarItemRenderer renderer;
    private boolean angleLabelsVisible = true;
    private Font angleLabelFont = new Font("SansSerif", 0, 12);
    private Paint angleLabelPaint = Color.black;
    private boolean angleGridlinesVisible;
    private transient Stroke angleGridlineStroke;
    private transient Paint angleGridlinePaint;
    private boolean radiusGridlinesVisible;
    private transient Stroke radiusGridlineStroke;
    private transient Paint radiusGridlinePaint;
    private List cornerTextItems = new ArrayList();

    public PolarPlot() {
        this(null, null, null);
    }

    public PolarPlot(XYDataset dataset, ValueAxis radiusAxis, PolarItemRenderer renderer) {
        this.dataset = dataset;
        if (this.dataset != null) {
            this.dataset.addChangeListener(this);
        }
        this.angleTicks = new ArrayList();
        this.angleTicks.add(new NumberTick(new Double(0.0), "0", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(45.0), "45", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(90.0), "90", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(135.0), "135", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(180.0), "180", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(225.0), "225", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(270.0), "270", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(315.0), "315", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.radiusAxis = radiusAxis;
        if (this.radiusAxis != null) {
            this.radiusAxis.setPlot(this);
            this.radiusAxis.addChangeListener(this);
        }
        this.renderer = renderer;
        if (this.renderer != null) {
            this.renderer.setPlot(this);
            this.renderer.addChangeListener(this);
        }
        this.angleGridlinesVisible = true;
        this.angleGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.angleGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.radiusGridlinesVisible = true;
        this.radiusGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.radiusGridlinePaint = DEFAULT_GRIDLINE_PAINT;
    }

    public void addCornerTextItem(String text) {
        this.cornerTextItems.add(text);
    }

    public void removeCornerTextItem(String text) {
        this.cornerTextItems.remove(text);
    }

    public void clearCornerTextItem() {
        this.cornerTextItems.clear();
    }

    public String getPlotType() {
        return localizationResources.getString("Polar_Plot");
    }

    public ValueAxis getRadialAxis() {
        Plot parent;
        ValueAxis result = this.radiusAxis;
        if (result == null && (parent = this.getParent()) instanceof PolarPlot) {
            PolarPlot polar = (PolarPlot)parent;
            result = polar.getRadialAxis();
        }
        return result;
    }

    public void setRadialAxis(ValueAxis axis) {
        if (axis != null) {
            axis.setPlot(this);
        }
        if (this.radiusAxis != null) {
            this.radiusAxis.removeChangeListener(this);
        }
        this.radiusAxis = axis;
        if (this.radiusAxis != null) {
            this.radiusAxis.configure();
            this.radiusAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public XYDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(XYDataset dataset) {
        XYDataset existing = this.dataset;
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.dataset = dataset;
        if (this.dataset != null) {
            this.setDatasetGroup(this.dataset.getGroup());
            this.dataset.addChangeListener(this);
        }
        DatasetChangeEvent event = new DatasetChangeEvent(this, this.dataset);
        this.datasetChanged(event);
    }

    public PolarItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(PolarItemRenderer renderer) {
        if (this.renderer != null) {
            this.renderer.removeChangeListener(this);
        }
        this.renderer = renderer;
        if (this.renderer != null) {
            this.renderer.setPlot(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isAngleLabelsVisible() {
        return this.angleLabelsVisible;
    }

    public void setAngleLabelsVisible(boolean visible) {
        this.angleLabelsVisible = visible;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Font getAngleLabelFont() {
        return this.angleLabelFont;
    }

    public void setAngleLabelFont(Font font) {
        this.angleLabelFont = font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getAngleLabelPaint() {
        return this.angleLabelPaint;
    }

    public void setAngleLabelPaint(Paint paint) {
        this.angleLabelPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isAngleGridlinesVisible() {
        return this.angleGridlinesVisible;
    }

    public void setAngleGridlinesVisible(boolean visible) {
        if (this.angleGridlinesVisible != visible) {
            this.angleGridlinesVisible = visible;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getAngleGridlineStroke() {
        return this.angleGridlineStroke;
    }

    public void setAngleGridlineStroke(Stroke stroke) {
        this.angleGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getAngleGridlinePaint() {
        return this.angleGridlinePaint;
    }

    public void setAngleGridlinePaint(Paint paint) {
        this.angleGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRadiusGridlinesVisible() {
        return this.radiusGridlinesVisible;
    }

    public void setRadiusGridlinesVisible(boolean visible) {
        if (this.radiusGridlinesVisible != visible) {
            this.radiusGridlinesVisible = visible;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRadiusGridlineStroke() {
        return this.radiusGridlineStroke;
    }

    public void setRadiusGridlineStroke(Stroke stroke) {
        this.radiusGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRadiusGridlinePaint() {
        return this.radiusGridlinePaint;
    }

    public void setRadiusGridlinePaint(Paint paint) {
        this.radiusGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, PlotState parentState, PlotRenderingInfo info) {
        Insets insets;
        boolean b2;
        boolean b1 = plotArea.getWidth() <= 10.0;
        boolean bl = b2 = plotArea.getHeight() <= 10.0;
        if (b1 || b2) {
            return;
        }
        if (info != null) {
            info.setPlotArea(plotArea);
        }
        if ((insets = this.getInsets()) != null) {
            plotArea.setRect(plotArea.getX() + (double)insets.left, plotArea.getY() + (double)insets.top, plotArea.getWidth() - (double)insets.left - (double)insets.right, plotArea.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        Rectangle2D dataArea = plotArea;
        if (info != null) {
            info.setDataArea(dataArea);
        }
        this.drawBackground(g2, dataArea);
        double h = Math.min(dataArea.getWidth() / 2.0, dataArea.getHeight() / 2.0) - 20.0;
        Rectangle2D.Double quadrant = new Rectangle2D.Double(dataArea.getCenterX(), dataArea.getCenterY(), h, h);
        AxisState state = this.drawAxis(g2, plotArea, quadrant);
        if (this.renderer != null) {
            Shape originalClip = g2.getClip();
            Composite originalComposite = g2.getComposite();
            g2.clip(dataArea);
            g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
            this.drawGridlines(g2, dataArea, this.angleTicks, state.getTicks());
            this.render(g2, dataArea, info);
            g2.setClip(originalClip);
            g2.setComposite(originalComposite);
        }
        this.drawOutline(g2, dataArea);
        this.drawCornerTextItems(g2, dataArea);
    }

    public void drawCornerTextItems(Graphics2D g2, Rectangle2D area) {
        if (this.cornerTextItems.isEmpty()) {
            return;
        }
        g2.setColor(Color.black);
        double width = 0.0;
        double height = 0.0;
        Iterator it = this.cornerTextItems.iterator();
        while (it.hasNext()) {
            String msg = (String)it.next();
            FontMetrics fm = g2.getFontMetrics();
            Rectangle2D bounds = TextUtilities.getTextBounds((String)msg, (Graphics2D)g2, (FontMetrics)fm);
            width = Math.max(width, bounds.getWidth());
            height += bounds.getHeight();
        }
        double xadj = 14.0;
        double yadj = 7.0;
        double x = area.getMaxX() - (width += xadj);
        double y = area.getMaxY() - (height += yadj);
        g2.drawRect((int)x, (int)y, (int)width, (int)height);
        x += 7.0;
        Iterator it2 = this.cornerTextItems.iterator();
        while (it2.hasNext()) {
            String msg = (String)it2.next();
            Rectangle2D bounds = TextUtilities.getTextBounds((String)msg, (Graphics2D)g2, (FontMetrics)g2.getFontMetrics());
            g2.drawString(msg, (int)x, (int)(y += bounds.getHeight()));
        }
    }

    protected AxisState drawAxis(Graphics2D g2, Rectangle2D plotArea, Rectangle2D dataArea) {
        return this.radiusAxis.draw(g2, dataArea.getMinY(), plotArea, dataArea, RectangleEdge.TOP, null);
    }

    public void render(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info) {
        if (!DatasetUtilities.isEmptyOrNull(this.dataset)) {
            int seriesCount = this.dataset.getSeriesCount();
            for (int series = 0; series < seriesCount; ++series) {
                this.renderer.drawSeries(g2, dataArea, info, this, this.dataset, series);
            }
        } else {
            this.drawNoDataMessage(g2, dataArea);
        }
    }

    protected void drawGridlines(Graphics2D g2, Rectangle2D dataArea, List angularTicks, List radialTicks) {
        Paint gridPaint;
        Stroke gridStroke;
        if (this.renderer == null) {
            return;
        }
        if (this.isAngleGridlinesVisible()) {
            gridStroke = this.getAngleGridlineStroke();
            gridPaint = this.getAngleGridlinePaint();
            if (gridStroke != null && gridPaint != null) {
                this.renderer.drawAngularGridLines(g2, this, angularTicks, dataArea);
            }
        }
        if (this.isRadiusGridlinesVisible()) {
            gridStroke = this.getRadiusGridlineStroke();
            gridPaint = this.getRadiusGridlinePaint();
            if (gridStroke != null && gridPaint != null) {
                this.renderer.drawRadialGridLines(g2, this, this.radiusAxis, radialTicks, dataArea);
            }
        }
    }

    public void zoom(double percent) {
        if (percent > 0.0) {
            double radius = this.getMaxRadius();
            double scaledRadius = radius * percent;
            this.radiusAxis.setUpperBound(scaledRadius);
            this.getRadialAxis().setAutoRange(false);
        } else {
            this.getRadialAxis().setAutoRange(true);
        }
    }

    public Range getDataRange(ValueAxis axis) {
        Range result = null;
        result = Range.combine(result, DatasetUtilities.findRangeExtent(this.dataset));
        return result;
    }

    public void datasetChanged(DatasetChangeEvent event) {
        if (this.radiusAxis != null) {
            this.radiusAxis.configure();
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(event);
        } else {
            PlotChangeEvent e = new PlotChangeEvent(this);
            this.notifyListeners(e);
        }
    }

    public void rendererChanged(RendererChangeEvent event) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getSeriesCount() {
        int result = 0;
        if (this.dataset != null) {
            result = this.dataset.getSeriesCount();
        }
        return result;
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = new LegendItemCollection();
        if (this.dataset != null && this.renderer != null) {
            int seriesCount = this.dataset.getSeriesCount();
            for (int i = 0; i < seriesCount; ++i) {
                LegendItem item = this.renderer.getLegendItem(i);
                result.add(item);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (super.equals(obj) && obj instanceof PolarPlot) {
            PolarPlot p = (PolarPlot)obj;
            boolean b1 = ObjectUtils.equal((Object)this.radiusAxis, (Object)p.radiusAxis);
            boolean b2 = ObjectUtils.equal((Object)this.renderer, (Object)p.renderer);
            boolean b3 = this.angleGridlinesVisible == p.angleGridlinesVisible;
            boolean b4 = ObjectUtils.equal((Object)this.angleGridlineStroke, (Object)p.angleGridlineStroke);
            boolean b5 = ObjectUtils.equal((Object)this.angleGridlinePaint, (Object)p.angleGridlinePaint);
            boolean b6 = this.radiusGridlinesVisible == p.radiusGridlinesVisible;
            boolean b7 = ObjectUtils.equal((Object)this.radiusGridlineStroke, (Object)p.radiusGridlineStroke);
            boolean b8 = ObjectUtils.equal((Object)this.radiusGridlinePaint, (Object)p.radiusGridlinePaint);
            return b1 && b2 && b3 && b4 && b5 && b6 && b7 && b8;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        PolarPlot clone = (PolarPlot)super.clone();
        clone.radiusAxis = (ValueAxis)ObjectUtils.clone((Object)this.radiusAxis);
        if (clone.radiusAxis != null) {
            clone.radiusAxis.setPlot(clone);
            clone.radiusAxis.addChangeListener(clone);
        }
        if (clone.dataset != null) {
            clone.dataset.addChangeListener(clone);
        }
        clone.renderer = (PolarItemRenderer)ObjectUtils.clone((Object)this.renderer);
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writeStroke((Stroke)this.angleGridlineStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.angleGridlinePaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.radiusGridlineStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.radiusGridlinePaint, (ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.angleGridlineStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.angleGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.radiusGridlineStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.radiusGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        if (this.radiusAxis != null) {
            this.radiusAxis.setPlot(this);
            this.radiusAxis.addChangeListener(this);
        }
        if (this.dataset != null) {
            this.dataset.addChangeListener(this);
        }
    }

    public void zoomHorizontalAxes(double factor) {
        this.zoom(factor);
    }

    public void zoomHorizontalAxes(double lowerPercent, double upperPercent) {
        this.zoom((upperPercent + lowerPercent) / 2.0);
    }

    public void zoomVerticalAxes(double factor) {
        this.zoom(factor);
    }

    public void zoomVerticalAxes(double lowerPercent, double upperPercent) {
        this.zoom((upperPercent + lowerPercent) / 2.0);
    }

    public double getMaxRadius() {
        return this.radiusAxis.getUpperBound();
    }

    public Point translateValueThetaRadiusToJava2D(double angleDegrees, double radius, Rectangle2D dataArea) {
        double radians = Math.toRadians(angleDegrees - 90.0);
        double xv = radius * Math.cos(radians);
        double yv = radius * Math.sin(radians);
        double minx = dataArea.getMinX() + 20.0;
        double maxx = dataArea.getMaxX() - 20.0;
        double miny = dataArea.getMinY() + 20.0;
        double maxy = dataArea.getMaxY() - 20.0;
        double lengthX = maxx - minx;
        double lengthY = maxy - miny;
        double length = Math.min(lengthX, lengthY);
        double midX = minx + lengthX / 2.0;
        double midY = miny + lengthY / 2.0;
        double axisMin = -this.getMaxRadius();
        double axisMax = this.getMaxRadius();
        float x = (float)(midX + xv / (axisMax - axisMin) * length);
        float y = (float)(midY + yv / (axisMax - axisMin) * length);
        int ix = Math.round(x);
        int iy = Math.round(y);
        Point p = new Point(ix, iy);
        return p;
    }
}

