/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.GlobalMapping;
import jRacy.GlobalMappingElement;
import jRacy.SMWContext;
import jRacy.SMWServer;
import jRacy.SMWThread;
import jRacy.SMWThreadDataElement;
import jRacy.StaticMainWindowData;
import jRacy.Trial;
import jRacy.UserEventWindow;
import jRacy.jRacy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class UserEventWindowPanel
extends JPanel
implements ActionListener,
MouseListener {
    int xPanelSize = 550;
    int yPanelSize = 550;
    private Vector staticNodeList;
    private int newXPanelSize = 0;
    private int newYPanelSize = 0;
    private String counterName = null;
    private int mappingID = -1;
    private String mappingName;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int defaultBarLength = 250;
    private int maxXLength = 0;
    private int maxUserEventNumberValue = 0;
    private double maxUserEventMinValue = 0.0;
    private double maxUserEventMaxValue = 0.0;
    private double maxUserEventMeanValue = 0.0;
    private int serverNumber = -1;
    private int contextNumber = -1;
    private int threadNumber = -1;
    private UserEventWindow uEWindow = null;
    private Trial trial = null;
    private StaticMainWindowData sMWData = null;
    private SMWServer tmpSMWServer = null;
    private SMWContext tmpSMWContext = null;
    private SMWThread tmpSMWThread = null;
    private SMWThreadDataElement tmpSMWThreadDataElement = null;
    private Vector tmpContextList = null;
    private Vector tmpThreadList = null;
    private Vector tmpThreadDataElementList = null;
    private JPopupMenu popup = new JPopupMenu();

    public UserEventWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEWP01");
        }
    }

    public UserEventWindowPanel(Trial trial, int n, UserEventWindow userEventWindow) {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.trial = trial;
            this.mappingID = n;
            GlobalMapping globalMapping = this.trial.getGlobalMapping();
            GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(this.mappingID, 2);
            this.mappingName = globalMappingElement.getMappingName();
            this.uEWindow = userEventWindow;
            JMenuItem jMenuItem = new JMenuItem("Change User Event Color");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Reset to Generic Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            int n;
            String string;
            double d;
            FontMetrics fontMetrics;
            Font font;
            super.paintComponent(graphics);
            if (!this.trial.getPreferences().areBarDetailsSet()) {
                font = new Font(this.trial.getPreferences().getJRacyFont(), this.trial.getPreferences().getFontStyle(), 12);
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics(font);
                int n2 = fontMetrics.getAscent();
                int n3 = fontMetrics.getMaxDescent();
                int n4 = n2 + n3;
                this.trial.getPreferences().setBarDetails(n2, n4 + 5);
                this.trial.getPreferences().setSliders(n2, n4 + 5);
            }
            this.barSpacing = this.trial.getPreferences().getBarSpacing();
            this.barHeight = this.trial.getPreferences().getBarHeight();
            font = new Font(this.trial.getPreferences().getJRacyFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
            graphics.setFont(font);
            fontMetrics = graphics.getFontMetrics(font);
            boolean bl = false;
            int n5 = -1;
            int n6 = 0;
            int n7 = 0;
            int n8 = this.defaultBarLength + 60;
            n6 = 0;
            GlobalMapping globalMapping = this.trial.getGlobalMapping();
            GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(this.mappingID, 2);
            this.maxUserEventNumberValue = globalMappingElement.getMaxUserEventNumberValue();
            this.maxUserEventMinValue = globalMappingElement.getMaxUserEventMinValue();
            this.maxUserEventMaxValue = globalMappingElement.getMaxUserEventMaxValue();
            this.maxUserEventMeanValue = globalMappingElement.getMaxUserEventMeanValue();
            n6 += this.barSpacing;
            this.counterName = this.trial.getCounterName();
            if (this.counterName != null) {
                graphics.drawString("COUNTER NAME: " + this.counterName, 5, n6);
                n6 += this.barSpacing;
            }
            graphics.drawString("USER EVENT NAME: " + this.mappingName, 5, n6);
            n7 = fontMetrics.stringWidth(this.mappingName);
            n6 += this.barSpacing;
            if (this.uEWindow.userEventValue().equals("value")) {
                n5 = 0;
                d = this.maxUserEventNumberValue;
                string = new String(Double.toString(d));
                n = fontMetrics.stringWidth(string);
                n8 += n;
            } else if (this.uEWindow.userEventValue().equals("min")) {
                n5 = 1;
                d = this.maxUserEventMinValue;
                string = new String(Double.toString(d));
                n = fontMetrics.stringWidth(string);
                n8 += n;
            } else if (this.uEWindow.userEventValue().equals("max")) {
                n5 = 2;
                d = this.maxUserEventMaxValue;
                string = new String(Double.toString(d));
                n = fontMetrics.stringWidth(string);
                n8 += n;
            } else {
                n5 = 3;
                d = this.maxUserEventMeanValue;
                string = new String(Double.toString(d));
                n = fontMetrics.stringWidth(string);
                n8 += n;
            }
            this.serverNumber = 0;
            Enumeration enumeration = this.uEWindow.getStaticMainWindowSystemData().elements();
            while (enumeration.hasMoreElements()) {
                this.tmpSMWServer = (SMWServer)enumeration.nextElement();
                this.contextNumber = 0;
                this.tmpContextList = this.tmpSMWServer.getContextList();
                Enumeration enumeration2 = this.tmpContextList.elements();
                while (enumeration2.hasMoreElements()) {
                    this.tmpSMWContext = (SMWContext)enumeration2.nextElement();
                    this.tmpThreadList = this.tmpSMWContext.getThreadList();
                    this.threadNumber = 0;
                    Enumeration enumeration3 = this.tmpThreadList.elements();
                    while (enumeration3.hasMoreElements()) {
                        String string2 = "n,c,t   " + this.serverNumber + "," + this.contextNumber + "," + this.threadNumber;
                        this.tmpSMWThread = (SMWThread)enumeration3.nextElement();
                        this.tmpThreadDataElementList = this.tmpSMWThread.getThreadDataList();
                        Enumeration enumeration4 = this.tmpThreadDataElementList.elements();
                        while (enumeration4.hasMoreElements()) {
                            this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                            if (this.tmpSMWThreadDataElement.getMappingID() != this.mappingID) continue;
                            n6 += this.barSpacing;
                            double d2 = n5 == 0 ? (double)this.tmpSMWThreadDataElement.getUserEventNumberValue() : (n5 == 1 ? this.tmpSMWThreadDataElement.getUserEventMinValue() : (n5 == 2 ? this.tmpSMWThreadDataElement.getUserEventMaxValue() : this.tmpSMWThreadDataElement.getUserEventMeanValue()));
                            double d3 = d2 / d;
                            int n9 = (int)(d3 * (double)this.defaultBarLength);
                            if (n9 == 0) {
                                n9 = 1;
                            }
                            Color color = this.tmpSMWThreadDataElement.getUserEventMappingColor();
                            graphics.setColor(color);
                            if (n9 > 2 && this.barHeight > 2) {
                                graphics.fillRect(n8 - n9 + 1, n6 - this.barHeight + 1, n9 - 1, this.barHeight - 1);
                                if (this.mappingID == this.trial.getColorChooser().getUEHCMappingID()) {
                                    graphics.setColor(this.trial.getColorChooser().getUEHC());
                                    graphics.drawRect(n8 - n9, n6 - this.barHeight, n9, this.barHeight);
                                    graphics.drawRect(n8 - n9 + 1, n6 - this.barHeight + 1, n9 - 2, this.barHeight - 2);
                                } else {
                                    graphics.setColor(Color.black);
                                    graphics.drawRect(n8 - n9, n6 - this.barHeight, n9, this.barHeight);
                                }
                            } else {
                                if (this.mappingID == this.trial.getColorChooser().getUEHCMappingID()) {
                                    graphics.setColor(this.trial.getColorChooser().getUEHC());
                                } else {
                                    color = this.tmpSMWThreadDataElement.getMappingColor();
                                    graphics.setColor(color);
                                }
                                graphics.fillRect(n8 - n9, n6 - this.barHeight, n9, this.barHeight);
                            }
                            graphics.setColor(Color.black);
                            string = new String(Double.toString(d2));
                            n = fontMetrics.stringWidth(string);
                            int n10 = n8 - n9 - n - 5;
                            graphics.drawString(string, n10, n6);
                            string = string2;
                            graphics.drawString(string, n8 + 5, n6);
                            n = n8 + fontMetrics.stringWidth(string2) + 5;
                            if (n7 < n) {
                                n7 = n + 15;
                            }
                            this.tmpSMWThreadDataElement.setMDWDrawCoords(n10, n, n6 - this.barHeight, n6);
                        }
                        ++this.threadNumber;
                    }
                    ++this.contextNumber;
                }
                ++this.serverNumber;
            }
            boolean bl2 = false;
            if (n7 > 550) {
                this.xPanelSize = n7 + 1;
                bl2 = true;
            }
            if (n6 > 550) {
                this.yPanelSize = n6 + 1;
                bl2 = true;
            }
            if (bl2) {
                this.revalidate();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEWP03");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Change User Event Color")) {
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(this.mappingID, 2);
                    Color color = globalMappingElement.getMappingColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        globalMappingElement.setSpecificColor(color);
                        globalMappingElement.setColorFlag(true);
                        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(this.mappingID, 2);
                    globalMappingElement.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            if ((mouseEvent.getModifiers() & 0x10) == 0) {
                this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void changeInMultiples() {
        this.computeDefaultBarLength();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }

    public void computeDefaultBarLength() {
        try {
            double d = this.uEWindow.getSliderValue();
            double d2 = this.uEWindow.getSliderMultiple();
            double d3 = 250.0 * d * d2;
            this.defaultBarLength = (int)d3;
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEWP06");
        }
    }
}

