/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.GlobalMapping;
import jRacy.GlobalMappingElement;
import jRacy.StaticMainWindowData;
import jRacy.Trial;
import jRacy.UserEventWindowPanel;
import jRacy.jRacy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class UserEventWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener {
    private int mappingID = -1;
    private String mappingName = null;
    private JMenu userEventValuesMenu;
    private JMenuItem mappingGroupLedgerItem;
    private JMenuItem userEventLedgerItem;
    private ButtonGroup userEventValuesGroup = null;
    private JRadioButtonMenuItem valueButton = null;
    private JRadioButtonMenuItem minButton = null;
    private JRadioButtonMenuItem maxButton = null;
    private JRadioButtonMenuItem meanButton = null;
    private JRadioButtonMenuItem displaySlidersButton;
    private JLabel sliderMultipleLabel = new JLabel("Slider Mulitiple");
    private JComboBox sliderMultiple;
    private JLabel barLengthLabel = new JLabel("Bar Mulitiple");
    private JSlider barLengthSlider = new JSlider(0, 40, 1);
    private Container contentPane = null;
    private GridBagLayout gbl = null;
    private GridBagConstraints gbc = null;
    private JScrollPane userEventWinPanelScrollPane;
    private Trial trial = null;
    StaticMainWindowData sMWData = null;
    Vector sMWGeneralData = null;
    UserEventWindowPanel userEventWinPanelRef = null;
    private String userEventValuesString = null;

    public UserEventWindow() {
        try {
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(550, 550));
            this.setTitle("Wrong constructor used");
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEW01");
        }
    }

    public UserEventWindow(Trial trial, int n, StaticMainWindowData staticMainWindowData) {
        try {
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(550, 550));
            this.trial = trial;
            this.mappingID = n;
            this.sMWData = staticMainWindowData;
            this.userEventValuesString = "value";
            GlobalMapping globalMapping = this.trial.getGlobalMapping();
            GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 2);
            this.mappingName = globalMappingElement.getMappingName();
            this.setTitle("User Event Window: " + this.trial.getProfilePathName());
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    UserEventWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (jRacy.helpWindow.isVisible()) {
                jRacy.helpWindow.clearText();
                jRacy.helpWindow.writeText("This is the user event data window for:");
                jRacy.helpWindow.writeText(this.mappingName);
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("This window shows you this user event's statistics across all the threads.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Right click anywhere within this window to bring up a popup");
                jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                jRacy.helpWindow.writeText("for this user event.");
            }
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit Racy!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = new JMenu("Options");
            jMenu2.addMenuListener(this);
            this.userEventValuesMenu = new JMenu("User Event Values");
            this.userEventValuesGroup = new ButtonGroup();
            this.valueButton = new JRadioButtonMenuItem("Number of Events", true);
            this.valueButton.addActionListener(this);
            this.minButton = new JRadioButtonMenuItem("Min. Value", false);
            this.minButton.addActionListener(this);
            this.maxButton = new JRadioButtonMenuItem("Max. Value", false);
            this.maxButton.addActionListener(this);
            this.meanButton = new JRadioButtonMenuItem("Mean Value", false);
            this.meanButton.addActionListener(this);
            this.userEventValuesGroup.add(this.valueButton);
            this.userEventValuesGroup.add(this.minButton);
            this.userEventValuesGroup.add(this.maxButton);
            this.userEventValuesGroup.add(this.meanButton);
            this.userEventValuesMenu.add(this.valueButton);
            this.userEventValuesMenu.add(this.minButton);
            this.userEventValuesMenu.add(this.maxButton);
            this.userEventValuesMenu.add(this.meanButton);
            jMenu2.add(this.userEventValuesMenu);
            this.displaySlidersButton = new JRadioButtonMenuItem("Display Sliders", false);
            this.displaySlidersButton.addActionListener(this);
            jMenu2.add(this.displaySlidersButton);
            JMenu jMenu3 = new JMenu("Windows");
            jMenu3.addMenuListener(this);
            JMenuItem jMenuItem3 = new JMenuItem("Show Function Ledger");
            jMenuItem3.addActionListener(this);
            jMenu3.add(jMenuItem3);
            this.mappingGroupLedgerItem = new JMenuItem("Show Group Ledger");
            this.mappingGroupLedgerItem.addActionListener(this);
            jMenu3.add(this.mappingGroupLedgerItem);
            this.userEventLedgerItem = new JMenuItem("Show User Event Ledger");
            this.userEventLedgerItem.addActionListener(this);
            jMenu3.add(this.userEventLedgerItem);
            JMenuItem jMenuItem4 = new JMenuItem("Close All Sub-Windows");
            jMenuItem4.addActionListener(this);
            jMenu3.add(jMenuItem4);
            JMenu jMenu4 = new JMenu("Help");
            JMenuItem jMenuItem5 = new JMenuItem("About Racy");
            jMenuItem5.addActionListener(this);
            jMenu4.add(jMenuItem5);
            JMenuItem jMenuItem6 = new JMenuItem("Show Help Window");
            jMenuItem6.addActionListener(this);
            jMenu4.add(jMenuItem6);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu3);
            jMenuBar.add(jMenu4);
            this.setJMenuBar(jMenuBar);
            this.contentPane = this.getContentPane();
            this.gbl = new GridBagLayout();
            this.contentPane.setLayout(this.gbl);
            this.gbc = new GridBagConstraints();
            this.gbc.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.userEventWinPanelRef = new UserEventWindowPanel(this.trial, n, this);
            this.userEventWinPanelScrollPane = new JScrollPane(this.userEventWinPanelRef);
            this.userEventWinPanelScrollPane.setBorder(border);
            this.userEventWinPanelScrollPane.setPreferredSize(new Dimension(500, 450));
            String[] stringArray = new String[]{"1.00", "0.75", "0.50", "0.25", "0.10"};
            this.sliderMultiple = new JComboBox<String>(stringArray);
            this.sliderMultiple.addActionListener(this);
            this.barLengthSlider.setPaintTicks(true);
            this.barLengthSlider.setMajorTickSpacing(5);
            this.barLengthSlider.setMinorTickSpacing(1);
            this.barLengthSlider.setPaintLabels(true);
            this.barLengthSlider.setSnapToTicks(true);
            this.barLengthSlider.addChangeListener(this);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.userEventWinPanelScrollPane, this.gbc, 0, 0, 1, 1);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit Racy!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("Number of Events")) {
                    if (this.valueButton.isSelected()) {
                        this.userEventValuesString = "value";
                        this.userEventWinPanelRef.repaint();
                    }
                } else if (string.equals("Min. Value")) {
                    if (this.minButton.isSelected()) {
                        this.userEventValuesString = "min";
                        this.userEventWinPanelRef.repaint();
                    }
                } else if (string.equals("Max. Value")) {
                    if (this.maxButton.isSelected()) {
                        this.userEventValuesString = "max";
                        this.userEventWinPanelRef.repaint();
                    }
                } else if (string.equals("Mean Value")) {
                    if (this.meanButton.isSelected()) {
                        this.userEventValuesString = "mean";
                        this.userEventWinPanelRef.repaint();
                    }
                } else if (string.equals("Display Sliders")) {
                    if (this.displaySlidersButton.isSelected()) {
                        this.displaySiders(true);
                    } else {
                        this.displaySiders(false);
                    }
                } else if (string.equals("Show Function Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(0);
                } else if (string.equals("Show Group Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(1);
                } else if (string.equals("Show User Event Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(2);
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About Racy")) {
                    JOptionPane.showMessageDialog(this, jRacy.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    jRacy.helpWindow.clearText();
                    jRacy.helpWindow.show();
                    jRacy.helpWindow.writeText("This is the user event data window for:");
                    jRacy.helpWindow.writeText(this.mappingName);
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("This window shows you this user event's statistics across all the threads.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Right click anywhere within this window to bring up a popup");
                    jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                    jRacy.helpWindow.writeText("for this user event.");
                }
            } else if (object == this.sliderMultiple) {
                this.userEventWinPanelRef.changeInMultiples();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEW03");
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.userEventWinPanelRef.changeInMultiples();
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.trial.groupNamesPresent()) {
                this.mappingGroupLedgerItem.setEnabled(true);
            } else {
                this.mappingGroupLedgerItem.setEnabled(false);
            }
            if (this.trial.userEventsPresent()) {
                this.userEventLedgerItem.setEnabled(true);
            } else {
                this.userEventLedgerItem.setEnabled(false);
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEW04");
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.userEventWinPanelRef.repaint();
            } else if (string.equals("colorEvent")) {
                this.userEventWinPanelRef.repaint();
            } else if (string.equals("dataSetChangeEvent")) {
                this.sMWGeneralData = null;
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEW05");
        }
    }

    public Vector getStaticMainWindowSystemData() {
        try {
            if (this.sMWGeneralData == null) {
                this.sMWGeneralData = this.sMWData.getSMWUserEventData(this.mappingID);
                return this.sMWGeneralData;
            }
            return this.sMWGeneralData;
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW06");
            return null;
        }
    }

    public String userEventValue() {
        return this.userEventValuesString;
    }

    public int getSliderValue() {
        int n = -1;
        try {
            n = this.barLengthSlider.getValue();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEW07");
        }
        return n;
    }

    public double getSliderMultiple() {
        String string = null;
        try {
            string = (String)this.sliderMultiple.getSelectedItem();
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEW08");
            return 0.0;
        }
    }

    private void displaySiders(boolean bl) {
        if (bl) {
            this.contentPane.remove(this.userEventWinPanelScrollPane);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultipleLabel, this.gbc, 0, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultiple, this.gbc, 1, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, this.gbc, 2, 0, 1, 1);
            this.gbc.fill = 2;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.7;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, this.gbc, 3, 0, 1, 1);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.userEventWinPanelScrollPane, this.gbc, 0, 1, 4, 1);
        } else {
            this.contentPane.remove(this.sliderMultipleLabel);
            this.contentPane.remove(this.sliderMultiple);
            this.contentPane.remove(this.barLengthLabel);
            this.contentPane.remove(this.barLengthSlider);
            this.contentPane.remove(this.userEventWinPanelScrollPane);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.userEventWinPanelScrollPane, this.gbc, 0, 0, 1, 1);
        }
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEW09");
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (jRacy.debugIsOn) {
                System.out.println("------------------------");
                System.out.println("A funtion window for: \"" + this.mappingName + "\" is closing");
                System.out.println("Clearing resourses for that window.");
            }
            ((Component)this).setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "UEW10");
        }
    }
}

