/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.StaticMainWindowData;
import jRacy.StaticMainWindowPanel;
import jRacy.Trial;
import jRacy.jRacy;
import jRacy.jRacyManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class StaticMainWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener {
    Trial trial = null;
    JFileChooser fileChooser = new JFileChooser();
    private StaticMainWindowPanel sMWPanel;
    private StaticMainWindowData sMWData;
    private ButtonGroup sortGroup;
    private ButtonGroup sortOrderGroup;
    private JRadioButtonMenuItem mappingIDButton;
    private JRadioButtonMenuItem nameButton;
    private JRadioButtonMenuItem millisecondButton;
    private JRadioButtonMenuItem ascendingButton;
    private JRadioButtonMenuItem descendingButton;
    private JRadioButtonMenuItem displaySlidersButton;
    private JMenuItem mappingGroupLedgerItem;
    private JMenuItem userEventLedgerItem;
    private JLabel sliderMultipleLabel = new JLabel("Slider Mulitiple");
    private JComboBox sliderMultiple;
    private JLabel barLengthLabel = new JLabel("Bar Mulitiple");
    private JSlider barLengthSlider = new JSlider(0, 40, 1);
    private Container contentPane = null;
    private GridBagLayout gbl = null;
    private GridBagConstraints gbc = null;
    private JScrollPane scrollPane;
    boolean sortByMappingID = false;
    boolean sortByName = false;
    boolean sortByMillisecond = true;
    boolean descendingOrder = true;
    boolean displaySliders = false;
    private Vector currentSMWGeneralData = null;
    private Vector currentSMWMeanData = null;
    private boolean mShown = false;

    public StaticMainWindow(Trial trial) {
        try {
            this.trial = trial;
            this.setTitle("jRacy Main Window: " + this.trial.getProfilePathName());
            int n = 750;
            int n2 = 400;
            ((Component)this).setSize(new Dimension(n, n2));
            this.sMWData = new StaticMainWindowData(this.trial);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    StaticMainWindow.this.thisWindowClosing(windowEvent);
                }
            });
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            int n3 = dimension.height;
            int n4 = dimension.width;
            int n5 = (n4 - n) / 2;
            int n6 = (n3 - n2) / 2;
            ((Component)this).setLocation(n5, n6);
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenu jMenu2 = new JMenu("Open ...");
            JMenuItem jMenuItem = new JMenuItem("jRacy Manager");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenu.add(jMenu2);
            JMenu jMenu3 = new JMenu("Save ...");
            JMenuItem jMenuItem2 = new JMenuItem("jRacy Preferrences");
            jMenuItem2.addActionListener(this);
            jMenu3.add(jMenuItem2);
            jMenu.add(jMenu3);
            JMenuItem jMenuItem3 = new JMenuItem("Edit jRacy Preferences!");
            jMenuItem3.addActionListener(this);
            jMenu.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem("Exit jRacy!");
            jMenuItem4.addActionListener(this);
            jMenu.add(jMenuItem4);
            JMenu jMenu4 = new JMenu("Options");
            JMenu jMenu5 = new JMenu("Sort by ...");
            this.sortGroup = new ButtonGroup();
            this.mappingIDButton = new JRadioButtonMenuItem("function ID", false);
            this.mappingIDButton.addActionListener(this);
            this.nameButton = new JRadioButtonMenuItem("name", false);
            this.nameButton.addActionListener(this);
            this.millisecondButton = new JRadioButtonMenuItem("millisecond", true);
            this.millisecondButton.addActionListener(this);
            this.sortGroup.add(this.mappingIDButton);
            this.sortGroup.add(this.nameButton);
            this.sortGroup.add(this.millisecondButton);
            jMenu5.add(this.mappingIDButton);
            jMenu5.add(this.nameButton);
            jMenu5.add(this.millisecondButton);
            jMenu4.add(jMenu5);
            JMenu jMenu6 = new JMenu("Sort Order");
            this.sortOrderGroup = new ButtonGroup();
            this.ascendingButton = new JRadioButtonMenuItem("Ascending", false);
            this.ascendingButton.addActionListener(this);
            this.descendingButton = new JRadioButtonMenuItem("Descending", true);
            this.descendingButton.addActionListener(this);
            this.sortOrderGroup.add(this.ascendingButton);
            this.sortOrderGroup.add(this.descendingButton);
            jMenu6.add(this.ascendingButton);
            jMenu6.add(this.descendingButton);
            jMenu4.add(jMenu6);
            this.displaySlidersButton = new JRadioButtonMenuItem("Display Sliders", false);
            this.displaySlidersButton.addActionListener(this);
            jMenu4.add(this.displaySlidersButton);
            JMenu jMenu7 = new JMenu("Windows");
            jMenu7.addMenuListener(this);
            JMenuItem jMenuItem5 = new JMenuItem("Show Function Ledger");
            jMenuItem5.addActionListener(this);
            jMenu7.add(jMenuItem5);
            this.mappingGroupLedgerItem = new JMenuItem("Show Group Ledger");
            this.mappingGroupLedgerItem.addActionListener(this);
            jMenu7.add(this.mappingGroupLedgerItem);
            this.userEventLedgerItem = new JMenuItem("Show User Event Ledger");
            this.userEventLedgerItem.addActionListener(this);
            jMenu7.add(this.userEventLedgerItem);
            JMenuItem jMenuItem6 = new JMenuItem("Close All Sub-Windows");
            jMenuItem6.addActionListener(this);
            jMenu7.add(jMenuItem6);
            JMenu jMenu8 = new JMenu("Help");
            JMenuItem jMenuItem7 = new JMenuItem("Show Help Window");
            jMenuItem7.addActionListener(this);
            jMenu8.add(jMenuItem7);
            JMenuItem jMenuItem8 = new JMenuItem("About Racy");
            jMenuItem8.addActionListener(this);
            jMenu8.add(jMenuItem8);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu4);
            jMenuBar.add(jMenu7);
            jMenuBar.add(jMenu8);
            this.setJMenuBar(jMenuBar);
            this.contentPane = this.getContentPane();
            this.gbl = new GridBagLayout();
            this.contentPane.setLayout(this.gbl);
            this.gbc = new GridBagConstraints();
            this.gbc.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.sMWPanel = new StaticMainWindowPanel(this.trial, this);
            this.sMWPanel.setPreferredSize(new Dimension(600, 300));
            this.scrollPane = new JScrollPane(this.sMWPanel);
            this.scrollPane.setBorder(border);
            this.scrollPane.setPreferredSize(new Dimension(600, 300));
            String[] stringArray = new String[]{"1.00", "0.75", "0.50", "0.25", "0.10"};
            this.sliderMultiple = new JComboBox<String>(stringArray);
            this.sliderMultiple.addActionListener(this);
            this.barLengthSlider.setPaintTicks(true);
            this.barLengthSlider.setMajorTickSpacing(5);
            this.barLengthSlider.setMinorTickSpacing(1);
            this.barLengthSlider.setPaintLabels(true);
            this.barLengthSlider.setSnapToTicks(true);
            this.barLengthSlider.addChangeListener(this);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 1.0;
            this.addCompItem(this.scrollPane, this.gbc, 0, 0, 1, 1);
            this.sMWData.buildStaticMainWindowDataLists();
            this.sortLocalData();
            this.sMWPanel.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "SMW01");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (!string.equals("Pprof Dump File") && !string.equals("jRacy Output File")) {
                    if (string.equals("jRacy Manager")) {
                        jRacyManager jRacyManager2 = new jRacyManager();
                        jRacyManager2.show();
                    } else if (!string.equals("To A jRacy Output File") && !string.equals("jRacy Preferrences")) {
                        if (string.equals("Edit jRacy Preferences!")) {
                            this.trial.getPreferences().showPreferencesWindow();
                        } else if (string.equals("Exit jRacy!")) {
                            ((Component)this).setVisible(false);
                            this.dispose();
                            System.exit(0);
                        } else if (string.equals("function ID")) {
                            if (this.mappingIDButton.isSelected()) {
                                this.sortByMappingID = true;
                                this.sortByName = false;
                                this.sortByMillisecond = false;
                                this.sortLocalData();
                                this.sMWPanel.repaint();
                            }
                        } else if (string.equals("name")) {
                            if (this.nameButton.isSelected()) {
                                this.sortByMappingID = false;
                                this.sortByName = true;
                                this.sortByMillisecond = false;
                                this.sortLocalData();
                                this.sMWPanel.repaint();
                            }
                        } else if (string.equals("millisecond")) {
                            if (this.millisecondButton.isSelected()) {
                                this.sortByMappingID = false;
                                this.sortByName = false;
                                this.sortByMillisecond = true;
                                this.sortLocalData();
                                this.sMWPanel.repaint();
                            }
                        } else if (string.equals("Descending")) {
                            if (this.descendingButton.isSelected()) {
                                this.descendingOrder = true;
                                this.sortLocalData();
                                this.sMWPanel.repaint();
                            }
                        } else if (string.equals("Ascending")) {
                            if (this.ascendingButton.isSelected()) {
                                this.descendingOrder = false;
                                this.sortLocalData();
                                this.sMWPanel.repaint();
                            }
                        } else if (string.equals("Display Sliders")) {
                            if (this.displaySlidersButton.isSelected()) {
                                this.displaySiders(true);
                            } else {
                                this.displaySiders(false);
                            }
                        } else if (string.equals("Show Function Ledger")) {
                            if (this.sMWData.isDataLoaded()) {
                                this.trial.getGlobalMapping().displayMappingLedger(0);
                            } else {
                                JOptionPane.showMessageDialog(this, "Sorry, but you must load a pprof data file first!", "Selection Error!", 0);
                            }
                        } else if (string.equals("Show Group Ledger")) {
                            if (this.sMWData.isDataLoaded()) {
                                this.trial.getGlobalMapping().displayMappingLedger(1);
                            } else {
                                JOptionPane.showMessageDialog(this, "Sorry, but you must load a pprof data file first!", "Selection Error!", 0);
                            }
                        } else if (string.equals("Show User Event Ledger")) {
                            if (this.sMWData.isDataLoaded()) {
                                this.trial.getGlobalMapping().displayMappingLedger(2);
                            } else {
                                JOptionPane.showMessageDialog(this, "Sorry, but you must load a pprof data file first!", "Selection Error!", 0);
                            }
                        } else if (string.equals("Close All Sub-Windows")) {
                            this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                        } else if (string.equals("About Racy")) {
                            JOptionPane.showMessageDialog(this, jRacy.getInfoString());
                        } else if (string.equals("Show Help Window")) {
                            jRacy.helpWindow.show();
                            if (!this.sMWData.isDataLoaded()) {
                                jRacy.helpWindow.writeText("Welcome to jRacy");
                                jRacy.helpWindow.writeText("");
                                jRacy.helpWindow.writeText("The first step is to load a pprof dump file.You can find this option in the file menu.");
                                jRacy.helpWindow.writeText("");
                                jRacy.helpWindow.writeText("To create a pprof dump file, simply run pprof with the -d option, and pipe the output to a file.");
                            }
                        }
                    }
                }
            } else if (object == this.sliderMultiple) {
                this.sMWPanel.changeInMultiples();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "SMW02");
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.trial.groupNamesPresent()) {
                this.mappingGroupLedgerItem.setEnabled(true);
            } else {
                this.mappingGroupLedgerItem.setEnabled(false);
            }
            if (this.trial.userEventsPresent()) {
                this.userEventLedgerItem.setEnabled(true);
            } else {
                this.userEventLedgerItem.setEnabled(false);
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "SMW03");
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.sMWPanel.changeInMultiples();
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.sMWPanel.repaint();
            } else if (string.equals("colorEvent")) {
                this.sMWPanel.repaint();
            } else if (string.equals("dataEvent")) {
                this.sortLocalData();
                this.sMWPanel.repaint();
            } else if (string.equals("dataSetChangeEvent")) {
                this.currentSMWGeneralData = null;
                this.currentSMWMeanData = null;
                this.sortLocalData();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "SMW04");
        }
    }

    public int getSliderValue() {
        int n = -1;
        try {
            n = this.barLengthSlider.getValue();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "SMW05");
        }
        return n;
    }

    public double getSliderMultiple() {
        String string = null;
        try {
            string = (String)this.sliderMultiple.getSelectedItem();
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "SMW06");
            return 0.0;
        }
    }

    private void displaySiders(boolean bl) {
        if (bl) {
            this.contentPane.remove(this.scrollPane);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultipleLabel, this.gbc, 0, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultiple, this.gbc, 1, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, this.gbc, 2, 0, 1, 1);
            this.gbc.fill = 2;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.7;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, this.gbc, 3, 0, 1, 1);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 0.99;
            this.addCompItem(this.scrollPane, this.gbc, 0, 1, 4, 1);
        } else {
            this.contentPane.remove(this.sliderMultipleLabel);
            this.contentPane.remove(this.sliderMultiple);
            this.contentPane.remove(this.barLengthLabel);
            this.contentPane.remove(this.barLengthSlider);
            this.contentPane.remove(this.scrollPane);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 1.0;
            this.addCompItem(this.scrollPane, this.gbc, 0, 0, 1, 1);
        }
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.contentPane.add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "SMW07");
        }
    }

    public StaticMainWindowData getSMWData() {
        return this.sMWData;
    }

    private void sortLocalData() {
        try {
            if (this.sortByMappingID) {
                this.currentSMWGeneralData = this.descendingOrder ? this.sMWData.getSMWGeneralData("FIdDE") : this.sMWData.getSMWGeneralData("FIdAE");
            } else if (this.sortByName) {
                this.currentSMWGeneralData = this.descendingOrder ? this.sMWData.getSMWGeneralData("NDE") : this.sMWData.getSMWGeneralData("NAE");
            } else if (this.sortByMillisecond) {
                this.currentSMWGeneralData = this.descendingOrder ? this.sMWData.getSMWGeneralData("MDE") : this.sMWData.getSMWGeneralData("MAE");
            }
            if (this.sortByMappingID) {
                this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("FIdDE") : this.sMWData.getSMWMeanData("FIdAE");
            } else if (this.sortByName) {
                this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("NDE") : this.sMWData.getSMWMeanData("NAE");
            } else if (this.sortByMillisecond) {
                this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("MDE") : this.sMWData.getSMWMeanData("MAE");
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "SMW08");
        }
    }

    public Vector getSMWGeneralData() {
        return this.currentSMWGeneralData;
    }

    public Vector getSMWMeanData() {
        return this.currentSMWMeanData;
    }

    public boolean isDataLoaded() {
        try {
            return this.sMWData.isDataLoaded();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "SMW09");
            return false;
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            ((Component)this).setSize(dimension);
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
        System.exit(0);
    }
}

