/*
 * Decompiled with CFR 0.152.
 */
package perfdb.util.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import perfdb.ConnectionManager;

public class Output {
    ResultSet result;

    public Output(ResultSet result) {
        this.result = result;
    }

    public void displayResult(int column) {
        try {
            String dataRow = "";
            String columnName = "";
            int i = 1;
            while (i <= column) {
                columnName = columnName + this.result.getMetaData().getColumnName(i);
                if (i < column) {
                    columnName = columnName + " | ";
                }
                ++i;
            }
            System.out.println(columnName);
            while (this.result.next()) {
                int i2 = 1;
                while (i2 <= column) {
                    dataRow = dataRow + this.result.getString(i2);
                    if (i2 < column) {
                        dataRow = dataRow + " | ";
                    }
                    ++i2;
                }
                System.out.println(dataRow);
                dataRow = "";
            }
        }
        catch (Exception e) {
            System.out.println("Cannot display the result");
            System.out.println(e.getMessage());
            return;
        }
    }

    public void displayResult() {
        try {
            int column = this.result.getMetaData().getColumnCount();
            this.displayResult(column);
        }
        catch (Exception e) {
            System.out.println("Cannot display the result");
            System.out.println(e.getMessage());
            return;
        }
    }

    public void writeToFile(String filename, int column) {
        File writeFile = new File(filename.trim());
        if (!writeFile.exists()) {
            try {
                if (writeFile.createNewFile()) {
                    System.out.println("Create " + filename + " !");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            BufferedWriter xwriter = new BufferedWriter(new FileWriter(writeFile));
            this.writeColumnName(xwriter, column);
            this.writeBody(xwriter, column);
            xwriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeToFile(String filename) {
        try {
            int column = this.result.getMetaData().getColumnCount();
            this.writeToFile(filename, column);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeColumnName(BufferedWriter xwriter, int column) {
        try {
            String columnName = "";
            int i = 1;
            while (i <= column) {
                columnName = columnName + this.result.getMetaData().getColumnName(i);
                if (i < column) {
                    columnName = columnName + "\t";
                }
                ++i;
            }
            xwriter.write(columnName);
            xwriter.newLine();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeBody(BufferedWriter xwriter, int column) {
        try {
            String dataRow = "";
            while (this.result.next()) {
                int i = 1;
                while (i <= column) {
                    dataRow = dataRow + this.result.getString(i);
                    if (i < column) {
                        dataRow = dataRow + "\t";
                    }
                    ++i;
                }
                xwriter.write(dataRow);
                xwriter.newLine();
                dataRow = "";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void appendToTable(ConnectionManager connector, String tblName) {
        File tempFile = new File("save.tmp");
        if (!tempFile.exists()) {
            try {
                if (tempFile.createNewFile()) {
                    System.out.println("Create save.tmp !");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            BufferedWriter xwriter = new BufferedWriter(new FileWriter(tempFile));
            this.writeBody(xwriter, this.result.getMetaData().getColumnCount());
            xwriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("copy ");
        buf.append(tblName);
        buf.append(" from ");
        buf.append("'" + tempFile.getAbsolutePath() + "';");
        try {
            connector.getDB().executeUpdate(buf.toString());
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        tempFile.delete();
    }
}

