/*
 * Decompiled with CFR 0.152.
 */
package perfdb.loadxml;

import jargs.gnu.CmdLineParser;
import perfdb.ConnectionManager;
import perfdb.loadxml.Load;
import perfdb.util.dbinterface.DB;

public class LoadSchema {
    private Load load = null;
    private DB db = null;
    private static String SCHEMA_USAGE = "USAGE: perfdb_loadschema [{-h,--help}] [{-s,--schemafile} filename]\n";
    private ConnectionManager connector;

    public LoadSchema(String configFileName) {
        this.connector = new ConnectionManager(configFileName);
    }

    public ConnectionManager getConnector() {
        return this.connector;
    }

    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option configfileOpt = parser.addStringOption('g', "configfile");
        CmdLineParser.Option schemafileOpt = parser.addStringOption('s', "schemafile");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            System.err.println(SCHEMA_USAGE);
            System.exit(-1);
        }
        Boolean help = (Boolean)parser.getOptionValue(helpOpt);
        String configFile = (String)parser.getOptionValue(configfileOpt);
        String schemaFile = (String)parser.getOptionValue(schemafileOpt);
        if (help != null && help.booleanValue()) {
            System.err.println(SCHEMA_USAGE);
            System.exit(-1);
        }
        if (configFile == null) {
            System.err.println("Please enter a valid config file.");
            System.err.println(SCHEMA_USAGE);
            System.exit(-1);
        }
        if (schemaFile == null) {
            System.err.println("Please enter a valid schema file.");
            System.err.println(SCHEMA_USAGE);
            System.exit(-1);
        }
        LoadSchema loadSchema = new LoadSchema(configFile);
        loadSchema.getConnector().connect();
        int exitval = 0;
        loadSchema.getConnector().genParentSchema(schemaFile);
        loadSchema.getConnector().dbclose();
        System.exit(exitval);
    }
}

