/*
 * Decompiled with CFR 0.152.
 */
package perfdb.loadxml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import perfdb.util.dbinterface.DB;

public class LoadHandler
extends DefaultHandler {
    protected String TRIAL_TABLE = "trial";
    protected String XMLFILE_TABLE = "xml_file";
    protected String FUN_TABLE = "function";
    protected String TOTAL_TABLE = "interval_total_summary";
    protected String MEAN_TABLE = "interval_mean_summary";
    protected String INTER_LOC_TABLE = "interval_location_profile";
    protected String UE_TABLE = "user_event";
    protected String ATOMIC_LOC_TABLE = "atomic_location_profile";
    protected int funIndexCounter;
    protected int funTotalCounter;
    protected int funMeanCounter;
    protected int ueIndexCounter;
    protected int interLocCounter;
    protected int atomicLocCounter;
    protected String appid = "";
    protected String expid = "";
    protected String probsize = "";
    protected String trialName = "";
    protected String userData = "";
    protected String problemString = "";
    protected String currentElement = "";
    protected String documentName = "";
    protected String documentId = "";
    protected String metricStr = "";
    protected String metricId = "";
    protected String trialId = "";
    protected String trialTime = "";
    protected boolean newTrial = false;
    protected int funAmt;
    protected int ueAmt;
    protected String nodenum = "";
    protected String contextpnode = "";
    protected String threadpcontext = "";
    protected String nodeid = "";
    protected String threadid = "";
    protected String contextid = "";
    protected String funid = "";
    protected String funname = "";
    protected String fungroup = "";
    protected String funIndex = "";
    protected String locid = "";
    protected String inclperc = "";
    protected String incl = "";
    protected String exclperc = "";
    protected String excl = "";
    protected String callnum = "";
    protected String subrs = "";
    protected String inclpcall = "";
    protected String uename = "";
    protected String ueid = "";
    protected String uegroup = "UE";
    protected String numofsamples = "";
    protected String maxvalue = "";
    protected String minvalue = "";
    protected String meanvalue = "";
    protected String standardDeviation = "";
    private DB dbconnector;
    private String[] funArray;
    private String[] ueArray;
    private File ueTempFile;
    private BufferedWriter uewriter;
    private File funTempFile;
    private BufferedWriter fwriter;
    private File interLocTempFile;
    private BufferedWriter ilwriter;
    private File atomicLocTempFile;
    private BufferedWriter alwriter;
    private File totalTempFile;
    private BufferedWriter twriter;
    private File meanTempFile;
    private BufferedWriter mwriter;

    public LoadHandler(DB db, String trialId, String problemString) {
        this.dbconnector = db;
        this.trialId = trialId;
        this.problemString = problemString;
        try {
            this.atomicLocTempFile = new File("atomicLoc.tmp");
            this.atomicLocTempFile.createNewFile();
            this.alwriter = new BufferedWriter(new FileWriter(this.atomicLocTempFile));
            this.ueTempFile = new File("ue.tmp");
            this.ueTempFile.createNewFile();
            this.uewriter = new BufferedWriter(new FileWriter(this.ueTempFile));
            this.funTempFile = new File("fun.tmp");
            this.funTempFile.createNewFile();
            this.fwriter = new BufferedWriter(new FileWriter(this.funTempFile));
            this.interLocTempFile = new File("interLoc.tmp");
            this.interLocTempFile.createNewFile();
            this.ilwriter = new BufferedWriter(new FileWriter(this.interLocTempFile));
            this.totalTempFile = new File("total.tmp");
            this.totalTempFile.createNewFile();
            this.twriter = new BufferedWriter(new FileWriter(this.totalTempFile));
            this.meanTempFile = new File("mean.tmp");
            this.meanTempFile.createNewFile();
            this.mwriter = new BufferedWriter(new FileWriter(this.meanTempFile));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("select max(id) from function;");
        String tempStr = this.getDB().getDataItem(buf.toString());
        this.funIndexCounter = tempStr == null ? 0 : Integer.parseInt(tempStr);
        buf.delete(0, buf.toString().length());
        buf.append("select max(id) from interval_total_summary;");
        tempStr = this.getDB().getDataItem(buf.toString());
        this.funTotalCounter = tempStr == null ? 0 : Integer.parseInt(tempStr);
        buf.delete(0, buf.toString().length());
        buf.append("select max(id) from interval_mean_summary;");
        tempStr = this.getDB().getDataItem(buf.toString());
        this.funMeanCounter = tempStr == null ? 0 : Integer.parseInt(tempStr);
        buf.delete(0, buf.toString().length());
        buf.append("select max(id) from user_event;");
        tempStr = this.getDB().getDataItem(buf.toString());
        this.ueIndexCounter = tempStr == null ? 0 : Integer.parseInt(tempStr);
        buf.delete(0, buf.toString().length());
        buf.append("select max(id) from interval_location_profile;");
        tempStr = this.getDB().getDataItem(buf.toString());
        this.interLocCounter = tempStr == null ? 0 : Integer.parseInt(tempStr);
        buf.delete(0, buf.toString().length());
        buf.append("select max(id) from atomic_location_profile;");
        tempStr = this.getDB().getDataItem(buf.toString());
        this.atomicLocCounter = tempStr == null ? 0 : Integer.parseInt(tempStr);
    }

    public String getTrialTable() {
        return this.TRIAL_TABLE;
    }

    public String getFunTable() {
        return this.FUN_TABLE;
    }

    public String getInterLocTable() {
        return this.INTER_LOC_TABLE;
    }

    public String getUETable() {
        return this.UE_TABLE;
    }

    public String getAtomicLocTable() {
        return this.ATOMIC_LOC_TABLE;
    }

    public String getTotalTable() {
        return this.TOTAL_TABLE;
    }

    public String getMeanTable() {
        return this.MEAN_TABLE;
    }

    public DB getDB() {
        return this.dbconnector;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getTrialId() {
        return this.trialId;
    }

    public String getDocumentName() {
        if (this.documentName == null) {
            this.setDocumentName("NoName" + this.getDocumentId());
        }
        return this.documentName;
    }

    public void setDocumentName(String newValue) {
        this.documentName = newValue;
    }

    public void startDocument() throws SAXException {
        StringBuffer buf = new StringBuffer();
        buf.append("insert into ");
        buf.append(this.XMLFILE_TABLE);
        buf.append(" (trial, metric, name)");
        buf.append(" values ");
        File ff = new File(this.getDocumentName());
        String filename = ff.getAbsolutePath();
        buf.append("(0, 0, '" + filename + "'); ");
        try {
            this.getDB().executeUpdate(buf.toString());
            buf.delete(0, buf.toString().length());
            if (this.getDB().getDBType().compareTo("mysql") == 0) {
                buf.append("select LAST_INSERT_ID();");
            } else {
                buf.append("select currval('xml_file_id_seq');");
            }
            this.documentId = this.getDB().getDataItem(buf.toString());
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public String metricAttrToString(Attributes attrList) {
        StringBuffer buf = new StringBuffer();
        int length = attrList.getLength();
        int i = 0;
        while (i < length) {
            buf.append(attrList.getValue(i));
            ++i;
        }
        return buf.toString();
    }

    public void startElement(String url, String name, String qname, Attributes attrList) throws SAXException {
        if (name.equalsIgnoreCase("Trials")) {
            this.currentElement = "Trials";
        } else if (name.equalsIgnoreCase("Onetrial")) {
            this.currentElement = "Onetrial";
            this.metricStr = this.metricAttrToString(attrList);
        } else if (name.equalsIgnoreCase("ComputationModel")) {
            this.currentElement = "ComputationModel";
        } else if (name.equalsIgnoreCase("AppID")) {
            this.currentElement = "AppID";
        } else if (name.equalsIgnoreCase("ExpID")) {
            this.currentElement = "ExpID";
        } else if (name.equalsIgnoreCase("ProblemSize")) {
            this.currentElement = "ProblemSize";
        } else if (name.equalsIgnoreCase("FunAmt")) {
            this.currentElement = "FunAmt";
        } else if (name.equalsIgnoreCase("UserEventAmt")) {
            this.currentElement = "UEAmt";
        } else if (name.equalsIgnoreCase("Trialtime")) {
            this.currentElement = "Trialtime";
        } else if (name.equalsIgnoreCase("TrialName")) {
            this.currentElement = "TrialName";
        } else if (name.equalsIgnoreCase("node")) {
            this.currentElement = "node";
        } else if (name.equalsIgnoreCase("context")) {
            this.currentElement = "context";
        } else if (name.equalsIgnoreCase("thread")) {
            this.currentElement = "thread";
        } else if (name.equalsIgnoreCase("Pprof")) {
            this.currentElement = "Pprof";
        } else if (name.equalsIgnoreCase("nodeID")) {
            this.currentElement = "nodeID";
        } else if (name.equalsIgnoreCase("contextID")) {
            this.currentElement = "contextID";
        } else if (name.equalsIgnoreCase("threadID")) {
            this.currentElement = "threadID";
        } else if (name.equalsIgnoreCase("instrumentedobj")) {
            this.currentElement = "instrumentedobj";
        } else if (name.equalsIgnoreCase("funname")) {
            this.currentElement = "funname";
        } else if (name.equalsIgnoreCase("funID")) {
            this.currentElement = "funID";
        } else if (name.equalsIgnoreCase("fungroup")) {
            this.currentElement = "fungroup";
        } else if (name.equalsIgnoreCase("inclperc")) {
            this.currentElement = "inclperc";
        } else if (name.equalsIgnoreCase("inclutime")) {
            this.currentElement = "inclutime";
        } else if (name.equalsIgnoreCase("exclperc")) {
            this.currentElement = "exclperc";
        } else if (name.equalsIgnoreCase("exclutime")) {
            this.currentElement = "exclutime";
        } else if (name.equalsIgnoreCase("call")) {
            this.currentElement = "call";
        } else if (name.equalsIgnoreCase("subrs")) {
            this.currentElement = "subrs";
        } else if (name.equalsIgnoreCase("inclutimePcall")) {
            this.currentElement = "inclutimePcall";
        } else if (name.equalsIgnoreCase("userevent")) {
            this.currentElement = "userevent";
        } else if (name.equalsIgnoreCase("uename")) {
            this.currentElement = "uename";
        } else if (name.equalsIgnoreCase("ueID")) {
            this.currentElement = "ueID";
        } else if (name.equalsIgnoreCase("numofsamples")) {
            this.currentElement = "numofsamples";
        } else if (name.equalsIgnoreCase("maxvalue")) {
            this.currentElement = "maxvalue";
        } else if (name.equalsIgnoreCase("minvalue")) {
            this.currentElement = "minvalue";
        } else if (name.equalsIgnoreCase("meanvalue")) {
            this.currentElement = "meanvalue";
        } else if (name.equalsIgnoreCase("stddevvalue")) {
            this.currentElement = "stddevvalue";
        } else if (name.equalsIgnoreCase("totalfunsummary")) {
            this.currentElement = "totalfunsummary";
        } else if (name.equalsIgnoreCase("meanfunsummary")) {
            this.currentElement = "meanfunsummary";
        }
    }

    public void characters(char[] chars, int start, int length) {
        boolean isWhitespace = true;
        int i = start;
        while (i < start + length) {
            if (!Character.isWhitespace(chars[i])) {
                isWhitespace = false;
                break;
            }
            ++i;
        }
        if (isWhitespace) {
            return;
        }
        String tempcode = new String(chars, start, length);
        if (this.currentElement.equals("AppID")) {
            this.appid = tempcode;
            if (this.appid.length() == 0) {
                System.out.println("No valid application ID. Quit loadding.");
                System.exit(-1);
            }
        } else if (this.currentElement.equals("ExpID")) {
            this.expid = tempcode;
            if (this.expid.length() == 0) {
                System.out.println("No valid experiment ID. Quit loadding.");
                System.exit(-1);
            }
        } else if (this.currentElement.equals("ProblemSize")) {
            this.probsize = tempcode;
        } else if (this.currentElement.equals("TrialName")) {
            this.trialName = tempcode;
        } else if (this.currentElement.equals("UserData")) {
            this.userData = tempcode;
        } else if (this.currentElement.equals("Trialtime")) {
            this.trialTime = tempcode;
        } else if (this.currentElement.equals("FunAmt")) {
            this.funAmt = Integer.parseInt(tempcode);
            if (this.funAmt > 0) {
                this.funArray = new String[this.funAmt];
            }
        } else if (this.currentElement.equals("UEAmt")) {
            this.ueAmt = Integer.parseInt(tempcode);
            if (this.ueAmt > 0) {
                this.ueArray = new String[this.ueAmt];
            }
            if (this.ueAmt + this.funAmt == 0) {
                System.out.println("Cannot get a valid function amount, quit loadding.");
                System.exit(-1);
            }
        }
        if (this.currentElement.equals("node")) {
            this.nodenum = tempcode;
        } else if (this.currentElement.equals("context")) {
            this.contextpnode = tempcode;
        } else if (this.currentElement.equals("thread")) {
            this.threadpcontext = tempcode;
        } else if (this.currentElement.equals("nodeID")) {
            this.nodeid = tempcode;
        } else if (this.currentElement.equals("contextID")) {
            this.contextid = tempcode;
        } else if (this.currentElement.equals("threadID")) {
            this.threadid = tempcode;
        } else if (this.currentElement.equals("funname")) {
            this.funname = this.funname + tempcode;
        } else if (this.currentElement.equals("fungroup")) {
            this.fungroup = this.fungroup + tempcode;
        } else if (this.currentElement.equals("funID")) {
            this.funid = tempcode;
        } else if (this.currentElement.equals("inclperc")) {
            this.inclperc = tempcode;
        } else if (this.currentElement.equals("inclutime")) {
            this.incl = tempcode;
        } else if (this.currentElement.equals("exclperc")) {
            this.exclperc = tempcode;
        } else if (this.currentElement.equals("exclutime")) {
            this.excl = tempcode;
        } else if (this.currentElement.equals("call")) {
            this.callnum = tempcode;
        } else if (this.currentElement.equals("subrs")) {
            this.subrs = tempcode;
        } else if (this.currentElement.equals("inclutimePcall")) {
            this.inclpcall = tempcode;
        } else if (this.currentElement.equals("uename")) {
            this.uename = tempcode;
        } else if (this.currentElement.equals("ueID")) {
            this.ueid = tempcode;
        } else if (this.currentElement.equals("numofsamples")) {
            this.numofsamples = tempcode;
        } else if (this.currentElement.equals("maxvalue")) {
            this.maxvalue = tempcode;
        } else if (this.currentElement.equals("minvalue")) {
            this.minvalue = tempcode;
        } else if (this.currentElement.equals("meanvalue")) {
            this.meanvalue = tempcode;
        } else if (this.currentElement.equals("stddevvalue")) {
            this.standardDeviation = tempcode;
        }
    }

    public void endElement(String url, String name, String qname) {
        String ltempStr;
        String ftempStr;
        StringBuffer buf = new StringBuffer();
        if (name.equalsIgnoreCase("usereventamt")) {
            if (this.trialId.compareTo("0") == 0) {
                this.newTrial = true;
                buf.append("insert into ");
                buf.append(this.getTrialTable());
                buf.append(" (experiment, name, time, node_count, contexts_per_node, threads_per_context, userdata, problem_definition)");
                buf.append(" values ");
                buf.append("(" + this.expid + ", '" + this.trialName + "', '" + this.trialTime + "', " + this.nodenum + ", " + this.contextpnode + ", " + this.threadpcontext + ", '" + this.userData + "', '" + this.problemString + "'); ");
                try {
                    this.getDB().executeUpdate(buf.toString());
                    buf.delete(0, buf.toString().length());
                    if (this.getDB().getDBType().compareTo("mysql") == 0) {
                        buf.append("select LAST_INSERT_ID();");
                    } else {
                        buf.append("select currval('trial_id_seq');");
                    }
                    this.trialId = this.getDB().getDataItem(buf.toString());
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    this.newTrial = false;
                    buf.append("select id, function_number from function where trial = " + this.trialId + " order by function_number asc;");
                    ResultSet functions = this.getDB().executeQuery(buf.toString());
                    while (functions.next()) {
                        String tmpId = functions.getString(1);
                        int tmpInt = functions.getInt(2);
                        this.funArray[tmpInt] = tmpId;
                    }
                    functions.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                buf.delete(0, buf.toString().length());
                buf.append("insert into metric (name) values (TRIM('");
                buf.append(this.metricStr);
                buf.append("'));");
                this.getDB().executeUpdate(buf.toString());
                buf.delete(0, buf.toString().length());
                if (this.getDB().getDBType().compareTo("mysql") == 0) {
                    buf.append("select LAST_INSERT_ID();");
                } else {
                    buf.append("select currval('metric_id_seq');");
                }
                this.metricId = this.getDB().getDataItem(buf.toString());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            try {
                buf.delete(0, buf.toString().length());
                buf.append("update " + this.XMLFILE_TABLE + " set trial = " + this.trialId);
                buf.append(", metric = " + this.metricId + " where id = " + this.getDocumentId() + ";");
                this.getDB().executeUpdate(buf.toString());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        if (name.equalsIgnoreCase("instrumentedobj")) {
            try {
                int tempInt = Integer.parseInt(this.funid);
                if (this.funArray[tempInt] == null) {
                    ++this.funIndexCounter;
                    if (this.fungroup.trim().length() == 0) {
                        this.fungroup = "NA";
                    }
                    ftempStr = String.valueOf(this.funIndexCounter) + "\t" + this.getTrialId() + "\t" + this.funid + "\t" + this.funname + "\t" + this.fungroup;
                    this.fwriter.write(ftempStr, 0, ftempStr.length());
                    this.fwriter.newLine();
                    this.funArray[tempInt] = String.valueOf(this.funIndexCounter);
                }
                ++this.interLocCounter;
                ltempStr = String.valueOf(this.interLocCounter) + "\t" + this.funArray[tempInt] + "\t" + this.nodeid + "\t" + this.contextid + "\t" + this.threadid + "\t" + this.metricId + "\t" + this.inclperc + "\t" + this.incl + "\t" + this.exclperc + "\t" + this.excl + "\t" + this.callnum + "\t" + this.subrs + "\t" + this.inclpcall;
                this.ilwriter.write(ltempStr, 0, ltempStr.length());
                this.ilwriter.newLine();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.funname = "";
            this.fungroup = "";
        }
        if (name.equalsIgnoreCase("userevent") && this.newTrial) {
            try {
                int ueidInt = Integer.parseInt(this.ueid);
                if (this.ueArray[ueidInt] == null) {
                    ++this.ueIndexCounter;
                    ftempStr = String.valueOf(this.ueIndexCounter) + "\t" + this.getTrialId() + "\t" + this.uename + "\t" + this.uegroup;
                    this.uewriter.write(ftempStr, 0, ftempStr.length());
                    this.uewriter.newLine();
                    this.ueArray[ueidInt] = String.valueOf(this.ueIndexCounter);
                }
                ++this.atomicLocCounter;
                ltempStr = String.valueOf(this.atomicLocCounter) + "\t" + this.ueArray[ueidInt] + "\t" + this.nodeid + "\t" + this.contextid + "\t" + this.threadid + "\t" + this.numofsamples + "\t" + this.maxvalue + "\t" + this.minvalue + "\t" + this.meanvalue + "\t" + this.standardDeviation;
                this.alwriter.write(ltempStr, 0, ltempStr.length());
                this.alwriter.newLine();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.uename = "";
        }
        if (name.equalsIgnoreCase("totalfunction")) {
            try {
                ++this.funTotalCounter;
                String ttempStr = String.valueOf(this.funTotalCounter) + "\t" + this.funArray[Integer.parseInt(this.funid)] + "\t" + this.metricId + "\t" + this.inclperc + "\t" + this.incl + "\t" + this.exclperc + "\t" + this.excl + "\t" + this.callnum + "\t" + this.subrs + "\t" + this.inclpcall;
                this.twriter.write(ttempStr, 0, ttempStr.length());
                this.twriter.newLine();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.funname = "";
            this.fungroup = "";
        }
        if (name.equalsIgnoreCase("meanfunction")) {
            try {
                ++this.funMeanCounter;
                String mtempStr = String.valueOf(this.funMeanCounter) + "\t" + this.funArray[Integer.parseInt(this.funid)] + "\t" + this.metricId + "\t" + this.inclperc + "\t" + this.incl + "\t" + this.exclperc + "\t" + this.excl + "\t" + this.callnum + "\t" + this.subrs + "\t" + this.inclpcall;
                this.mwriter.write(mtempStr, 0, mtempStr.length());
                this.mwriter.newLine();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.funname = "";
            this.fungroup = "";
        }
        if (name.equalsIgnoreCase("Onetrial")) {
            try {
                this.fwriter.write("\\.", 0, "\\.".length());
                this.fwriter.newLine();
                this.fwriter.close();
                this.ilwriter.write("\\.", 0, "\\.".length());
                this.ilwriter.newLine();
                this.ilwriter.close();
                this.alwriter.write("\\.", 0, "\\.".length());
                this.alwriter.newLine();
                this.alwriter.close();
                this.uewriter.write("\\.", 0, "\\.".length());
                this.uewriter.newLine();
                this.uewriter.close();
                this.twriter.write("\\.", 0, "\\.".length());
                this.twriter.newLine();
                this.twriter.close();
                this.mwriter.write("\\.", 0, "\\.".length());
                this.mwriter.newLine();
                this.mwriter.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (this.getDB().getDBType().compareTo("mysql") == 0) {
                buf.append("load data infile '");
                buf.append(this.funTempFile.getAbsolutePath());
                buf.append("' into table ");
                buf.append(this.getFunTable() + ";");
            } else {
                buf.append("copy ");
                buf.append(this.getFunTable());
                buf.append(" from ");
                buf.append("'" + this.funTempFile.getAbsolutePath() + "';");
            }
            try {
                this.getDB().executeUpdate(buf.toString());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            buf.delete(0, buf.toString().length());
            if (this.getDB().getDBType().compareTo("mysql") == 0) {
                buf.append("load data infile '");
                buf.append(this.interLocTempFile.getAbsolutePath());
                buf.append("' into table ");
                buf.append(this.getInterLocTable() + ";");
            } else {
                buf.append("copy ");
                buf.append(this.getInterLocTable());
                buf.append(" from ");
                buf.append("'" + this.interLocTempFile.getAbsolutePath() + "';");
            }
            try {
                this.getDB().executeUpdate(buf.toString());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            if (this.ueAmt > 0) {
                buf.delete(0, buf.toString().length());
                if (this.getDB().getDBType().compareTo("mysql") == 0) {
                    buf.append("load data infile '");
                    buf.append(this.ueTempFile.getAbsolutePath());
                    buf.append("' into table ");
                    buf.append(this.getUETable() + ";");
                } else {
                    buf.append("copy ");
                    buf.append(this.getUETable());
                    buf.append(" from ");
                    buf.append("'" + this.ueTempFile.getAbsolutePath() + "';");
                }
                try {
                    this.getDB().executeUpdate(buf.toString());
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                buf.delete(0, buf.toString().length());
                if (this.getDB().getDBType().compareTo("mysql") == 0) {
                    buf.append("load data infile '");
                    buf.append(this.atomicLocTempFile.getAbsolutePath());
                    buf.append("' into table ");
                    buf.append(this.getAtomicLocTable() + ";");
                } else {
                    buf.append("copy ");
                    buf.append(this.getAtomicLocTable());
                    buf.append(" from ");
                    buf.append("'" + this.atomicLocTempFile.getAbsolutePath() + "';");
                }
                try {
                    this.getDB().executeUpdate(buf.toString());
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            buf.delete(0, buf.toString().length());
            if (this.getDB().getDBType().compareTo("mysql") == 0) {
                buf.append("load data infile '");
                buf.append(this.totalTempFile.getAbsolutePath());
                buf.append("' into table ");
                buf.append(this.getTotalTable() + ";");
            } else {
                buf.append("copy ");
                buf.append(this.getTotalTable());
                buf.append(" from ");
                buf.append("'" + this.totalTempFile.getAbsolutePath() + "';");
            }
            try {
                this.getDB().executeUpdate(buf.toString());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            buf.delete(0, buf.toString().length());
            if (this.getDB().getDBType().compareTo("mysql") == 0) {
                buf.append("load data infile '");
                buf.append(this.meanTempFile.getAbsolutePath());
                buf.append("' into table ");
                buf.append(this.getMeanTable() + ";");
            } else {
                buf.append("copy ");
                buf.append(this.getMeanTable());
                buf.append(" from ");
                buf.append("'" + this.meanTempFile.getAbsolutePath() + "';");
            }
            try {
                this.getDB().executeUpdate(buf.toString());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            this.funTempFile.delete();
            this.interLocTempFile.delete();
            this.ueTempFile.delete();
            this.atomicLocTempFile.delete();
            this.totalTempFile.delete();
            this.meanTempFile.delete();
        }
    }
}

