/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.LineData;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.ParaProfDataSession;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SPPMOutputDataSession
extends ParaProfDataSession {
    private int metric = 0;
    private GlobalMappingElement globalMappingElement = null;
    private GlobalThreadDataElement globalThreadDataElement = null;
    private Node node = null;
    private Context context = null;
    private Thread thread = null;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private String inputString = null;
    private String s1 = null;
    private String s2 = null;
    private String tokenString;
    private String groupNamesString = null;
    private StringTokenizer genericTokenizer;
    private int mappingID = -1;
    private Vector v = null;
    private File[] files = null;
    private BufferedReader br = null;
    private int deltaCount = 0;
    private int timestepCount = 0;
    private Hashtable methodIndexes = null;
    private double[] cpuTime = null;
    private double[] wallTime = null;
    private int[] calls = null;
    private int[] subroutines = null;
    private String eventName = null;
    private LineData lineData = new LineData();

    public SPPMOutputDataSession() {
        this.setMetrics(new Vector());
    }

    public void initialize(Object object) {
        boolean bl = true;
        try {
            this.v = (Vector)object;
            System.out.println(this.v.size() + " files");
            Enumeration enumeration = this.v.elements();
            while (enumeration.hasMoreElements()) {
                this.files = (File[])enumeration.nextElement();
                for (int i = 0; i < this.files.length; ++i) {
                    System.out.println("Processing data file, please wait ......");
                    long l = System.currentTimeMillis();
                    this.methodIndexes = new Hashtable();
                    this.cpuTime = new double[20];
                    this.wallTime = new double[20];
                    this.calls = new int[20];
                    this.subroutines = new int[20];
                    this.deltaCount = 0;
                    this.timestepCount = 0;
                    FileInputStream fileInputStream = new FileInputStream(this.files[i]);
                    InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                    this.br = new BufferedReader(inputStreamReader);
                    ++this.nodeID;
                    this.inputString = this.br.readLine();
                    if (this.inputString == null) {
                        return;
                    }
                    while ((this.inputString = this.br.readLine()) != null) {
                        if (this.inputString.length() == 0) continue;
                        if (this.inputString.trim().startsWith("==================> Begin Double Timestep")) {
                            this.processTimestepHeader(this.inputString);
                            continue;
                        }
                        if (this.inputString.trim().indexOf("threads update a") >= 0) {
                            this.processThreadCount(this.inputString);
                            continue;
                        }
                        if (this.inputString.trim().startsWith("DELTA-HYD cpu, wall, ratio:")) {
                            this.processEvent(this.inputString, 0);
                            ++this.deltaCount;
                            continue;
                        }
                        if (this.inputString.trim().startsWith("TSTEP-HYD cpu, wall, ratio:")) {
                            this.processEvent(this.inputString, this.deltaCount);
                            ++this.timestepCount;
                            this.deltaCount = 0;
                            continue;
                        }
                        if (!this.inputString.trim().startsWith("TOTAL-HYD cpu, wall, ratio:") || this.inputString.trim().indexOf("Finished Calculation") < 0) continue;
                        this.processEvent(this.inputString, this.timestepCount);
                    }
                    this.br.close();
                    this.saveMappings();
                    if (UtilFncs.debug) {
                        System.out.println("The total number of threads is: " + this.getNCT().getTotalNumberOfThreads());
                        System.out.println("The number of mappings is: " + this.getGlobalMapping().getNumberOfMappings(0));
                        System.out.println("The number of user events is: " + this.getGlobalMapping().getNumberOfMappings(2));
                    }
                    this.setFirstMetric(false);
                    l = System.currentTimeMillis() - l;
                    System.out.println("Done processing data file!");
                    System.out.println("Time to process file (in milliseconds): " + l);
                }
            }
            this.generateDerivedData(0);
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "SSD01");
        }
    }

    private void initializeThread() {
        this.mappingID = this.getGlobalMapping().addGlobalMapping(this.eventName, 0, 1);
        this.globalMappingElement = this.getGlobalMapping().getGlobalMappingElement(this.mappingID, 0);
        this.nodeID = this.nodeID == -1 ? 0 : this.nodeID;
        this.contextID = this.contextID == -1 ? 0 : this.contextID;
        this.threadID = this.threadID == -1 ? 0 : this.threadID;
        this.node = this.getNCT().getNode(this.nodeID);
        if (this.node == null) {
            this.node = this.getNCT().addNode(this.nodeID);
        }
        this.context = this.node.getContext(this.contextID);
        if (this.context == null) {
            this.context = this.node.addContext(this.contextID);
        }
        this.thread = this.context.getThread(this.threadID);
        if (this.thread == null) {
            this.thread = this.context.addThread(this.threadID);
            this.thread.setDebug(this.debug());
            this.thread.initializeFunctionList(this.getGlobalMapping().getNumberOfMappings(0));
            this.thread.initializeUsereventList(this.getGlobalMapping().getNumberOfMappings(2));
        }
        this.globalThreadDataElement = this.thread.getFunction(this.mappingID);
        if (this.globalThreadDataElement == null) {
            this.globalThreadDataElement = new GlobalThreadDataElement(this.getGlobalMapping().getGlobalMappingElement(this.mappingID, 0), false);
            this.thread.addFunction(this.globalThreadDataElement, this.mappingID);
        }
    }

    private void processTimestepHeader(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            string = stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            this.lineData.i0 = Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the header!");
            exception.printStackTrace();
        }
    }

    private void processThreadCount(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            this.lineData.i1 = Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the header!");
            exception.printStackTrace();
        }
    }

    private void processEvent(String string, int n) {
        try {
            Integer n2;
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            this.lineData.s0 = stringTokenizer.nextToken().trim();
            this.lineData.s1 = stringTokenizer.nextToken().trim();
            this.lineData.s1 = this.lineData.s1.replaceAll(",", "");
            this.lineData.s2 = stringTokenizer.nextToken().trim();
            this.lineData.s2 = this.lineData.s2.replaceAll(",", "");
            this.lineData.s3 = stringTokenizer.nextToken().trim();
            this.lineData.s3 = this.lineData.s3.replaceAll(":", "");
            this.lineData.d0 = Double.parseDouble(stringTokenizer.nextToken().trim());
            this.lineData.d0 /= (double)this.lineData.i1;
            this.lineData.d1 = Double.parseDouble(stringTokenizer.nextToken().trim());
            this.lineData.d2 = Double.parseDouble(stringTokenizer.nextToken().trim());
            while (stringTokenizer.hasMoreTokens() && !(string2 = stringTokenizer.nextToken().trim()).equals("@")) {
                this.lineData.s0 = this.lineData.s0 + " " + string2;
            }
            boolean bl = false;
            if (n == 0) {
                bl = true;
            }
            if ((n2 = (Integer)this.methodIndexes.get(this.lineData.s0)) == null) {
                n2 = new Integer(this.methodIndexes.size());
                this.methodIndexes.put(this.lineData.s0, n2);
                this.cpuTime[n2.intValue()] = this.lineData.d0;
                this.wallTime[n2.intValue()] = this.lineData.d1;
                this.calls[n2.intValue()] = 1;
                this.subroutines[n2.intValue()] = n;
            } else {
                int n3 = n2;
                this.cpuTime[n3] = this.cpuTime[n3] + this.lineData.d0;
                int n4 = n2;
                this.wallTime[n4] = this.wallTime[n4] + this.lineData.d1;
                int n5 = n2;
                this.calls[n5] = this.calls[n5] + 1;
                this.subroutines[n2.intValue()] = n;
            }
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the callsite data!");
            exception.printStackTrace();
        }
    }

    private void saveMappings() {
        try {
            Enumeration enumeration = this.methodIndexes.keys();
            while (enumeration.hasMoreElements()) {
                this.eventName = (String)enumeration.nextElement();
                Integer n = (Integer)this.methodIndexes.get(this.eventName);
                boolean bl = false;
                if (this.subroutines[n] == 0) {
                    bl = true;
                }
                for (int i = 0; i < this.lineData.i1; ++i) {
                    this.threadID = i;
                    this.initializeThread();
                    this.saveMappingData("cpu", this.cpuTime[n], bl);
                    this.thread.incrementStorage();
                    this.globalMappingElement.incrementStorage();
                    this.globalThreadDataElement.incrementStorage();
                    this.saveMappingData("wall", this.wallTime[n], bl);
                    this.globalThreadDataElement.setNumberOfCalls(this.calls[n]);
                    if (this.globalMappingElement.getMaxNumberOfCalls() < this.calls[n]) {
                        this.globalMappingElement.setMaxNumberOfCalls(this.calls[n]);
                    }
                    this.globalThreadDataElement.setNumberOfSubRoutines(this.subroutines[n]);
                    if (this.globalMappingElement.getMaxNumberOfSubRoutines() >= this.subroutines[n]) continue;
                    this.globalMappingElement.setMaxNumberOfSubRoutines(this.subroutines[n]);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the callsite data!");
            exception.printStackTrace();
        }
    }

    private void saveMappingData(String string, double d, boolean bl) {
        this.metric = this.getNumberOfMetrics();
        Metric metric = this.addMetric(string);
        if (this.metric < this.getNumberOfMetrics()) {
            this.getGlobalMapping().increaseVectorStorage();
        }
        this.metric = metric.getID();
        if (bl) {
            this.globalThreadDataElement.setExclusiveValue(this.metric, d);
            if (this.globalMappingElement.getMaxExclusiveValue(this.metric) < d) {
                this.globalMappingElement.setMaxExclusiveValue(this.metric, d);
            }
        } else {
            this.globalThreadDataElement.setExclusiveValue(this.metric, 0.0);
        }
        this.globalThreadDataElement.setInclusiveValue(this.metric, d);
        if (this.globalMappingElement.getMaxInclusiveValue(this.metric) < d) {
            this.globalMappingElement.setMaxInclusiveValue(this.metric, d);
        }
        this.globalThreadDataElement.setUserSecPerCall(this.metric, d);
        if (this.globalMappingElement.getMaxUserSecPerCall(this.metric) < d) {
            this.globalMappingElement.setMaxUserSecPerCall(this.metric, d);
        }
    }
}

