/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.Application;
import edu.uoregon.tau.dms.dss.AtomicEvent;
import edu.uoregon.tau.dms.dss.AtomicLocationProfile;
import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.DataSession;
import edu.uoregon.tau.dms.dss.Experiment;
import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.IntervalEvent;
import edu.uoregon.tau.dms.dss.IntervalLocationProfile;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.NCT;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.Trial;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;

public abstract class ParaProfDataSession
extends DataSession {
    protected Object initializeObject = null;
    private boolean firstMetric = true;
    private boolean groupCheck = false;
    private int totalNumberOfContexts = -1;
    private int totalNumberOfThreads = -1;
    private boolean profileStatsPresent = false;
    private boolean profileCallsPresent = false;
    private boolean aggregatesPresent = false;
    private boolean groupNamesPresent = false;
    private boolean userEventsPresent = false;
    private boolean callPathDataPresent = false;
    private int[] maxNCT = null;
    private boolean debug = false;
    private PrintWriter out = null;

    public ParaProfDataSession() {
        this.setGlobalMapping(new GlobalMapping());
        this.setNCT(new NCT());
    }

    public ParaProfDataSession(boolean bl) {
        this.debug = bl;
        this.setGlobalMapping(new GlobalMapping());
        this.setNCT(new NCT());
    }

    public void terminate() {
    }

    public ListIterator getApplicationList() {
        return null;
    }

    public ListIterator getExperimentList() {
        return null;
    }

    public ListIterator getTrialList() {
        return null;
    }

    public Application setApplication(int n) {
        return null;
    }

    public Application setApplication(String string, String string2) {
        return null;
    }

    public Experiment setExperiment(int n) {
        return null;
    }

    public Trial setTrial(int n) {
        return null;
    }

    public ListIterator getIntervalEvents() {
        return null;
    }

    public IntervalEvent setIntervalEvent(int n) {
        return null;
    }

    public IntervalEvent getIntervalEvent(int n) {
        return null;
    }

    public ListIterator getAtomicEvents() {
        return null;
    }

    public AtomicEvent setAtomicEvent(int n) {
        return null;
    }

    public AtomicEvent getAtomicEvent(int n) {
        return null;
    }

    public ListIterator getIntervalEventData() {
        return null;
    }

    public ListIterator getAtomicEventData() {
        return null;
    }

    public void getIntervalEventDetail(IntervalEvent intervalEvent) {
    }

    public void getAtomicEventDetail(AtomicEvent atomicEvent) {
    }

    public int saveTrial() {
        return -1;
    }

    public int saveTrial(Trial trial) {
        return -1;
    }

    public int saveIntervalEvent(IntervalEvent intervalEvent, int n, Hashtable hashtable) {
        return -1;
    }

    public void saveIntervalEventData(IntervalLocationProfile intervalLocationProfile, int n, Hashtable hashtable) {
    }

    public int saveAtomicEvent(AtomicEvent atomicEvent, int n) {
        return -1;
    }

    public void saveAtomicEventData(AtomicLocationProfile atomicLocationProfile, int n) {
    }

    public boolean profileStatsPresent() {
        return this.profileStatsPresent;
    }

    public boolean profileCallsPresent() {
        return this.profileCallsPresent();
    }

    public boolean aggregatesPresent() {
        return this.aggregatesPresent;
    }

    public boolean groupNamesPresent() {
        return this.groupNamesPresent;
    }

    public boolean userEventsPresent() {
        return this.userEventsPresent;
    }

    public boolean callPathDataPresent() {
        return this.callPathDataPresent;
    }

    public void setDebug(boolean bl) {
        try {
            this.debug = bl;
            if (bl && this.out == null) {
                Class<?> clazz = this.getClass();
                this.out = new PrintWriter(new FileWriter(new File(clazz.getName() + ".out")));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean debug() {
        return this.debug;
    }

    public int[] getMaxNCTNumbers() {
        if (this.maxNCT == null) {
            this.maxNCT = new int[3];
            for (int i = 0; i < 3; ++i) {
                this.maxNCT[i] = 0;
            }
            Enumeration enumeration = this.getNCT().getNodes().elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                if (node.getNodeID() > this.maxNCT[0]) {
                    this.maxNCT[0] = node.getNodeID();
                }
                Enumeration enumeration2 = node.getContexts().elements();
                while (enumeration2.hasMoreElements()) {
                    Context context = (Context)enumeration2.nextElement();
                    if (context.getContextID() > this.maxNCT[1]) {
                        this.maxNCT[1] = context.getContextID();
                    }
                    Enumeration enumeration3 = context.getThreads().elements();
                    while (enumeration3.hasMoreElements()) {
                        Thread thread = (Thread)enumeration3.nextElement();
                        if (thread.getThreadID() <= this.maxNCT[2]) continue;
                        this.maxNCT[2] = thread.getThreadID();
                    }
                }
            }
        }
        return this.maxNCT;
    }

    public void generateDerivedData(int n) {
        Enumeration enumeration = this.getNCT().getThreads().elements();
        while (enumeration.hasMoreElements()) {
            ((Thread)enumeration.nextElement()).setThreadDataAllMetrics();
        }
        this.setMeanDataAllMetrics(n);
    }

    public void setMeanData(int n, int n2) {
        GlobalMappingElement globalMappingElement;
        if (this.debug()) {
            this.outputToFile("####################################");
            this.outputToFile("Setting mean data :: public void setMeanData(int mappingSelection, int metric)");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        GlobalMapping globalMapping = this.getGlobalMapping();
        ListIterator listIterator = globalMapping.getMappingIterator(n);
        while (listIterator.hasNext()) {
            globalMappingElement = (GlobalMappingElement)listIterator.next();
            d4 = 0.0;
            d5 = 0.0;
            d = 0.0;
            d2 = 0.0;
            int n3 = globalMappingElement.getMappingID();
            int n4 = 0;
            Enumeration enumeration = this.getNCT().getNodes().elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                Enumeration enumeration2 = node.getContexts().elements();
                while (enumeration2.hasMoreElements()) {
                    Context context = (Context)enumeration2.nextElement();
                    Enumeration enumeration3 = context.getThreads().elements();
                    while (enumeration3.hasMoreElements()) {
                        Thread thread = (Thread)enumeration3.nextElement();
                        GlobalThreadDataElement globalThreadDataElement = thread.getFunction(n3);
                        if (globalThreadDataElement != null) {
                            d += globalThreadDataElement.getExclusiveValue(n2);
                            d2 += globalThreadDataElement.getInclusiveValue(n2);
                            d4 += (double)globalThreadDataElement.getNumberOfCalls();
                            d5 += (double)globalThreadDataElement.getNumberOfSubRoutines();
                        }
                        ++n4;
                    }
                }
            }
            globalMappingElement.setTotalNumberOfCalls(d4);
            globalMappingElement.setTotalNumberOfSubRoutines(d5);
            globalMappingElement.setMeanNumberOfCalls(d4 / (double)n4);
            globalMappingElement.setMeanNumberOfSubRoutines(d5 / (double)n4);
            globalMappingElement.setTotalExclusiveValue(n2, d);
            globalMappingElement.setTotalInclusiveValue(n2, d2);
            globalMappingElement.setTotalUserSecPerCall(n2, d2 / d4);
            globalMappingElement.setMeanExclusiveValue(n2, d / (double)n4);
            globalMappingElement.setMeanInclusiveValue(n2, d2 / (double)n4);
            globalMappingElement.setMeanUserSecPerCall(n2, d2 / d4);
            if (d2 > d3) {
                d3 = d2;
            }
            if (globalMappingElement.getMeanNumberOfSubRoutines() > globalMapping.getMaxMeanNumberOfSubRoutines()) {
                globalMapping.setMaxMeanNumberOfSubRoutines(globalMappingElement.getMeanNumberOfSubRoutines());
            }
            if (globalMappingElement.getMeanNumberOfCalls() > globalMapping.getMaxMeanNumberOfCalls()) {
                globalMapping.setMaxMeanNumberOfCalls(globalMappingElement.getMeanNumberOfCalls());
            }
            if (globalMappingElement.getMeanExclusiveValue(n2) > globalMapping.getMaxMeanExclusiveValue(n2)) {
                globalMapping.setMaxMeanExclusiveValue(n2, globalMappingElement.getMeanExclusiveValue(n2));
            }
            if (!(globalMappingElement.getMeanInclusiveValue(n2) > globalMapping.getMaxMeanInclusiveValue(n2))) continue;
            globalMapping.setMaxMeanInclusiveValue(n2, globalMappingElement.getMeanInclusiveValue(n2));
        }
        listIterator = globalMapping.getMappingIterator(n);
        while (listIterator.hasNext()) {
            globalMappingElement = (GlobalMappingElement)listIterator.next();
            if (d3 != 0.0) {
                globalMappingElement.setTotalInclusivePercentValue(n2, globalMappingElement.getTotalInclusiveValue(n2) / d3 * 100.0);
                globalMappingElement.setTotalExclusivePercentValue(n2, globalMappingElement.getTotalExclusiveValue(n2) / d3 * 100.0);
                globalMappingElement.setMeanInclusivePercentValue(n2, globalMappingElement.getTotalInclusiveValue(n2) / d3 * 100.0);
                globalMappingElement.setMeanExclusivePercentValue(n2, globalMappingElement.getTotalExclusiveValue(n2) / d3 * 100.0);
            }
            if (globalMappingElement.getMeanExclusivePercentValue(n2) > globalMapping.getMaxMeanExclusivePercentValue(n2)) {
                globalMapping.setMaxMeanExclusivePercentValue(n2, globalMappingElement.getMeanExclusivePercentValue(n2));
            }
            if (globalMappingElement.getMeanInclusivePercentValue(n2) > globalMapping.getMaxMeanInclusivePercentValue(n2)) {
                globalMapping.setMaxMeanInclusivePercentValue(n2, globalMappingElement.getMeanInclusivePercentValue(n2));
            }
            globalMappingElement.setMeanValuesSet(true);
        }
        if (this.debug()) {
            this.outputToFile("Done - Setting mean data :: public void setMeanData(int mappingSelection, int metric)");
            this.outputToFile("####################################");
        }
    }

    public void setMeanDataAllMetrics(int n) {
        int n2;
        GlobalMappingElement globalMappingElement;
        int n3 = this.getNumberOfMetrics();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n3; ++i) {
            dArray3[i] = 0.0;
        }
        GlobalMapping globalMapping = this.getGlobalMapping();
        ListIterator listIterator = globalMapping.getMappingIterator(n);
        while (listIterator.hasNext()) {
            int n4;
            globalMappingElement = (GlobalMappingElement)listIterator.next();
            d = 0.0;
            d2 = 0.0;
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n2] = 0.0;
                dArray2[n2] = 0.0;
            }
            n2 = globalMappingElement.getMappingID();
            int n5 = 0;
            Enumeration enumeration = this.getNCT().getNodes().elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                Enumeration enumeration2 = node.getContexts().elements();
                while (enumeration2.hasMoreElements()) {
                    Context context = (Context)enumeration2.nextElement();
                    Enumeration enumeration3 = context.getThreads().elements();
                    while (enumeration3.hasMoreElements()) {
                        Thread thread = (Thread)enumeration3.nextElement();
                        GlobalThreadDataElement globalThreadDataElement = thread.getFunction(n2);
                        if (globalThreadDataElement != null) {
                            for (int i = 0; i < n3; ++i) {
                                int n6 = i;
                                dArray[n6] = dArray[n6] + globalThreadDataElement.getExclusiveValue(i);
                                int n7 = i;
                                dArray2[n7] = dArray2[n7] + globalThreadDataElement.getInclusiveValue(i);
                                if (i != 0) continue;
                                d += (double)globalThreadDataElement.getNumberOfCalls();
                                d2 += (double)globalThreadDataElement.getNumberOfSubRoutines();
                            }
                        }
                        ++n5;
                    }
                }
            }
            globalMappingElement.setTotalNumberOfCalls(d);
            globalMappingElement.setTotalNumberOfSubRoutines(d2);
            globalMappingElement.setMeanNumberOfCalls(d / (double)n5);
            globalMappingElement.setMeanNumberOfSubRoutines(d2 / (double)n5);
            for (n4 = 0; n4 < n3; ++n4) {
                globalMappingElement.setTotalExclusiveValue(n4, dArray[n4]);
                globalMappingElement.setTotalInclusiveValue(n4, dArray2[n4]);
                globalMappingElement.setTotalUserSecPerCall(n4, dArray2[n4] / d);
                globalMappingElement.setMeanExclusiveValue(n4, dArray[n4] / (double)n5);
                globalMappingElement.setMeanInclusiveValue(n4, dArray2[n4] / (double)n5);
                globalMappingElement.setMeanUserSecPerCall(n4, dArray2[n4] / d);
                if (!(dArray2[n4] > dArray3[n4])) continue;
                dArray3[n4] = dArray2[n4];
            }
            if (globalMappingElement.getMeanNumberOfSubRoutines() > globalMapping.getMaxMeanNumberOfSubRoutines()) {
                globalMapping.setMaxMeanNumberOfSubRoutines(globalMappingElement.getMeanNumberOfSubRoutines());
            }
            if (globalMappingElement.getMeanNumberOfCalls() > globalMapping.getMaxMeanNumberOfCalls()) {
                globalMapping.setMaxMeanNumberOfCalls(globalMappingElement.getMeanNumberOfCalls());
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (globalMappingElement.getMeanExclusiveValue(n4) > globalMapping.getMaxMeanExclusiveValue(n4)) {
                    globalMapping.setMaxMeanExclusiveValue(n4, globalMappingElement.getMeanExclusiveValue(n4));
                }
                if (!(globalMappingElement.getMeanInclusiveValue(n4) > globalMapping.getMaxMeanInclusiveValue(n4))) continue;
                globalMapping.setMaxMeanInclusiveValue(n4, globalMappingElement.getMeanInclusiveValue(n4));
            }
        }
        listIterator = globalMapping.getMappingIterator(n);
        while (listIterator.hasNext()) {
            globalMappingElement = (GlobalMappingElement)listIterator.next();
            for (n2 = 0; n2 < n3; ++n2) {
                if (dArray3[n2] != 0.0) {
                    globalMappingElement.setTotalInclusivePercentValue(n2, globalMappingElement.getTotalInclusiveValue(n2) / dArray3[n2] * 100.0);
                    globalMappingElement.setTotalExclusivePercentValue(n2, globalMappingElement.getTotalExclusiveValue(n2) / dArray3[n2] * 100.0);
                    globalMappingElement.setMeanInclusivePercentValue(n2, globalMappingElement.getTotalInclusiveValue(n2) / dArray3[n2] * 100.0);
                    globalMappingElement.setMeanExclusivePercentValue(n2, globalMappingElement.getTotalExclusiveValue(n2) / dArray3[n2] * 100.0);
                }
                if (globalMappingElement.getMeanExclusivePercentValue(n2) > globalMapping.getMaxMeanExclusivePercentValue(n2)) {
                    globalMapping.setMaxMeanExclusivePercentValue(n2, globalMappingElement.getMeanExclusivePercentValue(n2));
                }
                if (!(globalMappingElement.getMeanInclusivePercentValue(n2) > globalMapping.getMaxMeanInclusivePercentValue(n2))) continue;
                globalMapping.setMaxMeanInclusivePercentValue(n2, globalMappingElement.getMeanInclusivePercentValue(n2));
            }
            globalMappingElement.setMeanValuesSet(true);
        }
    }

    protected Metric addMetric(String string) {
        Metric metric = new Metric();
        metric.setName(string);
        this.addMetric(metric);
        return metric;
    }

    protected void setProfileStatsPresent(boolean bl) {
        this.profileStatsPresent = bl;
    }

    protected void setProfileCallsPresent(boolean bl) {
        this.profileCallsPresent = bl;
    }

    protected void setAggregatesPresent(boolean bl) {
        this.aggregatesPresent = bl;
    }

    protected void setGroupNamesPresent(boolean bl) {
        this.groupNamesPresent = bl;
    }

    protected void setUserEventsPresent(boolean bl) {
        this.userEventsPresent = bl;
    }

    protected void setCallPathDataPresent(boolean bl) {
        this.callPathDataPresent = bl;
    }

    protected void setFirstMetric(boolean bl) {
        this.firstMetric = bl;
    }

    protected boolean firstMetric() {
        return this.firstMetric;
    }

    protected void setGroupCheck(boolean bl) {
        this.groupCheck = bl;
    }

    protected boolean groupCheck() {
        return this.groupCheck;
    }

    protected void outputToFile(String string) {
        if (this.out != null) {
            this.out.println(string);
        }
    }

    protected void flushDebugFileBuffer() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected void closeDebugFile() {
        if (this.out != null) {
            this.out.close();
        }
    }
}

