/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.UtilFncs;
import java.util.Collections;
import java.util.Vector;

public class Node
implements Comparable {
    int nodeID = -1;
    Vector contexts;

    public Node() {
        this.contexts = new Vector();
    }

    public Node(int n) {
        this.nodeID = n;
        this.contexts = new Vector();
    }

    public void setNodeID(int n) {
        this.nodeID = n;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public void addContext(Context context) {
        try {
            if (context.getContextID() < 0) {
                System.out.println("Error - Invalid context id (id less than zero). Context not added!");
                return;
            }
            int n = this.getContextPosition(context);
            if (n >= 0) {
                System.out.println("Error - Context already present. Context not added!");
            } else {
                this.contexts.insertElementAt(context, -(n + 1));
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "N1");
        }
    }

    public Context addContext(int n) {
        Context context = null;
        try {
            if (n < 0) {
                System.out.println("Error - Invalid context id (id less than zero). Context not added!");
                return null;
            }
            int n2 = this.getContextPosition(new Integer(n));
            if (n2 >= 0) {
                System.out.println("Error - Context already present. Context not added!");
            } else {
                context = new Context(this.nodeID, n);
                this.contexts.insertElementAt(context, -(n2 + 1));
            }
            return context;
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "N2");
            return context;
        }
    }

    public Vector getContexts() {
        return this.contexts;
    }

    public Context getContext(int n) {
        Context context = null;
        try {
            int n2 = this.getContextPosition(new Integer(n));
            if (n2 >= 0) {
                context = (Context)this.contexts.elementAt(n2);
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "N3");
        }
        return context;
    }

    public int getNumberOfContexts() {
        return this.contexts.size();
    }

    private int getContextPosition(Integer n) {
        return Collections.binarySearch(this.contexts, n);
    }

    private int getContextPosition(Context context) {
        return Collections.binarySearch(this.contexts, context);
    }

    public int compareTo(Object object) {
        if (object instanceof Integer) {
            return this.nodeID - (Integer)object;
        }
        return this.nodeID - ((Node)object).getNodeID();
    }
}

