/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.DataSessionIterator;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.Mapping;
import edu.uoregon.tau.dms.dss.UtilFncs;
import java.text.DecimalFormat;
import java.util.ListIterator;
import java.util.Vector;

public class GlobalThreadDataElement
implements Mapping {
    private GlobalMappingElement globalMappingElement = null;
    private boolean mappingExists = false;
    private double[] doubleList;
    private int numberOfCalls = 0;
    private int numberOfSubRoutines = 0;
    private int userEventNumberValue = 0;
    private boolean userevent = false;
    private Vector calls = null;
    private Vector parents = null;
    private Vector children = null;
    private Vector callPathIDSParents = null;
    private Vector callPathIDSChildren = null;

    public GlobalThreadDataElement(GlobalMappingElement globalMappingElement, boolean bl) {
        if (bl) {
            this.userevent = true;
            this.doubleList = new double[4];
        } else {
            this.doubleList = new double[5];
        }
        this.globalMappingElement = globalMappingElement;
    }

    public GlobalThreadDataElement(GlobalMappingElement globalMappingElement, boolean bl, int n) {
        if (bl) {
            this.userevent = true;
            this.doubleList = new double[n * 4];
        } else {
            this.doubleList = new double[n * 5];
        }
        this.globalMappingElement = globalMappingElement;
    }

    public GlobalMappingElement getGlobalMappingElement() {
        return this.globalMappingElement;
    }

    public String getMappingName() {
        return this.globalMappingElement.getMappingName();
    }

    public void setMappingName(String string) {
    }

    public void setMappingID(int n) {
    }

    public int getMappingID() {
        return this.globalMappingElement.getMappingID();
    }

    public boolean isGroupMember(int n) {
        return this.globalMappingElement.isGroupMember(n);
    }

    public int[] getGroups() {
        return this.globalMappingElement.getGroups();
    }

    public void setInclusiveValue(int n, double d) {
        this.insertDouble(n, 0, d);
    }

    public double getInclusiveValue(int n) {
        return this.getDouble(n, 0);
    }

    public void setExclusiveValue(int n, double d) {
        this.insertDouble(n, 1, d);
    }

    public double getExclusiveValue(int n) {
        return this.getDouble(n, 1);
    }

    public void setInclusivePercentValue(int n, double d) {
        this.insertDouble(n, 2, d);
    }

    public double getInclusivePercentValue(int n) {
        return this.getDouble(n, 2);
    }

    public void setExclusivePercentValue(int n, double d) {
        this.insertDouble(n, 3, d);
    }

    public double getExclusivePercentValue(int n) {
        return this.getDouble(n, 3);
    }

    public void setNumberOfCalls(int n) {
        this.numberOfCalls = n;
    }

    public int getNumberOfCalls() {
        return this.numberOfCalls;
    }

    public void setNumberOfSubRoutines(int n) {
        this.numberOfSubRoutines = n;
    }

    public int getNumberOfSubRoutines() {
        return this.numberOfSubRoutines;
    }

    public void setUserSecPerCall(int n, double d) {
        this.insertDouble(n, 4, d);
    }

    public double getUserSecPerCall(int n) {
        return this.getDouble(n, 4);
    }

    public static int getPositionOfName() {
        return 103;
    }

    public static String getTStatStringHeading(String string) {
        try {
            return UtilFncs.lpad("%" + string, 7) + UtilFncs.lpad(string, 16) + UtilFncs.lpad("Total " + string, 18) + UtilFncs.lpad("#Calls", 14) + UtilFncs.lpad("#Subrs", 14) + UtilFncs.lpad("Total " + string + "/Call", 21) + "   ";
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "GTDE01");
            return "An error occurred processing this string!";
        }
    }

    public String getTStatString(int n, int n2) {
        try {
            DecimalFormat decimalFormat = new DecimalFormat("##0.0");
            String string = UtilFncs.lpad(decimalFormat.format(this.getInclusivePercentValue(n2)), 7);
            string = string + "  " + UtilFncs.getOutputString(n, this.getExclusiveValue(n2), 14);
            string = string + "  " + UtilFncs.getOutputString(n, this.getInclusiveValue(n2), 16);
            string = string + "  " + UtilFncs.formatDouble(this.getNumberOfCalls(), 12);
            string = string + "  " + UtilFncs.formatDouble(this.getNumberOfSubRoutines(), 12);
            string = string + "  " + UtilFncs.getOutputString(n, this.getUserSecPerCall(n2), 19);
            return string;
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "GTDE01");
            return "An error occurred processing this string!";
        }
    }

    public boolean userevent() {
        return this.userevent;
    }

    public void setUserEventNumberValue(int n) {
        this.userEventNumberValue = n;
    }

    public int getUserEventNumberValue() {
        return this.userEventNumberValue;
    }

    public void setUserEventMinValue(double d) {
        this.doubleList[0] = d;
    }

    public double getUserEventMinValue() {
        return this.doubleList[0];
    }

    public void setUserEventMaxValue(double d) {
        this.doubleList[1] = d;
    }

    public double getUserEventMaxValue() {
        return this.doubleList[1];
    }

    public void setUserEventMeanValue(double d) {
        this.doubleList[2] = d;
    }

    public double getUserEventMeanValue() {
        return this.doubleList[2];
    }

    public void setUserEventSumSquared(double d) {
        this.doubleList[3] = d;
    }

    public double getUserEventSumSquared() {
        return this.doubleList[3];
    }

    public static String getUserEventStatStringHeading() {
        int n = 18;
        return UtilFncs.pad("NumSamples", n) + UtilFncs.pad("Max", n) + UtilFncs.pad("Min", n) + UtilFncs.pad("Mean", n) + UtilFncs.pad("Std. Dev", n);
    }

    public String getUserEventStatString(int n) {
        try {
            int n2;
            int n3 = 90;
            int n4 = 0;
            char[] cArray = new char[n3];
            GlobalThreadDataElement.insertSpaces(cArray, 0, 90);
            char[] cArray2 = Integer.toString(this.getUserEventNumberValue()).toCharArray();
            for (n2 = 0; n2 < cArray2.length; ++n2) {
                cArray[n4] = cArray2[n2];
                ++n4;
            }
            n4 = 18;
            String string = new String(Double.toString(UtilFncs.adjustDoublePresision(this.getUserEventMaxValue(), n)));
            cArray2 = string.toCharArray();
            for (n2 = 0; n2 < cArray2.length; ++n2) {
                cArray[n4] = cArray2[n2];
                ++n4;
            }
            n4 = 36;
            string = new String(Double.toString(UtilFncs.adjustDoublePresision(this.getUserEventMinValue(), n)));
            cArray2 = string.toCharArray();
            for (n2 = 0; n2 < cArray2.length; ++n2) {
                cArray[n4] = cArray2[n2];
                ++n4;
            }
            n4 = 54;
            string = new String(Double.toString(UtilFncs.adjustDoublePresision(this.getUserEventMeanValue(), n)));
            cArray2 = string.toCharArray();
            for (n2 = 0; n2 < cArray2.length; ++n2) {
                cArray[n4] = cArray2[n2];
                ++n4;
            }
            double d = this.getUserEventSumSquared();
            double d2 = this.getUserEventNumberValue();
            double d3 = this.getUserEventMeanValue();
            double d4 = Math.sqrt(Math.abs(d / d2) - d3 * d3);
            n4 = 72;
            string = new String(Double.toString(UtilFncs.adjustDoublePresision(d4, n)));
            cArray2 = string.toCharArray();
            for (int i = 0; i < cArray2.length; ++i) {
                cArray[n4] = cArray2[i];
                ++n4;
            }
            return new String(cArray);
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "GTDE01");
            return "An error occurred processing this string!";
        }
    }

    public void addCall(double d, double d2) {
        if (this.calls == null) {
            this.calls = new Vector();
        }
        double[] dArray = new double[]{d, d2};
        this.calls.add(dArray);
    }

    public boolean isCallPathObject() {
        return this.globalMappingElement.isCallPathObject();
    }

    public int addParent(int n) {
        if (this.parents == null) {
            this.parents = new Vector();
            this.callPathIDSParents = new Vector();
        }
        this.parents.add(new Integer(n));
        Vector vector = new Vector();
        this.callPathIDSParents.add(vector);
        return this.parents.size() - 1;
    }

    public void addParentCallPathID(int n, int n2) {
        Vector vector = (Vector)this.callPathIDSParents.elementAt(n);
        vector.add(new Integer(n2));
    }

    public void addParent(int n, int n2) {
        int n3 = UtilFncs.exists(this.parents, n);
        if (n3 == -1) {
            if (this.parents == null) {
                this.parents = new Vector();
                this.callPathIDSParents = new Vector();
            }
            this.parents.add(new Integer(n));
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(new Integer(n2));
            this.callPathIDSParents.add(vector);
        } else {
            Vector vector = (Vector)this.callPathIDSParents.elementAt(n3);
            vector.add(new Integer(n2));
        }
    }

    public Vector getParents() {
        return this.parents;
    }

    public Vector getChildren() {
        return this.children;
    }

    public ListIterator getParentsIterator() {
        return new DataSessionIterator(this.parents);
    }

    public ListIterator getChildrenIterator() {
        return new DataSessionIterator(this.children);
    }

    public ListIterator getCallPathIDParents(int n) {
        int n2 = UtilFncs.exists(this.parents, n);
        return new DataSessionIterator((Vector)this.callPathIDSParents.elementAt(n2));
    }

    public ListIterator getCallPathIDChildren(int n) {
        int n2 = UtilFncs.exists(this.children, n);
        return new DataSessionIterator((Vector)this.callPathIDSChildren.elementAt(n2));
    }

    public int addChild(int n) {
        if (this.children == null) {
            this.children = new Vector();
            this.callPathIDSChildren = new Vector();
        }
        this.children.add(new Integer(n));
        Vector vector = new Vector();
        this.callPathIDSChildren.add(vector);
        return this.children.size() - 1;
    }

    public void addChildCallPathID(int n, int n2) {
        Vector vector = (Vector)this.callPathIDSChildren.elementAt(n);
        vector.add(new Integer(n2));
    }

    public void addChild(int n, int n2) {
        int n3 = UtilFncs.exists(this.children, n);
        if (n3 == -1) {
            if (this.children == null) {
                this.children = new Vector();
                this.callPathIDSChildren = new Vector();
            }
            this.children.add(new Integer(n));
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(new Integer(n2));
            this.callPathIDSChildren.add(vector);
        } else {
            Vector vector = (Vector)this.callPathIDSChildren.elementAt(n3);
            vector.add(new Integer(n2));
        }
    }

    public int getStorageSize() {
        if (this.userevent) {
            return this.doubleList.length / 4;
        }
        return this.doubleList.length / 5;
    }

    public void incrementStorage() {
        if (this.userevent) {
            UtilFncs.systemError(null, null, "Error: Attempt to increase storage on a user event object!");
        }
        int n = this.doubleList.length;
        double[] dArray = new double[n + 5];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.doubleList[i];
        }
        this.doubleList = dArray;
    }

    private void insertDouble(int n, int n2, double d) {
        int n3 = n * 5 + n2;
        try {
            this.doubleList[n3] = d;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("inDouble: " + d);
            System.out.println("metric: " + n);
            System.out.println("offset: " + n2);
            System.out.println("actualLocation: " + n3);
            System.out.println("doubleList size: " + this.doubleList.length);
            UtilFncs.systemError(exception, null, "GTDE06");
        }
    }

    private double getDouble(int n, int n2) {
        int n3 = n * 5 + n2;
        try {
            return this.doubleList[n3];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            exception.printStackTrace();
            System.out.println("metric: " + n);
            System.out.println("offset: " + n2);
            System.out.println("actualLocation: " + n3);
            System.out.println("doubleList size: " + this.doubleList.length);
            UtilFncs.systemError(exception, null, "GTDE06");
            return -1.0;
        }
    }

    private static int insertSpaces(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[n] = 32;
            ++n;
        }
        return n;
    }
}

