/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.database.DB;
import edu.uoregon.tau.dms.dss.AtomicLocationProfile;
import edu.uoregon.tau.dms.dss.DataSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class AtomicEvent {
    private int atomicEventID;
    private String name;
    private String group;
    private int trialID;
    private int experimentID;
    private int applicationID;
    private AtomicLocationProfile meanSummary = null;
    private AtomicLocationProfile totalSummary = null;
    private DataSession dataSession = null;

    public AtomicEvent(DataSession dataSession) {
        this.dataSession = dataSession;
    }

    public int getID() {
        return this.atomicEventID;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public int getTrialID() {
        return this.trialID;
    }

    public int getExperimentID() {
        return this.experimentID;
    }

    public int getApplicationID() {
        return this.applicationID;
    }

    public AtomicLocationProfile getMeanSummary() {
        if (this.meanSummary == null) {
            this.dataSession.getAtomicEventDetail(this);
        }
        return this.meanSummary;
    }

    public AtomicLocationProfile getTotalSummary() {
        if (this.totalSummary == null) {
            this.dataSession.getAtomicEventDetail(this);
        }
        return this.totalSummary;
    }

    public void setID(int n) {
        this.atomicEventID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public void setTrialID(int n) {
        this.trialID = n;
    }

    public void setExperimentID(int n) {
        this.experimentID = n;
    }

    public void setApplicationID(int n) {
        this.applicationID = n;
    }

    public void setMeanSummary(AtomicLocationProfile atomicLocationProfile) {
        this.meanSummary = atomicLocationProfile;
    }

    public void setTotalSummary(AtomicLocationProfile atomicLocationProfile) {
        this.totalSummary = atomicLocationProfile;
    }

    public static Vector getAtomicEvents(DataSession dataSession, DB dB, String string) {
        Vector<AtomicEvent> vector = new Vector<AtomicEvent>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select u.id, u.trial, u.name, ");
        stringBuffer.append("u.group_name ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "atomic_event u inner join " + dB.getSchemaPrefix() + "trial t on u.trial = t.id ");
        stringBuffer.append("inner join " + dB.getSchemaPrefix() + "experiment e on t.experiment = e.id ");
        stringBuffer.append(string);
        stringBuffer.append(" order by id ");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            Object var6_7 = null;
            while (resultSet.next()) {
                AtomicEvent atomicEvent = new AtomicEvent(dataSession);
                atomicEvent.setID(resultSet.getInt(1));
                atomicEvent.setTrialID(resultSet.getInt(2));
                atomicEvent.setName(resultSet.getString(3));
                atomicEvent.setGroup(resultSet.getString(4));
                vector.addElement(atomicEvent);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public int saveAtomicEvent(DB dB, int n) {
        int n2 = 0;
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "atomic_event (trial, name, group_name) VALUES (?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, this.name);
            preparedStatement.setString(3, this.group);
            preparedStatement.executeUpdate();
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM atomic_event" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "atomic_event_id_seq.currval FROM dual" : "select currval('atomic_event_id_seq');"));
            n2 = Integer.parseInt(dB.getDataItem(string));
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the trial.");
            sQLException.printStackTrace();
        }
        return n2;
    }
}

