/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.xml.sax.SAXException;

public class SubstitutionGroupComparator {
    private final int TOP_LEVEL_SCOPE = -1;
    private StringPool fStringPool = null;
    private GrammarResolver fGrammarResolver = null;

    private SubstitutionGroupComparator() {
    }

    public SubstitutionGroupComparator(GrammarResolver grammarResolver, StringPool stringPool) {
        this.fGrammarResolver = grammarResolver;
        this.fStringPool = stringPool;
    }

    public boolean isEquivalentTo(QName qName, QName qName2) throws Exception {
        if (qName.localpart == qName2.localpart && qName.uri == qName2.uri) {
            return true;
        }
        if (this.fGrammarResolver == null || this.fStringPool == null) {
            throw new SAXException("Try to check substitutionGroup against a substitutionGroup, but no GrammarResolver is defined");
        }
        int n = 16;
        int n2 = qName.uri;
        int n3 = qName.localpart;
        String string = this.fStringPool.toString(qName.uri);
        String string2 = this.fStringPool.toString(qName.localpart);
        while (n >= 0) {
            if (string == null) {
                return false;
            }
            SchemaGrammar schemaGrammar = null;
            try {
                schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            if (schemaGrammar == null) {
                return false;
            }
            int n4 = schemaGrammar.getElementDeclIndex(n2, n3, -1);
            if (n4 == -1) {
                return false;
            }
            String string3 = schemaGrammar.getElementDeclSubstitutionGroupElementFullName(n4);
            if (string3 == null) {
                return false;
            }
            int n5 = string3.indexOf(",");
            string = "";
            string2 = string3;
            if (n5 >= 0) {
                if (n5 > 0) {
                    string = string3.substring(0, n5);
                }
                string2 = string3.substring(n5 + 1);
            }
            n2 = this.fStringPool.addSymbol(string);
            n3 = this.fStringPool.addSymbol(string2);
            if (n2 == qName2.uri && n3 == qName2.localpart) {
                return true;
            }
            --n;
        }
        return false;
    }
}

