/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.compile;

import org.jatha.Jatha;
import org.jatha.compile.AbsoluteValuePrimitive;
import org.jatha.compile.AddOnePrimitive;
import org.jatha.compile.AddPrimitive;
import org.jatha.compile.AppendPrimitive;
import org.jatha.compile.ApplyPrimitive;
import org.jatha.compile.AproposPrimitive;
import org.jatha.compile.ArcCosinePrimitive;
import org.jatha.compile.ArcSinePrimitive;
import org.jatha.compile.ArcTangent2Primitive;
import org.jatha.compile.ArcTangentPrimitive;
import org.jatha.compile.ArgumentCountMismatchException;
import org.jatha.compile.AssocPrimitive;
import org.jatha.compile.AtomPrimitive;
import org.jatha.compile.BoundpPrimitive;
import org.jatha.compile.ButlastPrimitive;
import org.jatha.compile.CarPrimitive;
import org.jatha.compile.CdrPrimitive;
import org.jatha.compile.CeilingPrimitive;
import org.jatha.compile.CharacterpPrimitive;
import org.jatha.compile.ClrhashPrimitive;
import org.jatha.compile.CompilerException;
import org.jatha.compile.ConsPrimitive;
import org.jatha.compile.ConspPrimitive;
import org.jatha.compile.ConstantpPrimitive;
import org.jatha.compile.CopyListPrimitive;
import org.jatha.compile.CosecantPrimitive;
import org.jatha.compile.CosinePrimitive;
import org.jatha.compile.CotangentPrimitive;
import org.jatha.compile.DefconstantPrimitive;
import org.jatha.compile.DefparameterPrimitive;
import org.jatha.compile.DefvarPrimitive;
import org.jatha.compile.DegreesToRadiansPrimitive;
import org.jatha.compile.DividePrimitive;
import org.jatha.compile.EighthPrimitive;
import org.jatha.compile.EltPrimitive;
import org.jatha.compile.EqPrimitive;
import org.jatha.compile.EqlPrimitive;
import org.jatha.compile.EqualNumericPrimitive;
import org.jatha.compile.EvalPrimitive;
import org.jatha.compile.ExitPrimitive;
import org.jatha.compile.FactorialPrimitive;
import org.jatha.compile.FboundpPrimitive;
import org.jatha.compile.FifthPrimitive;
import org.jatha.compile.FindPackagePrimitive;
import org.jatha.compile.FirstPrimitive;
import org.jatha.compile.FloatpPrimitive;
import org.jatha.compile.FloorPrimitive;
import org.jatha.compile.FourthPrimitive;
import org.jatha.compile.FreePrimitive;
import org.jatha.compile.FuncallPrimitive;
import org.jatha.compile.GcFullPrimitive;
import org.jatha.compile.GcPrimitive;
import org.jatha.compile.GethashPrimitive;
import org.jatha.compile.GreaterThanOrEqualPrimitive;
import org.jatha.compile.GreaterThanPrimitive;
import org.jatha.compile.GrindefPrimitive;
import org.jatha.compile.HashtableCountPrimitive;
import org.jatha.compile.HashtableRehashSizePrimitive;
import org.jatha.compile.HashtableRehashThresholdPrimitive;
import org.jatha.compile.HashtableSizePrimitive;
import org.jatha.compile.HashtableTestPrimitive;
import org.jatha.compile.HashtablepPrimitive;
import org.jatha.compile.IntegerpPrimitive;
import org.jatha.compile.InternPrimitive;
import org.jatha.compile.KeywordpPrimitive;
import org.jatha.compile.LastPrimitive;
import org.jatha.compile.LengthPrimitive;
import org.jatha.compile.LessThanOrEqualPrimitive;
import org.jatha.compile.LessThanPrimitive;
import org.jatha.compile.LispPrimitive;
import org.jatha.compile.ListAllPackagesPrimitive;
import org.jatha.compile.ListPrimitive;
import org.jatha.compile.ListStarPrimitive;
import org.jatha.compile.ListpPrimitive;
import org.jatha.compile.LoadPrimitive;
import org.jatha.compile.MakeHashTablePrimitive;
import org.jatha.compile.MaxPrimitive;
import org.jatha.compile.MemberPrimitive;
import org.jatha.compile.MinPrimitive;
import org.jatha.compile.MultiplyPrimitive;
import org.jatha.compile.NStringCapitalizePrimitive;
import org.jatha.compile.NStringDowncasePrimitive;
import org.jatha.compile.NStringUpcasePrimitive;
import org.jatha.compile.NinthPrimitive;
import org.jatha.compile.NotPrimitive;
import org.jatha.compile.NreversePrimitive;
import org.jatha.compile.NullPrimitive;
import org.jatha.compile.NumberpPrimitive;
import org.jatha.compile.PopPrimitive;
import org.jatha.compile.PositionPrimitive;
import org.jatha.compile.Prin1Primitive;
import org.jatha.compile.PrincPrimitive;
import org.jatha.compile.PrintPrimitive;
import org.jatha.compile.PushPrimitive;
import org.jatha.compile.QuotePrimitive;
import org.jatha.compile.RadiansToDegreesPrimitive;
import org.jatha.compile.RassocPrimitive;
import org.jatha.compile.ReciprocalPrimitive;
import org.jatha.compile.RemhashPrimitive;
import org.jatha.compile.RemovePrimitive;
import org.jatha.compile.RestPrimitive;
import org.jatha.compile.ReversePrimitive;
import org.jatha.compile.RplacaPrimitive;
import org.jatha.compile.RplacdPrimitive;
import org.jatha.compile.SecantPrimitive;
import org.jatha.compile.SecondPrimitive;
import org.jatha.compile.SetPrimitive;
import org.jatha.compile.SetfGethashPrimitive;
import org.jatha.compile.SetfSymbolFunctionPrimitive;
import org.jatha.compile.SetfSymbolPlistPrimitive;
import org.jatha.compile.SetfSymbolValuePrimitive;
import org.jatha.compile.SetqPrimitive;
import org.jatha.compile.SeventhPrimitive;
import org.jatha.compile.SinePrimitive;
import org.jatha.compile.SixthPrimitive;
import org.jatha.compile.SquareRootPrimitive;
import org.jatha.compile.StringCapitalizePrimitive;
import org.jatha.compile.StringDowncasePrimitive;
import org.jatha.compile.StringEndsWithPrimitive;
import org.jatha.compile.StringEqPrimitive;
import org.jatha.compile.StringEqualPrimitive;
import org.jatha.compile.StringGreaterThanOrEqualPrimitive;
import org.jatha.compile.StringGreaterThanPrimitive;
import org.jatha.compile.StringGreaterpPrimitive;
import org.jatha.compile.StringLeftTrimPrimitive;
import org.jatha.compile.StringLessThanOrEqualPrimitive;
import org.jatha.compile.StringLessThanPrimitive;
import org.jatha.compile.StringLesspPrimitive;
import org.jatha.compile.StringNeqPrimitive;
import org.jatha.compile.StringNotGreaterpPrimitive;
import org.jatha.compile.StringNotLesspPrimitive;
import org.jatha.compile.StringPrimitive;
import org.jatha.compile.StringRightTrimPrimitive;
import org.jatha.compile.StringStartsWithPrimitive;
import org.jatha.compile.StringTrimPrimitive;
import org.jatha.compile.StringUpcasePrimitive;
import org.jatha.compile.StringpPrimitive;
import org.jatha.compile.SubstPrimitive;
import org.jatha.compile.SubtractOnePrimitive;
import org.jatha.compile.SubtractPrimitive;
import org.jatha.compile.SymbolFunctionPrimitive;
import org.jatha.compile.SymbolNamePrimitive;
import org.jatha.compile.SymbolPackagePrimitive;
import org.jatha.compile.SymbolPlistPrimitive;
import org.jatha.compile.SymbolValuePrimitive;
import org.jatha.compile.SymbolpPrimitive;
import org.jatha.compile.TangentPrimitive;
import org.jatha.compile.TenthPrimitive;
import org.jatha.compile.ThirdPrimitive;
import org.jatha.compile.TimePrimitive;
import org.jatha.compile.TracePrimitive;
import org.jatha.compile.TypeOfPrimitive;
import org.jatha.compile.UndefinedFunctionException;
import org.jatha.compile.ZeropPrimitive;
import org.jatha.dynatype.LispCons;
import org.jatha.dynatype.LispConsOrNil;
import org.jatha.dynatype.LispException;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispPackage;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispValue;
import org.jatha.machine.SECDMachine;

public class LispCompiler {
    LispValue AND;
    LispValue DEFUN;
    LispValue IF;
    LispValue LAMBDA;
    LispValue LET;
    LispValue LETREC;
    LispValue OR;
    LispValue PRIMITIVE;
    LispValue PROGN;
    LispValue QUOTE;
    LispValue SETQ;
    LispValue WHEN;
    LispValue ZERO;
    LispValue ONE;
    LispValue TWO;
    boolean WarnAboutSpecialsP = false;
    private Jatha f_lisp = null;

    private void initializeConstants() {
        this.AND = this.f_lisp.EVAL.intern("AND");
        this.DEFUN = this.f_lisp.EVAL.intern("DEFUN");
        this.IF = this.f_lisp.EVAL.intern("IF");
        this.LAMBDA = this.f_lisp.EVAL.intern("LAMBDA");
        this.LET = this.f_lisp.EVAL.intern("LET");
        this.LETREC = this.f_lisp.EVAL.intern("LETREC");
        this.OR = this.f_lisp.EVAL.intern("OR");
        this.PROGN = this.f_lisp.EVAL.intern("PROGN");
        this.PRIMITIVE = this.f_lisp.EVAL.intern("PRIMITIVE", (LispPackage)this.f_lisp.findPackage("KEYWORD"));
        this.QUOTE = this.f_lisp.EVAL.intern("QUOTE");
        this.SETQ = this.f_lisp.EVAL.intern("SETQ");
        this.WHEN = this.f_lisp.EVAL.intern("WHEN");
    }

    public LispCompiler(Jatha lisp) {
        this.f_lisp = lisp;
        this.initializeConstants();
    }

    public void init() {
        this.Register(new AbsoluteValuePrimitive(this.f_lisp));
        this.Register(new AppendPrimitive(this.f_lisp));
        this.Register(new ApplyPrimitive(this.f_lisp));
        this.Register(new AproposPrimitive(this.f_lisp));
        this.Register(new ArcSinePrimitive(this.f_lisp));
        this.Register(new ArcCosinePrimitive(this.f_lisp));
        this.Register(new ArcTangentPrimitive(this.f_lisp));
        this.Register(new ArcTangent2Primitive(this.f_lisp));
        this.Register(new AssocPrimitive(this.f_lisp));
        this.Register(new AtomPrimitive(this.f_lisp));
        this.Register(new BoundpPrimitive(this.f_lisp));
        this.Register(new ButlastPrimitive(this.f_lisp));
        this.Register(new CarPrimitive(this.f_lisp));
        this.Register(new CdrPrimitive(this.f_lisp));
        this.Register(new CeilingPrimitive(this.f_lisp));
        this.Register(new CharacterpPrimitive(this.f_lisp));
        this.Register(new ClrhashPrimitive(this.f_lisp));
        this.Register(new ConsPrimitive(this.f_lisp));
        this.Register(new ConspPrimitive(this.f_lisp));
        this.Register(new ConstantpPrimitive(this.f_lisp));
        this.Register(new CopyListPrimitive(this.f_lisp));
        this.Register(new CosecantPrimitive(this.f_lisp));
        this.Register(new CosinePrimitive(this.f_lisp));
        this.Register(new CotangentPrimitive(this.f_lisp));
        this.Register(new DefconstantPrimitive(this.f_lisp));
        this.Register(new DefparameterPrimitive(this.f_lisp));
        this.Register(new DefvarPrimitive(this.f_lisp));
        this.Register(new DegreesToRadiansPrimitive(this.f_lisp));
        this.Register(new EighthPrimitive(this.f_lisp));
        this.Register(new EltPrimitive(this.f_lisp));
        this.Register(new EqPrimitive(this.f_lisp));
        this.Register(new EqlPrimitive(this.f_lisp));
        this.Register(new EqualNumericPrimitive(this.f_lisp));
        this.Register(new ExitPrimitive(this.f_lisp));
        this.Register(new EvalPrimitive(this.f_lisp));
        this.Register(new FactorialPrimitive(this.f_lisp));
        this.Register(new FboundpPrimitive(this.f_lisp));
        this.Register(new FindPackagePrimitive(this.f_lisp));
        this.Register(new FifthPrimitive(this.f_lisp));
        this.Register(new FirstPrimitive(this.f_lisp));
        this.Register(new FloatpPrimitive(this.f_lisp));
        this.Register(new FloorPrimitive(this.f_lisp));
        this.Register(new FuncallPrimitive(this.f_lisp));
        this.Register(new FourthPrimitive(this.f_lisp));
        this.Register(new GrindefPrimitive(this.f_lisp));
        this.Register(new GethashPrimitive(this.f_lisp));
        this.Register(new GreaterThanPrimitive(this.f_lisp));
        this.Register(new GreaterThanOrEqualPrimitive(this.f_lisp));
        this.Register(new SetfGethashPrimitive(this.f_lisp));
        this.Register(new HashtablepPrimitive(this.f_lisp));
        this.Register(new HashtableCountPrimitive(this.f_lisp));
        this.Register(new HashtableRehashSizePrimitive(this.f_lisp));
        this.Register(new HashtableRehashThresholdPrimitive(this.f_lisp));
        this.Register(new HashtableSizePrimitive(this.f_lisp));
        this.Register(new HashtableTestPrimitive(this.f_lisp));
        this.Register(new IntegerpPrimitive(this.f_lisp));
        this.Register(new InternPrimitive(this.f_lisp));
        this.Register(new KeywordpPrimitive(this.f_lisp));
        this.Register(new LastPrimitive(this.f_lisp));
        this.Register(new LengthPrimitive(this.f_lisp));
        this.Register(new LessThanPrimitive(this.f_lisp));
        this.Register(new LessThanOrEqualPrimitive(this.f_lisp));
        this.Register(new ListPrimitive(this.f_lisp));
        this.Register(new ListStarPrimitive(this.f_lisp));
        this.Register(new ListAllPackagesPrimitive(this.f_lisp));
        this.Register(new ListpPrimitive(this.f_lisp));
        this.Register(new LoadPrimitive(this.f_lisp));
        this.Register(new MakeHashTablePrimitive(this.f_lisp));
        this.Register(new MaxPrimitive(this.f_lisp));
        this.Register(new MemberPrimitive(this.f_lisp));
        this.Register(new MinPrimitive(this.f_lisp));
        this.Register(new NinthPrimitive(this.f_lisp));
        this.Register(new NotPrimitive(this.f_lisp));
        this.Register(new NreversePrimitive(this.f_lisp));
        this.Register(new NStringCapitalizePrimitive(this.f_lisp));
        this.Register(new NStringDowncasePrimitive(this.f_lisp));
        this.Register(new NStringUpcasePrimitive(this.f_lisp));
        this.Register(new NullPrimitive(this.f_lisp));
        this.Register(new NumberpPrimitive(this.f_lisp));
        this.Register(new PopPrimitive(this.f_lisp));
        this.Register(new PositionPrimitive(this.f_lisp));
        this.Register(new Prin1Primitive(this.f_lisp));
        this.Register(new PrincPrimitive(this.f_lisp));
        this.Register(new PrintPrimitive(this.f_lisp));
        this.Register(new PushPrimitive(this.f_lisp));
        this.Register(new QuotePrimitive(this.f_lisp));
        this.Register(new RadiansToDegreesPrimitive(this.f_lisp));
        this.Register(new RassocPrimitive(this.f_lisp));
        this.Register(new ReciprocalPrimitive(this.f_lisp));
        this.Register(new RemhashPrimitive(this.f_lisp));
        this.Register(new RemovePrimitive(this.f_lisp));
        this.Register(new RestPrimitive(this.f_lisp));
        this.Register(new ReversePrimitive(this.f_lisp));
        this.Register(new RplacaPrimitive(this.f_lisp));
        this.Register(new RplacdPrimitive(this.f_lisp));
        this.Register(new SecantPrimitive(this.f_lisp));
        this.Register(new SecondPrimitive(this.f_lisp));
        this.Register(new SetPrimitive(this.f_lisp));
        this.Register(new SetfSymbolFunctionPrimitive(this.f_lisp));
        this.Register(new SetfSymbolPlistPrimitive(this.f_lisp));
        this.Register(new SetfSymbolValuePrimitive(this.f_lisp));
        this.Register(new SetqPrimitive(this.f_lisp));
        this.Register(new SeventhPrimitive(this.f_lisp));
        this.Register(new SinePrimitive(this.f_lisp));
        this.Register(new SixthPrimitive(this.f_lisp));
        this.Register(new StringpPrimitive(this.f_lisp));
        this.Register(new SquareRootPrimitive(this.f_lisp));
        this.Register(new StringPrimitive(this.f_lisp));
        this.Register(new StringUpcasePrimitive(this.f_lisp));
        this.Register(new StringDowncasePrimitive(this.f_lisp));
        this.Register(new StringCapitalizePrimitive(this.f_lisp));
        this.Register(new StringEndsWithPrimitive(this.f_lisp));
        this.Register(new StringEqualPrimitive(this.f_lisp));
        this.Register(new StringEqPrimitive(this.f_lisp));
        this.Register(new StringNeqPrimitive(this.f_lisp));
        this.Register(new StringLessThanPrimitive(this.f_lisp));
        this.Register(new StringLesspPrimitive(this.f_lisp));
        this.Register(new StringGreaterThanPrimitive(this.f_lisp));
        this.Register(new StringGreaterpPrimitive(this.f_lisp));
        this.Register(new StringLessThanOrEqualPrimitive(this.f_lisp));
        this.Register(new StringGreaterThanOrEqualPrimitive(this.f_lisp));
        this.Register(new StringNotLesspPrimitive(this.f_lisp));
        this.Register(new StringNotGreaterpPrimitive(this.f_lisp));
        this.Register(new StringStartsWithPrimitive(this.f_lisp));
        this.Register(new StringTrimPrimitive(this.f_lisp));
        this.Register(new StringLeftTrimPrimitive(this.f_lisp));
        this.Register(new StringRightTrimPrimitive(this.f_lisp));
        this.Register(new SubstPrimitive(this.f_lisp));
        this.Register(new SymbolpPrimitive(this.f_lisp));
        this.Register(new SymbolFunctionPrimitive(this.f_lisp));
        this.Register(new SymbolNamePrimitive(this.f_lisp));
        this.Register(new SymbolPackagePrimitive(this.f_lisp));
        this.Register(new SymbolPlistPrimitive(this.f_lisp));
        this.Register(new SymbolValuePrimitive(this.f_lisp));
        this.Register(new TangentPrimitive(this.f_lisp));
        this.Register(new TenthPrimitive(this.f_lisp));
        this.Register(new ThirdPrimitive(this.f_lisp));
        this.Register(new TimePrimitive(this.f_lisp));
        this.Register(new TypeOfPrimitive(this.f_lisp));
        this.Register(new ZeropPrimitive(this.f_lisp));
        this.Register(new AddPrimitive(this.f_lisp));
        this.Register(new DividePrimitive(this.f_lisp));
        this.Register(new MultiplyPrimitive(this.f_lisp));
        this.Register(new SubtractPrimitive(this.f_lisp));
        this.Register(new AddOnePrimitive(this.f_lisp));
        this.Register(new SubtractOnePrimitive(this.f_lisp));
        this.Register(new TracePrimitive(this.f_lisp));
        this.Register(new GcPrimitive(this.f_lisp));
        this.Register(new GcFullPrimitive(this.f_lisp));
        this.Register(new FreePrimitive(this.f_lisp));
    }

    public void Register(LispPrimitive primitive) {
        this.f_lisp.EVAL.intern(primitive.LispFunctionNameString()).setf_symbol_function(this.f_lisp.makeList(this.PRIMITIVE, primitive));
    }

    public void WarnAboutSpecials(boolean value) {
        this.WarnAboutSpecialsP = value;
    }

    LispValue loc(long y, LispValue z) {
        if (y == 1L) {
            return z.car();
        }
        return this.loc(y - 1L, z.cdr());
    }

    LispValue getComponentAt(LispValue ij_indexes, LispValue valueList) {
        long i = ((LispInteger)ij_indexes.car()).getLongValue();
        long j = ((LispInteger)ij_indexes.cdr()).getLongValue();
        return this.loc(j, this.loc(i, valueList));
    }

    LispValue index2(LispValue e, LispValue n, long j) {
        if (n == this.f_lisp.NIL) {
            return n;
        }
        if (n.car() == e) {
            return this.f_lisp.makeInteger(j);
        }
        return this.index2(e, n.cdr(), j + 1L);
    }

    LispValue index_aux(LispValue e, LispValue n, long i) {
        if (n == this.f_lisp.NIL) {
            return n;
        }
        LispValue j = this.index2(e, n.car(), 1L);
        if (j == this.f_lisp.NIL) {
            return this.index_aux(e, n.cdr(), i + 1L);
        }
        return this.f_lisp.makeCons(this.f_lisp.makeInteger(i), j);
    }

    LispValue index(LispValue e, LispValue n) {
        return this.index_aux(e, n, 1L);
    }

    public LispValue compileArgsLeftToRight(LispValue args, LispValue valueList, LispValue code) throws CompilerException {
        if (args == this.f_lisp.NIL) {
            return code;
        }
        return this.compile(args.car(), valueList, this.compileArgsLeftToRight(args.cdr(), valueList, code));
    }

    public LispValue compileConstantArgsLeftToRight(SECDMachine machine, LispValue args, LispValue valueList, LispValue code) {
        if (args == this.f_lisp.NIL) {
            return code;
        }
        return this.f_lisp.makeCons(machine.LDC, this.f_lisp.makeCons(args.car(), this.compileConstantArgsLeftToRight(machine, args.cdr(), valueList, code)));
    }

    public LispValue quoteList(LispValue l) {
        if (l == this.f_lisp.NIL) {
            return l;
        }
        return this.f_lisp.makeCons(this.f_lisp.makeList(this.QUOTE, l.car()), this.quoteList(l.cdr()));
    }

    public LispValue compile(SECDMachine machine, LispValue expr, LispValue varValues) throws CompilerException {
        return this.compile(expr, varValues, (LispValue)this.f_lisp.makeCons(machine.STOP, this.f_lisp.NIL));
    }

    public LispValue compile(LispValue expr, LispValue valueList, LispValue code) throws CompilerException {
        if (expr.atom() == this.f_lisp.NIL) {
            return this.compileList(this.f_lisp.MACHINE, expr, valueList, code);
        }
        return this.compileAtom(this.f_lisp.MACHINE, expr, valueList, code);
    }

    LispValue compileAtom(SECDMachine machine, LispValue expr, LispValue valueList, LispValue code) throws CompilerException {
        if (expr == this.f_lisp.NIL) {
            return this.f_lisp.makeCons(machine.NIL, code);
        }
        if (expr == this.f_lisp.T) {
            return this.f_lisp.makeCons(machine.T, code);
        }
        if (expr.symbolp() == this.f_lisp.NIL || expr.keywordp() == this.f_lisp.T) {
            return this.f_lisp.makeCons(machine.LDC, this.f_lisp.makeCons(expr, code));
        }
        LispValue varIndex = this.index(expr, valueList);
        if (varIndex == this.f_lisp.NIL) {
            if (!expr.specialP() && this.WarnAboutSpecialsP) {
                System.err.print("\n;; ** Warning - " + ((Object)expr).toString() + " assumed special.\n");
            }
            return this.f_lisp.makeCons(machine.LD_GLOBAL, this.f_lisp.makeCons(expr, code));
        }
        return this.f_lisp.makeCons(machine.LD, this.f_lisp.makeCons(varIndex, code));
    }

    LispValue compileList(SECDMachine machine, LispValue expr, LispValue valueList, LispValue code) throws CompilerException {
        LispValue function = expr.car();
        LispValue args = expr.cdr();
        if (function.atom() == this.f_lisp.T) {
            if (this.BuiltinFunctionP(function)) {
                return this.compileBuiltin(machine, function, args, valueList, code);
            }
            if (this.SpecialFormP(function)) {
                return this.compileSpecialForm(machine, function, args, valueList, code);
            }
            LispValue defn = this.index(function, valueList);
            if (defn == this.f_lisp.NIL) {
                try {
                    defn = function.symbol_function();
                }
                catch (LispException e) {
                    defn = null;
                }
                if (defn == this.f_lisp.NIL || defn == null) {
                    throw new UndefinedFunctionException(((LispString)function.symbol_name()).getValue());
                }
            }
            if (defn.car().numberp() == this.f_lisp.T) {
                return this.compileApp(machine, args, valueList, this.f_lisp.makeCons(machine.LD, this.f_lisp.makeCons(defn, code.car() == machine.RTN ? this.f_lisp.makeCons(machine.DAP, code.cdr()) : this.f_lisp.makeCons(machine.AP, code))));
            }
            if (defn.car() == this.LAMBDA) {
                return this.compileApp(machine, args, valueList, this.compileLambda(machine, defn.cdr().cdr(), this.f_lisp.makeCons(defn.second(), valueList), code));
            }
            return this.f_lisp.makeCons(machine.DUM, this.f_lisp.makeCons(machine.LDFC, this.f_lisp.makeCons(function, this.f_lisp.makeCons(machine.NIL, this.f_lisp.makeCons(new ConsPrimitive(this.f_lisp), this.compileLambda(machine, expr, this.f_lisp.makeCons(this.f_lisp.makeCons(function, this.f_lisp.NIL), valueList), this.f_lisp.makeCons(machine.RAP, code)))))));
        }
        return this.compileApp(machine, args, valueList, this.compile(function, valueList, (LispValue)(code.car() == machine.RTN ? this.f_lisp.makeCons(machine.DAP, code.cdr()) : this.f_lisp.makeCons(machine.AP, code))));
    }

    LispValue compileSpecialForm(SECDMachine machine, LispValue function, LispValue args, LispValue valueList, LispValue code) throws CompilerException {
        if (function == this.PROGN) {
            return this.compileProgn(args, valueList, code);
        }
        if (function == this.LAMBDA) {
            return this.compileLambda(machine, this.f_lisp.makeCons(this.PROGN, args.cdr()), this.f_lisp.makeCons(args.car(), valueList), code);
        }
        if (function == this.DEFUN) {
            return this.compileDefun(machine, args.car(), args.cdr(), valueList, code);
        }
        if (function == this.AND) {
            return this.compileAnd(machine, args, valueList, code);
        }
        if (function == this.OR) {
            return this.compileOr(machine, args, valueList, code);
        }
        if (function == this.IF) {
            return this.compileIf(machine, args.first(), args.second(), args.third(), valueList, code);
        }
        if (function == this.WHEN) {
            return this.compileIf(machine, args.first(), this.f_lisp.makeList(this.PROGN, args.second()), this.f_lisp.NIL, valueList, code);
        }
        if (function == this.LET || function == this.LETREC) {
            LispValue vars = this.varsFromLetBindings(args.first());
            LispValue values = this.valuesFromLetBindings(args.first());
            LispCons newValues = this.f_lisp.makeCons(vars, valueList);
            LispCons body = this.f_lisp.makeCons(this.PROGN, args.cdr());
            if (function == this.LET) {
                return this.compileLet(machine, vars, values, valueList, body, code);
            }
            return this.f_lisp.makeCons(machine.DUM, this.compileApp(machine, values, newValues, this.compileLambda(machine, body, newValues, this.f_lisp.makeCons(machine.RAP, code))));
        }
        System.out.println("\n;; *** Compiler error in CompileAtom");
        return this.f_lisp.NIL;
    }

    public LispValue compileLet(SECDMachine machine, LispValue vars, LispValue values, LispValue valueList, LispValue body, LispValue code) throws CompilerException {
        LispConsOrNil specialVars = this.f_lisp.NIL;
        LispConsOrNil specialVals = this.f_lisp.NIL;
        LispConsOrNil localVars = this.f_lisp.NIL;
        LispConsOrNil localVals = this.f_lisp.NIL;
        LispValue varPtr = vars;
        LispValue valPtr = values;
        while (varPtr != this.f_lisp.NIL) {
            if (varPtr.car().specialP()) {
                specialVars = this.f_lisp.makeCons(varPtr.car(), specialVars);
                specialVals = this.f_lisp.makeCons(valPtr.car(), specialVals);
            } else {
                localVars = this.f_lisp.makeCons(varPtr.car(), localVars);
                localVals = this.f_lisp.makeCons(valPtr.car(), localVals);
            }
            varPtr = varPtr.cdr();
            valPtr = valPtr.cdr();
        }
        return this.compileApp(machine, localVals, valueList, this.compileSpecialBind(machine, specialVars, specialVals, valueList, this.compileLambda(machine, body, this.f_lisp.makeCons(localVars, valueList), this.f_lisp.makeCons(machine.AP, this.compileSpecialUnbind(machine, specialVars, code)))));
    }

    LispValue compileSpecialBind(SECDMachine machine, LispValue vars, LispValue values, LispValue valueList, LispValue code) throws CompilerException {
        if (vars == this.f_lisp.NIL) {
            return code;
        }
        return this.compile(values.car(), valueList, (LispValue)this.f_lisp.makeCons(machine.SP_BIND, this.f_lisp.makeCons(vars.car(), this.compileSpecialBind(machine, vars.cdr(), values.cdr(), valueList, code))));
    }

    LispValue compileSpecialUnbind(SECDMachine machine, LispValue vars, LispValue code) {
        if (vars == this.f_lisp.NIL) {
            return code;
        }
        return this.f_lisp.makeCons(machine.SP_UNBIND, this.f_lisp.makeCons(vars.car(), this.compileSpecialUnbind(machine, vars.cdr(), code)));
    }

    public LispValue varsFromLetBindings(LispValue varValueList) {
        if (varValueList == this.f_lisp.NIL) {
            return this.f_lisp.NIL;
        }
        if (varValueList.car().basic_consp()) {
            return this.f_lisp.makeCons(varValueList.car().car(), this.varsFromLetBindings(varValueList.cdr()));
        }
        return this.f_lisp.makeCons(varValueList.car(), this.varsFromLetBindings(varValueList.cdr()));
    }

    public LispValue valuesFromLetBindings(LispValue varValueList) {
        if (varValueList == this.f_lisp.NIL) {
            return this.f_lisp.NIL;
        }
        if (varValueList.car().basic_consp()) {
            return this.f_lisp.makeCons(varValueList.car().second(), this.valuesFromLetBindings(varValueList.cdr()));
        }
        return this.f_lisp.makeCons(this.f_lisp.NIL, this.valuesFromLetBindings(varValueList.cdr()));
    }

    boolean BuiltinFunctionP(LispValue fn) {
        if (fn.symbolp() != this.f_lisp.T || fn.fboundp() != this.f_lisp.T) {
            return false;
        }
        LispValue defn = fn.symbol_function();
        if (defn == null) {
            return false;
        }
        return defn.listp() == this.f_lisp.T && defn.first() == this.PRIMITIVE;
    }

    boolean SpecialFormP(LispValue fn) {
        return fn.symbolp() == this.f_lisp.T && (fn == this.AND || fn == this.DEFUN || fn == this.IF || fn == this.LET || fn == this.LAMBDA || fn == this.LETREC || fn == this.OR || fn == this.PROGN || fn == this.WHEN);
    }

    LispValue compileApp(SECDMachine machine, LispValue args, LispValue valueList, LispValue code) throws CompilerException {
        if (args == this.f_lisp.NIL) {
            return this.f_lisp.makeCons(machine.NIL, code);
        }
        return this.compile(args.car(), valueList, this.compileApp(machine, args.cdr(), valueList, this.f_lisp.makeCons(new ConsPrimitive(this.f_lisp), code)));
    }

    LispValue compileBuiltin(SECDMachine machine, LispValue fn, LispValue args, LispValue valueList, LispValue code) throws CompilerException {
        if (!((LispPrimitive)fn.symbol_function().second()).validArgumentList(args)) {
            throw new ArgumentCountMismatchException(((LispString)fn.symbol_name()).getValue(), ((LispPrimitive)fn.symbol_function().second()).parameterCountString(), ((LispInteger)args.length()).getLongValue());
        }
        return ((LispPrimitive)fn.symbol_function().second()).CompileArgs(this, machine, fn, args, valueList, code);
    }

    LispValue compileAnd(SECDMachine machine, LispValue args, LispValue valueList, LispValue code) throws CompilerException {
        if (args == this.f_lisp.NIL) {
            return this.f_lisp.makeCons(machine.T, code);
        }
        if (args.cdr() == this.f_lisp.NIL) {
            return this.compile(args.first(), valueList, code);
        }
        LispValue dummyVar = this.f_lisp.EVAL.intern("*AND-DUMMY-VAR*");
        dummyVar.set_special(true);
        return this.compile(this.f_lisp.makeList(this.LET, this.f_lisp.makeCons(this.f_lisp.makeList(dummyVar, args.first()), this.f_lisp.NIL), this.f_lisp.makeList(this.IF, dummyVar, this.compileAndAux(dummyVar, args.cdr()), this.f_lisp.NIL)), valueList, code);
    }

    LispValue compileAndAux(LispValue dummyVar, LispValue args) {
        if (args.cdr() == this.f_lisp.NIL) {
            return args.car();
        }
        return this.f_lisp.makeList(this.PROGN, this.f_lisp.makeList(this.SETQ, dummyVar, args.car()), this.f_lisp.makeList(this.IF, dummyVar, this.compileAndAux(dummyVar, args.cdr()), this.f_lisp.NIL));
    }

    LispValue compileOr(SECDMachine machine, LispValue args, LispValue valueList, LispValue code) throws CompilerException {
        if (args == this.f_lisp.NIL) {
            return this.f_lisp.makeCons(machine.NIL, code);
        }
        if (args.cdr() == this.f_lisp.NIL) {
            return this.compile(args.first(), valueList, code);
        }
        LispValue dummyVar = this.f_lisp.EVAL.intern("*OR-DUMMY-VAR*");
        dummyVar.set_special(true);
        return this.compile(this.f_lisp.makeList(this.LET, this.f_lisp.makeCons(this.f_lisp.makeList(dummyVar, args.first()), this.f_lisp.NIL), this.f_lisp.makeList(this.IF, dummyVar, dummyVar, this.compileOrAux(dummyVar, args.cdr()))), valueList, code);
    }

    LispValue compileOrAux(LispValue dummyVar, LispValue args) {
        if (args.cdr() == this.f_lisp.NIL) {
            return args.car();
        }
        return this.f_lisp.makeList(this.PROGN, this.f_lisp.makeList(this.SETQ, dummyVar, args.car()), this.f_lisp.makeList(this.IF, dummyVar, dummyVar, this.compileOrAux(dummyVar, args.cdr())));
    }

    LispValue compileDefun(SECDMachine machine, LispValue name, LispValue argsAndBody, LispValue valueList, LispValue code) throws CompilerException {
        name.setf_symbol_function(this.compileList(this.f_lisp.MACHINE, this.f_lisp.makeCons(this.LAMBDA, argsAndBody), this.f_lisp.makeCons(this.f_lisp.makeCons(name, this.f_lisp.NIL), valueList), this.f_lisp.makeCons(machine.STOP, this.f_lisp.NIL)).second());
        return this.compileList(this.f_lisp.MACHINE, this.f_lisp.makeCons(this.QUOTE, this.f_lisp.makeCons(name, this.f_lisp.NIL)), this.f_lisp.makeCons(this.f_lisp.makeCons(name, this.f_lisp.NIL), valueList), code);
    }

    LispValue compileIf(SECDMachine machine, LispValue test, LispValue thenExpr, LispValue elseExpr, LispValue valueList, LispValue code) throws CompilerException {
        if (code.car() == machine.RTN || code.car() == machine.STOP) {
            return this.compileOptimizedIf(machine, test, thenExpr, elseExpr, valueList, code);
        }
        return this.compile(test, valueList, (LispValue)this.f_lisp.makeCons(machine.SEL, this.f_lisp.makeCons(this.compile(thenExpr, valueList, (LispValue)this.f_lisp.makeCons(machine.JOIN, this.f_lisp.NIL)), this.f_lisp.makeCons(this.compile(elseExpr, valueList, (LispValue)this.f_lisp.makeCons(machine.JOIN, this.f_lisp.NIL)), code))));
    }

    LispValue compileOptimizedIf(SECDMachine machine, LispValue test, LispValue thenExpr, LispValue elseExpr, LispValue valueList, LispValue code) throws CompilerException {
        return this.compile(test, valueList, (LispValue)this.f_lisp.makeCons(machine.TEST, this.f_lisp.makeCons(this.compile(thenExpr, valueList, (LispValue)this.f_lisp.makeCons(code.car(), this.f_lisp.NIL)), this.compile(elseExpr, valueList, code))));
    }

    LispValue compileProgn(LispValue body, LispValue valueList, LispValue code) throws CompilerException {
        if (body == this.f_lisp.NIL) {
            return code;
        }
        return this.compile(body.car(), valueList, this.compileProgn(body.cdr(), valueList, code));
    }

    LispValue compileLambda(SECDMachine machine, LispValue body, LispValue valueList, LispValue code) throws CompilerException {
        return this.f_lisp.makeCons(machine.LDF, this.f_lisp.makeCons(this.compile(body, valueList, (LispValue)this.f_lisp.makeCons(machine.RTN, this.f_lisp.NIL)), code));
    }
}

