/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.ParaProfImageFormatFileFilter;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfImageOptionsPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ParaProfImageOutput {
    public void saveImage(ParaProfImageInterface paraProfImageInterface) {
        block16: {
            try {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Save Image File");
                jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
                FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
                for (int i = 0; i < fileFilterArray.length; ++i) {
                    jFileChooser.removeChoosableFileFilter(fileFilterArray[i]);
                }
                jFileChooser.addChoosableFileFilter(new ParaProfImageFormatFileFilter(ParaProfImageFormatFileFilter.PNG));
                jFileChooser.addChoosableFileFilter(new ParaProfImageFormatFileFilter(ParaProfImageFormatFileFilter.JPG));
                jFileChooser.setFileSelectionMode(0);
                ParaProfImageOptionsPanel paraProfImageOptionsPanel = new ParaProfImageOptionsPanel((Component)((Object)paraProfImageInterface));
                jFileChooser.setAccessory(paraProfImageOptionsPanel);
                jFileChooser.addPropertyChangeListener(paraProfImageOptionsPanel);
                int n = jFileChooser.showSaveDialog((Component)((Object)paraProfImageInterface));
                if (n == 0) {
                    System.out.println("Saving image ...");
                    File file = jFileChooser.getSelectedFile();
                    FileFilter fileFilter = jFileChooser.getFileFilter();
                    String string = file.getCanonicalPath();
                    ParaProfImageFormatFileFilter paraProfImageFormatFileFilter = null;
                    if (fileFilter instanceof ParaProfImageFormatFileFilter) {
                        paraProfImageFormatFileFilter = (ParaProfImageFormatFileFilter)fileFilter;
                        String string2 = ParaProfImageFormatFileFilter.getExtension(file);
                        if (string2 == null) {
                            string = string + "." + paraProfImageFormatFileFilter.getExtension();
                            file = new File(string);
                        } else if (!string2.equals("png") && !string2.equals("jpg")) {
                            string = string + "." + paraProfImageFormatFileFilter.getExtension();
                            file = new File(string);
                        }
                        Dimension dimension = paraProfImageInterface.getImageSize(paraProfImageOptionsPanel.isFullScreen(), paraProfImageOptionsPanel.isPrependHeader());
                        BufferedImage bufferedImage = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), 1);
                        Graphics2D graphics2D = bufferedImage.createGraphics();
                        graphics2D.setColor(Color.white);
                        graphics2D.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
                        graphics2D.setColor(Color.black);
                        if (paraProfImageOptionsPanel.isFullScreen()) {
                            paraProfImageInterface.renderIt(graphics2D, 2, paraProfImageOptionsPanel.isPrependHeader());
                        } else {
                            paraProfImageInterface.renderIt(graphics2D, 1, paraProfImageOptionsPanel.isPrependHeader());
                        }
                        ImageWriter imageWriter = null;
                        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(paraProfImageFormatFileFilter.getExtension().toUpperCase());
                        if (iterator.hasNext()) {
                            imageWriter = iterator.next();
                        }
                        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
                        imageWriter.setOutput(imageOutputStream);
                        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
                        if (paraProfImageOptionsPanel.imageQualityEnabled()) {
                            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                            imageWriteParam.setCompressionMode(2);
                            imageWriteParam.setCompressionQuality(paraProfImageOptionsPanel.getImageQuality());
                            System.out.println("Qulity is: " + imageWriteParam.getCompressionQuality());
                            imageWriter.write(null, iIOImage, imageWriteParam);
                        } else {
                            imageWriter.write(iIOImage);
                        }
                        System.out.println("Done saving image.");
                    } else if (UtilFncs.debug) {
                        System.out.println("Aborted saving image ... not a recognized type!");
                    }
                    break block16;
                }
                if (UtilFncs.debug) {
                    System.out.println("Did not get a file name to save image to.");
                }
                return;
            }
            catch (Exception exception) {
                UtilFncs.systemError((Object)exception, null, (String)"PPIO01");
            }
        }
    }
}

