/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.MappingDataWindow;
import edu.uoregon.tau.paraprof.MappingLedgerWindow;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.UserEventWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class MappingLedgerWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ParaProfImageInterface {
    private int xPanelSize = 300;
    private int yPanelSize = 400;
    private int barHeight = -1;
    private int barSpacing = -1;
    private ParaProfTrial trial = null;
    private MappingLedgerWindow mLWindow = null;
    private int windowType = -1;
    private Vector list = null;
    private JPopupMenu popup = new JPopupMenu();
    private Object clickedOnObject = null;
    private boolean debug = false;

    public MappingLedgerWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MLWP01");
        }
    }

    public MappingLedgerWindowPanel(ParaProfTrial paraProfTrial, MappingLedgerWindow mappingLedgerWindow, int n, boolean bl) {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.trial = paraProfTrial;
            this.mLWindow = mappingLedgerWindow;
            this.windowType = n;
            this.debug = bl;
            this.addMouseListener(this);
            JMenuItem jMenuItem = null;
            switch (n) {
                case 0: {
                    jMenuItem = new JMenuItem("Show Function Details");
                    jMenuItem.addActionListener(this);
                    this.popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Change Function Color");
                    jMenuItem.addActionListener(this);
                    this.popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Reset to Generic Color");
                    jMenuItem.addActionListener(this);
                    this.popup.add(jMenuItem);
                    break;
                }
                case 1: {
                    jMenuItem = new JMenuItem("Show Function Details");
                    jMenuItem.addActionListener(this);
                    this.popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Change Group Color");
                    jMenuItem.addActionListener(this);
                    this.popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Reset to Generic Color");
                    jMenuItem.addActionListener(this);
                    this.popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Show This Group Only");
                    jMenuItem.addActionListener(this);
                    this.popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Show All Groups Except This One");
                    jMenuItem.addActionListener(this);
                    this.popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Show All Groups");
                    jMenuItem.addActionListener(this);
                    this.popup.add(jMenuItem);
                    break;
                }
                case 2: {
                    jMenuItem = new JMenuItem("Show User Event Details");
                    jMenuItem.addActionListener(this);
                    this.popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Change User Event Color");
                    jMenuItem.addActionListener(this);
                    this.popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Reset to Generic Color");
                    jMenuItem.addActionListener(this);
                    this.popup.add(jMenuItem);
                }
            }
            this.repaint();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MLWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, 0, false);
        }
        catch (Exception exception) {
            System.out.println(exception);
            UtilFncs.systemError((Object)exception, null, (String)"TDWP03");
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (pageFormat.getOrientation() == 1) {
            System.out.println("PORTRAIT");
        } else if (pageFormat.getOrientation() == 0) {
            System.out.println("LANDSCAPE");
        }
        if (n >= 3) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        this.renderIt(graphics2D, 2, false);
        return 0;
    }

    public void renderIt(Graphics2D graphics2D, int n, boolean bl) {
        try {
            this.list = this.mLWindow.getData();
            int n2 = 0;
            int n3 = 0;
            boolean bl2 = false;
            int n4 = 0;
            this.trial.getPreferences().setBarDetails(graphics2D);
            this.barSpacing = this.trial.getPreferences().getBarSpacing();
            this.barHeight = this.trial.getPreferences().getBarHeight();
            Font font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            n2 = 5;
            n3 += this.barSpacing;
            Enumeration enumeration = this.list.elements();
            while (enumeration.hasMoreElements()) {
                GlobalMappingElement globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
                if (globalMappingElement.getMappingName() == null) continue;
                graphics2D.setColor(globalMappingElement.getColor());
                graphics2D.fillRect(n2, (n3 += this.barSpacing) - this.barHeight, this.barHeight, this.barHeight);
                if (this.windowType == 2) {
                    if (globalMappingElement.getMappingID() == this.trial.getColorChooser().getUserEventHightlightColorID()) {
                        graphics2D.setColor(this.trial.getColorChooser().getUserEventHightlightColor());
                        graphics2D.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                        graphics2D.drawRect(n2 + 1, n3 - this.barHeight + 1, this.barHeight - 2, this.barHeight - 2);
                    } else {
                        graphics2D.setColor(Color.black);
                        graphics2D.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                    }
                } else if (this.windowType == 1) {
                    if (globalMappingElement.getMappingID() == this.trial.getColorChooser().getGroupHighlightColorID()) {
                        graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                        graphics2D.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                        graphics2D.drawRect(n2 + 1, n3 - this.barHeight + 1, this.barHeight - 2, this.barHeight - 2);
                    } else {
                        graphics2D.setColor(Color.black);
                        graphics2D.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                    }
                } else if (globalMappingElement.getMappingID() == this.trial.getColorChooser().getHighlightColorID()) {
                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                    graphics2D.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                    graphics2D.drawRect(n2 + 1, n3 - this.barHeight + 1, this.barHeight - 2, this.barHeight - 2);
                } else {
                    graphics2D.setColor(Color.black);
                    graphics2D.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                }
                graphics2D.setColor(Color.black);
                String string = globalMappingElement.getMappingName();
                graphics2D.drawString(string, n2 += this.barHeight + 10, n3);
                int n5 = 5 + this.barHeight + fontMetrics.stringWidth(string);
                if (n4 < n5) {
                    n4 = n5 + 11;
                }
                if (n == 0) {
                    globalMappingElement.setDrawCoords(0, n5, n3 - this.barHeight, n3);
                }
                n2 -= this.barHeight + 10;
            }
            if ((n3 >= this.yPanelSize || n4 >= this.xPanelSize) && n == 0) {
                this.yPanelSize = n3 + 1;
                this.xPanelSize = n4 + 1;
                this.revalidate();
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MLWP03");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                        this.trial.getColorChooser().setHighlightColorID(globalMappingElement.getMappingID());
                        MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, globalMappingElement.getMappingID(), this.trial.getStaticMainWindow().getSMWData(), this.debug());
                        this.trial.getSystemEvents().addObserver(mappingDataWindow);
                        mappingDataWindow.show();
                    }
                } else if (string.equals("Show User Event Details")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                        this.trial.getColorChooser().setUserEventHighlightColorID(globalMappingElement.getMappingID());
                        UserEventWindow userEventWindow = new UserEventWindow(this.trial, globalMappingElement.getMappingID(), this.trial.getStaticMainWindow().getSMWData(), this.debug());
                        this.trial.getSystemEvents().addObserver(userEventWindow);
                        userEventWindow.show();
                    }
                } else if (string.equals("Change Function Color") || string.equals("Change User Event Color") || string.equals("Change Group Color")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                        Color color = globalMappingElement.getColor();
                        JColorChooser jColorChooser = new JColorChooser();
                        if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                            globalMappingElement.setSpecificColor(color);
                            globalMappingElement.setColorFlag(true);
                            this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                        }
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                        globalMappingElement.setColorFlag(false);
                        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Show This Group Only")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                        GlobalMapping globalMapping = this.trial.getGlobalMapping();
                        globalMapping.setSelectedGroupID(globalMappingElement.getMappingID());
                        globalMapping.setGroupFilter(1);
                        this.trial.getSystemEvents().updateRegisteredObjects("dataEvent");
                    }
                } else if (string.equals("Show All Groups Except This One")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                        GlobalMapping globalMapping = this.trial.getGlobalMapping();
                        globalMapping.setSelectedGroupID(globalMappingElement.getMappingID());
                        globalMapping.setGroupFilter(2);
                        this.trial.getSystemEvents().updateRegisteredObjects("dataEvent");
                    }
                } else if (string.equals("Show All Groups") && this.clickedOnObject instanceof GlobalMappingElement) {
                    GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    globalMapping.setSelectedGroupID(-1);
                    globalMapping.setGroupFilter(0);
                    this.trial.getSystemEvents().updateRegisteredObjects("dataEvent");
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MLWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            GlobalMappingElement globalMappingElement = null;
            Enumeration enumeration = this.list.elements();
            while (enumeration.hasMoreElements()) {
                globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
                if (n2 > globalMappingElement.getYEnd()) continue;
                if (n2 >= globalMappingElement.getYBeg() && n >= globalMappingElement.getXBeg() && n <= globalMappingElement.getXEnd()) {
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        this.clickedOnObject = globalMappingElement;
                        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                        return;
                    }
                    if (this.windowType == 2) {
                        if (this.trial.getColorChooser().getUserEventHightlightColorID() == -1) {
                            this.trial.getColorChooser().setUserEventHighlightColorID(globalMappingElement.getMappingID());
                        } else if (this.trial.getColorChooser().getUserEventHightlightColorID() != globalMappingElement.getMappingID()) {
                            this.trial.getColorChooser().setUserEventHighlightColorID(globalMappingElement.getMappingID());
                        } else {
                            this.trial.getColorChooser().setUserEventHighlightColorID(-1);
                        }
                    } else if (this.windowType == 1) {
                        if (this.trial.getColorChooser().getGroupHighlightColorID() == -1) {
                            this.trial.getColorChooser().setGroupHighlightColorID(globalMappingElement.getMappingID());
                        } else if (this.trial.getColorChooser().getGroupHighlightColorID() == globalMappingElement.getMappingID()) {
                            this.trial.getColorChooser().setGroupHighlightColorID(-1);
                        } else {
                            this.trial.getColorChooser().setGroupHighlightColorID(globalMappingElement.getMappingID());
                        }
                    } else if (this.trial.getColorChooser().getHighlightColorID() == -1) {
                        this.trial.getColorChooser().setHighlightColorID(globalMappingElement.getMappingID());
                    } else if (this.trial.getColorChooser().getHighlightColorID() == globalMappingElement.getMappingID()) {
                        this.trial.getColorChooser().setHighlightColorID(-1);
                    } else {
                        this.trial.getColorChooser().setHighlightColorID(globalMappingElement.getMappingID());
                    }
                    return;
                }
                return;
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MLWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        if (bl) {
            return this.getPreferredSize();
        }
        return this.mLWindow.getSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize + 10, this.yPanelSize + 10);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

