/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.ColorChooserFrame;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.SavedPreferences;
import java.awt.Color;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;

public class ColorChooser
implements WindowListener {
    private ParaProfTrial trial = null;
    private Vector colors = new Vector();
    private Vector groupColors = new Vector();
    private Color highlightColor = Color.red;
    private int highlightColorID = -1;
    private Color groupHighlightColor = new Color(0, 255, 255);
    private int groupHighlightColorID = -1;
    private Color userEventHighlightColor = new Color(255, 255, 0);
    private int userEventHighlightColorID = -1;
    private Color miscMappingsColor = Color.black;
    private boolean clrChooserFrameShowing = false;
    private ColorChooserFrame clrChooserFrame;

    public ColorChooser(ParaProfTrial paraProfTrial, SavedPreferences savedPreferences) {
        try {
            this.trial = paraProfTrial;
            if (savedPreferences != null) {
                this.colors = savedPreferences.getColors();
                this.groupColors = savedPreferences.getGroupColors();
                this.highlightColor = savedPreferences.getHighlightColor();
                this.groupHighlightColor = savedPreferences.getGroupHighlightColor();
                this.userEventHighlightColor = savedPreferences.getUserEventHightlightColor();
                this.miscMappingsColor = savedPreferences.getMiscMappingsColor();
            } else {
                this.setDefaultColors();
                this.setDefaultGroupColors();
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CC01");
        }
    }

    public void showColorChooser() {
        try {
            if (!this.clrChooserFrameShowing) {
                this.clrChooserFrame = new ColorChooserFrame(this.trial, this);
                this.clrChooserFrame.addWindowListener(this);
                this.clrChooserFrame.show();
                this.clrChooserFrameShowing = true;
            } else {
                this.clrChooserFrame.show();
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CC02");
        }
    }

    public void setSavedColors() {
        try {
            ParaProf.savedPreferences.setColors(this.colors);
            ParaProf.savedPreferences.setGroupColors(this.groupColors);
            ParaProf.savedPreferences.setHighlightColor(this.highlightColor);
            ParaProf.savedPreferences.setGroupHighlightColor(this.groupHighlightColor);
            ParaProf.savedPreferences.setMiscMappingsColor(this.miscMappingsColor);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CC03");
        }
    }

    public int getNumberOfColors() {
        int n = -1;
        try {
            n = this.colors.size();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CC04");
        }
        return n;
    }

    public int getNumberOfMappingGroupColors() {
        int n = -1;
        try {
            n = this.groupColors.size();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CC05");
        }
        return n;
    }

    public void addColor(Color color) {
        try {
            this.colors.add(color);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CC10");
        }
    }

    public void setColor(Color color, int n) {
        try {
            this.colors.setElementAt(color, n);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CC06");
        }
    }

    public Color getColor(int n) {
        Color color = null;
        try {
            color = (Color)this.colors.elementAt(n);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CC08");
        }
        return color;
    }

    public Vector getColors() {
        return this.colors;
    }

    public void addGroupColor(Color color) {
        try {
            this.groupColors.add(color);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CC11");
        }
    }

    public void setGroupColor(Color color, int n) {
        try {
            this.groupColors.setElementAt(color, n);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CC07");
        }
    }

    public Color getGroupColor(int n) {
        Color color = null;
        try {
            color = (Color)this.groupColors.elementAt(n);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CC09");
        }
        return color;
    }

    public Vector getGroupColors() {
        return this.groupColors;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColorID(int n) {
        this.highlightColorID = n;
        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public int getHighlightColorID() {
        return this.highlightColorID;
    }

    public void setGroupHighlightColor(Color color) {
        this.groupHighlightColor = color;
    }

    public Color getGroupHighlightColor() {
        return this.groupHighlightColor;
    }

    public void setGroupHighlightColorID(int n) {
        this.groupHighlightColorID = n;
        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public int getGroupHighlightColorID() {
        return this.groupHighlightColorID;
    }

    public void setUserEventHightlightColor(Color color) {
        this.userEventHighlightColor = color;
    }

    public Color getUserEventHightlightColor() {
        return this.userEventHighlightColor;
    }

    public void setUserEventHighlightColorID(int n) {
        this.userEventHighlightColorID = n;
        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public int getUserEventHightlightColorID() {
        return this.userEventHighlightColorID;
    }

    public void setMiscMappingsColor(Color color) {
        this.miscMappingsColor = color;
    }

    public Color getMiscMappingsColor() {
        return this.miscMappingsColor;
    }

    public void setDefaultColors() {
        try {
            this.colors.clear();
            this.addColor(new Color(61, 104, 63));
            this.addColor(new Color(102, 0, 51));
            this.addColor(new Color(0, 102, 102));
            this.addColor(new Color(0, 51, 255));
            this.addColor(new Color(102, 132, 25));
            this.addColor(new Color(119, 71, 145));
            this.addColor(new Color(221, 232, 30));
            this.addColor(new Color(70, 156, 168));
            this.addColor(new Color(255, 153, 0));
            this.addColor(new Color(0, 255, 0));
            this.addColor(new Color(121, 196, 144));
            this.addColor(new Color(86, 88, 112));
            this.addColor(new Color(151, 204, 255));
            this.addColor(new Color(102, 102, 255));
            this.addColor(new Color(204, 255, 51));
            this.addColor(new Color(255, 204, 153));
            this.addColor(new Color(204, 0, 204));
            this.addColor(new Color(0, 102, 102));
            this.addColor(new Color(204, 204, 255));
            this.addColor(new Color(102, 255, 255));
            this.addColor(new Color(255, 102, 102));
            this.addColor(new Color(255, 204, 204));
            this.addColor(new Color(240, 97, 159));
            this.addColor(new Color(0, 102, 153));
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CC12");
        }
    }

    public void setDefaultGroupColors() {
        try {
            this.groupColors.clear();
            this.addGroupColor(new Color(102, 0, 102));
            this.addGroupColor(new Color(51, 51, 0));
            this.addGroupColor(new Color(204, 0, 51));
            this.addGroupColor(new Color(0, 102, 102));
            this.addGroupColor(new Color(255, 255, 102));
            this.addGroupColor(new Color(0, 0, 102));
            this.addGroupColor(new Color(153, 153, 255));
            this.addGroupColor(new Color(255, 51, 0));
            this.addGroupColor(new Color(255, 153, 0));
            this.addGroupColor(new Color(255, 102, 102));
            this.addGroupColor(new Color(51, 0, 51));
            this.addGroupColor(new Color(255, 255, 102));
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CC13");
        }
    }

    public void setColors(GlobalMapping globalMapping, int n) {
        GlobalMappingElement globalMappingElement;
        Enumeration enumeration;
        int n2;
        if (n == -1 || n == 0) {
            n2 = this.getNumberOfColors();
            enumeration = globalMapping.getMapping(0).elements();
            while (enumeration.hasMoreElements()) {
                globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
                globalMappingElement.setColor(this.getColor(globalMappingElement.getMappingID() % n2));
            }
        }
        if (n == -1 || n == 1) {
            n2 = this.getNumberOfMappingGroupColors();
            enumeration = globalMapping.getMapping(1).elements();
            while (enumeration.hasMoreElements()) {
                globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
                globalMappingElement.setColor(this.getGroupColor(globalMappingElement.getMappingID() % n2));
            }
        }
        if (n == -1 || n == 2) {
            n2 = this.getNumberOfColors();
            enumeration = globalMapping.getMapping(2).elements();
            while (enumeration.hasMoreElements()) {
                globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
                globalMappingElement.setColor(this.getColor(globalMappingElement.getMappingID() % n2));
            }
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this.clrChooserFrame) {
            this.clrChooserFrameShowing = false;
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

