/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.SMWThreadDataElement;
import edu.uoregon.tau.paraprof.UserEventWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class UserEventWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ParaProfImageInterface {
    private String counterName = null;
    private int mappingID = -1;
    private String mappingName;
    GlobalMappingElement gME = null;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int baseBarLength = 250;
    private int barLength = 0;
    private int textOffset = 60;
    private int maxXLength = 0;
    private boolean groupMember = false;
    private ParaProfTrial trial = null;
    private UserEventWindow uEWindow = null;
    private Vector list = null;
    int xPanelSize = 0;
    int yPanelSize = 0;
    private JPopupMenu popup = new JPopupMenu();
    private int lastHeaderEndPosition = 0;
    private boolean debug = false;

    public UserEventWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP01");
        }
    }

    public UserEventWindowPanel(ParaProfTrial paraProfTrial, int n, UserEventWindow userEventWindow, boolean bl) {
        try {
            this.trial = paraProfTrial;
            this.uEWindow = userEventWindow;
            this.gME = paraProfTrial.getGlobalMapping().getGlobalMappingElement(n, 2);
            this.mappingName = this.gME.getMappingName();
            this.mappingID = n;
            this.debug = bl;
            this.barLength = this.baseBarLength;
            this.setBackground(Color.white);
            this.addMouseListener(this);
            JMenuItem jMenuItem = new JMenuItem("Change Userevnet Color");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Reset to Generic Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, 0, false);
        }
        catch (Exception exception) {
            System.out.println(exception);
            UtilFncs.systemError((Object)exception, null, (String)"TDWP03");
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (pageFormat.getOrientation() == 1) {
            System.out.println("PORTRAIT");
        } else if (pageFormat.getOrientation() == 0) {
            System.out.println("LANDSCAPE");
        }
        if (n >= 3) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        this.renderIt(graphics2D, 2, false);
        return 0;
    }

    public void renderIt(Graphics2D graphics2D, int n, boolean bl) {
        try {
            if (this.debug()) {
                System.out.println("####################################");
                System.out.println("UserEventWindowPanel.renderIt(...)");
                System.out.println("####################################");
            }
            this.list = this.uEWindow.getData();
            double d = 0.0;
            double d2 = 0.0;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.barLength + this.textOffset;
            SMWThreadDataElement sMWThreadDataElement = null;
            this.trial.getPreferences().setBarDetails(graphics2D);
            this.barSpacing = this.trial.getPreferences().getBarSpacing();
            this.barHeight = this.trial.getPreferences().getBarHeight();
            Font font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            switch (this.uEWindow.getValueType()) {
                case 12: {
                    d2 = this.gME.getMaxUserEventNumberValue();
                    break;
                }
                case 14: {
                    d2 = this.gME.getMaxUserEventMinValue();
                    break;
                }
                case 16: {
                    d2 = this.gME.getMaxUserEventMaxValue();
                    break;
                }
                case 18: {
                    d2 = this.gME.getMaxUserEventMeanValue();
                    break;
                }
                default: {
                    UtilFncs.systemError(null, null, (String)("Unexpected type - UEWP value: " + this.uEWindow.getValueType()));
                }
            }
            if (this.debug()) {
                System.out.println("Max value: " + d2);
            }
            if (this.resizePanel(fontMetrics, n4 += (n2 = fontMetrics.stringWidth(UtilFncs.getOutputString((int)0, (double)d2, (int)ParaProf.defaultNumberPrecision)))) && n == 0) {
                this.revalidate();
                return;
            }
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            if (n == 0 || n == 1) {
                if (n == 0) {
                    rectangle = graphics2D.getClipBounds();
                    n5 = (int)rectangle.getY();
                    n6 = (int)((double)n5 + rectangle.getHeight());
                } else {
                    rectangle2 = this.uEWindow.getViewRect();
                    n5 = (int)rectangle2.getY();
                    n6 = (int)((double)n5 + rectangle2.getHeight());
                }
                n7 = (n5 - n3) / this.barSpacing - 1;
                n8 = (n6 - n3) / this.barSpacing + 1;
                if (n7 < 0) {
                    n7 = 0;
                }
                if (n8 < 0) {
                    n8 = 0;
                }
                if (n7 > this.list.size() - 1) {
                    n7 = this.list.size() - 1;
                }
                if (n8 > this.list.size() - 1) {
                    n8 = this.list.size() - 1;
                }
                if (n == 0) {
                    n3 += n7 * this.barSpacing;
                }
            } else if (n == 2 || n == 3) {
                n7 = 0;
                n8 = this.list.size() - 1;
            }
            if (bl) {
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                Insets insets = this.getInsets();
                n3 += this.barSpacing;
                String string = this.uEWindow.getHeaderString();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
                while (stringTokenizer.hasMoreTokens()) {
                    AttributedString attributedString = new AttributedString(stringTokenizer.nextToken());
                    attributedString.addAttribute(TextAttribute.FONT, font);
                    AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                    float f = this.getSize().width - insets.left - insets.right;
                    float f2 = insets.left;
                    float f3 = insets.right;
                    while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                        TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                        textLayout.draw(graphics2D, f2, n3 += this.barSpacing);
                        f2 = insets.left;
                    }
                }
                this.lastHeaderEndPosition = n3;
            }
            int n9 = n7;
            while (n9 <= n8) {
                sMWThreadDataElement = (SMWThreadDataElement)this.list.elementAt(n9);
                switch (this.uEWindow.getValueType()) {
                    case 12: {
                        d = sMWThreadDataElement.getUserEventNumberValue();
                        break;
                    }
                    case 14: {
                        d = sMWThreadDataElement.getUserEventMinValue();
                        break;
                    }
                    case 16: {
                        d = sMWThreadDataElement.getUserEventMaxValue();
                        break;
                    }
                    case 18: {
                        d = sMWThreadDataElement.getUserEventMeanValue();
                        break;
                    }
                    default: {
                        UtilFncs.systemError(null, null, (String)("Unexpected type - UEWP value: " + this.uEWindow.getValueType()));
                    }
                }
                if (this.debug()) {
                    System.out.println("Value: " + d);
                }
                this.drawBar(graphics2D, fontMetrics, d, d2, "n,c,t " + sMWThreadDataElement.getNodeID() + "," + sMWThreadDataElement.getContextID() + "," + sMWThreadDataElement.getThreadID(), n4, n3 += this.barSpacing, this.barHeight, this.groupMember, n);
                ++n9;
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"UEWP03");
        }
    }

    private void drawBar(Graphics2D graphics2D, FontMetrics fontMetrics, double d, double d2, String string, int n, int n2, int n3, boolean bl, int n4) {
        int n5 = 0;
        double d3 = 0.0;
        String string2 = null;
        int n6 = 0;
        int n7 = 0;
        d3 = d / d2;
        n5 = (int)(d3 * (double)this.barLength);
        if (n5 == 0) {
            n5 = 1;
        }
        if (n5 > 2 && n3 > 2) {
            graphics2D.setColor(this.gME.getColor());
            graphics2D.fillRect(n - n5 + 1, n2 - n3 + 1, n5 - 1, n3 - 1);
            if (this.mappingID == this.trial.getColorChooser().getUserEventHightlightColorID()) {
                graphics2D.setColor(this.trial.getColorChooser().getUserEventHightlightColor());
                graphics2D.drawRect(n - n5, n2 - n3, n5, n3);
                graphics2D.drawRect(n - n5 + 1, n2 - n3 + 1, n5 - 2, n3 - 2);
            } else {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n - n5, n2 - n3, n5, n3);
            }
        } else {
            if (this.mappingID == this.trial.getColorChooser().getUserEventHightlightColorID()) {
                graphics2D.setColor(this.trial.getColorChooser().getUserEventHightlightColor());
            } else {
                graphics2D.setColor(this.gME.getColor());
            }
            graphics2D.fillRect(n - n5, n2 - n3, n5, n3);
        }
        graphics2D.setColor(Color.black);
        string2 = UtilFncs.getOutputString((int)0, (double)d, (int)ParaProf.defaultNumberPrecision);
        n6 = fontMetrics.stringWidth(string2);
        n7 = n - n5 - n6 - 5;
        graphics2D.drawString(string2, n7, n2);
        graphics2D.drawString(string, n + 5, n2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Change Function Color")) {
                    Color color = this.gME.getColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        this.gME.setSpecificColor(color);
                        this.gME.setColorFlag(true);
                        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    this.gME.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            if ((mouseEvent.getModifiers() & 0x10) == 0) {
                this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.uEWindow.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    public void changeInMultiples() {
        this.computeBarLength();
        this.repaint();
    }

    public void computeBarLength() {
        try {
            double d = this.uEWindow.getSliderValue();
            double d2 = this.uEWindow.getSliderMultiple();
            this.barLength = this.baseBarLength * (int)(d * d2);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP06");
        }
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n) {
        boolean bl = false;
        try {
            int n2 = (this.uEWindow.getData().size() + 2) * this.barSpacing + 10;
            int[] nArray = this.trial.getMaxNCTNumbers();
            String string = "n,c,t " + nArray[0] + "," + nArray[1] + "," + nArray[2];
            int n3 = n + 5 + fontMetrics.stringWidth(string) + 25;
            if (n2 != this.yPanelSize || n3 != this.xPanelSize) {
                this.yPanelSize = n2;
                this.xPanelSize = n3;
                this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
                bl = false;
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP07");
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

