/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.DataSession;
import edu.uoregon.tau.dms.dss.DataSessionIterator;
import edu.uoregon.tau.dms.dss.FileList;
import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.NCT;
import edu.uoregon.tau.dms.dss.ParaProfDataSession;
import edu.uoregon.tau.dms.dss.ParaProfObserver;
import edu.uoregon.tau.dms.dss.Trial;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.ColorChooser;
import edu.uoregon.tau.paraprof.Metric;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfTreeNodeUserObject;
import edu.uoregon.tau.paraprof.Preferences;
import edu.uoregon.tau.paraprof.StaticMainWindow;
import edu.uoregon.tau.paraprof.SystemEvents;
import java.awt.Component;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ParaProfTrial
extends Trial
implements ParaProfObserver,
ParaProfTreeNodeUserObject {
    int type = -1;
    boolean defaultTrial = false;
    ParaProfExperiment experiment = null;
    DefaultMutableTreeNode defaultMutableTreeNode = null;
    private TreePath treePath = null;
    private boolean dBTrial = false;
    private boolean upload = false;
    private boolean loading = false;
    private SystemEvents systemEvents = new SystemEvents();
    private StaticMainWindow sMW = null;
    private ColorChooser clrChooser = new ColorChooser(this, null);
    private Preferences preferences = new Preferences(this, null);
    private String path = null;
    private String pathReverse = null;
    private int selectedMetricID = 0;
    private Vector observers = new Vector();
    private boolean debug = UtilFncs.debug;

    public ParaProfTrial(int n) {
        super(0);
        this.setID(-1);
        this.setExperimentID(-1);
        this.setApplicationID(-1);
        this.setName("");
        this.type = n;
    }

    public ParaProfTrial(Trial trial, int n) {
        super(trial);
        this.type = n;
    }

    public void setExperiment(ParaProfExperiment paraProfExperiment) {
        this.experiment = paraProfExperiment;
    }

    public ParaProfExperiment getExperiment() {
        return this.experiment;
    }

    public void setDMTN(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.defaultMutableTreeNode = defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDMTN() {
        return this.defaultMutableTreeNode;
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public void setDBTrial(boolean bl) {
        this.dBTrial = bl;
    }

    public boolean dBTrial() {
        return this.dBTrial;
    }

    public void setDefaultTrial(boolean bl) {
        this.defaultTrial = bl;
    }

    public boolean defaultTrial() {
        return this.defaultTrial;
    }

    public void setUpload(boolean bl) {
        this.upload = bl;
    }

    public boolean upload() {
        return this.upload;
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
    }

    public boolean loading() {
        return this.loading;
    }

    public String getIDString() {
        if (this.experiment != null) {
            return this.experiment.getIDString() + ":" + super.getID();
        }
        return ":" + super.getID();
    }

    public ColorChooser getColorChooser() {
        return this.clrChooser;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public String getTrialIdentifier(boolean bl) {
        if (this.path != null) {
            if (bl) {
                return this.pathReverse;
            }
            return this.path;
        }
        return "Application " + this.getApplicationID() + ", Experiment " + this.getExperimentID() + ", Trial " + this.getID() + ".";
    }

    public void setPaths(String string) {
        this.path = string;
        this.pathReverse = FileList.getPathReverse((String)string);
    }

    public String getPath() {
        return this.path;
    }

    public String getPathReverse() {
        return this.pathReverse;
    }

    public String toString() {
        return super.getName();
    }

    public ParaProfDataSession getParaProfDataSession() {
        return (ParaProfDataSession)this.dataSession;
    }

    public void clearDefaultMutableTreeNodes() {
        this.setDMTN(null);
    }

    public StaticMainWindow getStaticMainWindow() {
        return this.sMW;
    }

    public void showMainWindow() {
        if (this.sMW == null) {
            this.sMW = new StaticMainWindow(this, UtilFncs.debug);
            ((Component)this.sMW).setVisible(true);
            this.getSystemEvents().addObserver(this.sMW);
        } else {
            this.getSystemEvents().addObserver(this.sMW);
            this.sMW.show();
        }
    }

    public void closeStaticMainWindow() {
        if (this.sMW != null) {
            this.getSystemEvents().deleteObserver(this.sMW);
            ((Component)this.sMW).setVisible(false);
        }
    }

    public SystemEvents getSystemEvents() {
        return this.systemEvents;
    }

    public void setSelectedMetricID(int n) {
        this.selectedMetricID = n;
    }

    public int getSelectedMetricID() {
        return this.selectedMetricID;
    }

    public boolean isTimeMetric() {
        String string = this.getMetricName(this.getSelectedMetricID());
        return (string = string.toUpperCase()).indexOf("TIME") != -1;
    }

    public boolean isDerivedMetric() {
        return this.getMetric(this.getSelectedMetricID()).getDerivedMetric();
    }

    public Vector getMetrics() {
        return this.dataSession.getMetrics();
    }

    public DataSessionIterator getMetricList() {
        return new DataSessionIterator(this.getMetrics());
    }

    public int getNumberOfMetrics() {
        return this.dataSession.getNumberOfMetrics();
    }

    public int getMetricID(String string) {
        return this.dataSession.getMetricID(string);
    }

    public Metric getMetric(int n) {
        return (Metric)this.dataSession.getMetric(n);
    }

    public String getMetricName(int n) {
        return this.dataSession.getMetricName(n);
    }

    public Metric addMetric() {
        Metric metric = new Metric();
        this.dataSession.addMetric((edu.uoregon.tau.dms.dss.Metric)metric);
        return metric;
    }

    public GlobalMapping getGlobalMapping() {
        return this.dataSession.getGlobalMapping();
    }

    public NCT getNCT() {
        return this.dataSession.getNCT();
    }

    public boolean groupNamesPresent() {
        return ((ParaProfDataSession)this.dataSession).groupNamesPresent();
    }

    public boolean userEventsPresent() {
        return ((ParaProfDataSession)this.dataSession).userEventsPresent();
    }

    public boolean callPathDataPresent() {
        return ((ParaProfDataSession)this.dataSession).callPathDataPresent();
    }

    public int[] getMaxNCTNumbers() {
        return ((ParaProfDataSession)this.dataSession).getMaxNCTNumbers();
    }

    public void setMeanData(int n, int n2) {
        ((ParaProfDataSession)this.dataSession).setMeanData(n, n2);
    }

    public void setMeanDataAllMetrics(int n, int n2) {
        ((ParaProfDataSession)this.dataSession).setMeanData(n, n2);
    }

    public void update(Object object) {
        try {
            DataSession dataSession = (DataSession)object;
            dataSession.terminate();
            this.clrChooser.setColors(dataSession.getGlobalMapping(), -1);
            int n = dataSession.getNumberOfMetrics();
            Vector<Metric> vector = new Vector<Metric>();
            int n2 = 0;
            while (n2 < n) {
                Metric metric = new Metric();
                metric.setName(dataSession.getMetricName(n2));
                metric.setID(n2);
                metric.setTrial(this);
                vector.add(metric);
                ++n2;
            }
            dataSession.setMetrics(vector);
            this.setDataSession(dataSession);
            this.setLoading(false);
            ParaProf.paraProfManager.populateTrialMetrics(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void update() {
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

