/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.MappingDataWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.SMWThreadDataElement;
import edu.uoregon.tau.paraprof.ThreadDataWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ThreadDataWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ParaProfImageInterface {
    private int xPanelSize = 640;
    private int yPanelSize = 480;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int baseBarLength = 250;
    private int barLength = 0;
    private int textOffset = 60;
    private int maxXLength = 0;
    private ParaProfTrial trial = null;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private ThreadDataWindow tDWindow = null;
    private int windowType = -1;
    private Thread thread = null;
    private Vector list = null;
    private JPopupMenu popup = new JPopupMenu();
    private Object clickedOnObject = null;
    private int lastHeaderEndPosition = 0;
    private boolean debug = false;

    public ThreadDataWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDWP01");
        }
    }

    public ThreadDataWindowPanel(ParaProfTrial paraProfTrial, int n, int n2, int n3, ThreadDataWindow threadDataWindow, int n4, boolean bl) {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.nodeID = n;
            this.contextID = n2;
            this.threadID = n3;
            this.trial = paraProfTrial;
            this.tDWindow = threadDataWindow;
            this.windowType = n4;
            this.debug = bl;
            this.barLength = this.baseBarLength;
            if (n4 == 1) {
                this.thread = paraProfTrial.getNCT().getThread(n, n2, n3);
            }
            JMenuItem jMenuItem = new JMenuItem("Show Function Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Change Function Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Reset to Generic Color");
            jMenuItem3.addActionListener(this);
            this.popup.add(jMenuItem3);
            this.repaint();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, 0, false);
        }
        catch (Exception exception) {
            System.out.println(exception);
            UtilFncs.systemError((Object)exception, null, (String)"TDWP03");
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (pageFormat.getOrientation() == 1) {
            System.out.println("PORTRAIT");
        } else if (pageFormat.getOrientation() == 0) {
            System.out.println("LANDSCAPE");
        }
        if (n >= 3) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        this.renderIt(graphics2D, 2, false);
        return 0;
    }

    public void renderIt(Graphics2D graphics2D, int n, boolean bl) {
        try {
            this.list = this.tDWindow.getData();
            double d = 0.0;
            double d2 = 0.0;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.barLength + this.textOffset;
            SMWThreadDataElement sMWThreadDataElement = null;
            if (this.list.size() == 0) {
                return;
            }
            this.trial.getPreferences().setBarDetails(graphics2D);
            this.barSpacing = this.trial.getPreferences().getBarSpacing();
            this.barHeight = this.trial.getPreferences().getBarHeight();
            Font font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            if (this.windowType == 0) {
                switch (this.tDWindow.getValueType()) {
                    case 2: {
                        if (this.tDWindow.isPercent()) {
                            d2 = this.trial.getGlobalMapping().getMaxMeanExclusivePercentValue(this.trial.getSelectedMetricID());
                            break;
                        }
                        d2 = this.trial.getGlobalMapping().getMaxMeanExclusiveValue(this.trial.getSelectedMetricID());
                        break;
                    }
                    case 4: {
                        if (this.tDWindow.isPercent()) {
                            d2 = this.trial.getGlobalMapping().getMaxMeanInclusivePercentValue(this.trial.getSelectedMetricID());
                            break;
                        }
                        d2 = this.trial.getGlobalMapping().getMaxMeanInclusiveValue(this.trial.getSelectedMetricID());
                        break;
                    }
                    case 6: {
                        d2 = this.trial.getGlobalMapping().getMaxMeanNumberOfCalls();
                        break;
                    }
                    case 8: {
                        d2 = this.trial.getGlobalMapping().getMaxMeanNumberOfSubRoutines();
                        break;
                    }
                    case 10: {
                        d2 = this.trial.getGlobalMapping().getMaxMeanUserSecPerCall(this.trial.getSelectedMetricID());
                        break;
                    }
                    default: {
                        UtilFncs.systemError(null, null, (String)("Unexpected type - MDWP value: " + this.tDWindow.getValueType()));
                        break;
                    }
                }
            } else {
                switch (this.tDWindow.getValueType()) {
                    case 2: {
                        if (this.tDWindow.isPercent()) {
                            d2 = this.thread.getMaxExclusivePercentValue(this.trial.getSelectedMetricID());
                            break;
                        }
                        d2 = this.thread.getMaxExclusiveValue(this.trial.getSelectedMetricID());
                        break;
                    }
                    case 4: {
                        if (this.tDWindow.isPercent()) {
                            d2 = this.thread.getMaxInclusivePercentValue(this.trial.getSelectedMetricID());
                            break;
                        }
                        d2 = this.thread.getMaxInclusiveValue(this.trial.getSelectedMetricID());
                        break;
                    }
                    case 6: {
                        d2 = this.thread.getMaxNumberOfCalls();
                        break;
                    }
                    case 8: {
                        d2 = this.thread.getMaxNumberOfSubRoutines();
                        break;
                    }
                    case 10: {
                        d2 = this.thread.getMaxUserSecPerCall(this.trial.getSelectedMetricID());
                        break;
                    }
                    default: {
                        UtilFncs.systemError(null, null, (String)("Unexpected type - MDWP value: " + this.tDWindow.getValueType()));
                    }
                }
            }
            if (this.tDWindow.isPercent()) {
                n2 = fontMetrics.stringWidth(UtilFncs.adjustDoublePresision((double)d2, (int)ParaProf.defaultNumberPrecision) + "%");
                n4 += n2;
            } else {
                n2 = fontMetrics.stringWidth(UtilFncs.getOutputString((int)this.tDWindow.units(), (double)d2, (int)ParaProf.defaultNumberPrecision));
                n4 += n2;
            }
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            if (n == 0 || n == 1) {
                if (n == 0) {
                    rectangle = graphics2D.getClipBounds();
                    n5 = (int)rectangle.getY();
                    n6 = (int)((double)n5 + rectangle.getHeight());
                } else {
                    rectangle2 = this.tDWindow.getViewRect();
                    n5 = (int)rectangle2.getY();
                    n6 = (int)((double)n5 + rectangle2.getHeight());
                }
                n7 = (n5 - n3) / this.barSpacing - 1;
                n8 = (n6 - n3) / this.barSpacing + 1;
                if (n7 < 0) {
                    n7 = 0;
                }
                if (n8 < 0) {
                    n8 = 0;
                }
                if (n7 > this.list.size() - 1) {
                    n7 = this.list.size() - 1;
                }
                if (n8 > this.list.size() - 1) {
                    n8 = this.list.size() - 1;
                }
                if (n == 0) {
                    n3 += n7 * this.barSpacing;
                }
            } else if (n == 2 || n == 3) {
                n7 = 0;
                n8 = this.list.size() - 1;
            }
            if (this.resizePanel(fontMetrics, n4, this.list, n7, n8) && n == 0) {
                this.revalidate();
                return;
            }
            if (bl) {
                n3 += this.barSpacing;
                String string = this.tDWindow.getHeaderString();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
                while (stringTokenizer.hasMoreTokens()) {
                    graphics2D.drawString(stringTokenizer.nextToken(), 15, n3);
                    n3 += this.barSpacing;
                }
                this.lastHeaderEndPosition = n3;
            }
            for (int i = n7; i <= n8; ++i) {
                sMWThreadDataElement = (SMWThreadDataElement)this.list.elementAt(i);
                if (this.windowType == 0) {
                    switch (this.tDWindow.getValueType()) {
                        case 2: {
                            if (this.tDWindow.isPercent()) {
                                d = sMWThreadDataElement.getMeanExclusivePercentValue();
                                break;
                            }
                            d = sMWThreadDataElement.getMeanExclusiveValue();
                            break;
                        }
                        case 4: {
                            if (this.tDWindow.isPercent()) {
                                d = sMWThreadDataElement.getMeanInclusivePercentValue();
                                break;
                            }
                            d = sMWThreadDataElement.getMeanInclusiveValue();
                            break;
                        }
                        case 6: {
                            d = sMWThreadDataElement.getMeanNumberOfCalls();
                            break;
                        }
                        case 8: {
                            d = sMWThreadDataElement.getMeanNumberOfSubRoutines();
                            break;
                        }
                        case 10: {
                            d = sMWThreadDataElement.getMeanUserSecPerCall();
                            break;
                        }
                        default: {
                            UtilFncs.systemError(null, null, (String)("Unexpected type - MDWP value: " + this.tDWindow.getValueType()));
                            break;
                        }
                    }
                } else {
                    switch (this.tDWindow.getValueType()) {
                        case 2: {
                            if (this.tDWindow.isPercent()) {
                                d = sMWThreadDataElement.getExclusivePercentValue();
                                break;
                            }
                            d = sMWThreadDataElement.getExclusiveValue();
                            break;
                        }
                        case 4: {
                            if (this.tDWindow.isPercent()) {
                                d = sMWThreadDataElement.getInclusivePercentValue();
                                break;
                            }
                            d = sMWThreadDataElement.getInclusiveValue();
                            break;
                        }
                        case 6: {
                            d = sMWThreadDataElement.getNumberOfCalls();
                            break;
                        }
                        case 8: {
                            d = sMWThreadDataElement.getNumberOfSubRoutines();
                            break;
                        }
                        case 10: {
                            d = sMWThreadDataElement.getUserSecPerCall();
                            break;
                        }
                        default: {
                            UtilFncs.systemError(null, null, (String)("Unexpected type - MDWP value: " + this.tDWindow.getValueType()));
                        }
                    }
                }
                this.drawBar(graphics2D, fontMetrics, d, d2, n4, n3 += this.barSpacing, this.barHeight, sMWThreadDataElement, n);
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDWP04");
        }
    }

    private void drawBar(Graphics2D graphics2D, FontMetrics fontMetrics, double d, double d2, int n, int n2, int n3, SMWThreadDataElement sMWThreadDataElement, int n4) {
        int n5 = 0;
        double d3 = 0.0;
        String string = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = sMWThreadDataElement.getMappingID();
        String string2 = sMWThreadDataElement.getMappingName();
        boolean bl = sMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGroupHighlightColorID());
        d3 = d / d2;
        n5 = (int)(d3 * (double)this.barLength);
        if (n5 == 0) {
            n5 = 1;
        }
        if (n5 > 2 && n3 > 2) {
            graphics2D.setColor(sMWThreadDataElement.getColor());
            graphics2D.fillRect(n - n5 + 1, n2 - n3 + 1, n5 - 1, n3 - 1);
            if (n8 == this.trial.getColorChooser().getHighlightColorID()) {
                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                graphics2D.drawRect(n - n5, n2 - n3, n5, n3);
                graphics2D.drawRect(n - n5 + 1, n2 - n3 + 1, n5 - 2, n3 - 2);
            } else if (bl) {
                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                graphics2D.drawRect(n - n5, n2 - n3, n5, n3);
                graphics2D.drawRect(n - n5 + 1, n2 - n3 + 1, n5 - 2, n3 - 2);
            } else {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n - n5, n2 - n3, n5, n3);
            }
        } else {
            if (n8 == this.trial.getColorChooser().getHighlightColorID()) {
                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
            } else if (bl) {
                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
            } else {
                graphics2D.setColor(sMWThreadDataElement.getColor());
            }
            graphics2D.fillRect(n - n5, n2 - n3, n5, n3);
        }
        graphics2D.setColor(Color.black);
        string = this.tDWindow.isPercent() && this.tDWindow.getValueType() <= 4 ? UtilFncs.adjustDoublePresision((double)d, (int)ParaProf.defaultNumberPrecision) + "%" : UtilFncs.getOutputString((int)this.tDWindow.units(), (double)d, (int)ParaProf.defaultNumberPrecision);
        n6 = fontMetrics.stringWidth(string);
        n7 = n - n5 - n6 - 5;
        graphics2D.drawString(string, n7, n2);
        graphics2D.drawString(string2, n + 5, n2);
        n6 = fontMetrics.stringWidth(string2);
        if (n4 == 0) {
            sMWThreadDataElement.setDrawCoords(n7, n + 5 + n6, n2 - n3, n2);
        }
    }

    public void changeInMultiples() {
        this.computeBarLength();
        this.repaint();
    }

    public void computeBarLength() {
        try {
            double d = this.tDWindow.getSliderValue();
            double d2 = this.tDWindow.getSliderMultiple();
            this.barLength = this.baseBarLength * (int)(d * d2);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP06");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            SMWThreadDataElement sMWThreadDataElement = null;
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                        this.trial.getColorChooser().setHighlightColorID(sMWThreadDataElement.getMappingID());
                        MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, sMWThreadDataElement.getMappingID(), this.tDWindow.getSMWData(), this.debug());
                        this.trial.getSystemEvents().addObserver(mappingDataWindow);
                        mappingDataWindow.show();
                    }
                } else if (string.equals("Change Function Color")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        int n = ((SMWThreadDataElement)this.clickedOnObject).getMappingID();
                        GlobalMapping globalMapping = this.trial.getGlobalMapping();
                        GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                        Color color = globalMappingElement.getColor();
                        new JColorChooser();
                        color = JColorChooser.showDialog(this, "Please select a new color", color);
                        if (color != null) {
                            globalMappingElement.setSpecificColor(color);
                            globalMappingElement.setColorFlag(true);
                            this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                        }
                    }
                } else if (string.equals("Reset to Generic Color") && this.clickedOnObject instanceof SMWThreadDataElement) {
                    int n = ((SMWThreadDataElement)this.clickedOnObject).getMappingID();
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                    globalMappingElement.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            SMWThreadDataElement sMWThreadDataElement = null;
            int n4 = n2 / this.trial.getPreferences().getBarSpacing();
            if (n4 < this.list.size()) {
                sMWThreadDataElement = (SMWThreadDataElement)this.list.elementAt(n4);
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    this.clickedOnObject = sMWThreadDataElement;
                    this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
                if (this.trial.getColorChooser().getHighlightColorID() == -1) {
                    this.trial.getColorChooser().setHighlightColorID(sMWThreadDataElement.getMappingID());
                } else if (this.trial.getColorChooser().getHighlightColorID() != sMWThreadDataElement.getMappingID()) {
                    this.trial.getColorChooser().setHighlightColorID(sMWThreadDataElement.getMappingID());
                } else {
                    this.trial.getColorChooser().setHighlightColorID(-1);
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getPreferredSize() : this.tDWindow.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n, Vector vector, int n2, int n3) {
        boolean bl = false;
        try {
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl2 = false;
            SMWThreadDataElement sMWThreadDataElement = null;
            for (int i = n2; i <= n3; ++i) {
                sMWThreadDataElement = (SMWThreadDataElement)vector.elementAt(i);
                n6 = n + 5 + fontMetrics.stringWidth(sMWThreadDataElement.getMappingName()) + 500;
                if (n6 <= n4) continue;
                n4 = n6;
            }
            n5 = this.barSpacing + (vector.size() + 1) * this.barSpacing;
            if (n5 != this.yPanelSize || n4 != this.xPanelSize) {
                this.yPanelSize = n5;
                this.xPanelSize = n4;
                this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
                bl = false;
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP07");
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

