/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.dynatype;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jatha.Jatha;
import org.jatha.dynatype.LispCons;
import org.jatha.dynatype.LispException;
import org.jatha.dynatype.LispPackage;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.LispValueNotAConsException;
import org.jatha.dynatype.LispValueNotAFunctionException;
import org.jatha.dynatype.LispValueNotAHashtableException;
import org.jatha.dynatype.LispValueNotAListException;
import org.jatha.dynatype.LispValueNotANumberException;
import org.jatha.dynatype.LispValueNotASequenceException;
import org.jatha.dynatype.LispValueNotASymbolException;
import org.jatha.dynatype.StandardLispCons;
import org.jatha.dynatype.StandardLispString;

public abstract class StandardLispValue
implements LispValue,
Comparable {
    protected Jatha f_lisp = null;

    public StandardLispValue() {
    }

    public StandardLispValue(Jatha lisp) {
        this.f_lisp = lisp;
    }

    public Jatha getLisp() {
        return this.f_lisp;
    }

    public void setLisp(Jatha lisp) {
        this.f_lisp = lisp;
    }

    public String internal_getName() {
        throw new LispValueNotASymbolException("The argument to internal_getName()");
    }

    public void internal_princ(PrintStream os) {
        os.print("#<unprintable object>");
    }

    public void internal_princ_as_cdr(PrintStream os) {
        os.print(" . ");
        this.internal_princ(os);
    }

    public void internal_prin1(PrintStream os) {
        os.print("#<unprintable object>");
    }

    public void internal_prin1_as_cdr(PrintStream os) {
        os.print(" . ");
        this.internal_prin1(os);
    }

    public void internal_print(PrintStream os) {
        System.err.print("#<unprintable object>");
    }

    public void internal_print_as_cdr(PrintStream os) {
        os.print(" . ");
        this.internal_print(os);
    }

    public void apropos_print(PrintWriter out) {
        System.err.print("** Internal error: apropos_print called on non-Symbol: #<unprintable object>");
    }

    public boolean basic_atom() {
        return false;
    }

    public boolean basic_bignump() {
        return false;
    }

    public boolean basic_consp() {
        return false;
    }

    public boolean basic_constantp() {
        return false;
    }

    public boolean basic_floatp() {
        return false;
    }

    public boolean basic_foreignp() {
        return false;
    }

    public boolean basic_integerp() {
        return false;
    }

    public boolean basic_functionp() {
        return false;
    }

    public boolean basic_keywordp() {
        return false;
    }

    public int basic_length() {
        throw new LispValueNotAListException("The argument to basic_length");
    }

    public boolean basic_listp() {
        return false;
    }

    public boolean basic_macrop() {
        return false;
    }

    public boolean basic_null() {
        return false;
    }

    public boolean basic_numberp() {
        return false;
    }

    public boolean basic_stringp() {
        return false;
    }

    public boolean basic_symbolp() {
        return false;
    }

    public boolean contains(LispValue object) {
        throw new LispValueNotAListException("The argument to contains");
    }

    public int compareTo(Object o) {
        if (o instanceof LispValue) {
            return this.toStringSimple().compareTo(((LispValue)o).toStringSimple());
        }
        return this.toStringSimple().compareTo(o);
    }

    public Iterator iterator() {
        return null;
    }

    public Object toJava() {
        return this.toStringSimple();
    }

    public Object toJava(String typeHint) {
        return this.toStringSimple();
    }

    public Collection toCollection() {
        ArrayList<StandardLispValue> result = new ArrayList<StandardLispValue>(1);
        result.add(this);
        return result;
    }

    public String toString() {
        return "<unprintable object>";
    }

    public String toStringSimple() {
        return this.toString();
    }

    public String toStringAsCdr() {
        StringBuffer buf = new StringBuffer();
        buf.append(" . ");
        buf.append(this.toString());
        return buf.toString();
    }

    public String toStringAsCdr_internal(long index) {
        if (index > this.f_lisp.getMaxListLength().getLongValue()) {
            System.err.println("Printing list...longer than *MAX-LIST-LENGTH*.  Truncated.");
            System.err.println("Next few items are: ");
            LispValue ptr = this;
            int i = 0;
            while (i < 10) {
                if (!(ptr instanceof LispCons)) break;
                System.err.println("    " + ptr.car());
                ptr = ptr.cdr();
                ++i;
            }
            return "...";
        }
        if (this instanceof LispCons) {
            StringBuffer buf = new StringBuffer();
            buf.append(" ");
            buf.append(this.car().toString());
            buf.append(this.cdr().toStringAsCdr_internal(index + 1L));
            return buf.toString();
        }
        return this.toStringAsCdr();
    }

    public void set_special(boolean value) {
        throw new LispValueNotASymbolException("The argument to set_special");
    }

    public boolean specialP() {
        throw new LispValueNotASymbolException("The argument to specialP");
    }

    public void adjustSpecialCount(int amount) {
        throw new LispValueNotASymbolException("The argument to adjustSpecialCount");
    }

    public int get_specialCount() {
        throw new LispValueNotASymbolException("The argument to get_specialCount");
    }

    public void setPackage(LispPackage newPackage) {
        System.err.println("\n*** INTERNAL ERROR: LispValue.setPackage() '" + this + "'" + " to " + newPackage);
    }

    public LispValue abs() {
        throw new LispValueNotANumberException("The first argument to ABS");
    }

    public LispValue acos() {
        throw new LispValueNotANumberException("The first argument to ACOS");
    }

    public LispValue asin() {
        throw new LispValueNotANumberException("The first argument to ASIN");
    }

    public LispValue atan() {
        throw new LispValueNotANumberException("The first argument to ATAN");
    }

    public LispValue atan2(LispValue x) {
        throw new LispValueNotANumberException("The first argument to ATAN2");
    }

    public LispValue append(LispValue otherList) {
        throw new LispValueNotAListException("The first argument to APPEND");
    }

    public LispValue apply(LispValue args) {
        throw new LispValueNotAFunctionException("The first argument to APPLY");
    }

    public LispValue assoc(LispValue index) {
        throw new LispValueNotAListException("The second argument to ASSOC");
    }

    public LispValue atom() {
        return this.f_lisp.NIL;
    }

    public LispValue bignump() {
        return this.f_lisp.NIL;
    }

    public LispValue boundp() {
        throw new LispValueNotASymbolException("The argument to BOUNDP");
    }

    public LispValue butlast() {
        throw new LispValueNotAListException("The argument to BUTLAST");
    }

    public LispValue car() {
        throw new LispValueNotAConsException("The argument to CAR");
    }

    public LispValue cdr() {
        throw new LispValueNotAConsException("The argument to CDR");
    }

    public LispValue ceiling() {
        throw new LispValueNotANumberException("The first argument to CEILING");
    }

    public LispValue characterp() {
        return this.f_lisp.NIL;
    }

    public LispValue clrhash() {
        throw new LispValueNotAHashtableException("The argument to CLRHASH");
    }

    public LispValue concatenate(LispValue value) {
        String first = null;
        first = this instanceof LispString ? this.toStringSimple() : this.toString();
        if (value instanceof LispString) {
            return new StandardLispString(this.f_lisp, first + value.toStringSimple());
        }
        return new StandardLispString(this.f_lisp, first + value.toString());
    }

    public LispValue consp() {
        return this.f_lisp.NIL;
    }

    public LispValue copy_list() {
        throw new LispValueNotAListException("The argument to COPY-LIST");
    }

    public LispValue copy() {
        return this;
    }

    public LispValue cos() {
        throw new LispValueNotANumberException("The argument to COS");
    }

    public LispValue cot() {
        throw new LispValueNotANumberException("The first argument to COT");
    }

    public LispValue csc() {
        throw new LispValueNotANumberException("The first argument to CSC");
    }

    public LispValue degreesToRadians() {
        throw new LispValueNotANumberException("The argument to DegreesToRadians");
    }

    public LispValue eighth() {
        throw new LispValueNotASequenceException("The first argument to EIGHTH");
    }

    public LispValue elt(int index) {
        throw new LispValueNotASequenceException("The first argument to ELT");
    }

    public LispValue elt(LispValue index) {
        throw new LispValueNotASequenceException("The first argument to ELT");
    }

    public LispValue eq(LispValue val) {
        if (this == val) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }

    public LispValue eql(LispValue val) {
        if (this == val) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }

    public LispValue equal(LispValue val) {
        if (this == val) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }

    public LispValue fboundp() {
        throw new LispValueNotASymbolException("The argument to FBOUNDP");
    }

    public LispValue floatp() {
        return this.f_lisp.NIL;
    }

    public LispValue fifth() {
        throw new LispValueNotASequenceException("The first argument to FIFTH");
    }

    public LispValue first() {
        throw new LispValueNotASequenceException("The first argument to FIRST");
    }

    public LispValue floor() {
        throw new LispValueNotANumberException("The first argument to FLOOR");
    }

    public LispValue fourth() {
        throw new LispValueNotASequenceException("The first argument to FOURTH");
    }

    public LispValue funcall(LispValue args) {
        throw new LispValueNotAFunctionException("The first argument to FUNCALL");
    }

    public LispValue gethash(LispValue key) {
        throw new LispValueNotAHashtableException("The second argument to GETHASH");
    }

    public LispValue gethash(LispValue key, LispValue defawlt) {
        throw new LispValueNotAHashtableException("The second argument to GETHASH");
    }

    public LispValue setf_gethash(LispValue key, LispValue value) {
        throw new LispValueNotAHashtableException("The second argument to SETF-GETHASH");
    }

    public LispValue hashtablep() {
        return this.f_lisp.NIL;
    }

    public LispValue hash_table_count() {
        throw new LispValueNotAHashtableException("The argument to HASH-TABLE-COUNT");
    }

    public LispValue hash_table_size() {
        throw new LispValueNotAHashtableException("The argument to HASH-TABLE-SIZE");
    }

    public LispValue hash_table_rehash_size() {
        throw new LispValueNotAHashtableException("The argument to HASH-TABLE-REHASH-SIZE");
    }

    public LispValue hash_table_rehash_threshold() {
        throw new LispValueNotAHashtableException("The argument to HASH-TABLE-REHASH-THRESHOLD");
    }

    public LispValue hash_table_test() {
        throw new LispValueNotAHashtableException("The argument to HASH-TABLE-TEST");
    }

    public LispValue integerp() {
        return this.f_lisp.NIL;
    }

    public LispValue keywordp() {
        return this.f_lisp.NIL;
    }

    public LispValue last() {
        throw new LispValueNotAListException("The argument to LAST");
    }

    public LispValue length() {
        throw new LispValueNotASequenceException("The argument to LENGTH");
    }

    public LispValue lisp_null() {
        return this.f_lisp.NIL;
    }

    public LispValue list() {
        return new StandardLispCons(this.f_lisp, this.f_lisp.NIL, this.f_lisp.NIL);
    }

    public LispValue listp() {
        return this.f_lisp.NIL;
    }

    public LispValue max(LispValue args) {
        throw new LispValueNotANumberException("One of the arguments to MAX");
    }

    public LispValue min(LispValue args) {
        throw new LispValueNotANumberException("One of the arguments to MIN");
    }

    public LispValue member(LispValue elt) {
        throw new LispValueNotAListException("The second argument to MEMBER");
    }

    public LispValue nconc(LispValue arg) {
        throw new LispValueNotAListException("The argument to NCONC");
    }

    public LispValue negate() {
        throw new LispValueNotANumberException("The argument to NEGATE");
    }

    public LispValue ninth() {
        throw new LispValueNotASequenceException("The first argument to NINTH");
    }

    public LispValue nreverse() {
        throw new LispValueNotAListException("The argument to NREVERSE");
    }

    public LispValue numberp() {
        return this.f_lisp.NIL;
    }

    public LispValue pop() {
        throw new LispValueNotASymbolException("The argument to POP");
    }

    public LispValue prin1() {
        this.internal_prin1(System.out);
        return this;
    }

    public LispValue princ() {
        this.internal_princ(System.out);
        return this;
    }

    public LispValue print() {
        System.out.println();
        this.internal_print(System.out);
        System.out.print(" ");
        return this;
    }

    public LispValue push(LispValue value) {
        throw new LispValueNotASymbolException("The second argument to PUSH");
    }

    public LispValue radiansToDegrees() {
        throw new LispValueNotANumberException("The argument to RadianstoDegrees");
    }

    public LispValue rassoc(LispValue index) {
        throw new LispValueNotAListException("The second argument to RASSOC");
    }

    public LispValue remhash(LispValue key) {
        throw new LispValueNotAHashtableException("The second argument to REMHASH");
    }

    public LispValue remove(LispValue elt) {
        throw new LispValueNotASequenceException("The second argument to REMOVE");
    }

    public LispValue rest() {
        throw new LispValueNotASequenceException("The argument to REST");
    }

    public LispValue reverse() {
        throw new LispValueNotASequenceException("The argument to REVERSE");
    }

    public LispValue rplaca(LispValue newCar) {
        throw new LispValueNotAListException("The first argument to RPLACA");
    }

    public LispValue rplacd(LispValue newCdr) {
        throw new LispValueNotAListException("The first argument to RPLACD");
    }

    public LispValue sec() {
        throw new LispValueNotANumberException("The first argument to SEC");
    }

    public LispValue second() {
        throw new LispValueNotASequenceException("The first argument to SECOND");
    }

    public LispValue setf_symbol_function(LispValue newFunction) {
        throw new LispValueNotASymbolException("The argument to SETF-SYMBOL-FUNCTION");
    }

    public LispValue setf_symbol_plist(LispValue newPlist) {
        throw new LispValueNotASymbolException("The argument to SETF-SYMBOL-PLIST");
    }

    public LispValue setf_symbol_value(LispValue newValue) {
        throw new LispValueNotASymbolException("The argument to SETF-SYMBOL-VALUE");
    }

    public LispValue setq(LispValue newValue) {
        throw new LispValueNotASymbolException("The argument to SETQ");
    }

    public LispValue seventh() {
        throw new LispValueNotASequenceException("The first argument to SEVENTH");
    }

    public LispValue sixth() {
        throw new LispValueNotASequenceException("The first argument to SIXTH");
    }

    public LispValue sin() {
        throw new LispValueNotANumberException("The argument to SIN");
    }

    public LispValue sqrt() {
        throw new LispValueNotANumberException("The argument to SQRT");
    }

    public LispValue stringp() {
        return this.f_lisp.NIL;
    }

    public LispValue subst(LispValue newValue, LispValue oldValue) {
        throw new LispValueNotAListException("The third argument to SUBST");
    }

    public LispValue substring(LispValue start) {
        throw new LispValueNotASequenceException("The operand of substring");
    }

    public LispValue substring(LispValue start, LispValue end) {
        throw new LispValueNotASequenceException("The operand of substring");
    }

    public LispValue symbolp() {
        return this.f_lisp.NIL;
    }

    public LispValue symbol_function() throws LispException {
        throw new LispValueNotASymbolException("The argument to SYMBOL_FUNCTION");
    }

    public LispValue symbol_name() {
        throw new LispValueNotASymbolException("The argument to SYMBOL_NAME");
    }

    public LispValue symbol_package() {
        throw new LispValueNotASymbolException("The argument to SYMBOL_PACKAGE");
    }

    public LispValue symbol_plist() {
        throw new LispValueNotASymbolException("The argument to SYMBOL_PLIST");
    }

    public LispValue symbol_value() throws LispException {
        throw new LispValueNotASymbolException("The argument to SYMBOL_VALUE");
    }

    public LispValue tan() {
        throw new LispValueNotANumberException("The argument to TAN");
    }

    public LispValue tenth() {
        throw new LispValueNotASequenceException("The first argument to TENTH");
    }

    public LispValue third() {
        throw new LispValueNotASequenceException("The first argument to THIRD");
    }

    public LispValue type_of() {
        return this.f_lisp.T;
    }

    public LispValue typep(LispValue type) {
        return this.f_lisp.NIL;
    }

    public LispValue zerop() {
        throw new LispValueNotANumberException("The argument to ZEROP");
    }

    public LispValue add(LispValue args) {
        throw new LispValueNotANumberException("An argument to + (add)");
    }

    public LispValue divide(LispValue args) {
        throw new LispValueNotANumberException("An argument to / (divide)");
    }

    public LispValue multiply(LispValue args) {
        throw new LispValueNotANumberException("An argument to * (multiply)");
    }

    public LispValue subtract(LispValue args) {
        throw new LispValueNotANumberException("An argument to - (subtract)");
    }

    public LispValue greaterThan(LispValue arg) {
        throw new LispValueNotANumberException("An argument to > (greater than)");
    }

    public LispValue greaterThanOrEqual(LispValue arg) {
        throw new LispValueNotANumberException("An argument to >= (greater than or equal)");
    }

    public LispValue lessThan(LispValue arg) {
        throw new LispValueNotANumberException("An argument to < (less than)");
    }

    public LispValue lessThanOrEqual(LispValue arg) {
        throw new LispValueNotANumberException("An argument to > (less than or equal)");
    }

    public LispValue equalNumeric(LispValue arg) {
        throw new LispValueNotANumberException("An argument to = (numeric equal)");
    }
}

