/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.dynatype;

import org.jatha.Jatha;
import org.jatha.dynatype.LispBignum;
import org.jatha.dynatype.LispConsOrNil;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispNumber;
import org.jatha.dynatype.LispReal;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.LispValueNotANumberException;
import org.jatha.dynatype.StandardLispAtom;
import org.jatha.dynatype.StandardLispReal;

public abstract class StandardLispNumber
extends StandardLispAtom
implements LispNumber {
    public StandardLispNumber() {
    }

    public StandardLispNumber(Jatha lisp) {
        super(lisp);
    }

    public boolean basic_constantp() {
        return true;
    }

    public boolean basic_numberp() {
        return true;
    }

    public abstract double getDoubleValue();

    public LispValue abs() {
        if (this.getDoubleValue() > 0.0) {
            return this;
        }
        return new StandardLispReal(this.f_lisp, this.getDoubleValue() * -1.0);
    }

    public LispValue degreesToRadians() {
        return new StandardLispReal(this.f_lisp, this.getDoubleValue() * Math.PI / 180.0);
    }

    public LispValue radiansToDegrees() {
        return new StandardLispReal(this.f_lisp, this.getDoubleValue() * 180.0 / Math.PI);
    }

    public LispValue max(LispValue args) {
        double maxValue = this.getDoubleValue();
        double otherValue = 0.0;
        boolean allIntegers = this instanceof LispInteger;
        LispValue arglist = args;
        if (!(arglist instanceof LispConsOrNil)) {
            arglist = this.f_lisp.makeList(arglist);
        }
        while (arglist != this.f_lisp.NIL) {
            LispValue arg = arglist.car();
            if (!arg.basic_numberp()) {
                super.max(arglist.car());
                return this.f_lisp.NIL;
            }
            if (allIntegers && !arg.basic_integerp()) {
                allIntegers = false;
            }
            if ((otherValue = ((LispNumber)arg).getDoubleValue()) > maxValue) {
                maxValue = otherValue;
            }
            arglist = arglist.cdr();
        }
        if (allIntegers) {
            return this.f_lisp.makeInteger((long)maxValue);
        }
        return this.f_lisp.makeReal(maxValue);
    }

    public LispValue min(LispValue args) {
        double minValue = this.getDoubleValue();
        double otherValue = 0.0;
        boolean allIntegers = this instanceof LispInteger;
        LispValue arglist = args;
        if (!(arglist instanceof LispConsOrNil)) {
            arglist = this.f_lisp.makeList(arglist);
        }
        while (arglist != this.f_lisp.NIL) {
            LispValue arg = arglist.car();
            if (!arg.basic_numberp()) {
                super.max(arglist.car());
                return this.f_lisp.NIL;
            }
            if (allIntegers && !arg.basic_integerp()) {
                allIntegers = false;
            }
            if ((otherValue = ((LispNumber)arg).getDoubleValue()) < minValue) {
                minValue = otherValue;
            }
            arglist = arglist.cdr();
        }
        if (allIntegers) {
            return this.f_lisp.makeInteger((long)minValue);
        }
        return this.f_lisp.makeReal(minValue);
    }

    public LispValue negate() {
        return this.subtract(this.f_lisp.NIL);
    }

    public LispValue numberp() {
        return this.f_lisp.T;
    }

    public LispValue add(LispValue args) {
        LispValue arglist;
        double d_sum = this.getDoubleValue();
        long l_sum = 0L;
        long l_addend = 0L;
        boolean allIntegers = this.basic_integerp();
        if (allIntegers) {
            l_sum = this.getLongValue();
        }
        if (!((arglist = args) instanceof LispConsOrNil)) {
            arglist = this.f_lisp.makeList(arglist);
        }
        while (arglist != this.f_lisp.NIL) {
            LispValue addend = arglist.car();
            if (!addend.basic_numberp()) {
                super.add(arglist.car());
                return this.f_lisp.NIL;
            }
            if (allIntegers && addend.basic_floatp()) {
                allIntegers = false;
                d_sum = l_sum;
            }
            if (allIntegers) {
                if (addend instanceof LispBignum) {
                    LispBignum bn_val = this.f_lisp.makeBignum(l_sum);
                    return bn_val.add(arglist);
                }
                l_addend = ((LispInteger)addend).getLongValue();
                if (l_sum > 0L && l_addend > 0L) {
                    if (Long.MAX_VALUE - l_sum < l_addend) {
                        LispBignum bn_val = this.f_lisp.makeBignum(l_sum);
                        return bn_val.add(arglist);
                    }
                } else if (l_sum < 0L && l_addend < 0L && Long.MIN_VALUE - l_sum > l_addend) {
                    LispBignum bn_val = this.f_lisp.makeBignum(l_sum);
                    return bn_val.add(arglist);
                }
            }
            if (allIntegers) {
                l_sum += l_addend;
            } else {
                d_sum = addend.basic_floatp() ? (d_sum += ((LispReal)addend).getDoubleValue()) : (addend.bignump() == this.f_lisp.T ? (d_sum += ((LispBignum)addend).getDoubleValue()) : (d_sum += (double)((LispInteger)addend).getLongValue()));
            }
            arglist = arglist.cdr();
        }
        if (allIntegers) {
            return this.f_lisp.makeInteger(l_sum);
        }
        return this.f_lisp.makeReal(d_sum);
    }

    public LispValue divide(LispValue args) {
        double d_quotient = 0.0;
        long l_quotient = 0L;
        boolean allIntegers = this.basic_integerp();
        int argCount = 1;
        LispValue arglist = null;
        if (!allIntegers) {
            d_quotient = this.getLongValue();
        } else {
            l_quotient = this.getLongValue();
        }
        arglist = args;
        if (!(arglist instanceof LispConsOrNil)) {
            arglist = this.f_lisp.makeList(arglist);
        }
        while (arglist != this.f_lisp.NIL) {
            LispValue term = arglist.car();
            if (!term.basic_numberp()) {
                super.divide(arglist.car());
                return this.f_lisp.NIL;
            }
            ++argCount;
            if (allIntegers && (term.basic_floatp() || term.bignump() == this.f_lisp.T)) {
                allIntegers = false;
                d_quotient = l_quotient;
            }
            if (term.zerop() == this.f_lisp.NIL) {
                if (!allIntegers) {
                    d_quotient = term.bignump() == this.f_lisp.T ? (d_quotient /= ((LispBignum)term).getDoubleValue()) : (term.basic_floatp() ? (d_quotient /= (double)((LispReal)term).getLongValue()) : (d_quotient /= (double)((LispInteger)term).getLongValue()));
                } else {
                    long term_value = ((LispInteger)term).getLongValue();
                    d_quotient = (double)l_quotient / (double)term_value;
                    if ((double)StrictMath.round(d_quotient) == d_quotient) {
                        l_quotient /= term_value;
                    } else {
                        allIntegers = false;
                    }
                }
            } else {
                System.out.print("\n;; *** ERROR: Attempt to divide by 0.\n");
                return this.f_lisp.NIL;
            }
            arglist = arglist.cdr();
        }
        if (argCount == 1) {
            if (allIntegers && l_quotient != 0L) {
                allIntegers = false;
                d_quotient = 1.0 / (double)l_quotient;
            } else if (!allIntegers && d_quotient != 0.0) {
                d_quotient = 1.0 / d_quotient;
            } else {
                System.out.print("\n;; *** ERROR: Attempt to divide by 0.\n");
                return this.f_lisp.NIL;
            }
        }
        if (allIntegers) {
            return this.f_lisp.makeInteger(l_quotient);
        }
        if (d_quotient == (double)((long)d_quotient)) {
            return this.f_lisp.makeInteger((long)d_quotient);
        }
        return this.f_lisp.makeReal(d_quotient);
    }

    public LispValue multiply(LispValue args) {
        LispValue arglist;
        double d_product = this.getDoubleValue();
        long l_product = 0L;
        long l_result = 0L;
        boolean allIntegers = this.basic_integerp();
        if (allIntegers) {
            l_product = this.getLongValue();
        }
        if (!((arglist = args) instanceof LispConsOrNil)) {
            arglist = this.f_lisp.makeList(arglist);
        }
        while (arglist != this.f_lisp.NIL) {
            LispValue term = arglist.car();
            if (!term.basic_numberp()) {
                super.multiply(arglist.car());
                return this.f_lisp.NIL;
            }
            if (allIntegers && term.basic_floatp()) {
                allIntegers = false;
                d_product = l_product;
            }
            if (allIntegers) {
                if (term instanceof LispBignum) {
                    LispBignum bn_val = this.f_lisp.makeBignum(l_product);
                    return bn_val.multiply(arglist);
                }
                long l_term = ((LispInteger)term).getLongValue();
                l_result = l_product * l_term;
                if (l_result / l_term != l_product) {
                    LispBignum bn_val = this.f_lisp.makeBignum(l_product);
                    return bn_val.multiply(arglist);
                }
            }
            if (allIntegers) {
                l_product = l_result;
            } else {
                d_product = term.basic_floatp() ? (d_product *= ((LispReal)term).getDoubleValue()) : (term.bignump() == this.f_lisp.T ? (d_product *= ((LispBignum)term).getDoubleValue()) : (d_product *= (double)((LispInteger)term).getLongValue()));
            }
            arglist = arglist.cdr();
        }
        if (allIntegers) {
            return this.f_lisp.makeInteger(l_product);
        }
        if (d_product == (double)((long)d_product)) {
            return this.f_lisp.makeInteger((long)d_product);
        }
        return this.f_lisp.makeReal(d_product);
    }

    public LispValue subtract(LispValue args) {
        LispValue arglist;
        double d_sum = -this.getDoubleValue();
        long l_sum = 0L;
        long l_addend = 0L;
        boolean allIntegers = this.basic_integerp();
        int argCount = 1;
        if (allIntegers) {
            l_sum = -this.getLongValue();
        }
        if (!((arglist = args) instanceof LispConsOrNil)) {
            arglist = this.f_lisp.makeList(arglist);
        }
        while (arglist != this.f_lisp.NIL) {
            LispValue addend = arglist.car();
            if (!addend.basic_numberp()) {
                super.subtract(arglist.car());
                return this.f_lisp.NIL;
            }
            if (allIntegers && addend.basic_floatp()) {
                allIntegers = false;
                d_sum = l_sum;
            }
            if (++argCount == 2) {
                l_sum = -l_sum;
                d_sum = -d_sum;
            }
            if (allIntegers) {
                if (addend instanceof LispBignum) {
                    LispBignum bn_val = this.f_lisp.makeBignum(l_sum);
                    return bn_val.subtract(arglist);
                }
                l_addend = ((LispInteger)addend).getLongValue();
                if (l_sum > 0L && l_addend < 0L) {
                    if (Long.MAX_VALUE + l_addend < l_sum) {
                        LispBignum bn_val = this.f_lisp.makeBignum(l_sum);
                        return bn_val.subtract(arglist);
                    }
                } else if (l_sum < 0L && l_addend > 0L && Long.MIN_VALUE + l_addend > l_sum) {
                    LispBignum bn_val = this.f_lisp.makeBignum(l_sum);
                    return bn_val.subtract(arglist);
                }
            }
            if (allIntegers) {
                l_sum -= l_addend;
            } else {
                d_sum = addend.basic_floatp() ? (d_sum -= ((LispReal)addend).getDoubleValue()) : (addend.bignump() == this.f_lisp.T ? (d_sum -= ((LispBignum)addend).getDoubleValue()) : (d_sum -= (double)((LispInteger)addend).getLongValue()));
            }
            arglist = arglist.cdr();
        }
        if (allIntegers) {
            return this.f_lisp.makeInteger(l_sum);
        }
        return this.f_lisp.makeReal(d_sum);
    }

    public LispValue acos() {
        return new StandardLispReal(this.f_lisp, 1.0 / StrictMath.acos(this.getDoubleValue()));
    }

    public LispValue asin() {
        return new StandardLispReal(this.f_lisp, 1.0 / StrictMath.asin(this.getDoubleValue()));
    }

    public LispValue atan() {
        return new StandardLispReal(this.f_lisp, 1.0 / StrictMath.atan(this.getDoubleValue()));
    }

    public LispValue atan2(LispValue x) {
        if (x instanceof LispNumber) {
            return new StandardLispReal(this.f_lisp, 1.0 / StrictMath.atan2(this.getDoubleValue(), ((LispNumber)x).getDoubleValue()));
        }
        throw new LispValueNotANumberException("The second argument to atan2 (" + x + ")");
    }

    public LispValue ceiling() {
        if (this instanceof LispInteger) {
            return this;
        }
        if (this.getDoubleValue() > 9.223372036854776E18) {
            return this.f_lisp.makeBignum(StrictMath.floor(this.getDoubleValue()));
        }
        return this.f_lisp.makeInteger((long)StrictMath.ceil(this.getDoubleValue()));
    }

    public LispValue cos() {
        return new StandardLispReal(this.f_lisp, StrictMath.cos(this.getDoubleValue()));
    }

    public LispValue cot() {
        return new StandardLispReal(this.f_lisp, 1.0 / StrictMath.tan(this.getDoubleValue()));
    }

    public LispValue csc() {
        return new StandardLispReal(this.f_lisp, 1.0 / StrictMath.sin(this.getDoubleValue()));
    }

    public LispValue floor() {
        if (this instanceof LispInteger) {
            return this;
        }
        if (this.getDoubleValue() > 9.223372036854776E18) {
            return this.f_lisp.makeBignum(StrictMath.floor(this.getDoubleValue()));
        }
        return this.f_lisp.makeInteger((long)Math.floor(this.getDoubleValue()));
    }

    public LispValue sec() {
        return new StandardLispReal(this.f_lisp, 1.0 / StrictMath.cos(this.getDoubleValue()));
    }

    public LispValue sin() {
        return new StandardLispReal(this.f_lisp, StrictMath.sin(this.getDoubleValue()));
    }

    public LispValue sqrt() {
        return new StandardLispReal(this.f_lisp, StrictMath.sqrt(this.getDoubleValue()));
    }

    public LispValue tan() {
        return new StandardLispReal(this.f_lisp, StrictMath.tan(this.getDoubleValue()));
    }

    public LispValue typep(LispValue type) {
        LispValue result = super.typep(type);
        if (result == this.f_lisp.T || type == this.f_lisp.NUMBER_TYPE) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }

    public LispValue greaterThan(LispValue arg) {
        if (arg instanceof LispNumber) {
            if (this.getDoubleValue() > ((LispNumber)arg).getDoubleValue()) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotANumberException("> " + arg);
    }

    public LispValue greaterThanOrEqual(LispValue arg) {
        if (arg instanceof LispNumber) {
            if (this.getDoubleValue() >= ((LispNumber)arg).getDoubleValue()) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotANumberException(">= " + arg);
    }

    public LispValue lessThan(LispValue arg) {
        if (arg instanceof LispNumber) {
            if (this.getDoubleValue() < ((LispNumber)arg).getDoubleValue()) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotANumberException("< " + arg);
    }

    public LispValue lessThanOrEqual(LispValue arg) {
        if (arg instanceof LispNumber) {
            if (this.getDoubleValue() <= ((LispNumber)arg).getDoubleValue()) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotANumberException("<= " + arg);
    }

    public LispValue equalNumeric(LispValue arg) {
        if (arg instanceof LispNumber) {
            if (this.getDoubleValue() == ((LispNumber)arg).getDoubleValue()) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotANumberException("= " + arg);
    }

    public LispValue eql(LispValue arg) {
        if (arg instanceof LispNumber) {
            return this.equalNumeric(arg);
        }
        return this.f_lisp.NIL;
    }
}

