/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.dynatype;

import java.util.Iterator;
import org.jatha.Jatha;
import org.jatha.dynatype.LispConsIterator;
import org.jatha.dynatype.LispConsOrNil;
import org.jatha.dynatype.LispIndexOutOfRangeException;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.LispValueNotAnIntegerException;
import org.jatha.dynatype.StandardLispCons;
import org.jatha.dynatype.StandardLispInteger;
import org.jatha.dynatype.StandardLispValue;

public abstract class StandardLispConsOrNil
extends StandardLispValue
implements LispConsOrNil {
    public StandardLispConsOrNil() {
    }

    public StandardLispConsOrNil(Jatha lisp) {
        super(lisp);
    }

    public boolean basic_consp() {
        return this != this.f_lisp.NIL;
    }

    public boolean basic_listp() {
        return true;
    }

    public LispValue butlast() {
        if (this.cdr().consp() != this.f_lisp.T) {
            return this.f_lisp.NIL;
        }
        return this.f_lisp.makeCons(this.car(), this.cdr().butlast());
    }

    public LispValue elt(LispValue index) {
        if (!index.basic_integerp()) {
            throw new LispValueNotAnIntegerException("to ELT");
        }
        long indexValue = ((LispInteger)index).getLongValue();
        if (indexValue < 0L || indexValue > ((LispInteger)this.length()).getLongValue() - 1L) {
            throw new LispIndexOutOfRangeException(String.valueOf(indexValue) + " to ELT");
        }
        LispValue element = this;
        int i = 0;
        while ((long)i < indexValue) {
            element = element.cdr();
            ++i;
        }
        return element.car();
    }

    public LispValue length() {
        long count = 0L;
        LispValue ptr = this;
        while (ptr != this.f_lisp.NIL) {
            ++count;
            ptr = ptr.cdr();
        }
        return new StandardLispInteger(this.f_lisp, count);
    }

    public LispValue listp() {
        return this.f_lisp.T;
    }

    public LispValue nconc(LispValue arg) {
        try {
            if (this == arg) {
                throw new Exception("nconc: attaching me to myself: " + arg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this == this.f_lisp.NIL) {
            return arg;
        }
        if (arg.basic_consp()) {
            this.last().rplacd(arg);
        }
        return this;
    }

    public LispValue nreverse() {
        LispValue head = this;
        LispValue next = this.cdr();
        LispConsOrNil result = this.f_lisp.NIL;
        while (head != this.f_lisp.NIL) {
            next = head.cdr();
            head.rplacd(result);
            result = head;
            head = next;
        }
        return result;
    }

    public LispValue pop() {
        return this;
    }

    public LispValue reverse() {
        LispConsOrNil result = this.f_lisp.NIL;
        LispValue p = this;
        while (p != this.f_lisp.NIL) {
            result = new StandardLispCons(this.f_lisp, p.car(), result);
            p = p.cdr();
        }
        return result;
    }

    public Iterator iterator() {
        return new LispConsIterator(this);
    }
}

