/*
 * Decompiled with CFR 0.152.
 */
package TauIL.util;

import TauIL.util.InstList;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class InstListWriter {
    private static final String BEGIN = "BEGIN_";
    private static final String END = "END_";
    private static final String LIST = "_LIST";
    private static final String FILE = "FILE_";
    private static final String HEADER = "# Selective insturmentation: Specify an exclude/include list.";
    private FileWriter fout;
    private BufferedWriter fbuf;

    public void writeList(InstList instList) throws IOException {
        this.fout = new FileWriter(instList.fname);
        this.fbuf = new BufferedWriter(this.fout);
        this.writeLine(HEADER);
        this.fbuf.newLine();
        String string = InstList.literals[instList.list_type].toUpperCase();
        this.write(BEGIN);
        this.write(FILE);
        this.write(string);
        this.writeLine(LIST);
        String[] stringArray = instList.file_list.toArray(new String[0]);
        int n = 0;
        while (n < stringArray.length) {
            this.writeLine(stringArray[n]);
            ++n;
        }
        this.write(END);
        this.write(FILE);
        this.write(string);
        this.writeLine(LIST);
        this.fbuf.newLine();
        this.fbuf.flush();
        this.write(BEGIN);
        this.write(string);
        this.writeLine(LIST);
        String[] stringArray2 = instList.event_list.toArray(new String[0]);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.writeLine(stringArray2[n2]);
            ++n2;
        }
        this.write(END);
        this.write(string);
        this.write(LIST);
        this.fbuf.flush();
        this.fbuf.close();
    }

    private void writeLine(String string) throws IOException {
        this.fbuf.write(string, 0, string.length());
        this.fbuf.newLine();
    }

    private void write(String string) throws IOException {
        this.fbuf.write(string, 0, string.length());
    }
}

