/*
 * Decompiled with CFR 0.152.
 */
package TauIL.interpreter;

import TauIL.absyn.AbstractSyntax;
import TauIL.absyn.AbstractSyntaxTree;
import TauIL.absyn.Declaration;
import TauIL.absyn.Directive;
import TauIL.absyn.Entity;
import TauIL.absyn.IncludeDec;
import TauIL.absyn.Instrumentation;
import TauIL.absyn.ListManager;
import TauIL.absyn.MultiStatement;
import TauIL.absyn.Operator;
import TauIL.absyn.OperatorStatement;
import TauIL.absyn.Statement;
import TauIL.absyn.SyntaxAttribute;
import TauIL.absyn.SyntaxElement;
import TauIL.absyn.SyntaxList;
import TauIL.interpreter.DataSource;
import TauIL.interpreter.ProfileDataSource;
import TauIL.util.InstList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class Interpreter {
    private AbstractSyntaxTree ast;
    private Vector list;
    private Vector[] global_exclude = new Vector[3];
    private Vector[] global_include = new Vector[3];
    private Vector[] local_exclude = new Vector[3];
    private Vector[] local_include = new Vector[3];
    private Vector[] include = new Vector[3];
    private Vector[] exclude = new Vector[3];
    private Vector[] condition_list = new Vector[3];
    private Vector[] anti_list = new Vector[3];
    private Vector[] current_list = new Vector[3];
    private Directive data_source;
    private Instrumentation scenario;
    private DataSource data;
    private int target = 1;
    private int count = 0;
    private boolean debug = false;
    private boolean verbose = false;
    private File empty_file = new File("tauIL_dev_null");
    private PrintStream dev_null;

    public Interpreter() {
        this.debug("Interpreter : Interpreter()");
        int n = 0;
        while (n <= 2) {
            this.global_exclude[n] = new Vector();
            this.global_include[n] = new Vector();
            this.local_include[n] = new Vector();
            this.local_exclude[n] = new Vector();
            ++n;
        }
        this.list = new Vector();
        this.ast = null;
    }

    public Interpreter(AbstractSyntaxTree abstractSyntaxTree) {
        this();
        this.debug("Interpreter : Interpreter(AbstractSyntaxTree)");
        this.ast = abstractSyntaxTree;
    }

    public void setAST(AbstractSyntaxTree abstractSyntaxTree) {
        this.debug("Interpreter : setAST(AbstractSyntaxTree)");
        this.ast = abstractSyntaxTree;
    }

    public AbstractSyntaxTree getAST() {
        this.debug("Interpreter : getAST()");
        return this.ast;
    }

    public int numberInstLists() {
        return this.list.size();
    }

    public Vector getInstLists() {
        return this.list;
    }

    public void setDebugMode(boolean bl) {
        this.debug = bl;
    }

    public void setVerboseMode(boolean bl) {
        this.verbose = bl;
    }

    public void interpret() throws Exception {
        this.debug("Interpreter : interpret()");
        if (this.ast == null) {
            throw new Error("AST is null!");
        }
        if (this.empty_file.exists()) {
            this.empty_file.delete();
        }
        this.empty_file.createNewFile();
        this.dev_null = new PrintStream(new FileOutputStream(this.empty_file));
        this.include = this.global_include;
        this.exclude = this.global_exclude;
        this.debug("Interpreting global declarations...");
        this.interpretList(this.ast.declarations);
        this.include = this.local_include;
        this.exclude = this.local_exclude;
        this.debug("Interpreting insturmentation scenarios...");
        this.interpretList(this.ast.root);
        this.dev_null.close();
        this.empty_file.delete();
    }

    private void interpretList(SyntaxList syntaxList) {
        this.debug("Interpreter : interpretList(SyntaxList)");
        ListManager listManager = new ListManager(syntaxList);
        while (listManager.hasNext()) {
            this.interpretAS(listManager.next());
        }
    }

    private void interpretAS(AbstractSyntax abstractSyntax) {
        this.debug("Interpreter : interpretAS(AbstractSyntax)");
        if (abstractSyntax == null) {
            return;
        }
        if (!(abstractSyntax instanceof SyntaxElement)) {
            if (abstractSyntax instanceof SyntaxAttribute) {
                throw new Error(abstractSyntax + " : Syntax attributes can not be interpreted!");
            }
            throw new Error(abstractSyntax + " : Unrecogonized abstract syntax element!");
        }
        this.interpretElem((SyntaxElement)abstractSyntax);
    }

    private void interpretElem(SyntaxElement syntaxElement) {
        this.debug("Interpreter : interpretElem(SyntaxElement)");
        if (syntaxElement == null) {
            return;
        }
        if (syntaxElement instanceof Declaration) {
            this.interpret((Declaration)syntaxElement);
        } else if (syntaxElement instanceof Statement) {
            this.interpret((Statement)syntaxElement);
        } else if (syntaxElement instanceof Directive) {
            this.interpret((Directive)syntaxElement);
        } else if (syntaxElement instanceof Instrumentation) {
            this.interpret((Instrumentation)syntaxElement);
        }
    }

    private void interpret(Declaration declaration) {
        this.debug("Interpreter : interpret(Declaration)");
        if (declaration == null) {
            return;
        }
        if (!(declaration instanceof IncludeDec)) {
            throw new Error(declaration + " : Unrecognized declaration class!");
        }
        this.interpret((IncludeDec)declaration);
    }

    private void interpret(Statement statement) {
        this.debug("Interpreter : interpret(Statement)");
        if (statement instanceof MultiStatement) {
            this.interpret((MultiStatement)statement);
        } else if (statement instanceof OperatorStatement) {
            throw new Error(statement + " : Operator statments must be contained within a mulitistatment!");
        }
    }

    private void interpret(Directive directive) {
        this.debug("Interpreter : interpret(Directive)");
        switch (directive.directive) {
            case 0: {
                if (directive.flag != 0) break;
                this.condition_list = this.local_include;
                this.anti_list = this.local_exclude;
                this.target = 0;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.data_source = directive;
                break;
            }
            default: {
                throw new Error(directive.directive + " : Unrecognized directive type!");
            }
        }
    }

    private void interpret(IncludeDec includeDec) {
        Vector vector;
        this.debug("Interpreter : interpret(IncludeDec)");
        switch (includeDec.include_flag) {
            case 0: {
                vector = this.include[includeDec.entity_flag];
                break;
            }
            case 1: {
                vector = this.exclude[includeDec.entity_flag];
                break;
            }
            default: {
                throw new Error(includeDec.include_flag + " : Unrecognized include declaration type!");
            }
        }
        ListManager listManager = new ListManager(includeDec.list);
        while (listManager.hasNext()) {
            Entity entity = (Entity)listManager.next();
            vector.add(entity.name);
        }
    }

    private void interpret(Instrumentation instrumentation) {
        this.debug("Interpreter : interpret(Instrumentation)");
        this.scenario = instrumentation;
        this.resetLocalLists();
        this.condition_list = this.local_exclude;
        this.anti_list = this.local_include;
        this.target = 1;
        switch (instrumentation.type) {
            case 0: {
                this.data_source = new Directive(2, 0, "pprof.dat");
                break;
            }
            case 1: {
                throw new Error(instrumentation.type + " : Sorry, no support for static data sources at this time!");
            }
            case 2: {
                throw new Error(instrumentation.type + " : Sorry, no support for runtime data sources at this time!");
            }
            default: {
                throw new Error(instrumentation.type + " : Unrecognized data source type!");
            }
        }
        this.debug("Interpreting instrumentation directives...");
        this.interpretList(instrumentation.directives);
        this.loadDataSource();
        this.debug("Interpreting instrumentation declarations...");
        this.interpretList(instrumentation.declarations);
        this.debug("Interpreting instrumentation conditions...");
        this.current_list = this.condition_list;
        this.interpretList(instrumentation.conditions);
        this.debug("Interpreting instrumentation anti-conditions...");
        this.current_list = this.anti_list;
        this.interpretList(instrumentation.anti_conditions);
        Vector vector = new Vector(this.condition_list[0]);
        Vector vector2 = new Vector(this.condition_list[1]);
        vector.removeAll(this.anti_list[0]);
        vector2.removeAll(this.anti_list[1]);
        this.list.add(new InstList(instrumentation.fname, vector, vector2, this.target));
        ++this.count;
    }

    private void interpret(MultiStatement multiStatement) {
        this.debug("Interpreter : interpret(MultiStatement)");
        this.info("__________________________________________________________________________________");
        this.info(multiStatement.generateSyntax());
        this.info("");
        ListManager listManager = new ListManager(multiStatement);
        while (this.data.hasNext()) {
            boolean bl = true;
            this.data.next();
            listManager.reset();
            while (listManager.hasNext() && bl) {
                bl = this.interpret((OperatorStatement)listManager.next());
            }
            if (!bl) continue;
            String string = this.data.getEventName();
            this.info("\t" + string);
            if (this.current_list[1].indexOf(string) != -1) continue;
            this.current_list[1].add(string);
        }
        this.data.reset();
    }

    private boolean interpret(OperatorStatement operatorStatement) {
        double d;
        this.debug("Interpreter : interpret(OperatorStatement)");
        ProfileDataSource profileDataSource = (ProfileDataSource)this.data;
        if (profileDataSource.isTimeMetric() && operatorStatement.field.metric == 1) {
            System.out.println("Counter metrics in rule, but profile contains timer metrics!");
            return false;
        }
        if (!profileDataSource.isTimeMetric() && operatorStatement.field.metric == 0) {
            System.out.println("Timer metrics in rule, but profile contains counter metrics!");
            return false;
        }
        switch (operatorStatement.field.field) {
            case 0: {
                d = profileDataSource.getNumCalls();
                break;
            }
            case 1: {
                d = profileDataSource.getNumSubRS();
                break;
            }
            case 2: {
                d = profileDataSource.getPercent();
                break;
            }
            case 3: {
                d = profileDataSource.getUsec();
                break;
            }
            case 6: {
                d = profileDataSource.getCount();
                break;
            }
            case 4: {
                d = profileDataSource.getCumUsec();
                break;
            }
            case 7: {
                d = profileDataSource.getTotCount();
                break;
            }
            case 9: {
                d = profileDataSource.getStdDev();
                break;
            }
            case 5: {
                d = profileDataSource.getUsecsPerCall();
                break;
            }
            case 8: {
                d = profileDataSource.getCountsPerCall();
                break;
            }
            default: {
                throw new Error(operatorStatement.field.field + " : Unrecognized field!");
            }
        }
        return this.evaluate(d, operatorStatement.op, operatorStatement.val.value);
    }

    private boolean evaluate(double d, Operator operator, double d2) {
        this.debug("Interpreter : evaluate(double, Operator, double)");
        switch (operator.op) {
            case 0: {
                return d == d2;
            }
            case 1: {
                return d < d2;
            }
            case 3: {
                return d > d2;
            }
            case 4: {
                return d >= d2;
            }
            case 2: {
                return d <= d2;
            }
            case 5: {
                return d != d2;
            }
        }
        return false;
    }

    private void loadDataSource() {
        this.debug("Interpreter : loadDataSource()");
        switch (this.data_source.flag) {
            case 0: {
                break;
            }
            case 1: {
                throw new Error(this.data_source.flag + " : Database data sources are not supported at this time!");
            }
            default: {
                throw new Error(this.data_source.flag + " : Unrecognized data source use type!");
            }
        }
        switch (this.scenario.type) {
            case 0: {
                this.data = new ProfileDataSource(this.data_source.arg);
                break;
            }
        }
        PrintStream printStream = System.out;
        System.setOut(this.dev_null);
        this.data.load();
        System.setOut(printStream);
    }

    private void resetLocalLists() {
        this.debug("Interpreter : resetLocalLists()");
        int n = 0;
        while (n <= 2) {
            this.local_exclude[n].clear();
            this.local_include[n].clear();
            this.local_exclude[n].addAll(this.global_exclude[n]);
            this.local_include[n].addAll(this.global_include[n]);
            ++n;
        }
    }

    private void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    private void info(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }
}

