/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.ParaProfObserver;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.ApplicationManager;
import edu.uoregon.tau.paraprof.FileList;
import edu.uoregon.tau.paraprof.HelpWindow;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfLisp;
import edu.uoregon.tau.paraprof.ParaProfManager;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.SavedPreferences;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.Vector;
import javax.swing.Timer;
import javax.swing.UIManager;

public class ParaProf
implements ParaProfObserver,
ActionListener {
    static String homeDirectory = null;
    static File paraProfHomeDirectory = null;
    static String profilePathName = null;
    static int defaultNumberPrecision = 4;
    static boolean dbSupport = false;
    static ParaProfLisp paraProfLisp = null;
    static SavedPreferences savedPreferences = new SavedPreferences();
    static ParaProfManager paraProfManager = new ParaProfManager();
    static ApplicationManager applicationManager = new ApplicationManager();
    static HelpWindow helpWindow = new HelpWindow(UtilFncs.debug);
    private static String USAGE = "ParaProf/ParaProf (help | debug)";
    static Runtime runtime;
    static boolean runHasBeenOpened;
    private int type = -1;
    private boolean dump = false;
    private int dumptype = -1;
    String filePrefix = null;

    public ParaProf() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startSystem() {
        try {
            Object object;
            Object object2;
            paraProfHomeDirectory = new File(homeDirectory + "/.ParaProf");
            if (paraProfHomeDirectory.exists()) {
                System.out.println("Found ParaProf home directory!");
                System.out.println("Looking for preferences ...");
                try {
                    object2 = new FileInputStream(paraProfHomeDirectory.getPath() + "/ParaProf.dat");
                    object = new ObjectInputStream((InputStream)object2);
                    savedPreferences = (SavedPreferences)((ObjectInputStream)object).readObject();
                }
                catch (Exception exception) {
                    if (exception instanceof FileNotFoundException) {
                        System.out.println("No preference file present, using defaults!");
                    }
                    System.out.println("There was an internal error whilst trying to read the ParaProf preference");
                    System.out.println("file.  Please delete this file, or replace it with a valid one!");
                    System.out.println("Note: Deleting the file will cause ParaProf to restore the default preferences");
                }
                object2 = new File(paraProfHomeDirectory.getPath() + "/perfdmf.cfg");
                if (((File)object2).exists()) {
                    System.out.println("Found db configuration file: " + paraProfHomeDirectory.getPath() + "/perfdmf.cfg");
                    savedPreferences.setDatabaseConfigurationFile(paraProfHomeDirectory.getPath() + "/perfdmf.cfg");
                } else {
                    System.out.println("Did not find db configuration file ... load manually");
                }
            } else {
                System.out.println("Did not find ParaProf home directory ... creating ...");
                paraProfHomeDirectory.mkdir();
                System.out.println("Done creating ParaProf home directory!");
            }
            paraProfLisp = new ParaProfLisp(UtilFncs.debug);
            paraProfLisp.registerParaProfPrimitives();
            object2 = applicationManager.addApplication();
            object2.setName("Default App");
            object = ((ParaProfApplication)object2).addExperiment();
            object.setName("Default Exp");
            ParaProfTrial paraProfTrial = null;
            FileList fileList = new FileList();
            Vector vector = null;
            if (this.type != -1) {
                switch (this.type) {
                    case 0: {
                        if (this.filePrefix == null) {
                            vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, this.type, "pprof", UtilFncs.debug);
                            break;
                        }
                        vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, this.type, this.filePrefix, UtilFncs.debug);
                        break;
                    }
                    case 1: {
                        if (this.filePrefix == null) {
                            vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, this.type, "profile", UtilFncs.debug);
                            break;
                        }
                        vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, this.type, this.filePrefix, UtilFncs.debug);
                        break;
                    }
                    case 2: {
                        vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, this.type, this.filePrefix, UtilFncs.debug);
                        break;
                    }
                    case 5: {
                        if (this.filePrefix == null) {
                            vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, this.type, "gprof", UtilFncs.debug);
                            break;
                        }
                        vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, this.type, this.filePrefix, UtilFncs.debug);
                        break;
                    }
                    default: {
                        vector = new Vector();
                        System.out.println("Unrecognized file type.");
                        System.out.println("Use ParaProf's manager window to load them manually.");
                    }
                }
                if (vector.size() > 0) {
                    paraProfTrial = new ParaProfTrial(null, this.type);
                    paraProfTrial.addObserver(this);
                    paraProfTrial.setName("Default Trial");
                    paraProfTrial.setDefaultTrial(true);
                    paraProfTrial.setPaths(fileList.getPath());
                    ((ParaProfExperiment)object).addTrial(paraProfTrial);
                    paraProfTrial.setLoading(true);
                    paraProfTrial.initialize(vector);
                } else {
                    System.out.println("No profile files found in the current directory.");
                    System.out.println("Use ParaProf's manager window to load them manually.");
                }
            } else {
                vector = this.filePrefix == null ? fileList.getFileList(new File(System.getProperty("user.dir")), null, 0, "pprof", UtilFncs.debug) : fileList.getFileList(new File(System.getProperty("user.dir")), null, 0, this.filePrefix, UtilFncs.debug);
                if (vector.size() > 0) {
                    paraProfTrial = new ParaProfTrial(null, 0);
                    paraProfTrial.addObserver(this);
                    paraProfTrial.setName("Default Trial");
                    paraProfTrial.setDefaultTrial(true);
                    paraProfTrial.setPaths(fileList.getPath());
                    ((ParaProfExperiment)object).addTrial(paraProfTrial);
                    paraProfTrial.setLoading(true);
                    paraProfTrial.initialize(vector);
                } else {
                    vector = this.filePrefix == null ? fileList.getFileList(new File(System.getProperty("user.dir")), null, 1, "profile", UtilFncs.debug) : fileList.getFileList(new File(System.getProperty("user.dir")), null, 1, this.filePrefix, UtilFncs.debug);
                    if (vector.size() > 0) {
                        paraProfTrial = new ParaProfTrial(null, 1);
                        paraProfTrial.addObserver(this);
                        paraProfTrial.setName("Default Trial");
                        paraProfTrial.setDefaultTrial(true);
                        paraProfTrial.setPaths(fileList.getPath());
                        ((ParaProfExperiment)object).addTrial(paraProfTrial);
                        paraProfTrial.setLoading(true);
                        paraProfTrial.initialize(vector);
                    } else {
                        System.out.println("No profile files found in the current directory.");
                        System.out.println("Use ParaProf's manager window to load them manually.");
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("An un-caught exception has occurred within the program!");
            System.out.println("The details of this execption has been stored in a file named: exception.err");
            System.out.println("Please email this file to Robert Bell at bertie@cs.uoregon.edu ");
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Timer) {
            System.out.println("------------------------");
            System.out.println("The amount of memory used by the system is: " + runtime.totalMemory());
            System.out.println("The amount of memory free to the system is: " + runtime.freeMemory());
        }
    }

    public void update(Object object) {
        ParaProfTrial paraProfTrial = (ParaProfTrial)object;
        paraProfTrial.showMainWindow();
        try {
            FileInputStream fileInputStream = new FileInputStream("ParaProfLisp.lp");
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                System.out.println("Expression: " + string);
                System.out.println(paraProfLisp.eval(string));
            }
        }
        catch (Exception exception) {
            if (exception instanceof FileNotFoundException) {
                System.out.println("No ParaProfLisp.lp file present!");
            }
            System.out.println("There was an internal error whilst trying to read the ParaProfLisp.pl");
            System.out.println("Please delete this file, or replace it with a valid one!");
        }
    }

    public void update() {
    }

    public static String getInfoString() {
        return new String("ParaProf Version 2.0 ... The Tau Group!");
    }

    public static void main(String[] stringArray) {
        System.out.println("");
        homeDirectory = System.getProperty("user.home");
        ParaProf paraProf = new ParaProf();
        int n = 0;
        String string = null;
        while (n < stringArray.length) {
            if (!(string = stringArray[n++]).equalsIgnoreCase("HELP")) continue;
            System.out.println("-----------------------------------");
            System.out.println("ParaProf accepts the arguments below.");
            System.out.println("If an incorrect combination is given, an error will be generated.");
            System.out.println("For any assitance, please email tau-bugs@cs.uoregon.edu");
            System.out.println("Thank you!");
            System.out.println("------");
            System.out.println("help - prints this message.");
            System.out.println("debug - Causes ParaProf to output debugging information (some to file, and some to the standard out).");
            System.out.println("prefix  - prefix path for ParaProf to look for profile data (the default is the current directory).");
            System.out.println("filetype [pprof|profile|dynaprof] - the type of profile data to look for.");
            System.out.println("dump [pprof|standard] - Data is dumped to the standard out.");
            System.out.println("------");
            System.out.println("Some examples:");
            System.out.println("paraprof/ParaProf debug");
            System.out.println("paraprof/ParaProf prefix /tmp/data debug");
            System.out.println("paraprof/ParaProf prefix /tmp/data filetype dynaprof");
            System.out.println("-----------------------------------");
            System.exit(0);
        }
        n = 0;
        while (n < stringArray.length) {
            if (!(string = stringArray[n++]).equalsIgnoreCase("DEBUG")) continue;
            UtilFncs.debug = true;
        }
        n = 0;
        while (n < stringArray.length) {
            if ((string = stringArray[n++]).equalsIgnoreCase("FILETYPE")) {
                if (stringArray.length == n) {
                    System.out.println("No file type given!");
                    System.exit(0);
                }
                if ((string = stringArray[n++]).equalsIgnoreCase("pprof")) {
                    paraProf.type = 0;
                } else if (string.equalsIgnoreCase("profile")) {
                    paraProf.type = 1;
                } else if (string.equalsIgnoreCase("dynaprof")) {
                    paraProf.type = 2;
                } else if (string.equalsIgnoreCase("gprof")) {
                    paraProf.type = 5;
                } else {
                    System.out.println("Unrecognized file type: " + string);
                    System.exit(0);
                }
            } else if (string.equalsIgnoreCase("PREFIX")) {
                paraProf.filePrefix = string = stringArray[n++];
            }
            if (!string.equalsIgnoreCase("DUMP")) continue;
            paraProf.dump = true;
            if (stringArray.length == n) {
                System.out.println("No dump type given!");
                System.exit(0);
            }
            if ((string = stringArray[n++]).equalsIgnoreCase("pprof")) {
                paraProf.dumptype = 0;
                continue;
            }
            if (string.equalsIgnoreCase("standard")) {
                paraProf.dumptype = 1;
                continue;
            }
            System.out.println("Unrecognized dump type: " + string);
            System.exit(0);
        }
        if (paraProf.dump) {
            System.out.println("ParaProf will dump to the standard out with dump type: " + paraProf.dumptype);
            System.exit(0);
        }
        runtime = Runtime.getRuntime();
        if (UtilFncs.debug) {
            Timer timer = new Timer(8000, paraProf);
            timer.start();
        }
        paraProf.startSystem();
    }

    static {
        runHasBeenOpened = false;
    }
}

