/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.DataSessionIterator;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.CallPathTextWindowPanel;
import edu.uoregon.tau.paraprof.MappingLedgerWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfImageOutput;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.Preferences;
import edu.uoregon.tau.paraprof.StaticMainWindowData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class CallPathTextWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer {
    private ParaProfTrial trial = null;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private StaticMainWindowData sMWData = null;
    private boolean global = false;
    private int windowType = 1;
    private JMenu optionsMenu = null;
    private JMenu windowsMenu = null;
    private JMenu unitsSubMenu = null;
    private JCheckBoxMenuItem sortByName = null;
    private JCheckBoxMenuItem descendingOrder = null;
    private JCheckBoxMenuItem collapsedView = null;
    private JCheckBoxMenuItem showPathTitleInReverse = null;
    private JCheckBoxMenuItem showMetaData = null;
    private JMenuItem groupLedger = null;
    private JMenuItem usereventLedger = null;
    private JMenuItem callPathRelations = null;
    private JScrollPane sp = null;
    private CallPathTextWindowPanel panel = null;
    private Vector list = null;
    private boolean name = false;
    private int order = 0;
    private int valueType = 2;
    private int units = 0;
    private boolean debug = false;

    public CallPathTextWindow() {
        try {
            this.setLocation(new Point(0, 0));
            this.setSize(new Dimension(800, 600));
            this.setTitle("Wrong constructor used!");
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CPTW01");
        }
    }

    public CallPathTextWindow(ParaProfTrial paraProfTrial, int n, int n2, int n3, StaticMainWindowData staticMainWindowData, boolean bl, boolean bl2) {
        try {
            this.trial = paraProfTrial;
            this.nodeID = n;
            this.contextID = n2;
            this.threadID = n3;
            this.sMWData = staticMainWindowData;
            this.global = bl;
            this.debug = bl2;
            this.setLocation(new Point(0, 0));
            this.setSize(new Dimension(800, 600));
            if (bl) {
                this.setTitle("Call Path Data Relations - " + paraProfTrial.getTrialIdentifier(true));
            } else {
                this.setTitle("Call Path Data n,c,t, " + n + "," + n2 + "," + n3 + " - " + paraProfTrial.getTrialIdentifier(true));
            }
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    CallPathTextWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (ParaProf.helpWindow.isVisible()) {
                this.help(false);
            }
            this.sortLocalData();
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = null;
            JMenuItem jMenuItem = null;
            JMenu jMenu2 = new JMenu("File");
            jMenu = new JMenu("Open ...");
            jMenuItem = new JMenuItem("ParaProf Manager");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Bin Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenu2.add(jMenu);
            jMenu = new JMenu("Save ...");
            jMenuItem = new JMenuItem("Save Image");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenu2.add(jMenu);
            jMenuItem = new JMenuItem("Edit ParaProf Preferences!");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenuItem = new JMenuItem("Print");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenuItem = new JMenuItem("Exit ParaProf!");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenu2.addMenuListener(this);
            this.optionsMenu = new JMenu("Options");
            JCheckBoxMenuItem jCheckBoxMenuItem = null;
            ButtonGroup buttonGroup = null;
            JRadioButtonMenuItem jRadioButtonMenuItem = null;
            this.sortByName = new JCheckBoxMenuItem("Sort By Name", false);
            this.sortByName.addActionListener(this);
            this.optionsMenu.add(this.sortByName);
            this.descendingOrder = new JCheckBoxMenuItem("Descending Order", true);
            this.descendingOrder.addActionListener(this);
            this.optionsMenu.add(this.descendingOrder);
            this.unitsSubMenu = new JMenu("Select Units");
            buttonGroup = new ButtonGroup();
            jRadioButtonMenuItem = new JRadioButtonMenuItem("hr:min:sec", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            this.unitsSubMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Seconds", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            this.unitsSubMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Milliseconds", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            this.unitsSubMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Microseconds", true);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            this.unitsSubMenu.add(jRadioButtonMenuItem);
            this.optionsMenu.add(this.unitsSubMenu);
            jMenu = new JMenu("Select Value Type");
            buttonGroup = new ButtonGroup();
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Exclusive", true);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Subroutines", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Per Call Value", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            this.optionsMenu.add(jMenu);
            this.collapsedView = new JCheckBoxMenuItem("Collapsed View", false);
            this.collapsedView.addActionListener(this);
            this.optionsMenu.add(this.collapsedView);
            this.showPathTitleInReverse = new JCheckBoxMenuItem("Show Path Title in Reverse", true);
            this.showPathTitleInReverse.addActionListener(this);
            this.optionsMenu.add(this.showPathTitleInReverse);
            this.showMetaData = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
            this.showMetaData.addActionListener(this);
            this.optionsMenu.add(this.showMetaData);
            jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Path Title in Reverse", true);
            jCheckBoxMenuItem.addActionListener(this);
            this.optionsMenu.add(jCheckBoxMenuItem);
            jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
            jCheckBoxMenuItem.addActionListener(this);
            this.optionsMenu.add(jCheckBoxMenuItem);
            this.optionsMenu.addMenuListener(this);
            this.windowsMenu = new JMenu("Windows");
            jMenuItem = new JMenuItem("Show Function Ledger");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Group Ledger");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Show User Event Ledger");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Call Path Relations");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Close All Sub-Windows");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            this.windowsMenu.addMenuListener(this);
            JMenu jMenu3 = new JMenu("Help");
            jMenuItem = new JMenuItem("Show Help Window");
            jMenuItem.addActionListener(this);
            jMenu3.add(jMenuItem);
            jMenuItem = new JMenuItem("About ParaProf");
            jMenuItem.addActionListener(this);
            jMenu3.add(jMenuItem);
            jMenu3.addMenuListener(this);
            jMenuBar.add(jMenu2);
            jMenuBar.add(this.optionsMenu);
            jMenuBar.add(this.windowsMenu);
            jMenuBar.add(jMenu3);
            this.setJMenuBar(jMenuBar);
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.panel = new CallPathTextWindowPanel(paraProfTrial, n, n2, n3, this, bl, this.debug());
            this.sp = new JScrollPane(this.panel);
            JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
            jScrollBar.setUnitIncrement(35);
            this.setHeader();
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(this.sp, gridBagConstraints, 0, 0, 1, 1);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CPTW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Print")) {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    PageFormat pageFormat = printerJob.defaultPage();
                    PageFormat pageFormat2 = printerJob.pageDialog(pageFormat);
                    printerJob.setPrintable(this.panel, pageFormat2);
                    if (printerJob.printDialog()) {
                        printerJob.print();
                    }
                } else if (string.equals("Edit ParaProf Preferences!")) {
                    this.trial.getPreferences().showPreferencesWindow();
                } else if (string.equals("Save Image")) {
                    ParaProfImageOutput paraProfImageOutput = new ParaProfImageOutput();
                    paraProfImageOutput.saveImage(this.panel);
                } else if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit ParaProf!")) {
                    this.setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("Sort By Name")) {
                    this.name = this.sortByName.isSelected();
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Descending Order")) {
                    this.order = this.descendingOrder.isSelected() ? 0 : 1;
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Exclusive")) {
                    this.valueType = 2;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Inclusive")) {
                    this.valueType = 4;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Number of Calls")) {
                    this.valueType = 6;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Number of Subroutines")) {
                    this.valueType = 8;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Per Call Value")) {
                    this.valueType = 10;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Microseconds")) {
                    this.units = 0;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Milliseconds")) {
                    this.units = 1;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Seconds")) {
                    this.units = 2;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("hr:min:sec")) {
                    this.units = 3;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Collapsed View")) {
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Show Path Title in Reverse")) {
                    if (this.global) {
                        this.setTitle("Call Path Data Relations - " + this.trial.getTrialIdentifier(true));
                    } else {
                        this.setTitle("Call Path Data n,c,t, " + this.nodeID + "," + this.contextID + "," + this.threadID + " - " + this.trial.getTrialIdentifier(this.showPathTitleInReverse.isSelected()));
                    }
                } else if (string.equals("Show Meta Data in Panel")) {
                    this.setHeader();
                } else if (string.equals("Show Function Ledger")) {
                    new MappingLedgerWindow(this.trial, 0, this.debug()).show();
                } else if (string.equals("Show Group Ledger")) {
                    new MappingLedgerWindow(this.trial, 1, this.debug()).show();
                } else if (string.equals("Show User Event Ledger")) {
                    new MappingLedgerWindow(this.trial, 2, this.debug()).show();
                } else if (string.equals("Show Call Path Relations")) {
                    CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.trial, -1, -1, -1, this.getSMWData(), true, this.debug());
                    this.trial.getSystemEvents().addObserver(callPathTextWindow);
                    callPathTextWindow.show();
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About ParaProf")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    this.help(true);
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW03");
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.trial.isTimeMetric()) {
                this.unitsSubMenu.setEnabled(true);
            } else {
                this.unitsSubMenu.setEnabled(false);
            }
            if (this.trial.groupNamesPresent()) {
                this.windowsMenu.getItem(1).setEnabled(true);
            } else {
                this.windowsMenu.getItem(1).setEnabled(false);
            }
            if (this.trial.userEventsPresent()) {
                this.windowsMenu.getItem(2).setEnabled(true);
            } else {
                this.windowsMenu.getItem(1).setEnabled(false);
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW04");
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.setHeader();
                this.panel.repaint();
            } else if (string.equals("colorEvent")) {
                this.panel.repaint();
            } else if (string.equals("dataEvent")) {
                this.sortLocalData();
                if (!this.trial.isTimeMetric()) {
                    this.units = 0;
                }
                this.panel.repaint();
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW05");
        }
    }

    private void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("Call path text window.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window displays call path relationships in two ways:");
        ParaProf.helpWindow.writeText("1- If this window has been invoked from the \"windows\" menu of");
        ParaProf.helpWindow.writeText("ParaProf, the information displayed is all call path relations found.");
        ParaProf.helpWindow.writeText("That is, all the parent/child relationships.");
        ParaProf.helpWindow.writeText("Thus, in this case, given the parallel nature of ParaProf, this information");
        ParaProf.helpWindow.writeText("might not be valid for a particular thread. It is however useful to observe");
        ParaProf.helpWindow.writeText("all the realtionships that exist in the data.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("2- If this window has been invoked from the popup menu to the left of a thread bar");
        ParaProf.helpWindow.writeText("in the main ParaProf window, the information dispayed will be specific to this thread,");
        ParaProf.helpWindow.writeText("and will thus contain both parent/child relations and the data relating to those");
        ParaProf.helpWindow.writeText("relationships.");
    }

    public StaticMainWindowData getSMWData() {
        return this.sMWData;
    }

    private void sortLocalData() {
        try {
            this.list = this.global ? this.trial.getGlobalMapping().getMapping(0) : (this.name ? this.sMWData.getThreadData(this.nodeID, this.contextID, this.threadID, this.windowType, this.order) : this.sMWData.getThreadData(this.nodeID, this.contextID, this.threadID, this.windowType, this.valueType + this.order));
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW06");
        }
    }

    public Vector getData() {
        return this.list;
    }

    public ListIterator getDataIterator() {
        return new DataSessionIterator(this.getData());
    }

    public int getWindowType() {
        return this.windowType;
    }

    public int getValueType() {
        return this.valueType;
    }

    public int units() {
        return this.units;
    }

    public boolean showCollapsedView() {
        return this.collapsedView.isSelected();
    }

    public Dimension getViewportSize() {
        return this.sp.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.sp.getViewport().getViewRect();
    }

    public void setVerticalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CPTW05");
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void setHeader() {
        if (this.showMetaData.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            Preferences preferences = this.trial.getPreferences();
            jTextArea.setFont(new Font(preferences.getParaProfFont(), preferences.getFontStyle(), preferences.getFontSize()));
            jTextArea.append(this.getHeaderString());
            this.sp.setColumnHeaderView(jTextArea);
        } else {
            this.sp.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        return "Metric Name: " + this.trial.getMetricName(this.trial.getSelectedMetricID()) + "\n" + "Sorted By: " + UtilFncs.getValueTypeString((int)this.valueType) + "\n" + "Units: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.trial.isTimeMetric(), (boolean)this.trial.isDerivedMetric()) + "\n";
    }

    void closeThisWindow() {
        try {
            if (this.debug) {
                System.out.println("------------------------");
                System.out.println("A total stat window for: \"n,c,t, " + this.nodeID + "," + this.contextID + "," + this.threadID + "\" is closing");
                System.out.println("Clearing resourses for this window.");
            }
            this.setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CPTW06");
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

